/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.data;

import com.swimap.external.resource.client.basicType.AlarmLevel;
import com.swimap.external.resource.client.basicType.ContainAlarmStateType;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.impl.AlarmLevelImpl;
import com.swimap.resource.client.impl.ContainAlarmStateTypeImpl;
import com.swimap.resource.client.innerimpl.ResourceBaseModule;
import com.swimap.resource.client.innerimpl.data.ResourceParseManagerImpl;
import com.swimap.resource.client.innerimpl.util.ResourceUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class ResourceXmlManagerImpl {
    private static final IviewLogger logger = IviewLogger.getLogger(ResourceXmlManagerImpl.class, (String)"EAM");
    private static final String COMMON_FILE = "commonresource";
    private static final String PROFILE_INFO_FILE = "conf/resource/profileinfo";
    private static final String IN_PROFILE_INFO_FILE = "profileinfo";
    private static ResourceXmlManagerImpl instance = null;
    private CommStyleInfo commInfo = null;
    private ResourceBundle res = null;
    private List<AlarmLevel> userAlarmLevels = null;
    private List<AlarmLevel> defaultAlarmLevels = null;
    private List<ContainAlarmStateType> containAlarmStateTypes = null;
    private static final int SOUND_STATUS = 1;

    private ResourceXmlManagerImpl() {
        logger.trace((Object)"init default alarm commonresource start");
        Plugin plugin = ResourceUtil.getInstance().getResouceModulePlugin();
        this.commInfo = plugin.getCommStyleParser().getCommStyleInfo(COMMON_FILE);
        this.getDefaultAlarmLevels();
        logger.trace((Object)"init default alarm commonresource end");
    }

    public static synchronized ResourceXmlManagerImpl getInstance() {
        if (instance == null) {
            instance = new ResourceXmlManagerImpl();
        }
        return instance;
    }

    private List<AlarmLevel> initAlarmLevelsFromUserXML() {
        this.initUserProfileInfo();
        return this.parseAlarmLevelsFile();
    }

    private List<AlarmLevel> initDefaultAlarmLevelsFromXML() {
        return this.parseAlarmLevelsFile();
    }

    private List<ContainAlarmStateType> initContainAlarmStateFromXML() {
        return this.parseContainAlarmState();
    }

    private void initUserProfileInfo() {
        CommStyleInfo profileInfo = ResourceUtil.getInstance().getResouceModulePlugin().getCommStyleParser().getUserCommStyleInfo(IN_PROFILE_INFO_FILE);
        this.mergeProfileInfo(this.commInfo, profileInfo);
    }

    private void mergeProfileInfo(CommStyleInfo commInfo, CommStyleInfo profileInfo) {
        if (null == profileInfo || null == commInfo) {
            return;
        }
        AreaDescContainer alarmArea = null;
        int proAreaCount = profileInfo.getAreaDescContainerCount();
        for (int i = 0; i < proAreaCount; ++i) {
            AreaDescContainer area = profileInfo.getAreaDescContainer(i);
            if (!"AlarmLevel".equals(area.getAreaName())) continue;
            alarmArea = area;
            break;
        }
        int commAreaCount = commInfo.getAreaDescContainerCount();
        if (null != alarmArea) {
            for (int i = 0; i < commAreaCount; ++i) {
                AreaDescContainer area = commInfo.getAreaDescContainer(i);
                if (!"AlarmLevel".equals(area.getAreaName())) continue;
                commInfo.removeAreaDescContainer("AlarmLevel");
                commInfo.addAreaDescContainer(alarmArea);
                break;
            }
        }
    }

    private List<AlarmLevel> parseAlarmLevelsFile() {
        ArrayList<AlarmLevel> typeList = new ArrayList<AlarmLevel>(5);
        if (this.commInfo != null) {
            int areaCount = this.commInfo.getAreaDescContainerCount();
            for (int i = 0; i < areaCount; ++i) {
                AreaDescContainer area = this.commInfo.getAreaDescContainer(i);
                try {
                    DescContainer[] descs;
                    if (area == null || !"AlarmLevel".equals(area.getAreaName()) || (descs = area.getDescContainer()) == null) continue;
                    for (int j = 0; j < descs.length; ++j) {
                        AlarmLevel alarmLevel = this.convertDescToAlarmLevel(descs[j]);
                        typeList.add(alarmLevel);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return typeList;
    }

    private AlarmLevel convertDescToAlarmLevel(DescContainer desc) {
        int alarmLevel = Integer.parseInt(desc.getParasItemValue("id"));
        char synopsis = desc.getParasItemValue("synopsis").charAt(0);
        Color color = this.getColor(desc.getParasItemValue("color"));
        String sound = desc.getParasItemValue("sound");
        int soundDelay = Integer.parseInt(desc.getParasItemValue("sound-delay"));
        boolean isSounding = false;
        String tempIsSounding = desc.getParasItemValue("isSounding");
        if (tempIsSounding != null) {
            isSounding = !"false".equalsIgnoreCase(tempIsSounding);
        }
        int highLightTime = 0;
        String tempHighLightTime = desc.getParasItemValue("highLightTime");
        if (tempHighLightTime != null) {
            highLightTime = Integer.parseInt(tempHighLightTime);
        }
        int soundInterval = 0;
        String tempSoundInterval = desc.getParasItemValue("sound-interval");
        if (tempSoundInterval != null) {
            soundInterval = Integer.parseInt(tempSoundInterval);
        }
        int soundStatus = 1;
        String tempSoundStatus = desc.getParasItemValue("soundStatus");
        if (tempSoundStatus != null) {
            soundStatus = Integer.parseInt(tempSoundStatus);
        }
        boolean isLongPeriodSettingEnable = false;
        String tempIsLongPeriodSettingEnable = desc.getParasItemValue("isLongPeriodSettingEnable");
        if (tempIsLongPeriodSettingEnable != null) {
            isLongPeriodSettingEnable = Boolean.parseBoolean(tempIsLongPeriodSettingEnable);
        }
        int longTimeAlarmStatus = 1;
        String tempLongTimeAlarmStatus = desc.getParasItemValue("longTimeAlarmStatus");
        if (tempLongTimeAlarmStatus != null) {
            longTimeAlarmStatus = Integer.parseInt(tempLongTimeAlarmStatus);
        }
        String label = this.getString(desc.getParasItemValue("label"));
        AlarmLevelImpl result = new AlarmLevelImpl(alarmLevel, label, synopsis);
        result.setColor(color);
        result.setSound(sound);
        result.setSoundDelay(soundDelay);
        result.setIsSounding(isSounding);
        result.setHighLightTime(highLightTime);
        result.setSoundInterval(soundInterval);
        result.setSoundStatus(soundStatus);
        result.setLongTimeSettingEnable(isLongPeriodSettingEnable);
        result.setLongTimeAlarmStatus(longTimeAlarmStatus);
        return result;
    }

    private ContainAlarmStateTypeImpl convertDescToContainAlarmState(DescContainer desc) {
        int id = Integer.parseInt(desc.getParasItemValue("id"));
        String label = desc.getParasItemValue("label");
        label = this.getString(label);
        String iconStr = desc.getParasItemValue("icon");
        ImageIcon image = null;
        if (iconStr != null) {
            image = ResourceUtil.getInstance().getResourceImage(iconStr);
        }
        return new ContainAlarmStateTypeImpl(id, label, image);
    }

    private List<ContainAlarmStateType> parseContainAlarmState() {
        ArrayList<ContainAlarmStateType> typeList = new ArrayList<ContainAlarmStateType>(5);
        if (this.commInfo != null) {
            int areaCount = this.commInfo.getAreaDescContainerCount();
            for (int i = 0; i < areaCount; ++i) {
                AreaDescContainer area = this.commInfo.getAreaDescContainer(i);
                try {
                    DescContainer[] descs;
                    if (area == null || !"ContainAlarmStateType".equals(area.getAreaName()) || (descs = area.getDescContainer()) == null) continue;
                    for (int j = 0; j < descs.length; ++j) {
                        ContainAlarmStateTypeImpl containAlarmState = this.convertDescToContainAlarmState(descs[j]);
                        typeList.add(containAlarmState);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return typeList;
    }

    private Color getColor(String value) {
        if (value != null) {
            try {
                StringTokenizer token = new StringTokenizer(value, "-");
                int count = token.countTokens();
                if (count == 0) {
                    return Color.getColor(value);
                }
                if (count == 3) {
                    return new Color(Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()), Integer.parseInt(token.nextToken()));
                }
                logger.error((Object)("Cann't get color from string:" + value));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return Color.white;
    }

    public static String getColorString(Color color) {
        if (color == null) {
            return "255-255-255";
        }
        return color.getRed() + "-" + color.getGreen() + "-" + color.getBlue();
    }

    private String getString(String key) {
        try {
            if (this.res == null) {
                this.res = ResourceBaseModule.getResouceModulePlugin().getResource().getResourceBundleFromXmlFile("Res");
            }
            return this.res.getString(key);
        }
        catch (Exception e) {
            logger.error((Object)("Can not find value for key:" + key + ", exception: "), (Throwable)e);
            return key;
        }
    }

    public void writeBack() {
        CommStyleInfo writeBackInfo = new CommStyleInfo();
        AreaDescContainer alarmArea = null;
        if (this.commInfo != null) {
            int areaCount = this.commInfo.getAreaDescContainerCount();
            for (int i = 0; i < areaCount; ++i) {
                AlarmLevel[] alarmLevels;
                AreaDescContainer area = this.commInfo.getAreaDescContainer(i);
                DescContainer[] descs = area.getDescContainer();
                if ("AlarmLevel".equals(area.getAreaName())) {
                    alarmArea = area;
                }
                if ((alarmLevels = ResourceParseManagerImpl.getInstance().getAlarmLevels()) == null || alarmLevels.length != descs.length) continue;
                for (int j = 0; j < alarmLevels.length; ++j) {
                    ((AlarmLevelImpl)alarmLevels[j]).writeBack(descs[j]);
                }
            }
            writeBackInfo.addAreaDescContainer(alarmArea);
            try {
                CommStyleManager.getInstance().writeToUser(writeBackInfo, PROFILE_INFO_FILE);
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        } else {
            logger.debug((Object)"Can not get resource xml:conf/resource/profileinfo");
        }
    }

    public void clear() {
        if (this.defaultAlarmLevels != null) {
            this.defaultAlarmLevels.clear();
            this.defaultAlarmLevels = null;
        }
        if (this.containAlarmStateTypes != null) {
            this.containAlarmStateTypes.clear();
            this.containAlarmStateTypes = null;
        }
        if (this.userAlarmLevels != null) {
            this.userAlarmLevels.clear();
            this.userAlarmLevels = null;
        }
        this.commInfo = null;
        instance = null;
    }

    public synchronized List<AlarmLevel> getDefaultAlarmLevels() {
        if (this.defaultAlarmLevels == null) {
            logger.debug((Object)"initDefaultAlarmLevelsFromXML start...");
            this.defaultAlarmLevels = this.initDefaultAlarmLevelsFromXML();
            logger.debug((Object)"initDefaultAlarmLevelsFromXML end");
        }
        return this.defaultAlarmLevels;
    }

    public synchronized List<AlarmLevel> getUserAlarmLevels() {
        if (this.userAlarmLevels == null) {
            logger.debug((Object)"initAlarmLevelsFromUserXML start...");
            this.userAlarmLevels = this.initAlarmLevelsFromUserXML();
            logger.debug((Object)"initAlarmLevelsFromUserXML end");
        }
        return this.userAlarmLevels;
    }

    public synchronized List<ContainAlarmStateType> getContainAlarmStateTypes() {
        if (this.containAlarmStateTypes == null) {
            this.containAlarmStateTypes = this.initContainAlarmStateFromXML();
        }
        return this.containAlarmStateTypes;
    }
}

