/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.data;

import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.resource.client.basicType.AlarmLevel;
import com.swimap.external.resource.client.basicType.ContainAlarmStateType;
import com.swimap.external.resource.client.basicType.LinkType;
import com.swimap.external.resource.client.basicType.NEType;
import com.swimap.external.resource.client.basicType.SubnetType;
import com.swimap.external.resource.client.basicType.ValueNameIcon;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.impl.NETypeImpl;
import com.swimap.resource.client.impl.SubnetTypeImpl;
import com.swimap.resource.client.innerimpl.common.ResourceClientException;
import com.swimap.resource.client.innerimpl.data.DevTypeAndVersion;
import com.swimap.resource.client.innerimpl.data.OperatorRuleManager;
import com.swimap.resource.client.innerimpl.data.ResourceXmlManagerImpl;
import com.swimap.resource.client.innerimpl.data.SerialIconManagerImpl;
import com.swimap.resource.client.innerimpl.data.UnVisibleNeTypeManager;
import com.swimap.resource.client.innerimpl.data.ValueNameIconManager;
import com.swimap.resource.client.innerimpl.rpc.ResourceRpcCommunicationMgr;
import com.swimap.resource.client.innerimpl.rpc.ResourceRpcDataIf;
import com.swimap.resource.client.innerimpl.rpc.ResourceRpcEventMgr;
import com.swimap.resource.client.innerimpl.util.ResourceUtil;
import com.swimap.resource.client.innerimpl.util.RpcUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ResourceParseManagerImpl {
    private static final IviewLogger logger = IviewLogger.getLogger(ResourceParseManagerImpl.class, (String)"EAM");
    private static ResourceParseManagerImpl instance = new ResourceParseManagerImpl();
    private List<AlarmLevel> allAlarmLevels = new LinkedList<AlarmLevel>();
    private List<AlarmLevel> defaultAlarmLevels = new LinkedList<AlarmLevel>();
    private List<ContainAlarmStateType> containAlarmStateTypes = new LinkedList<ContainAlarmStateType>();
    private static Map<Boolean, Integer> hideSubnetTypeMap = new HashMap<Boolean, Integer>();
    private Map<Integer, SubnetType> subnetTypes = new HashMap<Integer, SubnetType>();
    private Map<Integer, NEType> needShowNeTypes = new HashMap<Integer, NEType>();
    private Map<Integer, NEType> needFilterNeTypes = new HashMap<Integer, NEType>();
    private Map<Integer, NEType> allNeTypes = new HashMap<Integer, NEType>();
    private Map<Integer, LinkType> allLinkTypes = new HashMap<Integer, LinkType>();
    private Set<Integer> noManagerTypes = new HashSet<Integer>();
    private static List<Integer> unVisibleNeType = new LinkedList<Integer>();
    private static Map<Integer, DevTypeAndVersion> typeIdToDevTypeAndVersion = new ConcurrentHashMap<Integer, DevTypeAndVersion>();
    private static Map<DevTypeAndVersion, Integer> devTypeAndVersionToTypeId = new ConcurrentHashMap<DevTypeAndVersion, Integer>();
    private ResourceRpcDataIf rpcInterface = new ResourceRpcCommunicationMgr();
    private static final String LABEL = "label";
    private static final String PRE_FIX = "image/icon";
    private HashSet<Integer> unknowIconTypes = new HashSet();

    public static ResourceParseManagerImpl getInstance() {
        return instance;
    }

    public void initialize() throws ResourceClientException {
        logger.debug((Object)"resource type initialize start");
        SerialIconManagerImpl.getInstance().initReadSerialIcon();
        this.initAlarmLevelsConf();
        DataTable subnetTypeTable = this.rpcInterface.getAllSubnetTypes();
        RpcUtil.initSubType(subnetTypeTable, this.subnetTypes, hideSubnetTypeMap);
        Map<String, DataTable> neDataTableMap = this.rpcInterface.getAllNeTypesAndDelID();
        RpcUtil.initNeType(neDataTableMap, this.needShowNeTypes, this.needFilterNeTypes, unVisibleNeType, this.allNeTypes);
        this.initTypeMapping(this.getAllNeTypesNotFilter());
        DataTable linkTypeTable = this.rpcInterface.getAllLinkTypes();
        RpcUtil.initLinkType(linkTypeTable, this.allLinkTypes);
        ValueNameIconManager.getInstance().initTypeToValueNameIcon();
        this.setNoManagerTypes(this.rpcInterface.getAllNoManager());
        this.initEamOperation(subnetTypeTable, neDataTableMap, linkTypeTable);
        ResourceRpcEventMgr.getInstance().open();
        this.recordUnknowIconTypes(this.needShowNeTypes);
        logger.debug((Object)"resource type initialize end");
    }

    private void initAlarmLevelsConf() {
        try {
            List<ContainAlarmStateType> tmpContainAlarmStateTypes;
            List<AlarmLevel> tmpAllAlarmLevels;
            List<AlarmLevel> tmpDefaultAlarmLevels = ResourceXmlManagerImpl.getInstance().getDefaultAlarmLevels();
            if (tmpDefaultAlarmLevels != null) {
                this.defaultAlarmLevels.addAll(tmpDefaultAlarmLevels);
            }
            if ((tmpAllAlarmLevels = ResourceXmlManagerImpl.getInstance().getUserAlarmLevels()) != null) {
                this.allAlarmLevels.addAll(tmpAllAlarmLevels);
            }
            if ((tmpContainAlarmStateTypes = ResourceXmlManagerImpl.getInstance().getContainAlarmStateTypes()) != null) {
                this.containAlarmStateTypes.addAll(tmpContainAlarmStateTypes);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void initEamOperation(DataTable subnetTypeTable, Map<String, DataTable> neDataTableMap, DataTable linkTypeTable) {
        try {
            DataTable neDataTable = null;
            if (neDataTableMap != null) {
                neDataTable = neDataTableMap.get("allNodeType");
            }
            OperatorRuleManager.getInstance().initOperatorRule(subnetTypeTable, neDataTable, linkTypeTable);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public void refreshNeTypes() {
        try {
            logger.debug((Object)"resource refresh Ne types start");
            HashMap<Integer, NEType> temp_needShowNeTypes = new HashMap<Integer, NEType>();
            HashMap<Integer, NEType> temp_needFilterNeTypes = new HashMap<Integer, NEType>();
            HashMap<Integer, NEType> temp_allNeTypes = new HashMap<Integer, NEType>();
            LinkedList<Integer> temp_unVisibleNeType = new LinkedList<Integer>();
            Map<String, DataTable> neDataTableMap = this.rpcInterface.getAllNeTypesAndDelID();
            RpcUtil.initNeType(neDataTableMap, temp_needShowNeTypes, temp_needFilterNeTypes, temp_unVisibleNeType, temp_allNeTypes);
            this.needShowNeTypes.clear();
            this.needFilterNeTypes.clear();
            unVisibleNeType.clear();
            this.allNeTypes.clear();
            typeIdToDevTypeAndVersion.clear();
            devTypeAndVersionToTypeId.clear();
            this.unknowIconTypes.clear();
            this.needShowNeTypes.putAll(temp_needShowNeTypes);
            this.needFilterNeTypes.putAll(temp_needFilterNeTypes);
            unVisibleNeType.addAll(temp_unVisibleNeType);
            this.allNeTypes.putAll(temp_allNeTypes);
            this.initTypeMapping(temp_allNeTypes.values());
            ValueNameIconManager.getInstance().initNeTypeToValueNameIcon();
            this.initEamOperation(null, neDataTableMap, null);
            this.recordUnknowIconTypes(this.needShowNeTypes);
            logger.debug((Object)"resource refresh Ne types end");
        }
        catch (Exception exp) {
            logger.error((Object)"", (Throwable)exp);
        }
    }

    public void addDynamicNeType(DataTable table, DataTable filterTable) {
        try {
            logger.debug((Object)"resource addDynamicNeType start");
            HashMap<Integer, NEType> tempNeedShowNeTypes = new HashMap<Integer, NEType>();
            HashMap<Integer, NEType> tempNeedFilterNeTypes = new HashMap<Integer, NEType>();
            HashMap<Integer, NEType> tempAllNeTypes = new HashMap<Integer, NEType>();
            Set<Integer> tempNeedFilterNeType = new HashSet<Integer>();
            if (filterTable != null) {
                tempNeedFilterNeType = RpcUtil.getNeedFilterNeTypeID(filterTable);
            }
            RpcUtil.parseNeTypes(table, tempNeedFilterNeType, tempNeedShowNeTypes, tempNeedFilterNeTypes, tempAllNeTypes);
            this.needShowNeTypes.putAll(tempNeedShowNeTypes);
            this.needFilterNeTypes.putAll(tempNeedFilterNeTypes);
            unVisibleNeType.clear();
            List<Integer> inVisibleTypes = UnVisibleNeTypeManager.getAllUnVisibleNeType();
            if (inVisibleTypes != null && inVisibleTypes.size() > 0) {
                unVisibleNeType.addAll(inVisibleTypes);
            }
            this.allNeTypes.putAll(tempAllNeTypes);
            this.initTypeMapping(tempAllNeTypes.values());
            ValueNameIconManager.getInstance().initNeTypeToValueNameIcon();
            OperatorRuleManager.getInstance().initOperatorRule(null, table, null);
            this.recordUnknowIconTypes(tempNeedShowNeTypes);
            logger.debug((Object)"resource addDynamicNeType end");
        }
        catch (Exception exp) {
            logger.error((Object)"", (Throwable)exp);
        }
    }

    public void addDynamicSubnetType(DataTable table) {
        logger.debug((Object)"resource addDynamicSubnetType start");
        HashMap<Integer, SubnetType> types = new HashMap<Integer, SubnetType>();
        HashMap<Boolean, Integer> hideSubnetMap = new HashMap<Boolean, Integer>();
        RpcUtil.parseSubnetTypes(table, types, hideSubnetMap);
        this.subnetTypes.putAll(types);
        ValueNameIconManager.getInstance().initSubnetTypeToValueNameIcon();
        OperatorRuleManager.getInstance().initOperatorRule(table, null, null);
        logger.debug((Object)"resource addDynamicSubnetType end");
    }

    public void addDynamicLinkType(DataTable table) {
        logger.debug((Object)"resource addDynamicLinkType start");
        HashMap<Integer, LinkType> types = new HashMap<Integer, LinkType>();
        RpcUtil.parseLinkTypes(table, types);
        this.allLinkTypes.putAll(types);
        ValueNameIconManager.getInstance().initLinkTypeToValueNameIcon();
        OperatorRuleManager.getInstance().initOperatorRule(null, null, table);
        logger.debug((Object)"resource addDynamicLinkType end");
    }

    public void clear() {
        logger.debug((Object)"clear resource data start");
        ResourceRpcEventMgr.getInstance().close();
        this.allAlarmLevels.clear();
        this.defaultAlarmLevels.clear();
        this.containAlarmStateTypes.clear();
        hideSubnetTypeMap.clear();
        this.subnetTypes.clear();
        this.needShowNeTypes.clear();
        this.needFilterNeTypes.clear();
        this.allNeTypes.clear();
        this.allLinkTypes.clear();
        this.noManagerTypes.clear();
        unVisibleNeType.clear();
        typeIdToDevTypeAndVersion.clear();
        devTypeAndVersionToTypeId.clear();
        this.unknowIconTypes.clear();
        logger.debug((Object)"clear resource data end");
    }

    public AlarmLevel[] getAlarmLevels() {
        return this.allAlarmLevels.toArray(new AlarmLevel[0]);
    }

    public LinkType[] getAllLinkTypes() {
        return this.allLinkTypes.values().toArray(new LinkType[0]);
    }

    public Collection<LinkType> getAllLinkType() {
        return this.allLinkTypes.values();
    }

    public NEType[] getAllNETypes() {
        return this.needShowNeTypes.values().toArray(new NEType[0]);
    }

    public SubnetType[] getAllSubnetTypes() {
        SubnetType[] result = new SubnetType[this.subnetTypes.size()];
        return this.subnetTypes.values().toArray(result);
    }

    public Collection<SubnetType> getAllSubnetType() {
        return this.subnetTypes.values();
    }

    public SubnetType[] getSubnetTypeByKind(int kind) {
        SubnetType[] types = this.getAllSubnetTypes();
        ArrayList<SubnetType> tmp = new ArrayList<SubnetType>();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                if (((SubnetTypeImpl)types[i]).getKind() != kind) continue;
                tmp.add(types[i]);
            }
            if (tmp.size() > 0) {
                types = new SubnetType[tmp.size()];
                tmp.toArray(types);
                return types;
            }
        }
        return null;
    }

    public LinkType getLinkType(int linkTypeID) {
        return this.allLinkTypes.get(linkTypeID);
    }

    public NEType getNEType(int neTypeID) {
        return this.needShowNeTypes.get(neTypeID);
    }

    public SubnetType getSubentType(int subnetTypeID) {
        return this.subnetTypes.get(subnetTypeID);
    }

    public AlarmLevel getAlarmLevlelInfo(int alarmLevelId) {
        if (this.allAlarmLevels != null) {
            for (AlarmLevel alarmLevel : this.allAlarmLevels) {
                if (alarmLevel.getId() != alarmLevelId) continue;
                return alarmLevel;
            }
        }
        return null;
    }

    public ContainAlarmStateType[] getAllContainAlarmStateTypes() {
        if (this.containAlarmStateTypes != null && this.containAlarmStateTypes.size() > 0) {
            ContainAlarmStateType[] result = new ContainAlarmStateType[this.containAlarmStateTypes.size()];
            this.containAlarmStateTypes.toArray(result);
            return result;
        }
        return null;
    }

    public ContainAlarmStateType getContainAlarm(int containAlarmValue) {
        if (this.containAlarmStateTypes != null && this.containAlarmStateTypes.size() > 0) {
            for (ContainAlarmStateType containAlarmStateType : this.containAlarmStateTypes) {
                if (containAlarmStateType.getId() != containAlarmValue) continue;
                return containAlarmStateType;
            }
        }
        return null;
    }

    public HashMap<Integer, AlarmLevel> getAllAlarmLevel() {
        HashMap<Integer, AlarmLevel> alarmLevels = new HashMap<Integer, AlarmLevel>();
        if (this.allAlarmLevels != null && this.allAlarmLevels.size() > 0) {
            Iterator<AlarmLevel> i$ = this.allAlarmLevels.iterator();
            while (i$.hasNext()) {
                AlarmLevel o;
                AlarmLevel al = o = i$.next();
                alarmLevels.put(al.getId(), al);
            }
        }
        return alarmLevels;
    }

    public AlarmLevel[] getAllDefaultAlarmLevels() {
        if (this.defaultAlarmLevels != null && this.defaultAlarmLevels.size() > 0) {
            AlarmLevel[] result = new AlarmLevel[this.defaultAlarmLevels.size()];
            this.defaultAlarmLevels.toArray(result);
            return result;
        }
        return null;
    }

    public List<Integer> getAllUnVisible() {
        return unVisibleNeType;
    }

    public Collection<NEType> getAllNeTypesNotFilter() {
        if (this.allNeTypes.size() != 0) {
            return this.allNeTypes.values();
        }
        return null;
    }

    public ImageIcon getNodeIconFromResource(int typeId, String label) {
        if (label == null || "".equals(label)) {
            label = LABEL;
        }
        try {
            ValueNameIcon[] nodeType = ValueNameIconManager.getInstance().getAllNodeTypes();
            for (int i = 0; i < nodeType.length; ++i) {
                if ((nodeType[i].getValue() != typeId || !nodeType[i].getKey().equals(label)) && !this.equalsIconFile(nodeType[i], label)) continue;
                return nodeType[i].getIcon();
            }
            if (!label.equals(LABEL)) {
                ImageIcon image;
                StringBuilder iconPath = new StringBuilder("image");
                if (label.indexOf(iconPath.toString()) > -1) {
                    iconPath = new StringBuilder(this.replaceIconPath(label));
                } else {
                    iconPath.append("/iconS/").append(label);
                }
                if (!iconPath.toString().endsWith(".gif")) {
                    iconPath.append(".gif");
                }
                if ((image = ResourceUtil.getInstance().getResourceImage(iconPath.toString())) != null) {
                    return image;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return new ImageIcon();
    }

    private boolean equalsIconFile(ValueNameIcon valueNameIcon, String iconLabel) {
        boolean isEqual = false;
        if (iconLabel != null) {
            int labelIndex;
            String iconFile = valueNameIcon.getIcon().toString();
            if (iconFile == null) {
                return isEqual;
            }
            int nameIndex = iconFile.lastIndexOf(PRE_FIX);
            int len = PRE_FIX.length();
            if (nameIndex == -1) {
                return isEqual;
            }
            String preFixIconName = iconFile.substring(nameIndex + len + 2);
            String preFixIconLabel = iconLabel;
            if (iconLabel.endsWith(".gif") && (labelIndex = iconLabel.lastIndexOf(PRE_FIX)) != -1) {
                preFixIconLabel = iconLabel.substring(labelIndex + len + 2);
            }
            isEqual = preFixIconName.equals(preFixIconLabel);
        }
        return isEqual;
    }

    private String replaceIconPath(String iconPath) {
        return iconPath.replaceFirst("/icon[L,M,N]/", "/iconS/");
    }

    public void setNoManagerTypes(int[] noTypes) {
        if (null != noTypes) {
            this.noManagerTypes.clear();
            for (int type : noTypes) {
                this.noManagerTypes.add(type);
            }
        }
    }

    public Set<Integer> getNoMangerTypeIds() {
        return this.noManagerTypes;
    }

    public boolean isHideSn(int typeId) {
        int hideSnType = -1111;
        Set<Map.Entry<Boolean, Integer>> sets = hideSubnetTypeMap.entrySet();
        Iterator<Map.Entry<Boolean, Integer>> i$ = sets.iterator();
        if (i$.hasNext()) {
            Map.Entry<Boolean, Integer> entry = i$.next();
            if (!entry.getKey().booleanValue()) {
                return false;
            }
            hideSnType = entry.getValue();
        }
        return typeId == hideSnType;
    }

    private void initTypeMapping(Collection<NEType> allnetypes) {
        if (allnetypes != null) {
            for (NEType netype : allnetypes) {
                if (!(netype instanceof NETypeImpl)) continue;
                NETypeImpl neTypeImpl = (NETypeImpl)netype;
                DevTypeAndVersion devAndVersion = new DevTypeAndVersion(neTypeImpl.m_iDevTypeID, neTypeImpl.m_iDevVersionID);
                typeIdToDevTypeAndVersion.put(neTypeImpl.getId(), devAndVersion);
                devTypeAndVersionToTypeId.put(devAndVersion, neTypeImpl.getId());
            }
        } else {
            logger.error((Object)"No any type!");
        }
    }

    public int getDevTypeIDByTypeID(int nodeType) {
        int devType = nodeType >> 16;
        if (typeIdToDevTypeAndVersion == null || typeIdToDevTypeAndVersion.size() == 0) {
            logger.debug((Object)"typeIdToDevTypeAndVersion is null, get dev type from as error!");
            return devType;
        }
        DevTypeAndVersion dt = typeIdToDevTypeAndVersion.get(nodeType);
        return dt == null ? devType : dt.getDevTypeID();
    }

    public int getVersionTypeIDByTypeID(int nodeType) {
        int versionID = nodeType & 0xFFFF;
        if (typeIdToDevTypeAndVersion == null || typeIdToDevTypeAndVersion.size() == 0) {
            logger.debug((Object)"typeIdToDevTypeAndVersion is null, get dev type from as error!");
            return nodeType;
        }
        DevTypeAndVersion dt = typeIdToDevTypeAndVersion.get(nodeType);
        return dt == null ? versionID : dt.getDevVersionID();
    }

    public int getTypeIDByDevTypeAndVersionID(int devTypeID, int devVersionID) {
        int devType = devTypeID << 16;
        int typeID = devType + devVersionID;
        if (devTypeAndVersionToTypeId == null || devTypeAndVersionToTypeId.size() == 0) {
            logger.debug((Object)"devTypeAndVersionToTypeId is null, get dev type from as error!");
            return typeID;
        }
        Integer type = devTypeAndVersionToTypeId.get(new DevTypeAndVersion(devTypeID, devVersionID));
        return type == null ? typeID : type;
    }

    private void recordUnknowIconTypes(Map<Integer, NEType> needCheckTypes) {
        try {
            if (needCheckTypes == null || needCheckTypes.isEmpty()) {
                return;
            }
            long l = System.currentTimeMillis();
            for (Integer typeid : needCheckTypes.keySet()) {
                NETypeImpl neTypeImpl = (NETypeImpl)needCheckTypes.get(typeid);
                HashMap<String, Icon> mapIconMap = neTypeImpl.getMapIcons();
                HashMap<String, Icon> treeIconMap = neTypeImpl.getTreeIcons();
                if (!this.isNeedRefresh(mapIconMap) && !this.isNeedRefresh(treeIconMap)) continue;
                this.unknowIconTypes.add(neTypeImpl.getId());
            }
            logger.debug((Object)("cost " + (System.currentTimeMillis() - l) + " unknowIconTypes :" + this.unknowIconTypes.toString()));
        }
        catch (Exception e) {
            logger.error((Object)"check unknowIconTypes error", (Throwable)e);
        }
    }

    private boolean isNeedRefresh(HashMap<String, Icon> iconMap) {
        if (iconMap == null || iconMap.isEmpty()) {
            return false;
        }
        for (String key : iconMap.keySet()) {
            Icon icon = iconMap.get(key);
            if (!ResourceUtil.getInstance().isUnknowIcon(icon)) continue;
            return true;
        }
        return false;
    }

    public boolean refreshUnknowIconType(int typeid) {
        try {
            if (this.unknowIconTypes.contains(typeid)) {
                NEType neType = this.needShowNeTypes.get(typeid);
                if (neType != null) {
                    NETypeImpl neTypeImpl = (NETypeImpl)neType;
                    HashMap<String, Icon> mapIconMap = neTypeImpl.getMapIcons();
                    HashMap<String, String> mapFileNames = neTypeImpl.getFileNames();
                    boolean bMapRefreshed = this.refreshTypeIcon(mapIconMap, mapFileNames);
                    HashMap<String, Icon> treeIconMap = neTypeImpl.getTreeIcons();
                    HashMap<String, String> treeFileNames = neTypeImpl.getTreeFileNames();
                    boolean bTreeRefreshed = this.refreshTypeIcon(treeIconMap, treeFileNames);
                    if (bMapRefreshed && bTreeRefreshed) {
                        this.unknowIconTypes.remove(typeid);
                    }
                    logger.debug((Object)("refresh unknowIcon type end, result: " + typeid + " map" + (bMapRefreshed ? "1" : "0") + " tree" + (bTreeRefreshed ? "1" : "0")));
                    ValueNameIconManager.getInstance().refreshNETypeImage(neTypeImpl);
                }
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"refresh unknowIcon failed", (Throwable)e);
        }
        return false;
    }

    private boolean refreshTypeIcon(HashMap<String, Icon> iconMap, HashMap<String, String> fileNames) {
        boolean isAllRefreshSuccess = true;
        for (String key : iconMap.keySet()) {
            Icon icon = iconMap.get(key);
            if (!ResourceUtil.getInstance().isUnknowIcon(icon)) continue;
            ImageIcon imageIcon = SerialIconManagerImpl.getInstance().getIcon(fileNames.get(key));
            if (ResourceUtil.getInstance().isUnknowIcon(imageIcon)) {
                isAllRefreshSuccess = false;
                continue;
            }
            iconMap.put(key, imageIcon);
        }
        return isAllRefreshSuccess;
    }
}

