/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.data;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.iview.util.log.IviewLogger;
import java.util.HashMap;
import java.util.StringTokenizer;

public class OperatorRuleManager {
    private static final IviewLogger logger = IviewLogger.getLogger(OperatorRuleManager.class, (String)"EAM");
    private HashMap<Integer, HashMap> neOperateMap = new HashMap();
    private HashMap<Integer, HashMap> subnetOperateMap = new HashMap();
    private HashMap<Integer, HashMap> linkOperateMap = new HashMap();
    private static final String CREATE_RULE = "create-by-Client";
    private static final String CREATE_CHILD_RULE = "add-member";
    private static final String DELETE_RULE = "delete-by-Client";
    private static final String DELETE_CHILE_RULE = "delete-member";
    private static final String ALLOW_MOVE_RULE = "self-move";
    private static final String MOVE_DESTINATION_RULE = "as-move-dst";
    private static final String ALLOW_MOVE_CHILE_RULE = "subobj-move-alone";
    private static final String ALLOW_CREATE_NECHILE_TYPE_RULE = "subne-type";
    private static final String ALLOW_CREATE_SNCHILE_TYPE_RULE = "subsn-type";
    private static final String PARENT_TYPE_RULE = "upper-sn-type";
    private static final String ALLOW_RIGHT_CONTROL_RULE = "regist-to-security";
    private static OperatorRuleManager instance = new OperatorRuleManager();

    protected OperatorRuleManager() {
    }

    public static OperatorRuleManager getInstance() {
        if (instance == null) {
            instance = new OperatorRuleManager();
        }
        return instance;
    }

    public void initOperatorRule(DataTable subnetTypeTable, DataTable neTypeTable, DataTable linkTypeTable) {
        try {
            if (subnetTypeTable != null && subnetTypeTable.size() > 0) {
                this.initSubOperatorRule(this.subnetOperateMap, subnetTypeTable);
                if (this.subnetOperateMap.size() > 0) {
                    logger.trace((Object)("subnet operate rule size: " + this.subnetOperateMap.size()));
                }
            }
            if (neTypeTable != null && neTypeTable.size() > 0) {
                this.initSubOperatorRule(this.neOperateMap, neTypeTable);
                if (this.neOperateMap.size() > 0) {
                    logger.trace((Object)("ne operate rule size: " + this.neOperateMap.size()));
                }
            }
            if (linkTypeTable != null && linkTypeTable.size() > 0) {
                this.initSubOperatorRule(this.linkOperateMap, linkTypeTable);
                if (this.linkOperateMap.size() > 0) {
                    logger.trace((Object)("link operate rule size: " + this.linkOperateMap.size()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void initSubOperatorRule(HashMap<Integer, HashMap> typeMap, DataTable typeTable) {
        for (DataRecord record : typeTable) {
            if (record.get("type_id") == null) continue;
            int typeID = record.getInt("type_id");
            this.configureRuleMap(typeID, typeMap, record);
        }
    }

    private HashMap getSubRuleMap(int typeID, HashMap<Integer, HashMap> typeMap) {
        if (typeMap.get(typeID) == null) {
            HashMap subMap = new HashMap();
            typeMap.put(typeID, subMap);
            return subMap;
        }
        return typeMap.get(typeID);
    }

    private void configureRuleMap(int typeID, HashMap<Integer, HashMap> typeMap, DataRecord record) {
        String featureName = record.get("feature_name");
        if (featureName == null) {
            return;
        }
        if (featureName.equals(ALLOW_CREATE_NECHILE_TYPE_RULE)) {
            this.getSubRuleMap(typeID, typeMap).put(ALLOW_CREATE_NECHILE_TYPE_RULE, record.get("feature_value"));
        } else if (featureName.equals(ALLOW_CREATE_SNCHILE_TYPE_RULE)) {
            this.getSubRuleMap(typeID, typeMap).put(ALLOW_CREATE_SNCHILE_TYPE_RULE, record.get("feature_value"));
        } else if (featureName.equals(CREATE_CHILD_RULE)) {
            boolean result = Boolean.parseBoolean(record.get("feature_value").trim());
            this.getSubRuleMap(typeID, typeMap).put(CREATE_CHILD_RULE, result);
        } else if (featureName.equals(ALLOW_MOVE_CHILE_RULE)) {
            boolean result = Boolean.parseBoolean(record.get("feature_value").trim());
            this.getSubRuleMap(typeID, typeMap).put(ALLOW_MOVE_CHILE_RULE, result);
        } else if (featureName.equals(ALLOW_MOVE_RULE)) {
            boolean result = Boolean.parseBoolean(record.get("feature_value").trim());
            this.getSubRuleMap(typeID, typeMap).put(ALLOW_MOVE_RULE, result);
        } else if (featureName.equals(ALLOW_RIGHT_CONTROL_RULE)) {
            this.getSubRuleMap(typeID, typeMap).put(ALLOW_RIGHT_CONTROL_RULE, record.getInt("feature_value"));
        } else if (featureName.equals(CREATE_RULE)) {
            this.getSubRuleMap(typeID, typeMap).put(CREATE_RULE, record.getInt("feature_value"));
        } else if (featureName.equals(DELETE_CHILE_RULE)) {
            boolean result = Boolean.parseBoolean(record.get("feature_value").trim());
            this.getSubRuleMap(typeID, typeMap).put(DELETE_CHILE_RULE, result);
        } else if (featureName.equals(DELETE_RULE)) {
            this.getSubRuleMap(typeID, typeMap).put(DELETE_RULE, record.getInt("feature_value"));
        } else if (featureName.equals(MOVE_DESTINATION_RULE)) {
            boolean result = Boolean.parseBoolean(record.get("feature_value").trim());
            this.getSubRuleMap(typeID, typeMap).put(MOVE_DESTINATION_RULE, result);
        } else if (featureName.equals(PARENT_TYPE_RULE)) {
            this.getSubRuleMap(typeID, typeMap).put(PARENT_TYPE_RULE, record.get("feature_value"));
        }
    }

    public boolean isAllowCreateNe(int typeId) {
        if (this.neOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.neOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(CREATE_RULE) != null) {
            if ((Integer)subOperatorMap.get(CREATE_RULE) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isAllowCreateNeChild(int typeId) {
        if (this.neOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.neOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(CREATE_CHILD_RULE) != null) {
            return (Boolean)subOperatorMap.get(CREATE_CHILD_RULE);
        }
        return true;
    }

    public boolean isAllowCreateSubnet(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(CREATE_RULE) != null) {
            if ((Integer)subOperatorMap.get(CREATE_RULE) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isAllowCreateLink(int typeId) {
        if (this.linkOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.linkOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(CREATE_RULE) != null) {
            if ((Integer)subOperatorMap.get(CREATE_RULE) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isAllowDeleteNe(int typeId) {
        if (this.neOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.neOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(DELETE_RULE) == null) {
            return true;
        }
        if (subOperatorMap.get(DELETE_RULE) != null) {
            if ((Integer)subOperatorMap.get(DELETE_RULE) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isAllowDeleteSubnet(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(DELETE_RULE) == null) {
            return true;
        }
        if (subOperatorMap.get(DELETE_RULE) != null) {
            if ((Integer)subOperatorMap.get(DELETE_RULE) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isAllowDeleteLink(int typeId) {
        if (this.linkOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.linkOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(DELETE_RULE) != null) {
            if ((Integer)subOperatorMap.get(DELETE_RULE) == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isAllowDeleteNeChildren(int typeId) {
        if (this.neOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.neOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(DELETE_CHILE_RULE) != null) {
            return (Boolean)subOperatorMap.get(DELETE_CHILE_RULE);
        }
        return true;
    }

    public boolean isAllowDeleteSubnetChildren(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(DELETE_CHILE_RULE) != null) {
            return (Boolean)subOperatorMap.get(DELETE_CHILE_RULE);
        }
        return true;
    }

    public boolean isAllowRightControlNe(int typeId) {
        return true;
    }

    public boolean isAllowRightControlLink(int typeId) {
        return true;
    }

    public boolean isAllowRightControlLink(String dn) {
        return true;
    }

    public boolean isMoveDestinationNe(int typeId) {
        if (this.neOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.neOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(MOVE_DESTINATION_RULE) != null) {
            return (Boolean)subOperatorMap.get(MOVE_DESTINATION_RULE);
        }
        return true;
    }

    public boolean isMoveDestinationSubnet(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(MOVE_DESTINATION_RULE) != null) {
            return (Boolean)subOperatorMap.get(MOVE_DESTINATION_RULE);
        }
        return true;
    }

    public boolean isAllowMoveNeSelf(int typeId) {
        if (this.neOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.neOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(ALLOW_MOVE_RULE) != null) {
            return (Boolean)subOperatorMap.get(ALLOW_MOVE_RULE);
        }
        return true;
    }

    public boolean isAllowMoveSubnetSelf(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(ALLOW_MOVE_RULE) != null) {
            return (Boolean)subOperatorMap.get(ALLOW_MOVE_RULE);
        }
        return true;
    }

    public boolean isAllowMoveChildByNe(int typeId) {
        if (this.neOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.neOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(ALLOW_MOVE_CHILE_RULE) != null) {
            return (Boolean)subOperatorMap.get(ALLOW_MOVE_CHILE_RULE);
        }
        return true;
    }

    public boolean isAllowMoveChildBySubnet(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return true;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return true;
        }
        if (subOperatorMap.get(ALLOW_MOVE_CHILE_RULE) != null) {
            return (Boolean)subOperatorMap.get(ALLOW_MOVE_CHILE_RULE);
        }
        return true;
    }

    public int[] allowCreateNeChildTypeBySubnet(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return null;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return null;
        }
        if (subOperatorMap.get(ALLOW_CREATE_NECHILE_TYPE_RULE) == null) {
            return null;
        }
        String reslut = (String)subOperatorMap.get(ALLOW_CREATE_NECHILE_TYPE_RULE);
        return this.getTypeIds(reslut);
    }

    public int[] allowCreateSnChildTypeBySubnet(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return null;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return null;
        }
        if (subOperatorMap.get(ALLOW_CREATE_SNCHILE_TYPE_RULE) == null) {
            return null;
        }
        String reslut = (String)subOperatorMap.get(ALLOW_CREATE_SNCHILE_TYPE_RULE);
        return this.getTypeIds(reslut);
    }

    public int[] parentTypeByCreateSubnet(int typeId) {
        if (this.subnetOperateMap.get(typeId) == null) {
            return null;
        }
        HashMap subOperatorMap = this.subnetOperateMap.get(typeId);
        if (subOperatorMap.size() == 0) {
            return null;
        }
        if (subOperatorMap.get(PARENT_TYPE_RULE) == null) {
            return null;
        }
        return this.getTypeIds((String)subOperatorMap.get(PARENT_TYPE_RULE));
    }

    private int[] getTypeIds(String type) {
        StringTokenizer t = new StringTokenizer(type, ",");
        int[] result = new int[t.countTokens()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(t.nextToken());
        }
        return result;
    }

    public boolean isAllowCreateNeChildForSnParent(int parentTypeId, int ownerTypeId) {
        int[] types = this.allowCreateNeChildTypeBySubnet(parentTypeId);
        if (types != null) {
            for (int type : types) {
                if (type != ownerTypeId) continue;
                return true;
            }
        }
        return types == null || types.length == 0;
    }

    public boolean isAllowCreateSnChildForSnParent(int parentTypeId, int ownerTypeId) {
        int[] parentTypes;
        int[] types = this.allowCreateSnChildTypeBySubnet(parentTypeId);
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != ownerTypeId) continue;
                return true;
            }
        }
        if ((parentTypes = this.parentTypeByCreateSubnet(ownerTypeId)) != null) {
            for (int i = 0; i < parentTypes.length; ++i) {
                if (parentTypes[i] != parentTypeId) continue;
                return true;
            }
        }
        return !(parentTypes != null && parentTypes.length != 0 || types != null && types.length != 0);
    }

    public static boolean verifyCommandRights(String key) {
        return true;
    }

    public void clear() {
        if (this.neOperateMap != null) {
            this.neOperateMap.clear();
        }
        this.neOperateMap = null;
        if (this.subnetOperateMap != null) {
            this.subnetOperateMap.clear();
        }
        this.subnetOperateMap = null;
        if (this.linkOperateMap != null) {
            this.linkOperateMap.clear();
        }
        this.linkOperateMap = null;
        instance = null;
    }
}

