/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl.data;

import com.swimap.external.resource.client.basicType.AlarmLevel;
import com.swimap.external.resource.client.basicType.ResourceClientUtil;
import com.swimap.external.sf.color.ColorInfo;
import com.swimap.external.sf.color.ColorManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.innerimpl.data.ResourceXmlManagerImpl;
import java.util.ArrayList;
import java.util.List;

public class AlarmColorPluginManager
implements ColorManager {
    private static final IviewLogger logger = IviewLogger.getLogger(AlarmColorPluginManager.class, (String)"EAM");

    public void clear() {
    }

    public List<ColorInfo> getColorInfo() {
        List<ColorInfo> colorInfoList = null;
        try {
            colorInfoList = this.initColorInfo(ResourceXmlManagerImpl.getInstance().getUserAlarmLevels());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return colorInfoList;
    }

    public List<ColorInfo> getDefaultColorInfo() {
        List<ColorInfo> colorInfoList = null;
        try {
            colorInfoList = this.initColorInfo(ResourceXmlManagerImpl.getInstance().getDefaultAlarmLevels());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return colorInfoList;
    }

    public boolean saveColor(List<ColorInfo> colorInfoLst) {
        if (colorInfoLst != null) {
            try {
                for (ColorInfo colorInfo : colorInfoLst) {
                    String key = colorInfo.getKey();
                    if (!key.startsWith("alarm.level.color.") || !(key = key.substring("alarm.level.color.".length())).matches("\\d+")) continue;
                    int level = Integer.parseInt(key);
                    AlarmLevel alarmLevel = ResourceClientUtil.getInstance().getResouceClientInterface().getAlarmLevelInfo(level);
                    if (alarmLevel == null) continue;
                    alarmLevel.setColor(colorInfo.getColor());
                }
                ResourceXmlManagerImpl.getInstance().writeBack();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private List<ColorInfo> initColorInfo(List<AlarmLevel> alarmLevels) {
        ArrayList<ColorInfo> colorInfoList = new ArrayList<ColorInfo>();
        if (alarmLevels != null) {
            for (AlarmLevel alarmLevel : alarmLevels) {
                colorInfoList.add(new ColorInfo("alarm.level.color." + alarmLevel.getId(), alarmLevel.getLabel(), alarmLevel.getColor()));
            }
        }
        return colorInfoList;
    }
}

