/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.innerimpl;

import com.swimap.external.resource.client.basicType.AlarmLevel;
import com.swimap.external.resource.client.basicType.ContainAlarmStateType;
import com.swimap.external.resource.client.basicType.LinkType;
import com.swimap.external.resource.client.basicType.NEType;
import com.swimap.external.resource.client.basicType.ResourceClientUtil;
import com.swimap.external.resource.client.basicType.SubnetType;
import com.swimap.external.resource.client.basicType.ValueNameIconInterface;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.resource.client.innerimpl.common.ResourceClientException;
import com.swimap.resource.client.innerimpl.data.ResourceParseManagerImpl;
import com.swimap.resource.client.innerimpl.data.ResourceXmlManagerImpl;
import com.swimap.resource.client.innerimpl.data.SerialIconManagerImpl;
import com.swimap.resource.client.innerimpl.data.UnVisibleNeTypeManager;
import com.swimap.resource.client.innerimpl.data.ValueNameIconImpl;
import com.swimap.resource.client.innerimpl.data.ValueNameIconManager;
import com.swimap.resource.client.innerimpl.util.ResourceUtil;
import com.swimap.resource.client.innerinterface.IResouceInnerInterface;
import com.swimap.resource.client.innerinterface.IResourceEventListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.omg.CORBA.ORB;

public class ResourceBaseModule
extends BaseModule
implements IResouceInnerInterface {
    private static final IviewLogger logger = IviewLogger.getLogger(ResourceBaseModule.class, (String)"EAM");
    private ValueNameIconInterface valueNameIconImpl = new ValueNameIconImpl();
    private List<IResourceEventListener> resourceEventListener = Collections.synchronizedList(new LinkedList());

    public ResourceBaseModule(ModuleManager moduleManager, ORB orb, String terminalIdValue, String instanceIdValue) throws ModuleManagementException {
        super(moduleManager, orb, terminalIdValue, instanceIdValue);
        this.init();
        this.register(this);
    }

    public String getModuleName() {
        return "resource";
    }

    private void init() {
        block2: {
            logger.debug((Object)"resource modelInit start");
            try {
                ResourceParseManagerImpl.getInstance().initialize();
            }
            catch (ResourceClientException e) {
                logger.error((Object)"resource modelInit failure....", (Throwable)e);
                if (!FrameworkCommandProcessor.getInstance().isExitWhileLoading()) break block2;
                return;
            }
        }
        ResourceClientUtil.getInstance().setInterface(this);
        logger.debug((Object)"resource modelInit end");
    }

    public void stop() {
        logger.debug((Object)"resource modelStop");
        ResourceClientUtil.getInstance().setInterface(null);
        ResourceXmlManagerImpl.getInstance().clear();
        SerialIconManagerImpl.clear();
        UnVisibleNeTypeManager.clear();
        ResourceParseManagerImpl.getInstance().clear();
        ValueNameIconManager.getInstance().clear();
        if (this.resourceEventListener != null) {
            this.resourceEventListener.clear();
            this.resourceEventListener = null;
        }
        logger.debug((Object)"resource modelStop success");
    }

    @Override
    public AlarmLevel[] getAlarmLevels() {
        return ResourceParseManagerImpl.getInstance().getAlarmLevels();
    }

    @Override
    public LinkType[] getAllLinkTypes() {
        return ResourceParseManagerImpl.getInstance().getAllLinkTypes();
    }

    @Override
    public NEType[] getAllNETypes() {
        return ResourceParseManagerImpl.getInstance().getAllNETypes();
    }

    @Override
    public NEType[] getAllNeTypesNotFilter() {
        Collection<NEType> allType = ResourceParseManagerImpl.getInstance().getAllNeTypesNotFilter();
        if (allType != null) {
            return allType.toArray(new NEType[0]);
        }
        return null;
    }

    @Override
    public SubnetType[] getAllSubnetTypes() {
        return ResourceParseManagerImpl.getInstance().getAllSubnetTypes();
    }

    @Override
    public Icon getIcon(String iconFileName) {
        return SerialIconManagerImpl.getInstance().getIcon(iconFileName);
    }

    @Override
    public LinkType getLinkType(int linkTypeID) {
        return ResourceParseManagerImpl.getInstance().getLinkType(linkTypeID);
    }

    @Override
    public NEType getNEType(int neTypeID) {
        return ResourceParseManagerImpl.getInstance().getNEType(neTypeID);
    }

    @Override
    public ImageIcon getNodeIconFromResource(int typeId, String label) {
        return ResourceParseManagerImpl.getInstance().getNodeIconFromResource(typeId, label);
    }

    @Override
    public SubnetType getSubentType(int subnetTypeID) {
        return ResourceParseManagerImpl.getInstance().getSubentType(subnetTypeID);
    }

    @Override
    public AlarmLevel getAlarmLevelInfo(int alarmLevelId) {
        return ResourceParseManagerImpl.getInstance().getAlarmLevlelInfo(alarmLevelId);
    }

    @Override
    public ContainAlarmStateType getContainAlarm(int containAlarmValue) {
        return ResourceParseManagerImpl.getInstance().getContainAlarm(containAlarmValue);
    }

    @Override
    public SubnetType getPhysicalRoot() {
        return ResourceParseManagerImpl.getInstance().getSubentType(0);
    }

    @Override
    public HashMap<Integer, AlarmLevel> getAllAlarmLevel() {
        return ResourceParseManagerImpl.getInstance().getAllAlarmLevel();
    }

    @Override
    public LinkType[] getAllLinkDefaultTypes() {
        return ResourceParseManagerImpl.getInstance().getAllLinkTypes();
    }

    @Override
    public NEType[] getAllNeDefaultTypesExtends() {
        return this.getAllNETypes();
    }

    @Override
    public NEType[] getAllNeTypesExtends() {
        return this.getAllNETypes();
    }

    @Override
    public List<Integer> getAllUnVisible() {
        return ResourceParseManagerImpl.getInstance().getAllUnVisible();
    }

    @Override
    public ContainAlarmStateType[] getAllContainAlarmStateTypes() {
        return ResourceParseManagerImpl.getInstance().getAllContainAlarmStateTypes();
    }

    @Override
    public int getOMCNeTypeID() {
        return 100000;
    }

    @Override
    public void writeBack() {
        ResourceXmlManagerImpl.getInstance().writeBack();
    }

    @Override
    public AlarmLevel[] getAllDefaultAlarmLevels() {
        return ResourceParseManagerImpl.getInstance().getAllDefaultAlarmLevels();
    }

    @Override
    public ImageIcon getNodeImageIconWidthTypeAndLabel(int typeId, String label) {
        return this.getNodeIconFromResource(typeId, label);
    }

    @Override
    public Set<Integer> getNoMangerTypeIds() {
        return ResourceParseManagerImpl.getInstance().getNoMangerTypeIds();
    }

    public static Plugin getResouceModulePlugin() {
        return ResourceUtil.getInstance().getResouceModulePlugin();
    }

    @Override
    public SubnetType[] getSubnetTypeByKind(int kind) {
        return ResourceParseManagerImpl.getInstance().getSubnetTypeByKind(kind);
    }

    @Override
    public ValueNameIconInterface getValueNameIconInterface() {
        return this.valueNameIconImpl;
    }

    @Override
    public int getDevTypeIDByTypeID(int typeID) throws NumberFormatException {
        return ResourceParseManagerImpl.getInstance().getDevTypeIDByTypeID(typeID);
    }

    @Override
    public int getNeTypeByDevTypeAndDevVersionID(int iDevTypeID, int iDevVersionID) throws NumberFormatException {
        return ResourceParseManagerImpl.getInstance().getTypeIDByDevTypeAndVersionID(iDevTypeID, iDevVersionID);
    }

    @Override
    public int getVersionTypeIDByTypeID(int typeID) throws NumberFormatException {
        return ResourceParseManagerImpl.getInstance().getVersionTypeIDByTypeID(typeID);
    }

    @Override
    public boolean isHideSubnet(int typeId) {
        return ResourceParseManagerImpl.getInstance().isHideSn(typeId);
    }

    @Override
    public boolean registerResourceEventListener(IResourceEventListener listen) {
        logger.trace((Object)("regist start ,listen : " + listen));
        boolean result = false;
        try {
            result = this.resourceEventListener.add(listen);
            logger.trace((Object)("regist end ,listen : " + listen));
        }
        catch (Exception e) {
            logger.error((Object)("regist listen : " + listen + " is failed."));
        }
        return result;
    }

    @Override
    public boolean unRegisterResourceEventListener(IResourceEventListener listen) {
        logger.trace((Object)("unregist start, listen : " + listen));
        boolean result = false;
        try {
            result = this.resourceEventListener.remove(listen);
            logger.trace((Object)("unregist end, listen : " + listen));
        }
        catch (Exception e) {
            logger.error((Object)("unregist listen : " + listen + " is failed."));
        }
        return result;
    }

    @Override
    public Collection<IResourceEventListener> getResourceEventListener() {
        if (this.resourceEventListener != null) {
            return new LinkedList<IResourceEventListener>(this.resourceEventListener);
        }
        return null;
    }
}

