/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.resource.client.impl;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.resource.client.innerimpl.data.ResourceXmlManagerImpl;
import com.swimap.resource.client.innerinterface.IInnerAlarmLevel;
import java.awt.Color;

public class AlarmLevelImpl
implements IInnerAlarmLevel {
    private static final int FULL_COLOR = 255;
    private int alarmLevel;
    private String label;
    private char synopsis;
    private Color color;
    private String sound;
    private int soundDelay;
    private boolean isSounding = false;
    private int highLightTime;
    private int soundInterval;
    private int soundStatus;
    private boolean isLongPeriodSettingEnable = false;
    private int longTimeAlarmStatus;

    public AlarmLevelImpl(int alarmLevel, String alarmLabel, char synopsis) {
        this.alarmLevel = alarmLevel;
        this.label = alarmLabel;
        this.synopsis = synopsis;
    }

    @Override
    public int getId() {
        return this.alarmLevel;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int getHighLightTime() {
        return this.highLightTime;
    }

    @Override
    public boolean getIsSounding() {
        return this.isSounding;
    }

    @Override
    public int getLongTimeAlarmStatus() {
        return this.longTimeAlarmStatus;
    }

    @Override
    public String getSound() {
        return this.sound;
    }

    @Override
    public int getSoundDelay() {
        return this.soundDelay;
    }

    @Override
    public int getSoundInterval() {
        return this.soundInterval;
    }

    @Override
    public int getSoundStatus() {
        return this.soundStatus;
    }

    @Override
    public char getSynopsis() {
        return this.synopsis;
    }

    @Override
    public boolean isLongTimeSettingEnable() {
        return this.isLongPeriodSettingEnable;
    }

    @Override
    public void setColor(Color cor) {
        this.color = cor;
    }

    @Override
    public void setHighLightTime(int highLightTime) {
        if (highLightTime < 0) {
            highLightTime = 0;
        }
        this.highLightTime = highLightTime;
    }

    @Override
    public void setIsSounding(boolean isSounding) {
        this.isSounding = isSounding;
    }

    @Override
    public void setLongTimeAlarmStatus(int longTimeAlmStus) {
        this.longTimeAlarmStatus = longTimeAlmStus;
    }

    @Override
    public void setLongTimeSettingEnable(boolean enable) {
        this.isLongPeriodSettingEnable = enable;
    }

    @Override
    public void setSound(String sd) {
        this.sound = sd;
    }

    @Override
    public void setSoundDelay(int soundDelay) {
        if (soundDelay < 0) {
            soundDelay = 1;
        }
        this.soundDelay = soundDelay;
    }

    @Override
    public void setSoundInterval(int soundInterval) {
        if (soundInterval < 0) {
            soundInterval = 0;
        }
        this.soundInterval = soundInterval;
    }

    @Override
    public void setSoundStatus(int soundStatus) {
        this.soundStatus = soundStatus;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void writeBack(DescContainer desc) {
        desc.setParasItem("id", String.valueOf(this.alarmLevel));
        desc.setParasItem("synopsis", String.valueOf(this.synopsis));
        desc.setParasItem("color", ResourceXmlManagerImpl.getColorString(this.color));
        desc.setParasItem("sound", this.sound);
        desc.setParasItem("sound-delay", String.valueOf(this.soundDelay));
        desc.setParasItem("isSounding", Boolean.toString(this.isSounding), true);
        desc.setParasItem("highLightTime", String.valueOf(this.highLightTime), true);
        desc.setParasItem("sound-interval", String.valueOf(this.soundInterval), true);
        desc.setParasItem("isLongPeriodSettingEnable", String.valueOf(this.isLongPeriodSettingEnable), true);
        desc.setParasItem("longTimeAlarmStatus", String.valueOf(this.longTimeAlarmStatus), true);
        desc.setParasItem("soundStatus", String.valueOf(this.soundStatus), true);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.label).append("-");
        buf.append(this.alarmLevel).append("-");
        buf.append(this.synopsis).append("-");
        buf.append(this.color != null ? this.color.getRGB() : 255).append("-");
        buf.append(this.sound).append("-");
        buf.append(this.soundDelay).append("-");
        buf.append(this.isSounding).append("-");
        buf.append(this.highLightTime).append("-");
        buf.append(this.soundInterval).append("-");
        buf.append(this.soundStatus).append("-");
        buf.append(this.isLongPeriodSettingEnable).append("-");
        buf.append(this.longTimeAlarmStatus);
        return buf.toString();
    }
}

