/*
 * Decompiled with CFR 0.152.
 */
package imap.iMAPcommon;

import com.swimap.iview.framework.pluginmanagement.PluginManager;
import imap.external.iMAPcommon.ErrorCode;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class CorbaUtils
implements ErrorCode {
    private static ResourceBundle res = null;
    private static Log logger = LogFactory.getLog(CorbaUtils.class);

    public static String getString(String key) {
        try {
            return res.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static long exportNamingRef(ORB orb, Object ref, String nameStr) {
        NameComponent[] name = null;
        Object obj = null;
        NamingContextExt rootContext = null;
        logger.info((java.lang.Object)("exportNamingRef " + nameStr));
        try {
            obj = orb.resolve_initial_references("NameService");
            rootContext = NamingContextExtHelper.narrow((Object)obj);
            if (rootContext == null) {
                logger.error((java.lang.Object)"Root context is null");
                return 5020L;
            }
            name = rootContext.to_name(nameStr);
            try {
                rootContext.rebind(name, ref);
            }
            catch (NotFound e) {
                logger.error((java.lang.Object)e.toString(), (Throwable)e);
                NameComponent[] cxtname = new NameComponent[name.length - 1];
                System.arraycopy(name, 0, cxtname, 0, name.length - 1);
                try {
                    rootContext.bind_new_context(cxtname);
                }
                catch (Exception ex) {
                    logger.error((java.lang.Object)ex.toString(), (Throwable)ex);
                    return 5020L;
                }
                rootContext.rebind(name, ref);
            }
        }
        catch (Exception cx) {
            logger.error((java.lang.Object)cx.toString(), (Throwable)cx);
            return 5019L;
        }
        return 0L;
    }

    public static Object importNamingRef(ORB orb, String nameStr) {
        NamingContextExt rootContext = null;
        NameComponent[] name = null;
        Object obj = null;
        logger.info((java.lang.Object)("importNamingRef " + nameStr));
        try {
            obj = orb.resolve_initial_references("NameService");
            rootContext = NamingContextExtHelper.narrow((Object)obj);
            if (rootContext == null) {
                logger.error((java.lang.Object)"root context is null");
                return null;
            }
            name = rootContext.to_name(nameStr);
            obj = rootContext.resolve(name);
            return obj;
        }
        catch (NotFound nx) {
            logger.error((java.lang.Object)nx.toString(), (Throwable)nx);
            return null;
        }
        catch (Exception ex) {
            logger.error((java.lang.Object)"Imports Object reference error.", (Throwable)ex);
            return null;
        }
    }

    public static long unbindNamingRef(ORB orb, String nameStr) {
        NamingContextExt rootContext = null;
        NameComponent[] name = null;
        Object obj = null;
        logger.info((java.lang.Object)("unbind " + nameStr));
        try {
            obj = orb.resolve_initial_references("NameService");
            rootContext = NamingContextExtHelper.narrow((Object)obj);
            if (rootContext == null) {
                logger.error((java.lang.Object)"rootContext is null");
                return 5021L;
            }
            name = rootContext.to_name(nameStr);
            rootContext.unbind(name);
        }
        catch (Exception ex) {
            logger.error((java.lang.Object)ex.toString(), (Throwable)ex);
            return 5021L;
        }
        return 0L;
    }

    public static String getExceptionMessage(Exception ex) {
        if (null == ex) {
            return "";
        }
        logger.info((java.lang.Object)("sf | unbindNamingRef | Exception:" + ex.getMessage()));
        logger.error((java.lang.Object)ex.toString(), (Throwable)ex);
        try {
            if (ex instanceof UNKNOWN) {
                if ("Unexpected User Exception: IDL:omg.org/CORBA/COMM_FAILURE:1.0".equals(ex.getMessage())) {
                    return CorbaUtils.getString("NetworkException");
                }
                if ("Unexpected User Exception: IDL:omg.org/CORBA/TRANSIENT:1.0".equals(ex.getMessage())) {
                    return CorbaUtils.getString("TransientException");
                }
                if ("Unexpected User Exception: IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0".equals(ex.getMessage())) {
                    return CorbaUtils.getString("TransientException");
                }
            }
            if (ex instanceof COMM_FAILURE) {
                return CorbaUtils.getString("NetworkException");
            }
            if (ex instanceof TRANSIENT) {
                return CorbaUtils.getString("TransientException");
            }
            if (ex instanceof OBJECT_NOT_EXIST) {
                return CorbaUtils.getString("TransientException");
            }
            return "";
        }
        catch (Exception exception) {
            logger.error((java.lang.Object)exception.toString(), (Throwable)exception);
            return "";
        }
    }

    static {
        try {
            res = PluginManager.getInstance().getPlugin("com.swimap.orbbase").getResource().getResourceBundleFromPropertyFile("Res");
        }
        catch (Exception e) {
            logger.error((java.lang.Object)e.toString(), (Throwable)e);
        }
    }
}

