/*
 * Decompiled with CFR 0.152.
 */
package imap.iMAPcommon;

import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class CommonTool {
    private static final IviewLogger log = IviewLogger.getLogger(CommonTool.class, (String)"FRM");

    public static boolean isUseAllIP() {
        try {
            String value = System.getProperty("use_all_ip");
            log.info((Object)("sf | isUseAllIP | use_all_ip:" + value));
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            return false;
        }
    }

    public static int getTimeOutTime() {
        int timeout = 5000;
        try {
            String value = System.getProperty("test_all_ip_timeout");
            log.info((Object)("sf | getTimeOutTime | test_all_ip_timeout:" + value));
            if (value != null) {
                timeout = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        return timeout;
    }

    public static int getTryToConnectTimes() {
        int times = 1;
        try {
            String value = System.getProperty("try_connect_times");
            log.info((Object)("sf | getTryToConnectTimes | try_connect_times:" + value));
            if (value != null) {
                times = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        return times;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryToConnect(String host, int port, int timeout, int times) {
        Socket socket = null;
        for (int i = 0; i < times; ++i) {
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                if (!socket.isConnected()) continue;
                socket.close();
                log.info((Object)("sys | tryToConnect | connect succeed with " + host + ':' + port));
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                log.error((Object)"tryToConnect fail.", (Throwable)e);
                continue;
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.error((Object)"tryToConnect close socket fail.", (Throwable)e);
                }
            }
        }
        log.info((Object)("sys | tryToConnect | connect fail with " + host + ':' + port));
        return false;
    }
}

