/*
 * Decompiled with CFR 0.152.
 */
package imap.external.iMAPcommon;

import imap.iMAPcommon.CommonTool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HedexConfigUtil {
    private static HedexConfigUtil instance = null;
    private final String hedexIpProp = "hedexWebIP";
    private final String hedexPortProp = "hedexWebPort";
    private final String hedexWebProtocal = "hedexWebProtocol";
    private Log logger = LogFactory.getLog(HedexConfigUtil.class);

    public static HedexConfigUtil getInstance() {
        if (instance == null) {
            instance = new HedexConfigUtil();
        }
        return instance;
    }

    public void setHedexIpAndPort(String loginIP, String[] infos) {
        if (infos.length < 3) {
            this.logger.error((Object)"Hedex setting information error.The length of infos<3");
            return;
        }
        String hedexPort = infos[1];
        String webProtocal = "http";
        if (Boolean.parseBoolean(System.getProperty("imap.enableSSL"))) {
            webProtocal = "https";
            hedexPort = infos[2];
        }
        System.setProperty("hedexWebPort", hedexPort);
        System.setProperty("hedexWebProtocol", webProtocal);
        String hedexWebIP = infos[0];
        boolean use_all_ip = CommonTool.isUseAllIP();
        if (use_all_ip) {
            int timeout = CommonTool.getTimeOutTime();
            int times = CommonTool.getTryToConnectTimes();
            boolean connectResult = CommonTool.tryToConnect(loginIP, Integer.parseInt(hedexPort), timeout, times);
            if (connectResult) {
                hedexWebIP = loginIP;
            }
        }
        System.setProperty("hedexWebIP", hedexWebIP);
        this.logger.info((Object)("Hedex set port:" + hedexPort + " ip|hostName :" + hedexWebIP + " webProtocal:" + webProtocal));
    }
}

