/*
 * Decompiled with CFR 0.152.
 */
package imap.external.iMAPcommon;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;
import org.omg.GIOP.Version;
import org.openorb.iiop.CDRInputStream;
import org.openorb.iiop.CDROutputStream;
import org.openorb.io.MarshalBuffer;
import org.openorb.io.StorageBuffer;

public final class CDRUtils {
    private static final Version GIOPVersion = new Version(1, 2);
    private static ORB orb;
    private static volatile boolean IsBigEndian;
    private static Log logger;

    private CDRUtils() {
    }

    public static byte[] int2Bytes(int val) {
        byte[] bs = new byte[]{(byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
        return bs;
    }

    public static int bytes2Int(byte[] bs) {
        int fourth = 0;
        int third = 0;
        int second = 0;
        int first = 0;
        int val = 0;
        fourth = (bs[0] & 0xFF) << 24;
        third = (bs[1] & 0xFF) << 16;
        second = (bs[2] & 0xFF) << 8;
        first = bs[3] & 0xFF;
        val = fourth + third + second + first;
        return val;
    }

    public static byte[] struct2Byte(Streamable struct) {
        return CDRUtils.struct2Byte(struct, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] struct2Byte(Streamable struct, boolean flag) {
        byte[] byArray;
        if (struct == null) {
            logger.error((Object)"sf | struct2Byte | structToByte data or struct is null");
            return null;
        }
        CDROutputStream stream = null;
        try {
            MarshalBuffer buffer = new MarshalBuffer(null, null);
            stream = new CDROutputStream(orb, GIOPVersion, buffer);
            if (flag) {
                stream.write_octet((byte)0);
            }
            struct._write((OutputStream)stream);
            StorageBuffer sb = buffer.lastFragment();
            if (sb == null) {
                logger.error((Object)"StorageBuffer is null");
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray3 = sb.linearize();
            return byArray3;
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
            byArray = null;
            return byArray;
        }
        catch (Throwable err) {
            logger.error((Object)err.toString(), err);
            byArray = null;
            return byArray;
        }
        finally {
            if (null != stream) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException ioex) {
                    logger.error((Object)ioex.toString(), (Throwable)ioex);
                }
                catch (SystemException sex) {
                    logger.error((Object)sex.toString(), (Throwable)sex);
                }
            }
        }
    }

    public static int byte2Struct(byte[] data, Streamable struct) {
        return CDRUtils.byte2Struct(data, struct, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int byte2Struct(byte[] data, Streamable struct, boolean flag) {
        if (data == null || data.length == 0) {
            logger.error((Object)"sf | byte2Struct | byteToStruct data is empty");
            return -1;
        }
        if (struct == null) {
            logger.error((Object)"sf | byte2Struct |  byteToStruct struct is null");
            return -1;
        }
        CDRInputStream stream = null;
        try {
            StorageBuffer buffer = new StorageBuffer(data, 0, data.length);
            stream = new CDRInputStream(orb, true, GIOPVersion, buffer);
            if (flag) {
                byte byte_order = stream.read_octet();
                if (byte_order == 0) {
                    IsBigEndian = true;
                    stream.bigEndian(true);
                } else {
                    IsBigEndian = false;
                    stream.bigEndian(false);
                }
            } else {
                stream.bigEndian(IsBigEndian);
            }
            struct._read((InputStream)stream);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
            int n = -1;
            return n;
        }
        catch (Throwable err) {
            logger.error((Object)err.toString(), err);
            int n = -1;
            return n;
        }
        finally {
            if (null != stream) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException ioex) {
                    logger.error((Object)ioex.toString(), (Throwable)ioex);
                }
                catch (SystemException sex) {
                    logger.error((Object)sex.toString(), (Throwable)sex);
                }
            }
        }
        return 0;
    }

    static {
        System.setProperty("org.omg.CORBA.ORBSingletonClass", "org.openorb.CORBA.ORBSingleton");
        orb = ORB.init();
        IsBigEndian = true;
        logger = LogFactory.getLog(CDRUtils.class);
    }
}

