/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.util;

import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.gui.netree.NETree;
import com.huawei.u2000.nelicense.model.NETreeNodeInfo;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.model.StatusTreeNodeInfo;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class NETreeUtil {
    private static boolean isContainFDN(String strFDN, String[] selectedNeArray) {
        boolean isContain = false;
        if (null != selectedNeArray) {
            for (String str : selectedNeArray) {
                if (!str.equals(strFDN)) continue;
                isContain = true;
                break;
            }
        }
        return isContain;
    }

    public static NETree createNETree(String strVersion, String[] strFDNs, boolean isContain) {
        NETree oTree = new NETree();
        NETreeUtil.updateNETree(strVersion, strFDNs, isContain, oTree);
        return oTree;
    }

    public static void updateNETree(String strVersion, String[] strFDNs, boolean isContain, NETree oTree) {
        boolean isAllNe = false;
        boolean isAllVersion = false;
        if (null == strFDNs || 0 == strFDNs.length) {
            isAllNe = true;
        }
        DefaultMutableTreeNode oRoot = oTree.getRoot();
        oRoot.removeAllChildren();
        if (isContain || !isAllNe) {
            NeLicenseBaseInfo[] oNeLicInfos;
            if ("allversion".equals(strVersion) || "".equals(strVersion)) {
                isAllVersion = true;
            }
            HashMap<String, DefaultMutableTreeNode> oStatusNodeMap = new HashMap<String, DefaultMutableTreeNode>();
            for (NeLicenseBaseInfo oNeLicInfo : oNeLicInfos = NeLicenseInfoManager.getInstance().getAllNeLicenseInfo()) {
                String strFDN = oNeLicInfo.getFdn();
                if (isContain ? !isAllNe && !NETreeUtil.isContainFDN(strFDN, strFDNs) : !isAllNe && NETreeUtil.isContainFDN(strFDN, strFDNs)) continue;
                String strVer = oNeLicInfo.getVersion();
                if (!isAllVersion && !strVer.equals(strVersion)) continue;
                String strStatus = oNeLicInfo.getStrStatus();
                DefaultMutableTreeNode oStatusNode = (DefaultMutableTreeNode)oStatusNodeMap.get(strStatus);
                if (null == oStatusNode) {
                    StatusTreeNodeInfo oStatusInfo = new StatusTreeNodeInfo(oNeLicInfo.getStatus());
                    oStatusNode = new DefaultMutableTreeNode(oStatusInfo);
                    oRoot.add(oStatusNode);
                    oStatusNodeMap.put(strStatus, oStatusNode);
                }
                NETreeNodeInfo oNEInfo = new NETreeNodeInfo(oNeLicInfo);
                DefaultMutableTreeNode oNENode = new DefaultMutableTreeNode(oNEInfo);
                oStatusNode.add(oNENode);
            }
        }
        oTree.getTree().updateUI();
    }
}

