/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.util;

import com.huawei.u2000.nelicense.NELicenseModule;
import com.huawei.u2000.nelicense.NELicenseModuleManager;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicHandShakeRsp;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.controller.LicOperationManager;
import com.huawei.u2000.nelicense.common.controller.NeLicenseDetailManager;
import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.gui.LicenseMainFrame;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.swimap.iview.communicate.MSGHead;
import com.swimap.iview.util.OptionPane;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class NELicShakeHandThread
extends Thread {
    private boolean m_isRunShakeHandThread = false;
    private int m_nextPollingTimeInterval;
    private int m_iShakeHandBreakTime;
    private int m_iHandShakeTimeOut;
    private int m_maxShakeHandBreakTime;
    private BaseCommManager m_commMgr;

    public NELicShakeHandThread() {
        String timoutstr = ResCenter.getInstance().getString("LicHand_Shake_Time_Out");
        String nextPollingIntervalStr = ResCenter.getInstance().getString("LicHand_Shake_Next_Polling_Interval");
        String handShakeBreakTimeStr = ResCenter.getInstance().getString("LicHand_Shake_Break_Time");
        try {
            this.m_iHandShakeTimeOut = Integer.parseInt(timoutstr);
            this.m_nextPollingTimeInterval = Integer.parseInt(nextPollingIntervalStr);
            this.m_maxShakeHandBreakTime = Integer.parseInt(handShakeBreakTimeStr);
        }
        catch (NumberFormatException e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
            this.m_maxShakeHandBreakTime = 25000;
        }
        this.m_commMgr = BaseCommManager.getInstance();
        LicDebugTracer.trace("NELicenseInfo:NELicShakeHandThread Thread Name : " + this.getName());
        LicDebugTracer.trace("NELicenseInfo:NELicShakeHandThread Thread ID : " + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LicDebugTracer.trace("NELicenseInfo:NELicShakeHandThread start");
        AsnNeLicHandShakeRsp oAsnHandShake = new AsnNeLicHandShakeRsp();
        while (this.m_isRunShakeHandThread) {
            Object message;
            LicDebugTracer.trace("NELicenseInfo:NELicShakeHandThread m_iShakeHandBreakTime = " + this.m_iShakeHandBreakTime + " | m_maxShakeHandBreakTime:" + this.m_maxShakeHandBreakTime);
            if (this.m_iShakeHandBreakTime >= this.m_maxShakeHandBreakTime) {
                this.handleTimeout(ResCenter.getInstance().getString("LicHAND_SHAKE_CONNECT_FAIL"));
                LicDebugTracer.trace("NELicenseInfo:handleTimeout NELicShakeHandThread end.. ");
                return;
            }
            ++this.m_iShakeHandBreakTime;
            MSGHead msgHead = null;
            try {
                LicDebugTracer.trace("NELicenseInfo:NELicShakeHandThread is clientId: " + NELicenseModuleManager.getUserID());
                msgHead = this.m_commMgr.getMSGHead(99820100, 4);
            }
            catch (Exception e) {
                this.handleTimeout("Get MSGHead fail!");
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
                LicDebugTracer.trace("NELicenseInfo:handleTimeout NELicShakeHandThread end.. ");
                return;
            }
            int iErrorCode = 0;
            try {
                iErrorCode = this.m_commMgr.sendSyncMsg(msgHead, null, oAsnHandShake, this.m_iHandShakeTimeOut);
            }
            catch (Exception ex) {
                LicDebugTracer.trace("NELicenseInfo:" + ex);
                LicDebugTracer.trace(ex);
                message = ResCenter.getInstance().getMergeString("LicHAND_SHAKE_CONNECT_FAIL_EXCEPTION", new String[]{String.valueOf(this.m_iShakeHandBreakTime)});
                this.handleTimeout((String)message);
                LicDebugTracer.trace("NELicenseInfo:handleTimeout NELicShakeHandThread end.. ");
                return;
            }
            if (0 == iErrorCode) {
                this.m_iShakeHandBreakTime = 0;
            }
            if (null == oAsnHandShake.iErrCode) {
                LicDebugTracer.trace("NELicenseInfo:RECEIVECODE is null");
            } else {
                LicDebugTracer.trace("NELicenseInfo:RECEIVECODE is " + oAsnHandShake.iErrCode.intValue());
            }
            LicDebugTracer.trace("NELicenseInfo:iErrorCode : " + iErrorCode);
            Object sync = new Object();
            try {
                message = sync;
                synchronized (message) {
                    sync.wait(this.m_nextPollingTimeInterval);
                }
            }
            catch (Exception ex) {
                LicDebugTracer.trace("NELicenseInfo:" + ex);
                LicDebugTracer.trace(ex);
            }
        }
        LicDebugTracer.trace("NELicenseInfo:NELicShakeHandThread end..");
    }

    private void handleTimeout(final String strMsg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionPane.showMessageDialog((Component)((Object)LicenseMainFrame.getInstance()), (Object)strMsg, (String)ResCenter.getInstance().getString("connect_error"), (int)0);
                NELicenseModule.setIsStartupServer(false);
                QueryLicensePanel.clear();
                LicenseTaskPanel.clear();
                NeLicenseInfoManager.getInstance().setToNull();
                NeLicenseDetailManager.getInstance().setToNull();
                LicOperationManager.getInstance().setToNull();
                if (null != LicenseMainFrame.getLicenseMainFrame()) {
                    LicenseMainFrame.getLicenseMainFrame().windowClosed();
                    LicenseMainFrame.getLicenseMainFrame().dispose();
                }
                NELicShakeHandThread.this.m_commMgr.getCommHandle().close();
                NELicShakeHandThread.this.m_commMgr = null;
                if (null != BaseCommManager.getBaseCommManager()) {
                    BaseCommManager.getBaseCommManager().setNull();
                }
            }
        });
    }

    public void startShakeHand() {
        LicDebugTracer.trace("NELicenseInfo:m_isRunShakeHandThread : " + this.m_isRunShakeHandThread);
        this.m_isRunShakeHandThread = true;
    }

    public void stopShakeHand() {
        LicDebugTracer.trace("NELicenseInfo:m_isRunShakeHandThread : " + this.m_isRunShakeHandThread);
        this.m_isRunShakeHandThread = false;
    }
}

