/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.util;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.sm.client.base.SessionService;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.statusbar.BubbleStatusBarItem;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GuiUtil {
    private static JFrame m_mainFrame;

    public static void displayCentered(JDialog dialog) {
        ScreenToolKit.centerLocateToScreen((Component)dialog);
        dialog.setVisible(true);
    }

    public static void showAdjustLicenseCapabilityDialog() {
        String message = ResCenter.getInstance().getString("adjust_License_capability");
        String title = ResCenter.getInstance().getString("confirm");
        int result = DCOptionPane.showExtConfirmDialog((Component)FrameworkUtilities.getMainFrame(), (String)message, (String)title, (int)0, (int)3);
        if (result == 0) {
            LicDebugTracer.trace("NELicenseInfo:1111");
        } else {
            LicDebugTracer.trace("NELicenseInfo:2222");
        }
    }

    public static void showAbateLicense() {
        String message = ResCenter.getInstance().getString("abate_License");
        String title = ResCenter.getInstance().getString("confirm");
        int result = DCOptionPane.showExtConfirmDialog((Component)FrameworkUtilities.getMainFrame(), (String)message, (String)title, (int)0, (int)3);
        if (result == 0) {
            LicDebugTracer.trace("NELicenseInfo:1111");
        } else {
            LicDebugTracer.trace("NELicenseInfo:2222");
        }
    }

    public static void showBubble(String message) {
        BubbleStatusBarItem bar = (BubbleStatusBarItem)FrameworkUtilities.getStatusBarManager().getStatusBarItem("Bubble");
        if (SwingUtilities.isEventDispatchThread()) {
            bar.setName("tempBar");
            bar.setMessage(message);
            bar.setEnableAutoHide(true);
        } else {
            final BubbleStatusBarItem tempBar = bar;
            final String tempMessage = message;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tempBar.setName("tempBar");
                    tempBar.setMessage(tempMessage);
                    tempBar.setEnableAutoHide(true);
                }
            });
        }
    }

    public static String getLicenseStatus(int status) {
        switch (status) {
            case 0: {
                return ResCenter.getInstance().getString("novalidlicense");
            }
            case 1: {
                return ResCenter.getInstance().getString("protected");
            }
            case 2: {
                return ResCenter.getInstance().getString("commercialuse");
            }
            case 3: {
                return ResCenter.getInstance().getString("debugging");
            }
            case 4: {
                return ResCenter.getInstance().getString("critical");
            }
        }
        return "";
    }

    public static void enableHelpKey(Component comp, String helpKey) {
        HelpManager.getInstance().enableHelpKey(comp, helpKey);
    }

    public static void showHintMessageWithInvokeLater(final String message) {
        if (SessionService.getInstance().isLogout()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCOptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (String)message);
            }
        });
    }

    public static boolean handleException(Throwable e) {
        if (e instanceof RpcErrorSecurity) {
            SessionService.getInstance().handleInvalidTokenException(e.getMessage());
            return true;
        }
        if (e instanceof RpcError) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
            GuiUtil.showHintMessageWithInvokeLater(ResCenter.getInstance().getString("corbaerror"));
            return true;
        }
        if (e.getMessage() != null && e.getMessage().equals("socket not connected.")) {
            LicDebugTracer.trace("NELicenseInfo:socket not connected");
            GuiUtil.showHintMessageWithInvokeLater(ResCenter.getInstance().getString("corbaerror"));
            return true;
        }
        return false;
    }

    public static void setMainFrame(JFrame oMainFrame) {
        m_mainFrame = oMainFrame;
    }

    public static JFrame getMainFrame() {
        return m_mainFrame;
    }

    public static void main(String[] args) {
        GuiUtil.showAdjustLicenseCapabilityDialog();
    }

    public static void setCursor(final Component parent, final Cursor cursor) {
        if (SwingUtilities.isEventDispatchThread()) {
            parent.setCursor(cursor);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    parent.setCursor(cursor);
                }
            });
        }
    }

    public static void setWaitingCursor() {
        GuiUtil.setCursor(GuiUtil.getMainFrame(), new Cursor(3));
    }

    public static void setDefaultCursor() {
        GuiUtil.setCursor(GuiUtil.getMainFrame(), new Cursor(0));
    }
}

