/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.util;

import com.huawei.u2000.nelicense.util.GlobalUtil;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.OpenFileChooser;
import com.swimap.iview.util.SaveFileChooser;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class FileOpenChooserUtil {
    private static String Csv_Surfix = ".csv";
    private static String Xls_Surfix = ".xls";
    private static String Txt_Surfix = ".txt";
    public static final int TXT_FILES_TYPE = 1;
    public static final int HTML_FILES_TYPE = 2;
    public static final int CSV_FILES_TYPE = 3;
    public static final int XLS_FILES_TYPE = 4;
    public static final int DAT_FILES_TYPE = 5;
    public static final int ZIP_FILES_TYPE = 6;
    private static final FileChooserFilter TXT_FILECHOOSERFILTER = new FileChooserFilter("txt", "TXTFiles");
    private static final FileChooserFilter HTML_FILECHOOSERFILTER = new FileChooserFilter("html", "HTMLFiles");
    private static final FileChooserFilter CSV_FILECHOOSERFILTER = new FileChooserFilter("csv", "CSVFiles");
    private static final FileChooserFilter XLS_FILECHOOSERFILTER = new FileChooserFilter("xls", "XLSFiles");
    private static final FileChooserFilter DAT_FILECHOOSERFILTER = new FileChooserFilter("dat", "DATFiles");
    private static final FileChooserFilter ZIP_FILECHOOSERFILTER = new FileChooserFilter("zip", "ZIPFiles");
    private static FileChooserFilter fileChooserFilter = null;

    public static String buildFileName(String info) {
        return info + "_" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss").format(new Date());
    }

    public static String showFileOpenChooser(int[] types, String path) {
        String openFileName = null;
        OpenFileChooser m_oFileChooser = new OpenFileChooser(path == null ? System.getProperty("user.dir") + System.getProperty("file.separator") : path, 0, "*\"?/|<>");
        m_oFileChooser.setName("SM_OPENFILEDIALOG");
        m_oFileChooser.setAcceptAllFileFilterUsed(false);
        List<FileChooserFilter> filterList = FileOpenChooserUtil.getFileChooserFilter(types);
        for (FileChooserFilter filter : filterList) {
            m_oFileChooser.addChoosableFileFilter((FileFilter)filter);
        }
        m_oFileChooser.setFileFilter((FileFilter)(fileChooserFilter == null ? filterList.get(0) : fileChooserFilter));
        int returnVal = m_oFileChooser.showOpenDialog((Component)GuiUtil.getMainFrame());
        if (returnVal == 0) {
            openFileName = m_oFileChooser.getSelectedFile().getPath();
            if (null != openFileName && 0 != openFileName.length()) {
                fileChooserFilter = (FileChooserFilter)m_oFileChooser.getFileFilter();
                String usedFilter = '.' + (String)fileChooserFilter.getAllFilters().get(0);
                if (!GlobalUtil.globalDealWithToLowerCase(openFileName).endsWith(usedFilter)) {
                    openFileName = openFileName + usedFilter;
                }
            }
            return openFileName;
        }
        return "";
    }

    public static String getFullFileName(String fileName) {
        SaveFileChooser chooser = new SaveFileChooser(System.getProperty("user.dir") + System.getProperty("file.separator"), true);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter((FileFilter)HTML_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)CSV_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)XLS_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)TXT_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)DAT_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)ZIP_FILECHOOSERFILTER);
        chooser.getTextField((Component)chooser).setText(FileOpenChooserUtil.buildFileName(fileName));
        if (chooser.showSaveDialog((Component)FrameworkUtilities.getMainFrame()) == 0) {
            return chooser.getSelectedFile().getPath() + '.' + ((FileChooserFilter)chooser.getFileFilter()).getAllFilters().get(0).toString();
        }
        return "";
    }

    private static List<FileChooserFilter> getFileChooserFilter(int[] types) {
        ArrayList<FileChooserFilter> filterList = new ArrayList<FileChooserFilter>();
        for (int j = 0; j < types.length; ++j) {
            if (types[j] == 3) {
                filterList.add(CSV_FILECHOOSERFILTER);
                continue;
            }
            if (types[j] == 2) {
                filterList.add(HTML_FILECHOOSERFILTER);
                continue;
            }
            if (types[j] == 1) {
                filterList.add(TXT_FILECHOOSERFILTER);
                continue;
            }
            if (types[j] == 4) {
                filterList.add(XLS_FILECHOOSERFILTER);
                continue;
            }
            if (types[j] == 5) {
                filterList.add(DAT_FILECHOOSERFILTER);
                continue;
            }
            if (types[j] != 6) continue;
            filterList.add(ZIP_FILECHOOSERFILTER);
        }
        return filterList;
    }

    public static String getFileType(String filename) {
        if (filename.endsWith(Txt_Surfix)) {
            return "txt";
        }
        if (filename.endsWith(Csv_Surfix)) {
            return "csv";
        }
        if (filename.endsWith(Xls_Surfix)) {
            return "xls";
        }
        return "html";
    }
}

