/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.wizard;

import com.huawei.dc.adapter.swimap.iview.framework.util.DCFrameworkUtilities;
import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.common.ASNInvoker;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.checknodesinfoxml.ReadZIPLicenseFile;
import com.huawei.u2000.nelicense.common.controller.LicOperationManager;
import com.huawei.u2000.nelicense.gui.panel.NESelectTablePanel;
import com.huawei.u2000.nelicense.gui.panel.loadlicensefile.AutoMatchingNEPanel;
import com.huawei.u2000.nelicense.gui.wizard.LicenseTaskWizard;
import com.huawei.u2000.nelicense.gui.wizard.WizardUtility;
import com.huawei.u2000.nelicense.model.NELicenseFileInfo;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.wizard.IWizardInterface;
import com.swimap.iview.templates.wizard.WizardTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JPanel;

public class SecondStepPanel
extends JPanel
implements IWizardInterface {
    private static final long serialVersionUID = -217232747508438083L;
    private Window parentWindow = null;
    int currurStep = 2;
    int nextStep = 3;
    private String filePath = "";
    public static final String ZIP_TYPE = ".zip";
    private static final String TXT_TYPE = ".txt";
    private static final String DAT_TYPE = ".dat";
    private static final int IS_SELECTED = 0;
    private static final int SELECT_NAME = 3;
    private NESelectTablePanel handleMatchNePanel = null;
    private AutoMatchingNEPanel autoMatchingNEPanel = null;
    private List<NELicenseFileInfo> neArray = new ArrayList<NELicenseFileInfo>();

    public SecondStepPanel() {
        this.handleMatchNePanel = new NESelectTablePanel(this.parentWindow, null, 0);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        String fileType = this.getFileType(this.filePath);
        if (fileType.equals(ZIP_TYPE)) {
            this.removeAll();
            this.autoMatchingNEPanel = new AutoMatchingNEPanel(this.filePath);
            if (this.autoMatchingNEPanel.getTable().isZipFileDataEmpty()) {
                this.revokeNextAction(this);
            }
            this.add((Component)this.autoMatchingNEPanel, "Center");
        } else if (fileType.equals(TXT_TYPE) || fileType.equals(DAT_TYPE)) {
            this.removeAll();
            this.add((Component)this.handleMatchNePanel.getPanel(), "Center");
        }
        JPanel leftPanel = WizardUtility.getPicPanel("Test", LicenseTaskWizard.getStepNames(), this.currurStep - 1);
        this.add((Component)leftPanel, "West");
        this.updateUI();
    }

    private void revokeNextAction(Container panel) {
        WizardTemplate parentTemplate = null;
        if (panel.getParent() instanceof WizardTemplate) {
            parentTemplate = (WizardTemplate)panel.getParent();
            parentTemplate.previousClicked();
        } else {
            this.revokeNextAction(panel.getParent());
        }
    }

    public void setParent(WizardTemplate wizard) {
    }

    public JPanel getDisplayPanel() {
        return this;
    }

    public int getNextStepNumber() {
        return this.nextStep;
    }

    public boolean isPreviousAllowed() {
        return true;
    }

    public boolean isNextAllowed() {
        return false;
    }

    public boolean isFinishAllowed() {
        return true;
    }

    public void setInformation(Object info) {
        if (info instanceof String) {
            this.filePath = (String)info;
            try {
                this.init();
                this.setSize(600, 400);
            }
            catch (Exception e) {
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
        }
    }

    public Object getInformation() {
        return null;
    }

    public boolean isUserEntryValid() {
        NeLicenseBaseInfo baseInfo;
        String fileType = this.getFileType(this.filePath);
        if (fileType.equals(ZIP_TYPE)) {
            NELicenseFileInfo[] neArray = this.autoMatchingNEPanel.getTable().getSelectedData();
            if (0 == neArray.length) {
                DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("noselectedne"));
                return false;
            }
            if (!this.validateIsSelectNE()) {
                String message = ResCenter.getInstance().getString("Match_LIC_TO_NE_Failed");
                String title = ResCenter.getInstance().getString("comfirm");
                DCOptionPane.showMessageDialog((Component)DCFrameworkUtilities.getMainFrame(), (String)message, (String)title, (int)0);
                return false;
            }
            if (!this.validateZippedLicenseSize(this.filePath, neArray)) {
                DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("license_file_size_error"));
                return false;
            }
            for (int i = 0; i < neArray.length - 1; ++i) {
                for (int j = i + 1; j < neArray.length; ++j) {
                    if (!neArray[i].getFdn().equals(neArray[j].getFdn())) continue;
                    DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("nerepeat"));
                    return false;
                }
            }
            return this.checkNeExists(neArray);
        }
        ArrayList<String> neIDList = this.handleMatchNePanel.getTableNEIDList();
        if (0 == neIDList.size()) {
            DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("noselectedne"));
            return false;
        }
        if (!ASNInvoker.getInstance().checkNEExists(neIDList.toArray(new String[0]), this.handleMatchNePanel.getSelectedNeList())) {
            return false;
        }
        String fileName = this.filePath.substring(this.filePath.lastIndexOf("\\") + 1, this.filePath.length());
        File licFile = new File(this.filePath);
        long length = licFile.length();
        if (length == 0L || length > 262144L) {
            DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("license_file_size_error"));
            return false;
        }
        String fileContent = ReadZIPLicenseFile.getDATorTXTFileContents(this.filePath);
        Map<String, NeLicenseBaseInfo> neBaseInfoMap = null;
        try {
            neBaseInfoMap = this.handleMatchNePanel.getNeLicenseBaseInfos();
        }
        catch (Exception e) {
            if (!GuiUtil.handleException(e)) {
                DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("getesninfofail"));
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
            return false;
        }
        if (null == neBaseInfoMap || neBaseInfoMap.size() == 0) {
            DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("esnisallnull"));
            return false;
        }
        ArrayList fdnsOfNoESN = new ArrayList();
        String strUnknowEsn = "";
        for (int i = 0; i < neIDList.size(); ++i) {
            NELicenseFileInfo info = new NELicenseFileInfo();
            baseInfo = neBaseInfoMap.get(neIDList.get(i));
            if (strUnknowEsn.equals(baseInfo.getEsn())) {
                fdnsOfNoESN.add(neIDList.get(i));
                continue;
            }
            info.setFileName(baseInfo.getEsn() + "_" + fileName);
            info.setFdn((String)neIDList.get(i));
            info.setLicenseContent(fileContent);
            this.neArray.add(info);
        }
        if (fdnsOfNoESN.size() == neIDList.size()) {
            DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("esnisallnull"));
            return false;
        }
        if (fdnsOfNoESN.size() > 0) {
            String[][] detail = new String[fdnsOfNoESN.size() + 1][1];
            detail[0] = new String[]{ResCenter.getInstance().getString("NE_Name"), ResCenter.getInstance().getString("NE_Type")};
            for (int i = 0; i < fdnsOfNoESN.size(); ++i) {
                baseInfo = neBaseInfoMap.get(fdnsOfNoESN.get(i));
                detail[i + 1] = new String[]{baseInfo.getLabel(), baseInfo.getNeType()};
            }
            DetailMessageDlg messDlg = new DetailMessageDlg((Frame)DCFrameworkUtilities.getMainFrame(), ResCenter.getInstance().getString("comfirm"), (Object)ResCenter.getInstance().getString("esnisnull"), 3, 1, (Object)detail, false);
            if (1 == messDlg.confirmShow()) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateZippedLicenseSize(String licFilePath, NELicenseFileInfo[] neLicInfoArray) {
        File licFile = null;
        ZipFile zipFile = null;
        try {
            licFile = new File(licFilePath);
            zipFile = new ZipFile(licFile);
            String fileName = "";
            ZipEntry entry = null;
            long size = 0L;
            for (NELicenseFileInfo neLicenseFileInfo : neLicInfoArray) {
                fileName = neLicenseFileInfo.getFileName();
                entry = zipFile.getEntry(fileName);
                size = entry.getSize();
                if (size != 0L && size <= 262144L) continue;
                LicDebugTracer.trace("NELicenseInfo:License file " + fileName + " is of invalid size. " + "Checking for file size will not proceed further.");
                zipFile.close();
                boolean bl = false;
                return bl;
            }
        }
        catch (ZipException e) {
            LicDebugTracer.trace("NELicenseInfo:Exception in reading the zip file for determiniing the size of the license file validity." + e);
            LicDebugTracer.trace(e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LicDebugTracer.trace("NELicenseInfo:Exception in reading the zip file for determiniing the size of the license file validity." + e);
            LicDebugTracer.trace(e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:Exception in reading the zip file for determiniing the size of the license file validity." + e);
            LicDebugTracer.trace(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    LicDebugTracer.trace("NELicenseInfo:" + e);
                    LicDebugTracer.trace(e);
                }
            }
        }
        return true;
    }

    private boolean checkNeExists(NELicenseFileInfo[] neArray) {
        String[] selectedNeFdnArray = new String[neArray.length];
        int count = 0;
        for (NELicenseFileInfo neLicenseFileInfo : neArray) {
            selectedNeFdnArray[count] = neLicenseFileInfo.getFdn();
            ++count;
        }
        try {
            String[] neExists = new String[]{};
            ArrayList<String> delNeList = new ArrayList<String>();
            for (NELicenseFileInfo selNeFDN : neArray) {
                for (String delNeFDN : neExists) {
                    if (!delNeFDN.equals(selNeFDN.getFdn())) continue;
                    LicDebugTracer.trace("NELicenseInfo:The NE with the FDN: " + delNeFDN + " Name : " + selNeFDN.getEsnName() + " does not exists any more.");
                    delNeList.add(selNeFDN.getEsnName());
                }
            }
            if (delNeList.size() > 0) {
                LicDebugTracer.trace("NELicenseInfo:Showing the DetailMessageDialog for listing the deleted NEs in the already selected NE list and return false");
                DetailMessageDlg messDlg = new DetailMessageDlg((Frame)DCFrameworkUtilities.getMainFrame(), ResCenter.getInstance().getString("title"), (Object)ResCenter.getInstance().getString("nedelted"), 1, 0, (Object)(ResCenter.getInstance().getString("nedelteddetails") + " " + ((Object)delNeList).toString()), false);
                messDlg.show();
                return false;
            }
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:Exception in checking the NE existance. " + e.getMessage());
            return false;
        }
        return true;
    }

    public int getStepNumber() {
        return this.currurStep;
    }

    public void finishAction() {
        String fileType = this.getFileType(this.filePath);
        if (fileType.equals(ZIP_TYPE)) {
            NELicenseFileInfo[] neArray = this.autoMatchingNEPanel.getTable().getSelectedData();
            ArrayList<NELicenseFileInfo> errorList = new ArrayList<NELicenseFileInfo>();
            for (int i = 0; i < neArray.length; ++i) {
                NELicenseFileInfo info = neArray[i];
                if (!"".equalsIgnoreCase(info.getLicenseContent())) continue;
                errorList.add(info);
            }
            if (errorList.size() != 0) {
                this.showResultDetailDialog(neArray, errorList);
            } else {
                this.sendDataToDs(neArray, errorList);
            }
        } else if (fileType.equals(TXT_TYPE) || fileType.equals(DAT_TYPE)) {
            this.sendDataToDs(this.neArray.toArray(new NELicenseFileInfo[0]), new ArrayList<NELicenseFileInfo>());
        }
    }

    private boolean validateIsSelectNE() {
        if (null == this.autoMatchingNEPanel) {
            return false;
        }
        int rowCount = this.autoMatchingNEPanel.getTable().getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            String neName;
            if (!Boolean.TRUE.equals(this.autoMatchingNEPanel.getTable().getValueAt(row, 0)) || null != (neName = this.autoMatchingNEPanel.getTable().getValueAt(row, 3).toString()) && !neName.equals("")) continue;
            return false;
        }
        return true;
    }

    private void sendDataToDs(NELicenseFileInfo[] dataArray, ArrayList<NELicenseFileInfo> errorSet) {
        block6: {
            try {
                int result = 0;
                ArrayList<NELicenseFileInfo> neList = new ArrayList<NELicenseFileInfo>();
                if (errorSet.size() == 0) {
                    result = LicOperationManager.getInstance().loadLicenseFile(dataArray);
                } else {
                    for (int i = 0; i < dataArray.length; ++i) {
                        if (errorSet.contains(dataArray[i])) continue;
                        neList.add(dataArray[i]);
                    }
                    NELicenseFileInfo[] neArray = new NELicenseFileInfo[neList.size()];
                    neList.toArray(neArray);
                    result = LicOperationManager.getInstance().loadLicenseFile(neArray);
                }
                if (0 != result) {
                    LicDebugTracer.trace("NELicenseInfo:Update ne license fail, result is " + result);
                    String message = ResCenter.getInstance().getString("LICENSE_FILE_NOT_MATCH");
                    String title = ResCenter.getInstance().getString("comfirm");
                    DCOptionPane.showMessageDialog((Component)DCFrameworkUtilities.getMainFrame(), (String)message, (String)title, (int)0);
                }
            }
            catch (Exception e) {
                if (GuiUtil.handleException(e)) break block6;
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
        }
    }

    public void cancelAction() {
    }

    public void displayHelp() {
    }

    private String getFileType(String filePath) {
        String temp = filePath.toLowerCase();
        if (temp.endsWith(ZIP_TYPE)) {
            return ZIP_TYPE;
        }
        if (temp.endsWith(TXT_TYPE)) {
            return TXT_TYPE;
        }
        if (temp.endsWith(DAT_TYPE)) {
            return DAT_TYPE;
        }
        return null;
    }

    private void showResultDetailDialog(NELicenseFileInfo[] neArray, ArrayList<NELicenseFileInfo> errorList) {
        String message = ResCenter.getInstance().getString("load_zipLicense_error");
        int size = errorList.size();
        String[][] detail = new String[size + 1][3];
        detail[0] = new String[]{ResCenter.getInstance().getString("load_zipLicense_error_ESNID"), ResCenter.getInstance().getString("load_zipLicense_error_NEName"), ResCenter.getInstance().getString("load_zipLicense_error_LicenseFileName")};
        int index = 1;
        for (NELicenseFileInfo info : errorList) {
            detail[index++] = info.toArray();
        }
        DetailMessageDlg messDlg = new DetailMessageDlg((Frame)DCFrameworkUtilities.getMainFrame(), ResCenter.getInstance().getString("comfirm"), (Object)message, 3, 1, (Object)detail, false);
        int result = messDlg.confirmShow();
        if (result == 0) {
            this.sendDataToDs(neArray, errorList);
        } else {
            messDlg.dispose();
        }
    }

    public static void setBaseWindow(Window _parentWindow) {
        NESelectTablePanel.setBaseWindow(_parentWindow);
    }
}

