/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.treetable;

import com.huawei.u2000.nelicense.gui.treetable.TreeTable;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class TaskTreeTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 2874329777895447468L;
    private JLabel contentLabel = new JLabel();
    private TreeTable table;
    private TreeTableModel tableModel;
    private static final int TREE_COLUMN = 0;
    private boolean isExpend = false;
    private boolean isLeaf = true;
    private int indentX = 0;
    private int iconIndetX = 0;
    private Icon expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
    private Icon collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");

    TaskTreeTableCellRenderer(TreeTable table, TreeTableModel tableModel) {
        this.setLayout(new BorderLayout());
        this.table = table;
        this.tableModel = tableModel;
        this.add(this.contentLabel);
        this.contentLabel.setOpaque(true);
        this.init();
    }

    private void init() {
        this.setBackground(this.table.getBackground());
        this.contentLabel.setFont(this.table.getFont());
        this.contentLabel.setName("JLabel_contentLabel");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = "";
        if (column > 0) {
            if (value != null) {
                text = value.toString();
            }
            this.contentLabel.setText(text);
        } else {
            text = this.handleTreeColumn(value);
        }
        this.doToolTip(text);
        this.doForeBackGroundColor(table, isSelected);
        return this;
    }

    private String handleTreeColumn(Object value) {
        String text = value.toString();
        if (value instanceof TreePath) {
            Object content = this.tableModel.getValueAt(((TreePath)value).getLastPathComponent(), 0);
            this.isExpend = this.table.getTree().isExpanded((TreePath)value);
            this.isLeaf = this.tableModel.isLeaf(((TreePath)value).getLastPathComponent());
            text = content.toString();
            this.contentLabel.setText(text);
            this.indentX = this.getContentIndentX((TreePath)value);
            this.iconIndetX = this.getIconIndentX((TreePath)value);
        }
        return text;
    }

    private void doForeBackGroundColor(JTable table, boolean isSelected) {
        if (isSelected) {
            this.contentLabel.setBackground(table.getSelectionBackground());
            this.contentLabel.setForeground(table.getSelectionForeground());
        } else {
            this.contentLabel.setBackground(table.getBackground());
            this.contentLabel.setForeground(table.getForeground());
        }
    }

    private void doToolTip(String text) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int width = this.contentLabel.getWidth();
        int StringWidth = SwingUtilities.computeStringWidth(fontMetrics, text + " ");
        if (StringWidth > width) {
            boolean hasContent = text != null && !"".equals(text.trim());
            this.setToolTipText(hasContent ? text : null);
        } else {
            this.setToolTipText(null);
        }
    }

    @Override
    public void doLayout() {
        if (this.getComponentCount() == 0) {
            return;
        }
        Component component = this.getComponent(0);
        Dimension dimension = this.getSize();
        component.setBounds(this.indentX, 0, dimension.width - this.indentX, dimension.height);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isLeaf) {
            if (this.isExpend) {
                this.expandedIcon.paintIcon(this, g, this.iconIndetX, (this.getHeight() - this.expandedIcon.getIconHeight()) / 2);
            } else {
                this.collapsedIcon.paintIcon(this, g, this.iconIndetX, (this.getHeight() - this.collapsedIcon.getIconHeight()) / 2);
            }
        }
    }

    private int getContentIndentX(TreePath path) {
        int i = this.table.getNodeIndent(path);
        i = this.isExpend ? (i += this.expandedIcon.getIconWidth()) : (i += this.collapsedIcon.getIconWidth());
        return i;
    }

    private int getIconIndentX(TreePath path) {
        int levelIndent = this.table.getLevelIndent();
        int level = this.table.getNodeIndent(path) / levelIndent - 1;
        return levelIndent / 2 + level * levelIndent - this.expandedIcon.getIconWidth() / 2;
    }
}

