/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.treetable;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.controller.LicOperationManager;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.util.GuiUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TaskProcess {
    private static final TaskProcess instance = new TaskProcess();
    private Map<Integer, TaskProcessData> cache = new HashMap<Integer, TaskProcessData>();

    private TaskProcess() {
    }

    public static TaskProcess getInstance() {
        return instance;
    }

    public void addTask(int taskId, int total) {
        TaskProcessData data = new TaskProcessData();
        data.total = total;
        this.cache.put(taskId, data);
    }

    public void increase(int taskId, int units) {
        TaskProcessData data = this.get(taskId);
        if (null != data) {
            LicDebugTracer.trace("NELicenseInfo:zsq data:" + data.complete);
            if (data.complete < data.total) {
                data.complete += units;
            }
        } else {
            LicDebugTracer.trace("NELicenseInfo:zsq data init");
            this.init();
            data = this.get(taskId);
            if (data.complete < data.total) {
                data.complete += units;
            }
            LicDebugTracer.trace("NELicenseInfo:zsq data:" + data.complete);
        }
    }

    public void decrease(int taskId, int units) {
        TaskProcessData data = this.get(taskId);
        if (null != data) {
            data.complete -= units;
        }
    }

    public void removeTask(int taskId) {
        this.cache.remove(taskId);
    }

    public String getCompletePercent(int taskId) {
        TaskProcessData data = this.get(taskId);
        if (null == data) {
            return "0%";
        }
        return data.total != 0 ? data.complete * 100 / data.total + "%" : "0%";
    }

    public void clear() {
        this.cache.clear();
    }

    public TaskProcessData get(int taskId) {
        TaskProcessData data = this.cache.get(taskId);
        if (null == data) {
            LicDebugTracer.trace("NELicenseInfo:No found the task, id is " + taskId);
            return null;
        }
        return data;
    }

    public void init() {
        block4: {
            try {
                this.cache.clear();
                Set<NeLicenseTask> oNeLicTaskSet = LicOperationManager.getInstance().getNeLicenseTask();
                for (NeLicenseTask oTask : oNeLicTaskSet) {
                    int iTaskId = oTask.getTaskId();
                    TaskProcessData data = this.cache.get(iTaskId);
                    if (null == data) {
                        data = new TaskProcessData();
                        data.id = iTaskId;
                        this.cache.put(data.id, data);
                    }
                    ++data.total;
                    if (-1 == oTask.getState()) continue;
                    ++data.complete;
                }
            }
            catch (Exception e) {
                if (GuiUtil.handleException(e)) break block4;
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
        }
    }

    public class TaskProcessData {
        public int id;
        public int total;
        public int complete;
    }
}

