/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.treetable;

import com.huawei.u2000.nelicense.common.Constants;
import com.huawei.u2000.nelicense.common.ExportNeLicInfoMgr;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.gui.treetable.TaskProcess;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.model.TreeTableNode;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.util.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LicenseTaskModel
implements TreeTableModel {
    private TreeTableNode root = new TreeTableNode();
    private final Object lock = new Object();
    private static final int INVALID_TASK_ID = -1;
    private List<TreeModelListener> listeners = null;
    private String[] columnName = new String[]{ResCenter.getInstance().getString("taskId"), ResCenter.getInstance().getString("operator"), ResCenter.getInstance().getString("taskType"), ResCenter.getInstance().getString("taskState"), ResCenter.getInstance().getString("taskBeginTime"), ResCenter.getInstance().getString("neFdn"), ResCenter.getInstance().getString("neType")};

    public LicenseTaskModel() {
    }

    public LicenseTaskModel(TreeTableNode node) {
        this.root = node;
    }

    public int getColumnCount() {
        return this.columnName.length;
    }

    public String[] getColumnName() {
        return this.columnName;
    }

    public String getColumnName(int index) {
        return this.columnName[index];
    }

    public Object getValueAt(Object node, int column) {
        NeLicenseTask task = ((TreeTableNode)node).getNodeContent();
        switch (column) {
            case 0: {
                return this.getTaskId(task);
            }
            case 1: {
                return task.getOperator();
            }
            case 2: {
                return this.getType(task.getType());
            }
            case 3: {
                return this.getTaskDes(task);
            }
            case 4: {
                return task.getBeginDateTime();
            }
            case 5: {
                return task.getNeName();
            }
            case 6: {
                return task.getNeType();
            }
        }
        LicDebugTracer.trace("NELicenseInfo:Error column, column is " + column);
        return "";
    }

    private int getTaskId(NeLicenseTask task) {
        return task.getSubTaskId() == -1 ? task.getTaskId() : task.getSubTaskId();
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TreeModelListener>();
        }
        this.listeners.add(treeModelListener);
    }

    private String getType(int type) {
        switch (type) {
            case 0: {
                return ResCenter.getInstance().getString("exportneapplyinfo");
            }
            case 1: {
                return ResCenter.getInstance().getString("adjustlicense");
            }
            case 2: {
                return ResCenter.getInstance().getString("synch_esn");
            }
            case 3: {
                return ResCenter.getInstance().getString("invalidationlicnese");
            }
            case 4: {
                return ResCenter.getInstance().getString("loadlicense");
            }
        }
        return "";
    }

    public String getTaskDes(NeLicenseTask task) {
        if (task.getSubTaskId() == -1) {
            return TaskProcess.getInstance().getCompletePercent(task.getTaskId());
        }
        String state = Constants.TaskState.taskStateAndDesMap.get(task.getState());
        LicDebugTracer.trace("NELicenseInfo:Error task state : " + task.getSubTaskId() + "_" + task.getTaskId() + "_" + task.getState() + "*******" + state);
        if (null == state) {
            LicDebugTracer.trace("NELicenseInfo:Error task state is null.");
            return "";
        }
        return ResCenter.getInstance().getString(state);
    }

    public void fireTableUpdate() {
        if (this.listeners == null) {
            return;
        }
        TreeModelEvent paramTreeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.getRoot()), null, null);
        TreeModelListener treeModelListener2 = null;
        for (TreeModelListener treeModelListener2 : this.listeners) {
            treeModelListener2.treeStructureChanged(paramTreeModelEvent);
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isCellEditable(Object object, int column) {
        return false;
    }

    public void addTaskData(Collection<NeLicenseTask> neLicenseTaskList) {
        HashSet<String> set = new HashSet<String>();
        for (NeLicenseTask task : neLicenseTaskList) {
            String value = task.getTaskId() + "-" + task.getSubTaskId();
            if (set.contains(value)) continue;
            TreeTableNode node = new TreeTableNode(task);
            if (!this.addTaskNode(node)) {
                this.addTaskNode(new TreeTableNode(this.makeParentTask(task)));
                this.addTaskNode(node);
            }
            set.add(value);
        }
        set.clear();
    }

    public void addTaskData(NeLicenseTask neLicenseTask) {
        TreeTableNode node = new TreeTableNode(neLicenseTask);
        if (!this.addTaskNode(node)) {
            this.addTaskNode(new TreeTableNode(this.makeParentTask(neLicenseTask)));
            this.addTaskNode(node);
        }
    }

    public void addRefreshTaskData(NeLicenseTask neLicenseTask, int currentColumnIndex, boolean isAscent) {
        LicDebugTracer.trace("NELicenseInfo:LicenseTaskModel | addRefreshTaskData | neLicenseTask ID: " + neLicenseTask.getTaskId() + " currentColumnIndex : " + currentColumnIndex + "isAscent : " + isAscent);
        TreeTableNode node = new TreeTableNode(neLicenseTask);
        if (!this.addRefreshTaskNode(node, currentColumnIndex, isAscent)) {
            this.addRefreshTaskNode(new TreeTableNode(this.makeParentTask(neLicenseTask)), currentColumnIndex, isAscent);
            this.addRefreshTaskNode(node, currentColumnIndex, isAscent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addRefreshTaskNode(TreeTableNode node, int currentColumnIndex, boolean isAscent) {
        boolean result = false;
        int nodeTaskId = node.getNodeContent().getTaskId();
        int nodeSubTaskId = node.getNodeContent().getSubTaskId();
        Object object = this.lock;
        synchronized (object) {
            if (nodeSubTaskId == -1) {
                TreeTableNode oldNode = this.findSameNode(node);
                if (null == oldNode) {
                    LicDebugTracer.trace("NELicenseInfo:This node is not present in the tree model. So add the node as new data to the tree table.");
                    this.addNodeToSortedIndex(node, currentColumnIndex, isAscent);
                } else {
                    oldNode.setNodeObject(node.getNodeContent());
                }
                result = true;
            } else {
                Enumeration<TreeNode> en = this.root.children();
                while (en.hasMoreElements()) {
                    TreeTableNode tempNode = (TreeTableNode)en.nextElement();
                    int taskId = tempNode.getNodeContent().getTaskId();
                    if (nodeTaskId != taskId) continue;
                    tempNode.add(node);
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private void addNodeToSortedIndex(TreeTableNode node, int columnIndex, boolean isAscent) {
        LicDebugTracer.trace("NELicenseInfo:LicenseTaskModel | addNodeToSortedIndex | The column " + columnIndex + " is sorted in ascending order : " + isAscent);
        if (columnIndex != 0) {
            this.addTaskSortedInColumnNonZero(node, columnIndex, isAscent);
        } else {
            LicDebugTracer.trace("NELicenseInfo:Check the first and last child of the root and insert the new task id to the beginning or end of the tree.");
            int index = 0;
            if (isAscent) {
                index = this.root.getChildCount();
            }
            this.root.insert(node, index);
        }
    }

    private void addTaskSortedInColumnNonZero(TreeTableNode node, int columnIndex, boolean isAscent) {
        List<TreeTableNode> nodeList = this.getNodeList();
        NeLicenseTask taskNodeContent = node.getNodeContent();
        Object taskColumnData = taskNodeContent.getColumnData(columnIndex);
        NeLicenseTask nodeContent = null;
        Object colData = null;
        int index = 0;
        int firstIndex = -1;
        int lastIndex = -1;
        for (TreeTableNode treeTableNode : nodeList) {
            nodeContent = treeTableNode.getNodeContent();
            colData = nodeContent.getColumnData(columnIndex);
            if (null == colData) {
                LicDebugTracer.trace("NELicenseInfo:The column data is null. The loop is broken here");
                break;
            }
            if (colData.equals(taskColumnData) && firstIndex == -1) {
                firstIndex = index;
            } else if (!colData.equals(taskColumnData) && firstIndex != -1) break;
            ++index;
        }
        lastIndex = index;
        int insertIndex = 0;
        LicDebugTracer.trace("NELicenseInfo:FirstIndex(Index where the sorted column data of the node is equal to the current model data value): " + firstIndex);
        LicDebugTracer.trace("NELicenseInfo:LastIndex(Index where the sorted column data of the node gets unequal to the current model data value): " + lastIndex);
        if (isAscent) {
            insertIndex = lastIndex;
        } else if (firstIndex == -1) {
            LicDebugTracer.trace("NELicenseInfo:None of the sorted column data equlas to the node data in that column. So insert the node to the beginning of the tree.");
            insertIndex = 0;
        } else {
            insertIndex = firstIndex;
        }
        LicDebugTracer.trace("NELicenseInfo:The node inserted at " + insertIndex + " index.");
        this.root.insert(node, insertIndex);
    }

    private List<TreeTableNode> getNodeList() {
        ArrayList<TreeTableNode> nodeList = new ArrayList<TreeTableNode>();
        int childCount = this.root.getChildCount();
        TreeNode childNode = null;
        for (int i = 0; i < childCount; ++i) {
            childNode = this.root.getChildAt(i);
            if (!(childNode instanceof TreeTableNode)) continue;
            nodeList.add((TreeTableNode)childNode);
        }
        return nodeList;
    }

    private NeLicenseTask makeParentTask(NeLicenseTask task) {
        NeLicenseTask parent = new NeLicenseTask();
        parent.setTaskId(task.getTaskId());
        parent.setSubTaskId(-1);
        parent.setOperator(task.getOperator());
        parent.setType(task.getType());
        parent.setBeginDateTime(task.getBeginDateTime());
        parent.setState(task.getState());
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTaskNode(TreeTableNode node) {
        boolean result = false;
        int nodeTaskId = node.getNodeContent().getTaskId();
        int nodeSubTaskId = node.getNodeContent().getSubTaskId();
        Object object = this.lock;
        synchronized (object) {
            if (nodeSubTaskId == -1) {
                TreeTableNode oldNode = this.findSameNode(node);
                if (null == oldNode) {
                    this.root.add(node);
                } else {
                    oldNode.setNodeObject(node.getNodeContent());
                }
                result = true;
            } else {
                Enumeration<TreeNode> en = this.root.children();
                while (en.hasMoreElements()) {
                    TreeTableNode tempNode = (TreeTableNode)en.nextElement();
                    int taskId = tempNode.getNodeContent().getTaskId();
                    if (nodeTaskId != taskId) continue;
                    tempNode.add(node);
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private TreeTableNode findSameNode(TreeTableNode node) {
        Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            TreeTableNode tempNode = (TreeTableNode)en.nextElement();
            NeLicenseTask tempTask = tempNode.getNodeContent();
            NeLicenseTask nodeTask = node.getNodeContent();
            if (null == tempTask || nodeTask == null || tempTask.getTaskId() != nodeTask.getTaskId()) continue;
            return tempNode;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskType(int taskId) {
        Object object = this.lock;
        synchronized (object) {
            Enumeration<TreeNode> en = this.root.children();
            while (en.hasMoreElements()) {
                TreeTableNode tempNode = (TreeTableNode)en.nextElement();
                if (taskId != tempNode.getNodeContent().getTaskId()) continue;
                return tempNode.getNodeContent().getType();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeLicenseTask getTaskInfo(int taskId) {
        Object object = this.lock;
        synchronized (object) {
            Enumeration<TreeNode> en = this.root.children();
            while (en.hasMoreElements()) {
                TreeTableNode tempNode = (TreeTableNode)en.nextElement();
                if (taskId != tempNode.getNodeContent().getTaskId()) continue;
                return tempNode.getNodeContent();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskInfo(NeLicenseTask task, int currentColumnIndex, boolean isAscent) {
        Object object = this.lock;
        synchronized (object) {
            Enumeration<TreeNode> en = this.root.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                TreeTableNode tempNode = (TreeTableNode)en.nextElement();
                if (!(tempNode.getUserObject() instanceof NeLicenseTask) || task.getTaskId() != tempNode.getNodeContent().getTaskId() || task.getSubTaskId() != tempNode.getNodeContent().getSubTaskId()) continue;
                tempNode.setNodeObject(task);
                return;
            }
        }
        this.addRefreshTaskData(task, currentColumnIndex, isAscent);
    }

    public void delPaths(TreePath[] paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        for (TreePath path : paths) {
            TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
            if (node == null || node.getParent() == null) continue;
            node.removeFromParent();
            TaskProcess.getInstance().removeTask(node.getNodeContent().getTaskId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delTask(int taskId) {
        Object object = this.lock;
        synchronized (object) {
            Enumeration<TreeNode> en = this.root.children();
            while (en.hasMoreElements()) {
                int id;
                TreeTableNode tempNode = (TreeTableNode)en.nextElement();
                if (tempNode.equals(this.root) || taskId != (id = tempNode.getNodeContent().getTaskId())) continue;
                tempNode.removeFromParent();
                TaskProcess.getInstance().removeTask(taskId);
                break;
            }
        }
    }

    private Map<Integer, NeLicenseTask> getAllSubTasks(TreeTableNode taskNode) {
        HashMap<Integer, NeLicenseTask> subTaskMap = new HashMap<Integer, NeLicenseTask>();
        for (int i = 0; i < taskNode.getChildCount(); ++i) {
            NeLicenseTask info = ((TreeTableNode)taskNode.getChildAt(i)).getNodeContent();
            subTaskMap.put(info.getSubTaskId(), info);
        }
        return subTaskMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodeState(NeLicenseTask task) {
        Object object = this.lock;
        synchronized (object) {
            TreeTableNode node;
            Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
            boolean isFound = false;
            while (en.hasMoreElements()) {
                TreeTableNode tempNode = (TreeTableNode)en.nextElement();
                if (tempNode.equals(this.root)) continue;
                int id = tempNode.getNodeContent().getTaskId();
                int subId = tempNode.getNodeContent().getSubTaskId();
                if (id != task.getTaskId() || subId != task.getSubTaskId()) continue;
                tempNode.setUserObject(task);
                if (subId != -1 && "100%".equals(TaskProcess.getInstance().getCompletePercent(id))) {
                    ((TreeTableNode)tempNode.getParent()).getNodeContent().setState(0);
                    if (tempNode.getParent().getChildCount() == 0) continue;
                    if (task.getType() == 2 || task.getType() == 4) {
                        GuiUtil.showBubble(ResCenter.getInstance().getMergeString(task.getState() == 0 ? "exetasksucceeded" : "exetaskfailured", new String[]{String.valueOf(id), this.getType(task.getType())}));
                    } else {
                        boolean exportSuccess = ExportNeLicInfoMgr.getInstance().exportToFile(id, this.getAllSubTasks((TreeTableNode)tempNode.getParent()));
                        GuiUtil.showBubble(ResCenter.getInstance().getMergeString(exportSuccess ? "exeexporttasksucceeded" : "exetaskfailured", new String[]{String.valueOf(id), this.getType(task.getType()), ExportNeLicInfoMgr.getInstance().getExprotFile(id)}));
                    }
                }
                isFound = true;
                break;
            }
            if (!isFound && !this.addTaskNode(node = new TreeTableNode(task))) {
                this.addTaskNode(new TreeTableNode(this.makeParentTask(task)));
                this.addTaskNode(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.root.removeAllChildren();
        }
    }

    public void setValueAt(Object arg0, Object arg1, int arg2) {
    }

    public Object getChild(Object parent, int index) {
        int count = ((TreeNode)parent).getChildCount();
        if (index >= count) {
            return ((TreeNode)parent).getChildAt(count - 1);
        }
        return ((TreeNode)parent).getChildAt(index);
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return Parameter.class;
        }
        return String.class;
    }

    public boolean isColumnSortable(int i) {
        return false;
    }

    public void setColumnSorted(int i, boolean flag) {
    }
}

