/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.table.selecttable;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCHeaderListener;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortButtonRenderer;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.gui.table.selecttable.DefaultSelectTableModel;
import com.huawei.u2000.nelicense.gui.table.selecttable.IRalationSelectListener;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.View;

public class SelectTable
extends DCExtendedTable {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_KEY_SPACE = "SPACE";
    protected JMenuItem itemSelect;
    protected JMenuItem itemDeselect;
    protected JMenuItem itemDeselectAll;
    protected JMenuItem itemSelectAll;
    private DefaultSelectTableModel model;
    private IRalationSelectListener listener;
    private int keyColumn;
    private static final int ROW_HEIGHT = 21;
    private static final int WIDTH = 520;
    private static final int HEIGHT = 300;
    private boolean showTipWhenOmit = true;
    private boolean isDefaultPopupMenuEnabled = true;
    private JPopupMenu menu;

    public SelectTable(DefaultSelectTableModel _model, int _keyColumn) {
        super((SortableTableModel)_model);
        this.model = _model;
        this.keyColumn = _keyColumn;
        this.init();
    }

    private void init() {
        this.setupPopupMenu();
        this.setReorderingAllowed(false);
        this.setColumnSortable(true);
        this.setRowHeight(21);
        this.addMouseListener();
        this.filterKeyInput(FILTER_KEY_SPACE);
    }

    public DefaultSelectTableModel getDefaultSelectTableModel() {
        return this.model;
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.setSortAgain(false);
        super.setValueAt(aValue, row, column);
        if (aValue instanceof Boolean) {
            boolean b = (Boolean)aValue;
            this.fireRalationSelectListener(this.model.getValueAt(row, this.keyColumn), b);
            this.model.fireTableCellUpdated(row, column);
        }
        this.setSortAgain(true);
    }

    private void addMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SelectTable.this.stopCellEdit();
            }
        });
    }

    private void filterKeyInput(String key) {
        this.getInputMap().put(KeyStroke.getKeyStroke(key), key);
        this.getActionMap().put(key, this.getEmptyAction());
    }

    private AbstractAction getEmptyAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        };
    }

    public void stopCellEdit() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public boolean setValueSelected(Object value, boolean b) {
        int count = this.model.getRowCount();
        for (int row = 0; row < count; ++row) {
            Object obj = this.model.getValueAt(row, this.keyColumn);
            if (!obj.equals(value)) continue;
            this.setValueAt(b, row, 0);
            return true;
        }
        return false;
    }

    public void setValueSelected(Object[] values, boolean b) {
        for (int i = 0; i < values.length; ++i) {
            this.setValueSelected(values[i], b);
        }
    }

    public void addRalationSelectListener(IRalationSelectListener _listener) {
        this.listener = _listener;
    }

    private void fireRalationSelectListener(Object ralatedObj, boolean isSelected) {
        if (null != this.listener) {
            this.listener.ralationSelect(ralatedObj, isSelected);
        }
    }

    public void selectedFirstRow() {
        if (this.getRowCount() > 0) {
            this.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void selectedLastRow() {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            this.getSelectionModel().setSelectionInterval(rowCount - 1, rowCount - 1);
        }
    }

    private void setAllItemEnabled(boolean enabled) {
        this.itemSelect.setEnabled(enabled);
        this.itemDeselect.setEnabled(enabled);
        this.itemDeselectAll.setEnabled(enabled);
        this.itemSelectAll.setEnabled(enabled);
    }

    private void setItemEnabledAsSelectedRow(int row) {
        if (row >= 0) {
            this.getSelectionModel().setSelectionInterval(row, row);
            String neName = (String)this.getValueAt(row, 3);
            if ("--".equals(neName)) {
                this.itemSelect.setEnabled(false);
                this.itemDeselect.setEnabled(false);
            } else if (this.getValueAt(row, 0).equals(Boolean.TRUE)) {
                this.itemSelect.setEnabled(false);
                this.itemDeselect.setEnabled(true);
            } else {
                this.itemSelect.setEnabled(true);
                this.itemDeselect.setEnabled(false);
            }
            this.itemSelectAll.setEnabled(false);
            this.itemDeselectAll.setEnabled(false);
            for (int i = 0; i < this.getSelectedRowCount(); ++i) {
                neName = (String)this.getValueAt(row, 3);
                if ("--".equals(neName)) continue;
                this.itemSelectAll.setEnabled(true);
                this.itemDeselectAll.setEnabled(true);
                break;
            }
        } else {
            this.itemSelect.setEnabled(false);
            this.itemDeselect.setEnabled(false);
        }
    }

    private boolean isDefaultPopupMenuEnabled() {
        return this.isDefaultPopupMenuEnabled;
    }

    public void setDefaultPopupMenuEnabled(boolean value) {
        this.isDefaultPopupMenuEnabled = value;
    }

    public void setupPopupMenu() {
        this.getPopupMenu();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectTable.this.showPopupMenu(e);
            }
        });
    }

    public void showPopupMenu(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.setAllItemEnabled(this.isEnabled());
            int[] rows = this.getSelectedRows();
            if (rows.length <= 1 && this.isEnabled()) {
                this.setItemEnabledAsSelectedRow(this.rowAtPoint(e.getPoint()));
            }
            if (this.isDefaultPopupMenuEnabled()) {
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.menu.setName("SM_SelectTable_PopupMenu");
            this.itemSelectAll = new MenuItemSelectAll(ResCenter.getInstance().getString("MENU_SELECT_ALL"), 'A', true);
            this.itemDeselectAll = new MenuItemSelectAll(ResCenter.getInstance().getString("MENU_DESELECT_ALL"), 'D', false);
            this.itemSelect = new MenuItemSelect(ResCenter.getInstance().getString("MENU_SELECT"), 'T', true);
            this.itemDeselect = new MenuItemSelect(ResCenter.getInstance().getString("MENU_DESELECT"), 'C', false);
            this.menu.add(this.itemSelect);
            this.menu.add(this.itemDeselect);
            this.menu.add(this.itemSelectAll);
            this.menu.add(this.itemDeselectAll);
        }
        return this.menu;
    }

    private void setReorderingAllowed(boolean allowed) {
        this.getTableHeader().setReorderingAllowed(allowed);
    }

    public void setColumnSortable(boolean sortable, int column) {
        DCSortButtonRenderer headRenderer = new DCSortButtonRenderer();
        this.tableHeader.addMouseListener((MouseListener)new DCHeaderListener(this.tableHeader, headRenderer, 1));
        this.model.setColumnSortable(column, sortable);
        TableColumn tableColumn = this.columnModel.getColumn(column);
        tableColumn.setHeaderRenderer((TableCellRenderer)headRenderer);
    }

    public void setColumnSortable(boolean sortable) {
        int count = this.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.setColumnSortable(sortable, i);
        }
    }

    public void clearAllSelectedRow() {
        int count = this.model.getRowCount();
        for (int row = 0; row < count; ++row) {
            Object obj = this.model.getValueAt(row, this.keyColumn);
            this.setValueAt(Boolean.FALSE, row, 0);
        }
        this.getSelectionModel().clearSelection();
        this.clearNotSavedCells();
    }

    public static void main(String[] args) {
        JDialog dlg = new JDialog();
        dlg.setSize(520, 300);
        dlg.setResizable(false);
        Container container = dlg.getContentPane();
        container.setLayout(new BorderLayout());
        Object[] columnNames = new String[]{"Select", "Name", "Desc"};
        Object[][] rows = new Object[][]{{Boolean.TRUE, "yh.liu", "test001"}, {Boolean.FALSE, "jh.hu", "test002"}, {Boolean.TRUE, "yx.yang", "test003"}};
        DefaultSelectTableModel model = new DefaultSelectTableModel(rows, columnNames);
        model.addRow(new Object[]{Boolean.TRUE, "bl.feng", "test004"});
        final SelectTable table = new SelectTable(model, 2);
        table.setDefaultPopupMenuEnabled(false);
        table.addRalationSelectListener(new IRalationSelectListener(){

            @Override
            public void ralationSelect(Object ralatedObj, boolean isSelected) {
                if (isSelected && "test001".equals(ralatedObj.toString())) {
                    table.setValueSelected("test003", isSelected);
                }
                if (!isSelected && "test003".equals(ralatedObj.toString())) {
                    table.setValueSelected("test001", isSelected);
                }
            }
        });
        container.add((Component)new JScrollPane((Component)((Object)table)), "Center");
        dlg.setDefaultCloseOperation(2);
        dlg.setLocationRelativeTo(dlg.getOwner());
        dlg.setVisible(true);
    }

    public Point getToolTipLocation(MouseEvent event) {
        if (null == this.getToolTipText(event)) {
            return null;
        }
        Point location = new Point();
        location.x = event.getPoint().x + 20;
        location.y = event.getPoint().y + 10;
        return location;
    }

    public String getToolTipText(MouseEvent e) {
        String tip = null;
        if (this.showTipWhenOmit) {
            JLabel jl;
            TableCellRenderer render;
            Component cellRender;
            int row = this.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = this.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != -1 && row != -1 && (cellRender = (render = this.getCellRenderer(row, col)).getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(row, col), this.isCellSelected(row, col), false, row, col)) instanceof JLabel && this.needTooltip(jl = (JLabel)cellRender, this.getColumnModel().getColumn(col).getWidth() - 1)) {
                tip = jl.getText();
            }
        }
        if (tip == null) {
            tip = super.getToolTipText(e);
        }
        return tip;
    }

    private boolean needTooltip(JLabel label, int width) {
        int availTextWidth;
        int gap;
        Icon icon;
        if (label == null) {
            LicDebugTracer.trace("NELicenseInfo:SelectTable | needTooltip label is null.");
            return false;
        }
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return false;
        }
        FontMetrics fm = label.getFontMetrics(label.getFont());
        Insets insets = label.getInsets(new Insets(0, 0, 0, 0));
        int viewWidth = width - (insets.left + insets.right);
        int iconWidth = 0;
        int textWidth = 0;
        boolean orientationIsLeftToRight = true;
        if (label != null && !label.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        int horizontalTextPosition = label.getHorizontalTextPosition();
        switch (horizontalTextPosition) {
            case 10: {
                horizontalTextPosition = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                horizontalTextPosition = orientationIsLeftToRight ? 4 : 2;
                break;
            }
        }
        iconWidth = icon != null ? icon.getIconWidth() : 0;
        boolean textIsEmpty = text == null || text.equals("");
        View v = null;
        if (textIsEmpty) {
            textWidth = 0;
            text = "";
        } else {
            v = (View)label.getClientProperty("html");
            textWidth = v != null ? (int)v.getPreferredSpan(0) : SwingUtilities.computeStringWidth(fm, text);
        }
        int n = gap = textIsEmpty || icon == null ? 0 : label.getIconTextGap();
        return !textIsEmpty && textWidth > (availTextWidth = horizontalTextPosition == 0 ? viewWidth : viewWidth - (iconWidth + gap));
    }

    private class MenuItemSelect
    extends SelectMenuItem {
        public MenuItemSelect(String name, char vk, boolean isSelected) {
            super(name, vk, isSelected);
        }

        @Override
        public void selectPerformed() {
            for (int i = 0; i < SelectTable.this.getSelectedRows().length; ++i) {
                int[] row = SelectTable.this.getSelectedRows();
                String neName = (String)SelectTable.this.getValueAt(row[i], 3);
                if ("--".equals(neName)) continue;
                SelectTable.this.setValueAt(this.isSelected, row[i], 0);
            }
        }
    }

    private class MenuItemSelectAll
    extends SelectMenuItem {
        public MenuItemSelectAll(String name, char vk, boolean isSelected) {
            super(name, vk, isSelected);
        }

        @Override
        public void selectPerformed() {
            int count = SelectTable.this.getRowCount();
            for (int i = 0; i < count; ++i) {
                String neName = (String)SelectTable.this.getValueAt(i, 3);
                if ("--".equals(neName)) continue;
                SelectTable.this.setValueAt(this.isSelected, i, 0);
            }
        }
    }

    private abstract class SelectMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = -4289922561069034216L;
        protected boolean isSelected;

        public SelectMenuItem(String name, char vk, boolean isSelected) {
            super(name);
            this.isSelected = isSelected;
            this.setName("SM_SelectTable_" + name);
            this.setMnemonic(vk);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectMenuItem.this.selectPerformed();
                }
            });
        }

        public abstract void selectPerformed();
    }
}

