/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.table;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.checknodesinfoxml.ReadZIPLicenseFile;
import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.gui.dlg.SingleSelectDomainDlg;
import com.huawei.u2000.nelicense.gui.table.selecttable.DefaultSelectTableModel;
import com.huawei.u2000.nelicense.gui.table.selecttable.SelectTable;
import com.huawei.u2000.nelicense.model.NELicenseFileInfo;
import com.huawei.u2000.nelicense.model.NETreeNodeInfo;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;

public class AutoMatchingNETable
extends SelectTable {
    private List<NELicenseFileInfo> datalist = new ArrayList<NELicenseFileInfo>();
    private static final String[] headers = new String[]{ResCenter.getInstance().getString("AutoMatchTableHead_isload"), ResCenter.getInstance().getString("AutoMatchTableHead_licenseFileName"), ResCenter.getInstance().getString("AutoMatchTableHead_ESN"), ResCenter.getInstance().getString("AutoMatchTableHead_NE_Name"), "hidden"};
    private SingleSelectDomainDlg dlg = null;
    private static final int C_CHOOSE = 0;
    private static final int C_LicenseFileName = 1;
    private static final int C_ESN = 2;
    private static final int C_NE_NAME = 3;
    private static final int C_FDN = 4;
    private JMenuItem itemMatching = new JMenuItem(ResCenter.getInstance().getString("MENU_MATCH"));

    public AutoMatchingNETable() {
        super(new DefaultSelectTableModel(null, headers), 1);
        this.getColumn(headers[0]).setMinWidth(80);
        this.getColumn(headers[0]).setMaxWidth(80);
        this.setDefaultPopupMenuEnabled(true);
        this.hideColumn(4);
        this.addMenuItem();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AutoMatchingNETable.this.showMyMenuItem(e);
            }
        });
        this.setName("LTE_AutoMatchingNETable");
    }

    public void addMenuItem() {
        JPopupMenu menu = this.getPopupMenu();
        this.itemMatching.setMnemonic('M');
        this.itemMatching.setEnabled(false);
        menu.add((Component)this.itemMatching, 0);
        this.itemMatching.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoMatchingNETable.this.dlg = new SingleSelectDomainDlg();
                JButton digOKbutton = AutoMatchingNETable.this.dlg.getOkButton();
                digOKbutton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultMutableTreeNode node = AutoMatchingNETable.this.dlg.getSelectTreeNodes();
                        if (null == node) {
                            DCOptionPane.showMessageDialog(null, (String)ResCenter.getInstance().getString("noselectedne"));
                        } else if (node.isLeaf()) {
                            LicDebugTracer.trace("NelicenseInfo:Class <" + this.getClass() + "> get the NE node: " + node);
                            AutoMatchingNETable.this.updateCurrentSelectRow(node);
                            AutoMatchingNETable.this.dlg.dispose();
                        }
                    }
                });
                AutoMatchingNETable.this.dlg.setVisible(true);
            }
        });
    }

    private void updateCurrentSelectRow(DefaultMutableTreeNode node) {
        int row = this.getSelectedRow();
        NETreeNodeInfo oNodeInfo = (NETreeNodeInfo)node.getUserObject();
        this.getDefaultSelectTableModel().setValueAt(oNodeInfo.getNeLicInfo().getLabel(), row, 3);
        this.getDefaultSelectTableModel().setValueAt(oNodeInfo.getNeLicInfo().getFdn(), row, 4);
        TableCellEditor r = super.getCellEditor(row, 0);
        Component checkBox = r.getTableCellEditorComponent((JTable)((Object)this), false, false, row, 0);
        ((JCheckBox)checkBox).setEnabled(true);
    }

    public void addData(NELicenseFileInfo info) {
        Vector<Object> vector = new Vector<Object>(headers.length);
        vector.add(Boolean.FALSE);
        vector.add(info.getFileName());
        vector.add(info.getEsn());
        vector.add(info.getEsnName());
        vector.add(info.getFdn());
        this.getDefaultSelectTableModel().addRow(vector);
    }

    public List getData() {
        ArrayList<Object> list = new ArrayList<Object>(0);
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            list.add(this.getValueAt(i, 1));
        }
        return list;
    }

    public NELicenseFileInfo[] getSelectedData() {
        ArrayList<NELicenseFileInfo> list = new ArrayList<NELicenseFileInfo>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!Boolean.TRUE.equals(this.getValueAt(i, 0))) continue;
            String fileContent = this.getFileContent((String)this.getValueAt(i, 1), (String)this.getValueAt(i, 2));
            NELicenseFileInfo info = new NELicenseFileInfo();
            info.setFileName((String)this.getValueAt(i, 1));
            info.setLicenseContent(fileContent);
            info.setFdn((String)this.getDefaultSelectTableModel().getValueAt(i, 4));
            info.setEsn((String)this.getValueAt(i, 2));
            info.setEsnName((String)this.getValueAt(i, 3));
            list.add(info);
        }
        NELicenseFileInfo[] neArray = new NELicenseFileInfo[list.size()];
        list.toArray(neArray);
        return neArray;
    }

    private String getFileContent(String fileName, String esn) {
        for (NELicenseFileInfo info : this.datalist) {
            if (!info.getEsn().equalsIgnoreCase(esn) || !info.getFileName().equalsIgnoreCase(fileName)) continue;
            return info.getLicenseContent();
        }
        return "";
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (this.isEnabled() && column == 0) {
            TableCellEditor editor = super.getCellEditor(row, column);
            String cellValue = (String)this.getValueAt(row, 3);
            Component checkbox = editor.getTableCellEditorComponent((JTable)((Object)this), false, false, row, column);
            if (checkbox instanceof JCheckBox) {
                JCheckBox cc = (JCheckBox)checkbox;
                if (cellValue != null && cellValue.equals("--")) {
                    cc.setEnabled(false);
                } else {
                    cc.setEnabled(true);
                }
            }
            return editor;
        }
        return super.getCellEditor(row, column);
    }

    public void showMyMenuItem(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int[] rows = this.getSelectedRows();
            if (rows.length <= 1 && this.isEnabled()) {
                int row = this.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    String neName = (String)this.getValueAt(row, 3);
                    if (neName.equals("--")) {
                        this.itemMatching.setEnabled(true);
                    } else {
                        this.itemMatching.setEnabled(false);
                    }
                    String esnID = (String)this.getValueAt(row, 2);
                    if (null == esnID || esnID.equals("")) {
                        this.itemMatching.setEnabled(false);
                    } else {
                        this.itemMatching.setEnabled(true);
                    }
                }
            } else {
                this.itemMatching.setEnabled(false);
            }
        }
    }

    public boolean isZipFileDataEmpty() {
        return this.datalist.size() <= 0;
    }

    public void initTableData(String filePath) {
        block4: {
            try {
                this.datalist = ReadZIPLicenseFile.readXMLFile(filePath);
                if (this.datalist.size() < 1) {
                    return;
                }
                for (NELicenseFileInfo info : this.datalist) {
                    Object[] NELicInfoLst = NeLicenseInfoManager.getInstance().getAllNeLicenseInfo();
                    LicDebugTracer.trace("NELicenseInfo: class <" + ((Object)((Object)this)).getClass() + "> get current NE List:" + Arrays.toString(NELicInfoLst));
                    info = this.autoMatchESNToNE(info, (NeLicenseBaseInfo[])NELicInfoLst);
                    this.addData(info);
                }
            }
            catch (Exception e) {
                if (GuiUtil.handleException(e)) break block4;
                LicDebugTracer.trace("NELicenseInfo: class <" + ((Object)((Object)this)).getClass() + "> occur exception when initTableData:" + e);
                LicDebugTracer.trace(e);
            }
        }
    }

    private NELicenseFileInfo autoMatchESNToNE(NELicenseFileInfo info, NeLicenseBaseInfo[] NELicInfoLst) {
        for (NeLicenseBaseInfo baseInfo : NELicInfoLst) {
            String[] esnLst = info.getEsn().split(",");
            for (int i = 0; i < esnLst.length; ++i) {
                String neEsn = baseInfo.getEsn() + ",";
                if (neEsn.indexOf(esnLst[i] + ",") < 0) continue;
                LicDebugTracer.trace("NELicenseInfo: class <" + ((Object)((Object)this)).getClass() + "> Auto match ESN File to NE " + baseInfo.getLabel() + "for same esn" + esnLst[i]);
                info.setEsnName(baseInfo.getLabel());
                info.setFdn(baseInfo.getFdn());
                return info;
            }
        }
        LicDebugTracer.trace("NELicenseInfo: class <" + ((Object)((Object)this)).getClass() + "> Auto match ESN File to current NE fail.");
        return info;
    }
}

