/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.panel;

import com.huawei.dc.adapter.swimap.iview.framework.util.DCFrameworkUtilities;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.adapter.swimap.iview.util.DCFileChooserFilter;
import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.dc.adapter.swimap.iview.util.DCSaveFileChooser;
import com.huawei.u2000.component.table.customize.TableCustomizer;
import com.huawei.u2000.nelicense.common.Constants;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.RightManager;
import com.huawei.u2000.nelicense.common.controller.NeLicenseDetailManager;
import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.common.licdetailsinfo.LicExportTask;
import com.huawei.u2000.nelicense.gui.dlg.SearchLicenseFilterDialog;
import com.huawei.u2000.nelicense.gui.dlg.SimpleProgressDlg;
import com.huawei.u2000.nelicense.model.FilterCondition;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.model.NeLicenseDetailInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.IInternalFrameInterface;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class QueryLicensePanel
extends JPanel {
    private static final long serialVersionUID = -8671448764963109246L;
    private static QueryLicensePanel instance;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private DCSortableTableModel m_oLicInfoSortableTableModel;
    private DCExtendedTable m_oLicInfoTable = null;
    private DCExtendedTable detailTable = null;
    private boolean licDetailInfoDataAddable;
    private String detailDes = ResCenter.getInstance().getString("DetailMessage");
    private JButton filterButton = new JButton(ResCenter.getInstance().getString("filterData"));
    private JButton queryButton = new JButton(ResCenter.getInstance().getString("BUTTON_QUERY_DETAIL"));
    private JButton refreshButton = new JButton(ResCenter.getInstance().getString("refresh"));
    private JMenuItem exportAllMenu = new JMenuItem(ResCenter.getInstance().getString("ExportAllRecord"));
    private JMenuItem exportSelectedMenu = new JMenuItem(ResCenter.getInstance().getString("ExportSelectedRecord"));
    private String fdnColumnName = "fdn";
    private static SearchLicenseFilterDialog dialog;
    private String[] pagedTableColumnNames = new String[]{ResCenter.getInstance().getString("NE_Name"), ResCenter.getInstance().getString("NE_Desc"), ResCenter.getInstance().getString("NE_Type"), ResCenter.getInstance().getString("License_Version"), ResCenter.getInstance().getString("License_ESN"), ResCenter.getInstance().getString("License_Status"), this.fdnColumnName};
    private JSplitPane frameSplitPane;
    private static FilterCondition filterCondition;
    private FilterCondition DEFAULT_FILTER_CONDITION = new FilterCondition(new int[]{0, 1, 2, 3, 4, 5}, "", new String[0]);
    private JPopupMenu popupMenu = null;
    private int m_curTaskId;
    private Thread oGetLicenseInfo = null;
    private SimpleProgressDlg m_oProgressDlg = null;
    private int iOldSelectIndex = -1;
    private List<LicExportTask> listTask = new ArrayList<LicExportTask>();

    public static QueryLicensePanel getInstance() {
        if (null == instance) {
            instance = new QueryLicensePanel();
        }
        return instance;
    }

    public static void clear() {
        if (null != dialog) {
            dialog.dispose();
            dialog = null;
        }
        if (null != filterCondition) {
            filterCondition.clear();
            filterCondition = null;
        }
        instance = null;
    }

    private JPanel getBtnPanel() {
        JPanel btnPanel = new JPanel(new BorderLayout());
        this.filterButton.setName("QueryLicensePanel_filterBtn");
        this.refreshButton.setName("QueryLicensePanel_refreshBtn");
        this.setButtonSize(this.filterButton);
        this.setButtonSize(this.refreshButton);
        this.filterButton.setMnemonic('i');
        this.refreshButton.setMnemonic('R');
        this.exportAllMenu.setMnemonic('A');
        this.exportSelectedMenu.setMnemonic('S');
        JPanel leftBtnPanel = new JPanel(new FlowLayout(0));
        JPanel rightBtnPanel = new JPanel(new FlowLayout(2));
        rightBtnPanel.add(this.filterButton);
        rightBtnPanel.add(this.refreshButton);
        btnPanel.add((Component)leftBtnPanel, "West");
        btnPanel.add((Component)rightBtnPanel, "East");
        return btnPanel;
    }

    private QueryLicensePanel() {
        this.initPanel();
        this.initListener();
        this.initPopupMenu();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        this.m_oLicInfoSortableTableModel = new DCSortableTableModel((Object[])this.pagedTableColumnNames, 0);
        this.m_oLicInfoTable = new DCExtendedTable((SortableTableModel)this.m_oLicInfoSortableTableModel);
        this.m_oLicInfoTable.setName("QueryLicensePanel_licInfoTable");
        this.m_oLicInfoTable.setColumnSortable(new int[]{0, 1, 2, 3, 4, 5}, true);
        this.m_oLicInfoTable.setSortable(true);
        this.m_oLicInfoTable.setSortableClickCount(1);
        this.hideTheColumn(this.fdnColumnName);
        this.m_oLicInfoTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane licInfoTableScrollPane = new JScrollPane((Component)this.m_oLicInfoTable);
        this.detailTable = new DCExtendedTable((SortableTableModel)new DCSortableTableModel());
        JScrollPane deatilPanel = new JScrollPane((Component)this.detailTable);
        JPanel detailPanel = new JPanel(new BorderLayout());
        JPanel queryBtnPanel = new JPanel(new FlowLayout(0));
        this.queryButton.setName("QueryLicensePanel_QueryBtn");
        this.setButtonSize(this.queryButton);
        this.queryButton.setMnemonic('Q');
        this.queryButton.setEnabled(false);
        queryBtnPanel.add(this.queryButton);
        detailPanel.add("North", queryBtnPanel);
        detailPanel.add("Center", deatilPanel);
        this.tabbedPane.addTab(this.detailDes, detailPanel);
        this.frameSplitPane = new JSplitPane(0, false);
        this.frameSplitPane.setTopComponent(licInfoTableScrollPane);
        this.frameSplitPane.setBottomComponent(this.tabbedPane);
        this.frameSplitPane.setResizeWeight(0.8);
        this.frameSplitPane.setOneTouchExpandable(true);
        this.add((Component)this.frameSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getBtnPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setMinimumSize(Constants.Component.ComponentSize.NELICENSE_RIGHT_FRAME_MIN_SIZE);
        TableCustomizer oTableCustomizer = new TableCustomizer((JTable)this.m_oLicInfoTable, "conf/u2000nelicense/query_lic_info.xml");
        TableColumn[] oTableColumns = new TableColumn[]{this.m_oLicInfoTable.getColumnModel().getColumn(0)};
        oTableCustomizer.setNotAllowCustomizedColumns(Arrays.asList(oTableColumns));
    }

    private void hideTheColumn(String columnName) {
        int columnIndex = this.m_oLicInfoTable.getColumnModel().getColumnIndex(columnName);
        TableColumn tableColumn = this.m_oLicInfoTable.getColumnModel().getColumn(columnIndex);
        if (null != tableColumn) {
            this.m_oLicInfoTable.removeColumn(tableColumn);
        }
    }

    private void initListener() {
        this.m_oLicInfoTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (RightManager.hasQueryNeLicenseDetailInfoRight() && QueryLicensePanel.this.m_oLicInfoTable.getSelectedRows().length == 1) {
                    QueryLicensePanel.this.queryButton.setEnabled(true);
                } else {
                    QueryLicensePanel.this.queryButton.setEnabled(false);
                }
                QueryLicensePanel.this.tableMouseReleased(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (RightManager.hasQueryNeLicenseDetailInfoRight() && QueryLicensePanel.this.m_oLicInfoTable.getSelectedRows().length == 1) {
                        QueryLicensePanel.this.queryButton.setEnabled(true);
                    } else {
                        QueryLicensePanel.this.queryButton.setEnabled(false);
                    }
                }
            }
        });
        this.m_oLicInfoTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                QueryLicensePanel.this.tableKeyReleased(e);
            }
        });
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                QueryLicensePanel.this.filter();
            }
        });
        this.queryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                QueryLicensePanel.this.initProgressDlg();
                QueryLicensePanel.this.getSelectedRow();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryLicensePanel.this.refresh();
            }
        });
        this.exportAllMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryLicensePanel.this.exportAllRecord();
            }
        });
        this.exportSelectedMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryLicensePanel.this.exportSelectedRecord();
            }
        });
    }

    public void addDetailTable(NeLicenseDetailInfo neLicenseDetailInfo, long taskId) {
        this.detailTable.clear();
        if (taskId == (long)this.m_curTaskId && this.licDetailInfoDataAddable) {
            String[] columns = neLicenseDetailInfo.getColumns().toArray(new String[0]);
            if (null != columns && columns.length > 0) {
                for (int i = 0; i < columns.length; ++i) {
                    columns[i] = ResCenter.getInstance().getString(columns[i]);
                }
            }
            this.detailTable.setModel((TableModel)new DCSortableTableModel((String[][])neLicenseDetailInfo.getDatas().toArray((T[])new String[0][]), columns));
        }
        this.detailTable.revalidate();
        this.closeProgressDlg();
    }

    public void clearDetailTable() {
        this.detailTable.setModel((TableModel)new DCSortableTableModel());
        this.detailTable.revalidate();
    }

    private void initPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.exportAllMenu);
            this.popupMenu.add(this.exportSelectedMenu);
        }
    }

    public void tableMouseReleased(MouseEvent e) {
        if (this.m_oLicInfoTable.rowAtPoint(e.getPoint()) != this.iOldSelectIndex) {
            this.clearDetailTable();
        }
        this.iOldSelectIndex = this.m_oLicInfoTable.rowAtPoint(e.getPoint());
        if (SwingUtilities.isRightMouseButton(e)) {
            int row = this.m_oLicInfoTable.rowAtPoint(e.getPoint());
            int[] selectedRows = this.m_oLicInfoTable.getSelectedRows();
            if (Arrays.binarySearch(selectedRows, row) < 0 && row > 0) {
                this.m_oLicInfoTable.setRowSelectionInterval(row, row);
            }
            if (this.m_oLicInfoTable.getSelectedRows().length > 0) {
                this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
            return;
        }
    }

    public void getSelectedRow() {
        if (this.m_oLicInfoTable.getSelectedRows().length == 1) {
            this.licDetailInfoDataAddable = true;
            if (null != this.oGetLicenseInfo && this.oGetLicenseInfo.isAlive()) {
                this.oGetLicenseInfo.destroy();
            }
            this.oGetLicenseInfo = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        QueryLicensePanel.this.queryNeLicenseDetailInfo(new int[]{QueryLicensePanel.this.m_oLicInfoTable.getSelectedRows()[0]});
                    }
                    catch (Exception e) {
                        QueryLicensePanel.this.closeProgressDlg();
                        LicDebugTracer.trace(e);
                    }
                }
            });
            this.oGetLicenseInfo.setName("QueryLicensePanel#getSelectedRow");
            this.oGetLicenseInfo.start();
            if (null != this.m_oProgressDlg) {
                this.m_oProgressDlg.setThread(this.oGetLicenseInfo);
                this.m_oProgressDlg.setVisible(true);
            }
        } else {
            this.licDetailInfoDataAddable = false;
            this.detailTable.setModel((TableModel)new DCSortableTableModel());
        }
    }

    public void tableKeyReleased(KeyEvent e) {
    }

    public void queryNeLicenseDetailInfo(int[] indexes) {
        block5: {
            if (!RightManager.hasQueryNeLicenseDetailInfoRight()) {
                LicDebugTracer.trace("NELicenseInfo:ho no right to query ne license detail information!");
                return;
            }
            int size = indexes.length;
            String[] neFdnArray = new String[size];
            int col = this.pagedTableColumnNames.length - 1;
            for (int i = 0; i < size; ++i) {
                String neFdn;
                neFdnArray[i] = neFdn = this.m_oLicInfoSortableTableModel.getValueAt(indexes[i], col).toString();
            }
            try {
                int[] detailResult = NeLicenseDetailManager.getInstance().getNeLicenseDetailInfo(neFdnArray);
                if (0 == detailResult[0]) {
                    this.m_curTaskId = detailResult[1];
                }
            }
            catch (Exception e) {
                if (GuiUtil.handleException(e)) break block5;
                LicDebugTracer.trace("NELicenseInfo:QueryLicensePanel : queryNeLicenseDetailInfo : info : " + e);
                DCOptionPane.showMessageDialog((Component)DCFrameworkUtilities.getMainFrame(), (String)e.toString());
            }
        }
    }

    public int getTaskID() {
        return this.m_curTaskId;
    }

    public void filter() {
        dialog = new SearchLicenseFilterDialog(this.getFilterCondition(), true);
        if (dialog.confirmShow()) {
            this.updateNeLicInfo(false);
        }
    }

    public DCSortableTableModel getTableModel() {
        return this.m_oLicInfoSortableTableModel;
    }

    public void exportAllRecord() {
        int count = this.m_oLicInfoTable.getRowCount();
        if (count == 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameworkUtilities.getMainFrame(), (String)"No record is selected.");
            return;
        }
        String file = this.getFilePath();
        if (file == null || "".equals(file.trim())) {
            return;
        }
        HashMap<String, String> fdns = new HashMap<String, String>();
        String[] arrayFDN = new String[count];
        for (int i = 0; i < count; ++i) {
            String neFdn = this.m_oLicInfoSortableTableModel.getValueAt(i, this.pagedTableColumnNames.length - 1).toString();
            String neName = this.m_oLicInfoSortableTableModel.getValueAt(i, 0).toString();
            fdns.put(neFdn, neName);
            arrayFDN[i] = neFdn;
        }
        LicExportTask task = new LicExportTask(count, fdns, file, arrayFDN);
        task.startTask();
        this.listTask.add(task);
    }

    public List<LicExportTask> getListTask() {
        return this.listTask;
    }

    public boolean isExport() {
        for (LicExportTask task : this.listTask) {
            if (!task.isRun()) continue;
            return true;
        }
        return false;
    }

    public void cancelSaveTask(int taskId) {
        if (null == this.listTask || this.listTask.size() == 0) {
            return;
        }
        for (LicExportTask task : this.listTask) {
            if (task.getTaskId() != taskId) continue;
            this.listTask.remove(task);
            break;
        }
    }

    public void exportSelectedRecord() {
        int[] selectedRows = this.m_oLicInfoTable.getSelectedRows();
        int length = selectedRows.length;
        if (length == 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameworkUtilities.getMainFrame(), (String)"No record is selected.");
            return;
        }
        String file = this.getFilePath();
        if (file == null || "".equals(file.trim())) {
            return;
        }
        HashMap<String, String> fdns = new HashMap<String, String>();
        String[] arrayFDN = new String[length];
        int count = 0;
        for (int i : selectedRows) {
            String neFdn = this.m_oLicInfoSortableTableModel.getValueAt(i, this.pagedTableColumnNames.length - 1).toString();
            String neName = this.m_oLicInfoSortableTableModel.getValueAt(i, 0).toString();
            fdns.put(neFdn, neName);
            arrayFDN[count++] = neFdn;
        }
        LicExportTask task = new LicExportTask(length, fdns, file, arrayFDN);
        task.startTask();
        this.listTask.add(task);
    }

    private String getFilePath() {
        boolean fileDir;
        String strPath = System.getProperty("user.dir") + System.getProperty("file.separator") + "report/";
        File fileDoc = new File(strPath);
        if (!fileDoc.exists() && !(fileDir = fileDoc.mkdir())) {
            LicDebugTracer.trace("QueryLicensePanel#getFilePath fail to make directory");
        }
        DCSaveFileChooser chooser = new DCSaveFileChooser(strPath, true);
        chooser.setAcceptAllFileFilterUsed(false);
        DCFileChooserFilter xml = new DCFileChooserFilter("xml", "XMLFiles");
        chooser.addChoosableFileFilter((FileFilter)xml);
        if (chooser.showSaveDialog((Component)DCFrameworkUtilities.getMainFrame()) != 0) {
            return null;
        }
        String savePath = chooser.getSelectedFile().getPath();
        String newfilterStr = "." + ((DCFileChooserFilter)chooser.getFileFilter()).getAllFilters().get(0).toString();
        if (savePath.lastIndexOf(".") == -1) {
            savePath = savePath + newfilterStr;
        } else {
            String oldFilterStr = savePath.substring(savePath.lastIndexOf("."), savePath.length()).toLowerCase();
            if (!oldFilterStr.equals(newfilterStr)) {
                savePath = savePath + newfilterStr;
            }
        }
        return savePath;
    }

    public void refresh() {
        this.updateNeLicInfo(true);
        this.clearDetailTable();
    }

    private void updateNeLicInfo(boolean isRefresh) {
        if (isRefresh) {
            NeLicenseInfoManager.getInstance().refresh();
        }
        NeLicenseBaseInfo[] oNeLicInfos = NeLicenseInfoManager.getInstance().getNeLicenseInfo(this.getFilterCondition());
        Vector oLicVec = new Vector();
        for (NeLicenseBaseInfo oNeLicInfo : oNeLicInfos) {
            Vector<String> licVec = new Vector<String>();
            licVec.add(oNeLicInfo.getLabel());
            licVec.add(oNeLicInfo.getDesc());
            licVec.add(oNeLicInfo.getNeType());
            licVec.add(oNeLicInfo.getVersion());
            licVec.add(oNeLicInfo.getEsn());
            licVec.add(oNeLicInfo.getStrStatus());
            licVec.add(oNeLicInfo.getFdn());
            oLicVec.add(licVec);
        }
        this.m_oLicInfoSortableTableModel.getDataVector().clear();
        this.m_oLicInfoSortableTableModel.addRows(oLicVec);
        if (0 == oLicVec.size()) {
            String message = ResCenter.getInstance().getString("noLicenseRecord");
            DCOptionPane.showMessageDialog((Component)DCFrameworkUtilities.getMainFrame(), (String)message);
        }
    }

    private void setButtonSize(JButton button) {
        Dimension size = new Dimension(80, 21);
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setSize(size);
        button.setPreferredSize(size);
        button.setMaximumSize(size);
        button.setMinimumSize(size);
    }

    public FilterCondition getFilterCondition() {
        if (null == filterCondition) {
            return this.DEFAULT_FILTER_CONDITION;
        }
        return filterCondition;
    }

    public void setFilterCondition(FilterCondition curCondition) {
        filterCondition = curCondition;
    }

    private void initProgressDlg() {
        this.closeProgressDlg();
        this.m_oProgressDlg = new SimpleProgressDlg(ResCenter.getInstance().getString("LICENSE_INFO_PROGRESS"), true, ResCenter.getInstance().getString("GETTING_LICENSE_INFO_PROGRESS"), this){
            private static final long serialVersionUID = 1L;

            @Override
            public void cancelButtonActionPerformed() {
                if (null == QueryLicensePanel.this.m_oProgressDlg) {
                    return;
                }
                QueryLicensePanel.this.m_oProgressDlg.dispose();
                QueryLicensePanel.this.m_oProgressDlg = null;
            }

            @Override
            protected void closeDialog() {
                super.dispose();
            }
        };
        this.m_oProgressDlg.setLocationRelativeTo(this);
        IInternalFrameInterface oInternalFrame = ((MDIFrame)FrameworkUtilities.getMainFrame()).getWindowManager().getActiveWindow();
        this.m_oProgressDlg.setModalParent(null);
        this.m_oProgressDlg.setDefaultCloseOperation(2);
        if (null != oInternalFrame && oInternalFrame instanceof InternalFrame) {
            this.m_oProgressDlg.setParentDefault(false);
            this.m_oProgressDlg.setParentDefault(false);
            this.m_oProgressDlg.setModalParent((InternalFrame)oInternalFrame);
        } else {
            this.m_oProgressDlg.toFront();
            LicDebugTracer.trace("QueryLicensePanel#initProgressDlg#oInternalFrame is not InternalFrame.");
        }
    }

    private void showProgressDlg() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != QueryLicensePanel.this.m_oProgressDlg) {
                    QueryLicensePanel.this.m_oProgressDlg.setVisible(true);
                }
            }
        });
    }

    private void closeProgressDlg() {
        if (null != this.m_oProgressDlg) {
            this.m_oProgressDlg.dispose();
            this.m_oProgressDlg = null;
        }
    }
}

