/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.panel;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.gui.dlg.MultiSelectDomainDlg;
import com.huawei.u2000.nelicense.gui.dlg.SingleSelectDomainDlg;
import com.huawei.u2000.nelicense.gui.panel.TablePanel;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class NESelectTablePanel {
    private JPanel panel = null;
    private TablePanel tablePanel = null;
    private JButton selectNeBtn = null;
    private MultiSelectDomainDlg dlg = null;
    private String[] selectedNeArray = null;
    private ArrayList<String> tableNeIDList = new ArrayList();
    private List<NeLicenseBaseInfo> neSelectedList = new ArrayList<NeLicenseBaseInfo>();
    private static Window parentWindow;

    public NESelectTablePanel(Window parentWindow, ActionListener selectActionListener, final int panelType) {
        NESelectTablePanel.parentWindow = parentWindow;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        String neName = ResCenter.getInstance().getString("NE_Name");
        String version = ResCenter.getInstance().getString("License_Version");
        String status = ResCenter.getInstance().getString("License_Status");
        String[] tableColumnName = new String[]{neName, version, status};
        this.tablePanel = new TablePanel(tableColumnName, null);
        this.panel.add((Component)this.tablePanel.getPanel(), "Center");
        this.selectNeBtn = new JButton();
        ScreenToolKit.setPreferredSizeofButtons((JButton[])new JButton[]{this.selectNeBtn}, (int)21);
        this.selectNeBtn.setMargin(new Insets(0, 2, 0, 2));
        this.selectNeBtn.setName("selectBtn");
        this.selectNeBtn.setMnemonic('S');
        this.selectNeBtn.setText(ResCenter.getInstance().getString("button_select"));
        if (null != selectActionListener) {
            this.selectNeBtn.addActionListener(selectActionListener);
        } else {
            this.selectNeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (null == NESelectTablePanel.this.dlg) {
                        NESelectTablePanel.this.dlg = new MultiSelectDomainDlg(parentWindow, null, panelType);
                    } else {
                        String[] neList = new String[NESelectTablePanel.this.neSelectedList.size()];
                        int count = 0;
                        for (NeLicenseBaseInfo neNode : NESelectTablePanel.this.neSelectedList) {
                            neList[count] = "";
                            neList[count] = neNode.getFdn();
                            ++count;
                        }
                        NESelectTablePanel.this.dlg = new MultiSelectDomainDlg(parentWindow, neList, panelType);
                    }
                    try {
                        this.addNEFDN();
                    }
                    catch (Exception e1) {
                        LicDebugTracer.trace("NELicenseInfo:" + e1);
                        LicDebugTracer.trace(e1);
                    }
                }

                private void addNEFDN() throws Exception {
                    if (NESelectTablePanel.this.dlg.getStatus()) {
                        NESelectTablePanel.this.tableNeIDList.clear();
                        NESelectTablePanel.this.neSelectedList = NESelectTablePanel.this.dlg.getSelectedNes();
                        int iArrSize = NESelectTablePanel.this.neSelectedList.size();
                        int devMostNum = this.getNelicTaskSelectDevicesMostNum();
                        if (devMostNum != -1 && iArrSize > devMostNum) {
                            StringBuffer strErrorMsg = new StringBuffer(ResCenter.getInstance().getString("DEV_NUMBER_LESS_THAN_MOST"));
                            strErrorMsg.append(' ');
                            strErrorMsg.append(devMostNum);
                            strErrorMsg.append('.');
                            OptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (Object)strErrorMsg);
                            return;
                        }
                        NESelectTablePanel.this.setSelectedNes(NESelectTablePanel.this.neSelectedList);
                        for (NeLicenseBaseInfo info : NESelectTablePanel.this.neSelectedList) {
                            NESelectTablePanel.this.tableNeIDList.add(info.getFdn());
                            LicDebugTracer.trace("NELicenseInfo:dn:" + info.getFdn());
                        }
                    }
                }

                private int getNelicTaskSelectDevicesMostNum() {
                    int mostNum = -1;
                    int DEFAULT_DEVICE_SIZE = 1000;
                    String number = ResCenter.getInstance().getString("NELIC_Task_Devices_Most_Number");
                    if (!number.equals("NELIC_Task_Devices_Most_Number")) {
                        try {
                            mostNum = Integer.parseInt(number);
                        }
                        catch (NumberFormatException nfe) {
                            mostNum = 1000;
                        }
                    }
                    return mostNum;
                }
            });
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 4, 4));
        buttonPanel.add(this.selectNeBtn);
        this.panel.add((Component)buttonPanel, "South");
    }

    public NESelectTablePanel(Window parentWindow, ActionListener selectActionListener) {
        this(parentWindow, selectActionListener, -1);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public ArrayList<String> getTableNEIDList() {
        return this.tableNeIDList;
    }

    public List<NeLicenseBaseInfo> getSelectedNeList() {
        return this.neSelectedList;
    }

    public Vector<Vector<Object>> getTableData() {
        Vector<Vector<Object>> data = this.tablePanel.getTableData();
        return data;
    }

    public void setTableData(Object[][] data) {
        this.tablePanel.setTableData(data);
    }

    public static void main(String[] args) {
        Dialog dlg = new Dialog(FrameworkUtilities.getMainFrame(), "NESelectTablePanel Test", true);
        ScreenToolKit.centerLocateToScreen((Component)dlg);
        dlg.setSize(300, 300);
        class SelectActionListener
        implements ActionListener {
            private Dialog dlg = null;

            public SelectActionListener(Dialog dlg) {
                this.dlg = dlg;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                new SingleSelectDomainDlg();
            }
        }
        NESelectTablePanel panel = new NESelectTablePanel(dlg, new SelectActionListener(dlg));
        dlg.add(panel.getPanel());
        dlg.setVisible(true);
    }

    public void setSelectedNes(List<NeLicenseBaseInfo> neSelectedList) throws Exception {
        this.selectedNeArray = new String[neSelectedList.size()];
        Object[][] data = new Object[neSelectedList.size()][];
        for (int i = 0; i < data.length; ++i) {
            this.selectedNeArray[i] = neSelectedList.get(i).getFdn();
            data[i] = new Object[3];
            data[i][0] = neSelectedList.get(i).getLabel();
            data[i][1] = neSelectedList.get(i).getVersion();
            data[i][2] = GuiUtil.getLicenseStatus(neSelectedList.get(i).getStatus());
        }
        this.tablePanel.setTableData(data);
    }

    public Map<String, NeLicenseBaseInfo> getNeLicenseBaseInfos() {
        HashMap<String, NeLicenseBaseInfo> oNeLicInfoMap = new HashMap<String, NeLicenseBaseInfo>();
        for (NeLicenseBaseInfo oNeLicInfo : this.neSelectedList) {
            oNeLicInfoMap.put(oNeLicInfo.getFdn(), oNeLicInfo);
        }
        return oNeLicInfoMap;
    }

    public static void setBaseWindow(Window _parentWindow) {
        parentWindow = _parentWindow;
    }
}

