/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.panel;

import com.huawei.dc.adapter.swimap.iview.framework.util.DCFrameworkUtilities;
import com.huawei.dc.adapter.swimap.iview.util.DCDebugTracer;
import com.huawei.dc.adapter.swimap.iview.util.DCFileChooserFilter;
import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.dc.adapter.swimap.iview.util.DCSaveFileChooser;
import com.huawei.u2000.nelicense.common.ASNInvoker;
import com.huawei.u2000.nelicense.common.Constants;
import com.huawei.u2000.nelicense.common.ExportNeLicInfoMgr;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.RightManager;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicPairData;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskEventDataMapRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskEventDataRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicenseItemInfo;
import com.huawei.u2000.nelicense.common.commmanager.StandAloneCommManager;
import com.huawei.u2000.nelicense.common.controller.LicAsynDetailController;
import com.huawei.u2000.nelicense.common.controller.LicOperationManager;
import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.common.interfaces.IASNMessageListener;
import com.huawei.u2000.nelicense.common.interfaces.IObjectDeallocator;
import com.huawei.u2000.nelicense.common.interfaces.MessageEvent;
import com.huawei.u2000.nelicense.common.licdetailsinfo.LicExportTask;
import com.huawei.u2000.nelicense.common.licdetailsinfo.NeRequestExport;
import com.huawei.u2000.nelicense.event.handlers.ExportInfoEventHandler;
import com.huawei.u2000.nelicense.gui.dlg.ExportNEApplyInfoDlg;
import com.huawei.u2000.nelicense.gui.dlg.SynchronESNDlg;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.gui.treetable.LicenseTaskModel;
import com.huawei.u2000.nelicense.gui.treetable.TaskProcess;
import com.huawei.u2000.nelicense.gui.treetable.TreeTable;
import com.huawei.u2000.nelicense.gui.wizard.SecondStepPanel;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.model.NeLicenseDetailInfo;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.model.NeLicenseTaskDetail;
import com.huawei.u2000.nelicense.model.NeLicenseTaskItemInfo;
import com.huawei.u2000.nelicense.model.NeLicenseTaskProcess;
import com.huawei.u2000.nelicense.model.TreeTableNode;
import com.huawei.u2000.nelicense.util.FileOpenChooserUtil;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import com.swimap.iview.templates.filtertreetable.TreeIconRenderer;
import com.swimap.iview.templates.wizard.WizardStyleInformation;
import com.swimap.iview.templates.wizard.WizardTemplate;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.commustru.fstru.FStruct;

public class LicenseTaskPanel
extends JPanel
implements IASNMessageListener,
IObjectDeallocator {
    private static final long serialVersionUID = 1L;
    private JScrollPane panel = null;
    private LicenseTaskModel model = null;
    private TreeTable stateTable = new TreeTable(this);
    private JTextArea descriptionTextArea = new JTextArea();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JButton loadButton = new JButton(ResCenter.getInstance().getString("loadButton"));
    private JButton disButton = new JButton(ResCenter.getInstance().getString("disButton"));
    private JButton synButton = new JButton(ResCenter.getInstance().getString("synButton"));
    private JButton adjButton = new JButton(ResCenter.getInstance().getString("adjButton"));
    private JButton expButton = new JButton(ResCenter.getInstance().getString("expButton"));
    private JButton delButton = new JButton(ResCenter.getInstance().getString("delButton"));
    private JButton refreshButton = new JButton(ResCenter.getInstance().getString("refreshButton"));
    private JMenuItem delRecordMenu = new JMenuItem(ResCenter.getInstance().getString("delRecord"));
    private JMenuItem forceActionMenu = new JMenuItem(ResCenter.getInstance().getString("forceAction"));
    private JMenuItem redoMenu = new JMenuItem(ResCenter.getInstance().getString("redo"));
    private JMenuItem exportResultMenu = new JMenuItem(ResCenter.getInstance().getString("exportResult"));
    private String detailDes = ResCenter.getInstance().getString("detailDes");
    private JSplitPane frameSplitPane;
    private static LicenseTaskPanel instance;
    private JPopupMenu popupMenu = null;
    private SortButtonRenderer headRenderer = new SortButtonRenderer();
    private int oldSelectedRowIndex = -1;
    private Set<NeLicenseTask> cacheTaskSet = null;
    private List<NeLicenseTaskProcess> m_taskProList = new ArrayList<NeLicenseTaskProcess>();
    private boolean isAscent = true;
    private int currentColumnIndex = 0;
    private List<NeRequestExport> m_exportList = new ArrayList<NeRequestExport>();
    private String m_actionType = "";
    private boolean m_delState = true;
    private boolean m_exportState = true;
    private boolean m_redoState = true;
    private boolean m_forcState = true;
    private boolean isFinishSend = true;
    private static final String missNEName = "<error>";
    private static boolean bSyncFinish;
    private LicAsynDetailController m_oAsyDetailCtr;
    private Map<Integer, TaskStatus> taskCompleteStatusMap = new HashMap<Integer, TaskStatus>();
    private transient ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            LicenseTaskPanel.this.m_actionType = event.getActionCommand();
            if (event.getActionCommand().equals(LicenseTaskPanel.this.loadButton.getText())) {
                LicenseTaskPanel.this.addTask();
                LicenseTaskPanel.this.initData(true);
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.disButton.getText())) {
                LicenseTaskPanel.this.isFinishSend = false;
                String message = ResCenter.getInstance().getString("abate_License");
                String title = ResCenter.getInstance().getString("confirm");
                int result = OptionPane.showExtConfirmDialog((Component)DCFrameworkUtilities.getMainFrame(), (Object)message, (String)title, (int)0, (int)3);
                if (result == 0) {
                    LicenseTaskPanel.this.exportTaskResult(2);
                }
                LicenseTaskPanel.this.isFinishSend = true;
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.synButton.getText())) {
                SynchronESNDlg oSynchronESNDlg = new SynchronESNDlg();
                if (!oSynchronESNDlg.bCancel) {
                    LicenseTaskPanel.this.initData(true);
                }
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.adjButton.getText())) {
                String message = ResCenter.getInstance().getString("adjust_License_capability");
                String title = ResCenter.getInstance().getString("confirm");
                int result = DCOptionPane.showExtConfirmDialog((Component)DCFrameworkUtilities.getMainFrame(), (String)message, (String)title, (int)0, (int)3);
                if (result == 0) {
                    LicenseTaskPanel.this.exportTaskResult(1);
                }
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.expButton.getText())) {
                LicenseTaskPanel.this.exportTaskResult(0);
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.delButton.getText())) {
                LicenseTaskPanel.this.delSelectedTask();
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.refreshButton.getText())) {
                LicenseTaskPanel.this.initData(true);
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.delRecordMenu.getText())) {
                LicenseTaskPanel.this.delSelectedTask();
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.forceActionMenu.getText())) {
                LicenseTaskPanel.this.forceExeTask();
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.redoMenu.getText())) {
                LicenseTaskPanel.this.redoAction();
            } else if (event.getActionCommand().equals(LicenseTaskPanel.this.exportResultMenu.getText())) {
                LicenseTaskPanel.this.exportAction();
            }
        }
    };
    private File choiceFile = null;

    public String getActionType() {
        return this.m_actionType;
    }

    public void removeExportTask(int taskID) {
        if (this.m_exportList == null || this.m_exportList.size() == 0) {
            return;
        }
        for (NeRequestExport export : this.m_exportList) {
            if (export.getTaskId() != taskID) continue;
            this.m_exportList.remove(export);
            break;
        }
    }

    public List<NeRequestExport> getExportList() {
        return this.m_exportList;
    }

    private LicenseTaskPanel() {
        if (!StandAloneCommManager.getIsStandAlone()) {
            this.setButtonEnableByRight();
        }
        this.init();
        this.currentColumnIndex = 0;
        this.setSortColumn();
        this.m_oAsyDetailCtr = LicAsynDetailController.getInstance();
        this.m_oAsyDetailCtr.addAsynMessageListener(this);
    }

    public static LicenseTaskPanel getInstance() {
        if (null == instance) {
            instance = new LicenseTaskPanel();
        }
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    private void setButtonEnableByRight() {
        this.loadButton.setEnabled(RightManager.hasUpdateNeLicenseRight());
        this.disButton.setEnabled(RightManager.hasCancleNeLicenseRight());
        this.delButton.setEnabled(RightManager.hasDeleteNeLicenseTaskRight());
        this.synButton.setEnabled(RightManager.hasSynNeInfoRight());
        this.adjButton.setEnabled(RightManager.hasAdjustNeLicenseRight());
        this.expButton.setEnabled(RightManager.hasOutputNeInfoRight());
        this.delRecordMenu.setEnabled(RightManager.hasDeleteNeLicenseTaskRight());
    }

    private void init() {
        this.model = new LicenseTaskModel();
        this.stateTable.setTreeTableModel(this.model);
        this.stateTable.getTableHeader().setReorderingAllowed(false);
        this.stateTable.getTableHeader().addMouseListener(new TreeTableHeaderMouseListener(this.headRenderer));
        this.stateTable.setTreeIconRenderer(new TreeIconRenderer(){

            public Icon getNodeIcon(TreeModel treemodel, Object node, Object value, Class object_class, boolean is_leaf, boolean is_expanded, Icon plaf_icon) {
                return null;
            }
        });
        this.stateTable.setShowsRootHandles(true);
        TableColumnModel columnModel = this.stateTable.getColumnModel();
        for (int i = columnModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn tableColumn = columnModel.getColumn(i);
            if (tableColumn == null) continue;
            tableColumn.setHeaderRenderer((TableCellRenderer)this.headRenderer);
        }
        this.panel = new JScrollPane((Component)((Object)this.stateTable));
        this.stateTableAddMouseListener();
        this.initStateTable();
        this.stateTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (e.getKeyCode() == 65 && e.isControlDown()) {
                    JTable _table = (JTable)e.getSource();
                    LicenseTaskPanel.this.handleTableSelection(_table);
                    LicenseTaskPanel.this.setMenuState();
                    LicenseTaskPanel.this.refreshDetail();
                }
            }
        });
        JScrollPane deatilPanel = new JScrollPane();
        deatilPanel.setBorder(BorderFactory.createEtchedBorder());
        deatilPanel.getViewport().add(this.descriptionTextArea);
        this.tabbedPane.addTab(this.detailDes, deatilPanel);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.setLayout(new BorderLayout());
        this.frameSplitPane = new JSplitPane(0, false);
        this.add((Component)this.frameSplitPane, "Center");
        this.frameSplitPane.setTopComponent(this.panel);
        this.frameSplitPane.setBottomComponent(this.tabbedPane);
        this.add((Component)this.getBtnPanel(), "South");
        this.frameSplitPane.setDividerLocation(0.8);
        this.frameSplitPane.setOneTouchExpandable(true);
        this.initData(false);
        this.initListener();
        this.initPopupMenu();
        this.stateTable.setRootVisible(false);
        this.delButton.setEnabled(this.stateTable.getSelectedRowCount() > 0);
        this.setMinimumSize(Constants.Component.ComponentSize.NELICENSE_RIGHT_FRAME_MIN_SIZE);
    }

    private void initStateTable() {
        ListSelectionModel listSelectionModel = this.stateTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LicenseTaskPanel.this.refreshDetail();
            }
        });
    }

    private void stateTableAddMouseListener() {
        this.stateTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseSelectedAction(e);
                LicenseTaskPanel.this.setMenuState();
                LicenseTaskPanel.this.refreshDetail();
                LicenseTaskPanel.this.showPopupMenu(e);
            }

            private void mouseSelectedAction(MouseEvent e) {
                JTable _table = (JTable)e.getSource();
                int selectIndex = _table.rowAtPoint(e.getPoint());
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (selectIndex != -1) {
                        this.retainRightClickSelection(_table, selectIndex);
                    }
                } else {
                    LicenseTaskPanel.this.handleTableSelection(_table);
                }
            }

            private void retainRightClickSelection(JTable _table, int selectIndex) {
                if (this.isSelectedRowClicked(_table, selectIndex)) {
                    int[] selectedRows;
                    for (int i : selectedRows = _table.getSelectedRows()) {
                        LicenseTaskPanel.this.stateTable.getSelectionModel().addSelectionInterval(i, i);
                    }
                } else {
                    LicenseTaskPanel.this.stateTable.setRowSelectionInterval(selectIndex, selectIndex);
                }
            }

            private boolean isSelectedRowClicked(JTable table, int selectIndex) {
                int[] selectedRows;
                for (int i : selectedRows = table.getSelectedRows()) {
                    if (selectIndex != i) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private void handleTableSelection(JTable _table) {
        int selectedRowCount = _table.getSelectedRowCount();
        if (selectedRowCount == 0) {
            return;
        }
        if (selectedRowCount == 1) {
            this.oldSelectedRowIndex = _table.getSelectedRow();
            return;
        }
        int rowCount = _table.getRowCount();
        if (this.oldSelectedRowIndex >= 0 && this.oldSelectedRowIndex < rowCount) {
            int[] selectedRows;
            int[] count = new int[selectedRowCount];
            int flag = 0;
            TreePath oldSelectedPath = this.stateTable.getPathForRow(this.oldSelectedRowIndex);
            TreePath oldSelectedParentPath = oldSelectedPath.getParentPath();
            for (int selectRowIndex : selectedRows = _table.getSelectedRows()) {
                TreePath selectedPath = this.stateTable.getPathForRow(selectRowIndex);
                TreePath selectedParentPath = selectedPath.getParentPath();
                if ((selectedParentPath == null || oldSelectedParentPath == null || !selectedParentPath.equals(oldSelectedParentPath)) && (selectedParentPath != null || oldSelectedParentPath != null)) continue;
                count[flag++] = selectRowIndex;
            }
            this.stateTable.clearSelection();
            for (int i = 0; i < flag; ++i) {
                int row = count[i];
                this.stateTable.addRowSelectionInterval(row, row);
            }
            if (flag == 0) {
                ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>();
                TreePath temp = null;
                for (int i = 0; i < selectedRows.length; ++i) {
                    TreePath thisParentPath = this.stateTable.getPathForRow(selectedRows[i]).getParentPath();
                    if (i == 0) {
                        temp = thisParentPath;
                    }
                    if (temp == null || !temp.equals(thisParentPath)) continue;
                    selectedPaths.add(this.stateTable.getPathForRow(selectedRows[i]));
                }
                this.stateTable.setSelectionPaths(selectedPaths.toArray(new TreePath[0]));
            }
        }
    }

    private JPanel getBtnPanel() {
        JPanel innPanel = new JPanel();
        innPanel.setLayout(new GridBagLayout());
        JPanel blankPanel = new JPanel();
        blankPanel.setSize(100, 20);
        this.loadButton.setName("LicenseTaskPanel_loadBtn");
        this.disButton.setName("LicenseTaskPanel_disBtn");
        this.synButton.setName("LicenseTaskPanel_disBtn");
        this.adjButton.setName("LicenseTaskPanel_adjBtn");
        this.expButton.setName("LicenseTaskPanel_expBtn");
        this.delButton.setName("LicenseTaskPanel_delBtn");
        this.refreshButton.setName("LicenseTaskPanel_refreshBtn");
        innPanel.add((Component)blankPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 12, 2, new Insets(8, 5, 0, 0), 0, 0));
        innPanel.add((Component)this.loadButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(8, 5, 0, 0), 0, 0));
        innPanel.add((Component)this.disButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(8, 5, 0, 0), 0, 0));
        innPanel.add((Component)this.synButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(8, 5, 0, 0), 0, 0));
        innPanel.add((Component)this.adjButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(8, 5, 0, 0), 0, 0));
        innPanel.add((Component)this.expButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(8, 5, 0, 0), 0, 0));
        JPanel innPanel1 = new JPanel();
        innPanel1.setLayout(new FlowLayout(2, 4, 0));
        innPanel1.add(this.delButton);
        innPanel1.add(this.refreshButton);
        this.setButtonSize(this.loadButton, "loadButton");
        this.setButtonSize(this.disButton, "disButton");
        this.setButtonSize(this.synButton, "synButton");
        this.setButtonSize(this.adjButton, "adjButton");
        this.setButtonSize(this.expButton, "expButton");
        this.setButtonSize(this.delButton, "delButton");
        this.setButtonSize(this.refreshButton, "refreshButton");
        this.loadButton.setMnemonic('o');
        this.disButton.setMnemonic('n');
        this.synButton.setMnemonic('s');
        this.adjButton.setMnemonic('j');
        this.expButton.setMnemonic('e');
        this.delButton.setMnemonic('d');
        this.refreshButton.setMnemonic('r');
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)innPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 12, 12, 0), 0, 0));
        mainPanel.add((Component)innPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 12, 12, 0), 0, 0));
        return mainPanel;
    }

    private void initListener() {
        this.loadButton.addActionListener(this.listener);
        this.disButton.addActionListener(this.listener);
        this.synButton.addActionListener(this.listener);
        this.adjButton.addActionListener(this.listener);
        this.expButton.addActionListener(this.listener);
        this.delButton.addActionListener(this.listener);
        this.refreshButton.addActionListener(this.listener);
        this.delRecordMenu.addActionListener(this.listener);
        this.exportResultMenu.addActionListener(this.listener);
        this.redoMenu.addActionListener(this.listener);
        this.forceActionMenu.addActionListener(this.listener);
    }

    public void removeListener() {
        this.loadButton.removeActionListener(this.listener);
        this.disButton.removeActionListener(this.listener);
        this.synButton.removeActionListener(this.listener);
        this.adjButton.removeActionListener(this.listener);
        this.expButton.removeActionListener(this.listener);
        this.delButton.removeActionListener(this.listener);
        this.refreshButton.removeActionListener(this.listener);
    }

    private void setButtonSize(JButton button, String buttonName) {
        Dimension size = new Dimension(button.getPreferredSize().width, 21);
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setSize(size);
        button.setPreferredSize(size);
        button.setMaximumSize(size);
        button.setMinimumSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData(boolean bSync) {
        Set<NeLicenseTask> neLicenseTaskList = null;
        try {
            neLicenseTaskList = LicOperationManager.getInstance().getAllNeLicenseTaskFromServer();
            LicDebugTracer.trace("[NELIC] LicenseTaskPanel#initData Start " + bSync + " neLicenseTaskList.size:" + neLicenseTaskList.size());
            if (bSync && bSyncFinish) {
                bSyncFinish = false;
                int iTimeOut = neLicenseTaskList.size() / 5000 + 2;
                iTimeOut = iTimeOut > 30 ? 30 : iTimeOut;
                LicenseTaskPanel licenseTaskPanel = this;
                synchronized (licenseTaskPanel) {
                    try {
                        this.wait(iTimeOut * 1000);
                    }
                    catch (InterruptedException e) {
                        DCDebugTracer.trace((InterruptedException)e);
                    }
                }
            }
            bSyncFinish = true;
        }
        catch (Exception e) {
            GuiUtil.handleException(e);
        }
        LicDebugTracer.trace("[NELIC] LicenseTaskPanel#initData End");
    }

    public synchronized void initData(Set<NeLicenseTask> neLicenseTaskList) {
        try {
            if (null != neLicenseTaskList) {
                LicDebugTracer.trace("[NELIC] LicenseTaskPanel#initData size:" + neLicenseTaskList.size());
                this.cacheTaskSet = neLicenseTaskList;
            }
            TaskProcess.getInstance().init();
        }
        catch (Exception e) {
            GuiUtil.handleException(e);
        }
        if (null != neLicenseTaskList) {
            this.model.clear();
            this.model.addTaskData(neLicenseTaskList);
        }
        this.sortColumn(this.currentColumnIndex);
        this.model.fireTableUpdate();
        this.delButton.setEnabled(this.stateTable.getSelectedRowCount() > 0);
        try {
            this.wait(300L);
        }
        catch (Exception e) {
            LicDebugTracer.trace(e);
        }
        this.notifyALL();
    }

    private void reinitData() {
        Set<NeLicenseTask> neLicenseTaskList = null;
        try {
            neLicenseTaskList = LicOperationManager.getInstance().getNeLicenseTask();
            this.initData(neLicenseTaskList);
        }
        catch (Exception e) {
            GuiUtil.handleException(e);
        }
    }

    private final void openLoadDlg() {
        WizardStyleInformation wizardStyleInformation = new WizardStyleInformation();
        try {
            String[] stepClassNames = new String[]{"com.huawei.u2000.nelicense.gui.wizard.FirstStepPanel", "com.huawei.u2000.nelicense.gui.wizard.SecondStepPanel"};
            wizardStyleInformation.setSteps(stepClassNames);
            WizardTemplate wizardTemplate = new WizardTemplate(DCFrameworkUtilities.getMainFrame());
            wizardTemplate.setInformation(wizardStyleInformation);
            wizardTemplate.setTitle(ResCenter.getInstance().getString("loadlicense"));
            wizardTemplate.setSize(600, 450);
            wizardTemplate.setDefaultCloseOperation(0);
            Component[] comp = wizardTemplate.getRootPane().getLayeredPane().getComponents();
            if (comp.length == 1 && comp[0] instanceof JPanel) {
                JPanel panel = (JPanel)comp[0];
                this.removeHelpButton(wizardTemplate, panel);
            }
            SecondStepPanel.setBaseWindow((Window)wizardTemplate);
            ScreenToolKit.centerLocateToScreen((Component)wizardTemplate);
            GuiUtil.enableHelpKey(wizardTemplate.getRootPane(), "iVIEW.LTELIC.LoadLicenseDlg");
            wizardTemplate.setModal(true);
            wizardTemplate.setVisible(true);
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo: class <" + this.getClass() + "> occur exception when open load DLG: " + e);
        }
    }

    private void removeHelpButton(WizardTemplate wizardTemplate, JPanel panel) {
        Component[] subComp = panel.getComponents();
        for (int i = 0; i < subComp.length; ++i) {
            if (subComp[i] instanceof JButton && "WizardTemplate_helpButton".equals(((JButton)subComp[i]).getName())) {
                ((JButton)subComp[i]).setVisible(false);
                return;
            }
            if (!(subComp[i] instanceof JPanel)) continue;
            this.removeHelpButton(wizardTemplate, (JPanel)subComp[i]);
        }
    }

    private void addTask() {
        this.openLoadDlg();
    }

    private void delSelectedTask() {
        int error;
        block5: {
            TreePath[] delPaths = this.stateTable.getSelectionPaths();
            error = -1;
            int[] delTaskIds = new int[delPaths.length];
            int i = 0;
            for (TreePath path : delPaths) {
                int taskId;
                delTaskIds[i] = taskId = ((TreeTableNode)path.getLastPathComponent()).getNodeContent().getTaskId();
                ++i;
            }
            try {
                error = LicOperationManager.getInstance().deleteTask(delTaskIds);
            }
            catch (Exception e) {
                if (!GuiUtil.handleException(e)) break block5;
                return;
            }
        }
        if (error != 0) {
            DCOptionPane.showErrorDialog((Component)this, (String)"operation failed !");
        } else {
            this.initData(true);
        }
        this.delButton.setEnabled(this.stateTable.getSelectedRowCount() > 0);
    }

    public void updateTaskState(NeLicenseTask task) {
        this.model.updateNodeState(task);
        this.model.fireTableUpdate();
    }

    private void refreshDetail() {
        if (this.stateTable.getSelectedRowCount() > 1) {
            this.descriptionTextArea.setText("");
        } else {
            TreePath path = this.stateTable.getSelectionPath();
            if (path == null) {
                this.descriptionTextArea.setText("");
            } else {
                TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
                if (node != null) {
                    this.descriptionTextArea.setText(node.getNodeContent().getDetail());
                }
            }
        }
    }

    private void showPopupMenu(MouseEvent e) {
        if (this.popupMenu != null && SwingUtilities.isRightMouseButton(e) && this.popupMenu.getComponentCount() > 0) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void initPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.delRecordMenu);
            this.popupMenu.add(this.forceActionMenu);
            this.popupMenu.add(this.redoMenu);
            this.popupMenu.add(this.exportResultMenu);
        }
    }

    private void setMenuState() {
        TreePath[] paths = null;
        try {
            paths = this.stateTable.getSelectionPaths();
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo: class <" + this.getClass() + "> occur exception when get selected paths: " + e);
        }
        if (paths == null) {
            this.m_delState = false;
            this.m_exportState = false;
            this.m_redoState = false;
            this.m_forcState = false;
        } else {
            this.m_delState = true;
            this.m_exportState = true;
            this.m_redoState = true;
            this.m_forcState = true;
            if (paths.length > 1) {
                this.m_exportState = false;
            }
            TreeTableNode parentNode = null;
            for (TreePath path : paths) {
                TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
                if (node == null) continue;
                if (parentNode == null && node.isLeaf()) {
                    parentNode = (TreeTableNode)node.getParent();
                }
                if (node.isLeaf()) {
                    this.m_delState = false;
                }
                if (node.isLeaf() || node.getNodeContent().getState() != 0 || node.getNodeContent().getType() == 2 || node.getNodeContent().getType() == 4) {
                    this.m_exportState = false;
                }
                this.setRedoForceState(parentNode, node);
            }
        }
        boolean hasSelectedRows = this.stateTable.getSelectedRows().length > 0;
        this.delRecordMenu.setEnabled(this.m_delState && hasSelectedRows && RightManager.hasDeleteNeLicenseTaskRight());
        this.delButton.setEnabled(this.m_delState && hasSelectedRows && RightManager.hasDeleteNeLicenseTaskRight());
        this.exportResultMenu.setEnabled(this.m_exportState);
        this.forceActionMenu.setEnabled(this.m_forcState && RightManager.hasUpdateNeLicenseRight());
        this.redoMenu.setEnabled(this.m_redoState);
    }

    private void setRedoForceState(TreeTableNode parentNode, TreeTableNode node) {
        if (!node.isLeaf()) {
            this.dealNodeNotLeaf(node);
        } else {
            int parentId = ((TreeTableNode)node.getParent()).getNodeContent().getTaskId();
            if (parentNode.getNodeContent().getTaskId() != parentId) {
                this.m_redoState = false;
                this.m_forcState = false;
            }
            if (node.getNodeContent().getState() != 2) {
                this.m_redoState = false;
            }
            if (node.getNodeContent().getState() == 5 && node.getNodeContent().getType() == 4) {
                LicDebugTracer.trace("LicenseTaskPanel#setRedoForceState is doing");
            } else {
                this.m_forcState = false;
            }
            this.setLeafNodeState(node);
        }
    }

    private void setLeafNodeState(TreeTableNode node) {
        if (node.getNodeContent().getType() == 4) {
            if (!RightManager.hasUpdateNeLicenseRight()) {
                this.m_redoState = false;
            }
        } else if (node.getNodeContent().getType() == 2) {
            if (!RightManager.hasSynNeInfoRight()) {
                this.m_redoState = false;
            }
        } else if (node.getNodeContent().getType() == 3) {
            if (!RightManager.hasCancleNeLicenseRight()) {
                this.m_redoState = false;
            }
        } else if (node.getNodeContent().getType() == 0) {
            if (!RightManager.hasOutputNeInfoRight()) {
                this.m_redoState = false;
            }
        } else if (node.getNodeContent().getType() == 1 && !RightManager.hasAdjustNeLicenseRight()) {
            this.m_redoState = false;
        }
    }

    private void dealNodeNotLeaf(TreeTableNode node) {
        this.m_redoState = false;
        this.m_forcState = false;
        if (TaskProcess.getInstance().getCompletePercent(node.getNodeContent().getTaskId()).equals("100%")) {
            if (node.getNodeContent().getType() != 2 && node.getNodeContent().getType() != 4) {
                LicDebugTracer.trace("LicenseTaskPanel#dealNodeNotLeaf finished");
            }
        } else {
            this.m_delState = false;
            this.m_exportState = false;
        }
    }

    private void redoAction() {
        int[] subTaskIds = this.getSelectedSubTaskId();
        if (subTaskIds.length > 0) {
            int error;
            block4: {
                this.removeSubTaskFromMap(subTaskIds);
                error = -1;
                try {
                    error = LicOperationManager.getInstance().retryTask(subTaskIds);
                }
                catch (Exception e) {
                    if (!GuiUtil.handleException(e)) break block4;
                    return;
                }
            }
            if (error != 0) {
                DCOptionPane.showErrorDialog((Component)this, (String)"operation failed !");
            }
        }
    }

    private void forceExeTask() {
        int[] subTaskIds = this.getSelectedSubTaskId();
        if (subTaskIds.length > 0) {
            int error;
            block5: {
                error = -1;
                try {
                    error = LicOperationManager.getInstance().forceExeTask(subTaskIds);
                }
                catch (Exception e) {
                    if (!GuiUtil.handleException(e)) break block5;
                    return;
                }
            }
            if (error != 0) {
                DCOptionPane.showErrorDialog((Component)this, (String)"operation failed !");
            } else {
                this.removeSubTaskFromMap(subTaskIds);
            }
        }
    }

    private void removeSubTaskFromMap(int[] subTaskIds) {
        Map<Integer, List<Integer>> taskAndSubTaskIdMap = ExportInfoEventHandler.getInstance().getTaskAndSubTaskIdMap();
        Collection<List<Integer>> values = taskAndSubTaskIdMap.values();
        Integer subTaskId = -1;
        for (List<Integer> list : values) {
            for (int i = 0; i < subTaskIds.length; ++i) {
                subTaskId = subTaskIds[i];
                if (!list.contains(subTaskId)) continue;
                list.remove(subTaskId);
            }
        }
    }

    private int[] getSelectedSubTaskId() {
        TreePath[] paths = this.stateTable.getSelectionPaths();
        if (paths == null || paths.length < 1) {
            return new int[0];
        }
        int taskId = this.getTaskIdBySubTaskNode(paths[0]);
        if (this.getTaskTypeBySubTaskNode(paths[0]) == 1 || this.getTaskTypeBySubTaskNode(paths[0]) == 0 || this.getTaskTypeBySubTaskNode(paths[0]) == 3) {
            String saveFilePath = this.getSaveFilePath();
            if (null == saveFilePath || saveFilePath.isEmpty()) {
                LicDebugTracer.trace("NELicenseInfo: class <" + this.getClass() + ">: No select file for save.");
                return new int[0];
            }
            ExportNeLicInfoMgr.getInstance().addExprotFile(taskId, saveFilePath);
        }
        int[] subTaskIds = new int[paths.length];
        int i = 0;
        for (TreePath path : paths) {
            NeLicenseTask nodeContent = ((TreeTableNode)path.getLastPathComponent()).getNodeContent();
            nodeContent.setState(-1);
            subTaskIds[i] = nodeContent.getSubTaskId();
            ++i;
        }
        TaskProcess.getInstance().decrease(taskId, subTaskIds.length);
        this.model.fireTableUpdate();
        return subTaskIds;
    }

    private int getTaskIdBySubTaskNode(TreePath path) {
        return ((TreeTableNode)path.getLastPathComponent()).getNodeContent().getTaskId();
    }

    private int getTaskTypeBySubTaskNode(TreePath path) {
        return ((TreeTableNode)path.getLastPathComponent()).getNodeContent().getType();
    }

    private String getSaveFilePath() {
        try {
            String currentDirectoryPath = "";
            if (4 == ((TreeTableNode)this.stateTable.getSelectionPaths()[0].getLastPathComponent()).getNodeContent().getType()) {
                int[] types = new int[]{1, 5, 6};
                currentDirectoryPath = FileOpenChooserUtil.showFileOpenChooser(types, this.choiceFile == null ? null : this.choiceFile.getParent());
                this.choiceFile = new File(currentDirectoryPath);
            } else {
                boolean isSuccess;
                String strPath = System.getProperty("user.dir") + System.getProperty("file.separator") + "report/";
                File fileDoc = new File(strPath);
                if (!fileDoc.exists() && !(isSuccess = fileDoc.mkdir())) {
                    LicDebugTracer.trace("LicenseTaskPanel::getSaveFilePath::mkdir failed!");
                    return null;
                }
                DCSaveFileChooser chooser = new DCSaveFileChooser(strPath, true);
                chooser.setAcceptAllFileFilterUsed(false);
                DCFileChooserFilter xml = new DCFileChooserFilter("xml", ResCenter.getInstance().getString("filefilter_xml"));
                chooser.addChoosableFileFilter((FileFilter)xml);
                chooser.showSaveDialog((Component)DCFrameworkUtilities.getMainFrame());
                currentDirectoryPath = chooser.getSelectFilePath();
                if (currentDirectoryPath.lastIndexOf(".xml") < 0) {
                    currentDirectoryPath = currentDirectoryPath + ".xml";
                }
            }
            return currentDirectoryPath;
        }
        catch (Exception e) {
            return "";
        }
    }

    private void exportAction() {
        TreePath selPaths = this.stateTable.getSelectionPath();
        int taskId = ((TreeTableNode)selPaths.getLastPathComponent()).getNodeContent().getTaskId();
        FileChooser chooser = new FileChooser();
        chooser.setFileFilter(new String[]{"xml"}, new String[]{ResCenter.getInstance().getString("filefilter_xml")});
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.showOpenDialog((Component)DCFrameworkUtilities.getMainFrame());
        String selectFilePath = chooser.getSelectFilePath();
        if (selectFilePath.lastIndexOf(".xml") < 0) {
            selectFilePath = selectFilePath + ".xml";
        }
        ExportNeLicInfoMgr.getInstance().addExprotFile(taskId, selectFilePath);
        ExportInfoEventHandler.getInstance().export(taskId);
    }

    private void setSortColumn() {
        this.headRenderer.setPressedColumn(this.currentColumnIndex);
        this.headRenderer.setSelectedColumn(this.currentColumnIndex);
        this.isAscent = true;
        if (1 == this.headRenderer.getState(this.currentColumnIndex)) {
            this.isAscent = false;
        }
        this.stateTable.sort(this.currentColumnIndex);
        this.model.fireTableUpdate();
    }

    public void sortColumn(final int index) {
        if (null == this.cacheTaskSet) {
            return;
        }
        List<NeLicenseTask> list = this.toList(this.cacheTaskSet);
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                NeLicenseTask v1 = (NeLicenseTask)o1;
                NeLicenseTask v2 = (NeLicenseTask)o2;
                Object temp1 = v1.getColumnData(index);
                Object temp2 = v2.getColumnData(index);
                int reValue = 0;
                reValue = temp1 instanceof Integer && temp2 instanceof Integer ? ((Integer)temp1).compareTo((Integer)temp2) : (temp1 instanceof Float && temp2 instanceof Float ? ((Float)temp1).compareTo((Float)temp2) : Collator.getInstance().compare(temp1.toString(), temp2.toString()));
                if (index != 0 && reValue == 0) {
                    reValue = ((Integer)v1.getColumnData(0)).compareTo((Integer)v2.getColumnData(0));
                }
                return LicenseTaskPanel.this.isAscent ? reValue : -reValue;
            }
        });
        this.model.clear();
        this.model.addTaskData(list);
    }

    private List<NeLicenseTask> toList(Set<NeLicenseTask> set) {
        ArrayList<NeLicenseTask> list = new ArrayList<NeLicenseTask>();
        Iterator<NeLicenseTask> ite = set.iterator();
        while (ite.hasNext()) {
            list.add(ite.next());
        }
        return list;
    }

    private int getActualColumnIndex(String columnName) {
        String[] columnNames = this.model.getColumnName();
        for (int i = 0; i < columnNames.length; ++i) {
            if (!columnName.equals(columnNames[i])) continue;
            return i;
        }
        return -1;
    }

    public int getTaskType(int taskId) {
        return this.model.getTaskType(taskId);
    }

    public void refreshPanel() {
        this.model.clear();
        this.initData(true);
    }

    public NeLicenseTask getTaskInfo(int taskId) {
        return this.model.getTaskInfo(taskId);
    }

    public void refreshData(int taskId) {
        Set<NeLicenseTask> neLicenseTaskSet;
        block8: {
            neLicenseTaskSet = null;
            try {
                NeLicenseTask taskInfo = this.model.getTaskInfo(taskId);
                String taskDes = this.model.getTaskDes(taskInfo);
                TaskStatus taskStatus = this.taskCompleteStatusMap.get(taskId);
                if (taskStatus == null) {
                    taskStatus = new TaskStatus(taskId);
                    this.taskCompleteStatusMap.put(taskId, taskStatus);
                }
                if ("100%".equals(taskDes) && taskStatus.isComplete()) {
                    LicDebugTracer.trace("Task ID : " + taskId + " : Return event due to 100%.");
                    return;
                }
                if ("100%".equals(taskDes)) {
                    LicDebugTracer.trace("NELicenseInfo:Task ID : " + taskId + ":  Proceed with 100%. Set the task as " + "complete and refresh the table for the last time for this task. ");
                    taskStatus.setComplete(true);
                }
                neLicenseTaskSet = ASNInvoker.getInstance().getNeLicenseTask();
                TaskProcess.getInstance().init();
            }
            catch (Exception e) {
                if (GuiUtil.handleException(e)) break block8;
                LicDebugTracer.trace("NELicenseInfo: class <" + this.getClass() + "> occur exception when refresh datas: " + e);
            }
        }
        if (null != neLicenseTaskSet) {
            for (NeLicenseTask task : neLicenseTaskSet) {
                if (task.getTaskId() != taskId) continue;
                this.model.setTaskInfo(task, this.currentColumnIndex, this.isAscent);
                this.cacheTaskSet.remove(task);
                this.cacheTaskSet.add(task);
                this.model.fireTableUpdate();
            }
        }
        if (TaskProcess.getInstance().getCompletePercent(taskId).equals("100%")) {
            this.model.getTaskInfo(taskId).setState(0);
        }
        this.model.fireTableUpdate();
    }

    @Override
    public void notifyMessage(MessageEvent event) {
        if (event != null) {
            this.dealNETaskMessage(event);
        }
    }

    private void dealNETaskMessage(MessageEvent event) {
        int iErrCode = 0;
        FStruct oAsn = event.getData();
        switch (event.getCmdCode()) {
            case 99820259: {
                if (oAsn instanceof AsnNeLicTaskEventDataMapRsp) {
                    AsnNeLicTaskEventDataMapRsp oAsnDataMapRsp = (AsnNeLicTaskEventDataMapRsp)oAsn;
                    iErrCode = oAsnDataMapRsp.iErrCode.intValue();
                    String curFDN = new String(oAsnDataMapRsp.strFdn);
                    int iTaskID = oAsnDataMapRsp.iTaskID.intValue();
                    this.dealDataMapErrorInfo(iErrCode, oAsnDataMapRsp, curFDN, iTaskID);
                    LicOperationManager.getInstance().updateLicenseTask(oAsnDataMapRsp);
                }
                this.reinitData();
                QueryLicensePanel.getInstance().refresh();
                break;
            }
            case 99820256: {
                if (oAsn instanceof AsnNeLicTaskEventDataRsp) {
                    AsnNeLicTaskEventDataRsp oNeDataRsp = (AsnNeLicTaskEventDataRsp)oAsn;
                    this.dealTaskEventErrorInfo(oNeDataRsp);
                    LicOperationManager.getInstance().updateLicenseTask(oNeDataRsp);
                }
                this.reinitData();
                break;
            }
            case 99820258: {
                this.initData(true);
                break;
            }
        }
    }

    private void dealTaskEventErrorInfo(AsnNeLicTaskEventDataRsp oNeDataRsp) {
        int iErrCode = oNeDataRsp.iErrCode.intValue();
        int iTaskID = oNeDataRsp.iTaskID.intValue();
        String curFDN = new String(oNeDataRsp.strFdn);
        String strErr = new String(oNeDataRsp.strErr);
        String curNename = "";
        int taskType = oNeDataRsp.iTaskType.intValue();
        if (3 == taskType) {
            while (!this.isFinishSend) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    LicDebugTracer.trace(e);
                }
            }
        }
        if (0 != iErrCode) {
            int detailID = QueryLicensePanel.getInstance().getTaskID();
            LicDebugTracer.trace("NELicenseInfo:NE license file task fail, task ID:" + iTaskID + ", ErrorCode:" + iErrCode);
            this.dealErrorInfoFromTaskType(iTaskID, curFDN, strErr, taskType, detailID);
            if (taskType == 4) {
                this.getTaskProcess(iTaskID, taskType, true);
            }
        } else {
            this.getTaskProcess(iTaskID, taskType, false);
            if (4 == taskType) {
                curNename = this.getNeName(iTaskID, curFDN);
                if (missNEName.equals(curNename)) {
                    LicDebugTracer.trace("NELicenseInfo:Not find the NE name when upload NE license file, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:" + strErr);
                    return;
                }
                LicDebugTracer.trace("NELicenseInfo:Upload NE license file success, task ID:" + iTaskID + ", FDN:" + curFDN);
            }
        }
    }

    private void getTaskProcess(int iTaskID, int taskType, boolean isFailNE) {
        boolean isNewTask = true;
        String message = ResCenter.getInstance().getMergeString("exetasksucceeded", new String[]{String.valueOf(iTaskID), Constants.TaskType.taskTypeName.get(taskType)});
        if (isFailNE) {
            message = ResCenter.getInstance().getMergeString("exetaskfailured", new String[]{String.valueOf(iTaskID), Constants.TaskType.taskTypeName.get(taskType)});
        }
        for (NeLicenseTaskProcess oTaskProcess : this.m_taskProList) {
            int iProTaskID = oTaskProcess.getTaskID();
            int iCurCount = oTaskProcess.getNECurCount();
            int iFailCount = oTaskProcess.getNEFailCount();
            if (iProTaskID != iTaskID) continue;
            oTaskProcess.setNECurCount(iCurCount + 1);
            if (isFailNE) {
                oTaskProcess.setNEFailCount(iFailCount + 1);
            }
            if (oTaskProcess.getNECurCount() == oTaskProcess.getNECount()) {
                if (oTaskProcess.getNEFailCount() > 0) {
                    message = ResCenter.getInstance().getMergeString("exetaskfailured", new String[]{String.valueOf(iTaskID), Constants.TaskType.taskTypeName.get(taskType)});
                }
                GuiUtil.showBubble(message);
                this.m_taskProList.remove(oTaskProcess);
                return;
            }
            isNewTask = false;
            break;
        }
        if (isNewTask) {
            int iTaskNECount = 0;
            Set<NeLicenseTask> oNeLicTaskSet = LicOperationManager.getInstance().getNeLicenseTask();
            for (NeLicenseTask oTask : oNeLicTaskSet) {
                if (iTaskID != oTask.getTaskId()) continue;
                ++iTaskNECount;
            }
            if (1 == iTaskNECount) {
                GuiUtil.showBubble(message);
                return;
            }
            NeLicenseTaskProcess oTaskProcess = new NeLicenseTaskProcess(iTaskID, iTaskNECount, isFailNE);
            this.m_taskProList.add(oTaskProcess);
        }
    }

    private void dealDataMapErrorInfo(int iErrCode, AsnNeLicTaskEventDataMapRsp oAsnDataMapRsp, String curFDN, int iTaskID) {
        if (0 == iErrCode) {
            HashMap<String, String> detailMap = new HashMap<String, String>();
            for (Object detailObj : oAsnDataMapRsp.oAsnNeLicPairDataLst) {
                if (!(detailObj instanceof AsnNeLicPairData)) continue;
                AsnNeLicPairData oAsnPair = (AsnNeLicPairData)detailObj;
                String detailKey = new String(oAsnPair.strKey);
                String detailValue = new String(oAsnPair.strValue);
                if (detailKey.equals("Esn") && detailValue.equals("")) {
                    detailValue = new String(oAsnDataMapRsp.strEsn);
                }
                detailMap.put(detailKey, detailValue);
            }
            NeLicenseTaskDetail neTaskDetail = this.getNETaskDetail(oAsnDataMapRsp, curFDN, iTaskID, detailMap);
            for (NeRequestExport task : this.m_exportList) {
                if (task.getTaskId() != iTaskID) continue;
                task.addExportData(neTaskDetail);
            }
        } else {
            LicDebugTracer.trace("NELicenseInfo:Export NE task information failure, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:Error_Code_" + iErrCode);
        }
    }

    private void dealErrorInfoFromTaskType(int iTaskID, String curFDN, String strErr, int taskType, int detailID) {
        block0 : switch (taskType) {
            case 0: 
            case 1: 
            case 3: {
                HashMap<String, String> detailMap = new HashMap<String, String>();
                ArrayList<NeLicenseTaskItemInfo> resItemList = new ArrayList<NeLicenseTaskItemInfo>();
                ArrayList<NeLicenseTaskItemInfo> funItemList = new ArrayList<NeLicenseTaskItemInfo>();
                NeLicenseTaskDetail neTaskDetail = new NeLicenseTaskDetail(curFDN, iTaskID, detailMap);
                neTaskDetail.setResItemInfo(resItemList);
                neTaskDetail.setFunItemInfo(funItemList);
                for (NeRequestExport task : LicenseTaskPanel.getInstance().getExportList()) {
                    if (task.getTaskId() != iTaskID) continue;
                    task.addExportData(neTaskDetail);
                    LicDebugTracer.trace("NELicenseInfo:Export NE task information failure, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:" + strErr);
                    break block0;
                }
                break;
            }
            case 5: {
                ArrayList<String> oDetailHead = new ArrayList<String>();
                ArrayList<String[]> oDetailDatas = new ArrayList<String[]>();
                NeLicenseDetailInfo curNeDetailInfo = new NeLicenseDetailInfo(oDetailHead, oDetailDatas, curFDN);
                if (0 != detailID && iTaskID == detailID) {
                    QueryLicensePanel.getInstance().addDetailTable(curNeDetailInfo, iTaskID);
                    LicDebugTracer.trace("NELicenseInfo:Query NE license Details failure, task ID:" + iTaskID + ", cause:" + strErr);
                    break;
                }
                this.addExportDataInfo(iTaskID, curFDN, strErr, curNeDetailInfo);
                break;
            }
            case 4: {
                String curNename = this.getNeName(iTaskID, curFDN);
                if (missNEName.equals(curNename)) {
                    LicDebugTracer.trace("NELicenseInfo:Not find the NE name when upload NE license file, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:" + strErr);
                    return;
                }
                LicDebugTracer.trace("NELicenseInfo:Upload NE license file failure, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:" + strErr);
                break;
            }
        }
    }

    private void addExportDataInfo(int iTaskID, String curFDN, String strErr, NeLicenseDetailInfo curNeDetailInfo) {
        for (LicExportTask task : QueryLicensePanel.getInstance().getListTask()) {
            if (task.getTaskId() != iTaskID) continue;
            task.addExportData(curNeDetailInfo);
            LicDebugTracer.trace("NELicenseInfo:Export NE license detail failure, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:" + strErr);
            break;
        }
    }

    private NeLicenseTaskDetail getNETaskDetail(AsnNeLicTaskEventDataMapRsp oAsnDataMapRsp, String curFDN, int iTaskID, Map<String, String> detailMap) {
        NeLicenseTaskItemInfo itemInfo;
        String attribValue;
        String attribKey;
        AsnNeLicPairData oAsnPair;
        int itemValue;
        String itemKey;
        AsnNeLicenseItemInfo oAsnItemInfo;
        ArrayList<NeLicenseTaskItemInfo> resItemList = new ArrayList<NeLicenseTaskItemInfo>();
        ArrayList<NeLicenseTaskItemInfo> funItemList = new ArrayList<NeLicenseTaskItemInfo>();
        HashMap<String, String> itemMap = new HashMap<String, String>();
        for (Object resObj : oAsnDataMapRsp.oAsnNeLicenseItemInfoRes) {
            if (!(resObj instanceof AsnNeLicenseItemInfo)) continue;
            oAsnItemInfo = (AsnNeLicenseItemInfo)resObj;
            itemKey = new String(oAsnItemInfo.strKey);
            itemValue = oAsnItemInfo.iValue.intValue();
            itemMap = new HashMap();
            for (Object obj : oAsnItemInfo.oAsnNeLicPairDataLst) {
                if (!(obj instanceof AsnNeLicPairData)) continue;
                oAsnPair = (AsnNeLicPairData)obj;
                attribKey = new String(oAsnPair.strKey);
                attribValue = new String(oAsnPair.strValue);
                itemMap.put(attribKey, attribValue);
            }
            itemInfo = new NeLicenseTaskItemInfo(itemKey, itemValue, itemMap);
            resItemList.add(itemInfo);
        }
        for (Object funObj : oAsnDataMapRsp.oAsnNeLicenseItemInfoFunc) {
            if (!(funObj instanceof AsnNeLicenseItemInfo)) continue;
            oAsnItemInfo = (AsnNeLicenseItemInfo)funObj;
            itemKey = new String(oAsnItemInfo.strKey);
            itemValue = oAsnItemInfo.iValue.intValue();
            itemMap = new HashMap();
            for (Object obj : oAsnItemInfo.oAsnNeLicPairDataLst) {
                if (!(obj instanceof AsnNeLicPairData)) continue;
                oAsnPair = (AsnNeLicPairData)obj;
                attribKey = new String(oAsnPair.strKey);
                attribValue = new String(oAsnPair.strValue);
                itemMap.put(attribKey, attribValue);
            }
            itemInfo = new NeLicenseTaskItemInfo(itemKey, itemValue, itemMap);
            funItemList.add(itemInfo);
        }
        NeLicenseTaskDetail neTaskDetail = new NeLicenseTaskDetail(curFDN, iTaskID, detailMap);
        neTaskDetail.setResItemInfo(resItemList);
        neTaskDetail.setFunItemInfo(funItemList);
        if (null != oAsnDataMapRsp.strEsn) {
            String esn = new String(oAsnDataMapRsp.strEsn);
            neTaskDetail.setEsn(esn);
        }
        return neTaskDetail;
    }

    private String getNeName(int iTaskID, String curFDN) {
        NeLicenseBaseInfo[] allNEInfo;
        String curNename = missNEName;
        for (NeLicenseBaseInfo oBaseInfo : allNEInfo = NeLicenseInfoManager.getInstance().getAllNeLicenseInfo()) {
            String taskFDN = oBaseInfo.getFdn();
            if (!taskFDN.equals(curFDN)) continue;
            curNename = oBaseInfo.getLabel();
            break;
        }
        return curNename;
    }

    @Override
    public void release() {
        this.m_oAsyDetailCtr.removeAsynMessageListener(this);
    }

    private void exportTaskResult(int taskType) {
        ExportNEApplyInfoDlg dlg = new ExportNEApplyInfoDlg(taskType);
        boolean isExportNelic = dlg.getIsExportNelic();
        if (dlg.m_isConfirm) {
            this.initData(true);
            String path = dlg.getFilePath();
            int taskID = dlg.getTaskID();
            NeRequestExport export = new NeRequestExport(path, taskID);
            export.startTask();
            this.m_exportList.add(export);
            if (isExportNelic) {
                int result;
                block5: {
                    result = 0;
                    try {
                        result = LicOperationManager.getInstance().notifyServerToExportNelic(taskID);
                    }
                    catch (Exception e1) {
                        if (!GuiUtil.handleException(e1)) break block5;
                        return;
                    }
                }
                if (result != 0) {
                    OptionPane.showMessageDialog((Component)this, (Object)ResCenter.getInstance().getString("exportinfotask_failure"));
                }
            }
        }
    }

    public void notifyALL() {
        this.notifyAll();
    }

    static {
        bSyncFinish = true;
    }

    class TaskStatus {
        private boolean isComplete = false;
        private int taskID = -1;

        TaskStatus(int taskId) {
            this.taskID = taskId;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public void setComplete(boolean isComplete) {
            this.isComplete = isComplete;
        }
    }

    private class TreeTableHeaderMouseListener
    extends MouseAdapter {
        private SortButtonRenderer headRenderer = null;

        TreeTableHeaderMouseListener(SortButtonRenderer _headRenderer) {
            this.headRenderer = _headRenderer;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                int columnIndex = LicenseTaskPanel.this.stateTable.columnAtPoint(e.getPoint());
                TableColumnModel tableColumnModel = LicenseTaskPanel.this.stateTable.getColumnModel();
                String columnName = (String)tableColumnModel.getColumn(columnIndex).getHeaderValue();
                LicenseTaskPanel.this.currentColumnIndex = LicenseTaskPanel.this.getActualColumnIndex(columnName);
                LicenseTaskPanel.this.setSortColumn();
            }
        }
    }
}

