/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.panel;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.gui.dlg.search.FindDialog;
import com.huawei.u2000.nelicense.gui.dlg.search.NETreeFindCommand;
import com.huawei.u2000.nelicense.gui.netree.NETree;
import com.huawei.u2000.nelicense.gui.toolbar.LittleToolbar;
import com.huawei.u2000.nelicense.gui.toolbar.ToolBarAction;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.huawei.u2000.nelicense.util.NETreeUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionListener;

public class ForSelectTreePanel {
    private static IviewLogger log = IviewLogger.getLogger(ForSelectTreePanel.class);
    private JPanel panel = null;
    private JLabel filterLabel = null;
    private JComboBox filterComboBox = null;
    private LittleToolbar toolbar = null;
    private NETree m_oNETree = null;
    private Vector<String> m_oFdnVector;
    private Window parentWindow;

    private void setComboBoxSize(JComboBox box, int windth, int height) {
        box.setPreferredSize(new Dimension(windth, height));
        box.setMaximumSize(new Dimension(windth, height));
        box.setMinimumSize(new Dimension(windth, height));
    }

    public NETree getNETree() {
        return this.m_oNETree;
    }

    public void setFDNVector(Vector<String> selectedVector) {
        this.m_oFdnVector = selectedVector;
    }

    private JPanel getFilterPanel(boolean onlyToolBar) {
        this.filterLabel = new JLabel();
        this.filterLabel.setName("filterLabel");
        this.filterLabel.setText(ResCenter.getInstance().getString("selectversion"));
        this.filterComboBox = new JComboBox();
        this.setComboBoxSize(this.filterComboBox, 200, 21);
        this.filterComboBox.setName("filterComboBox");
        this.filterComboBox.setRenderer(new MyCellRenderer());
        String[] versions = new String[]{};
        try {
            versions = NeLicenseInfoManager.getInstance().getAllVersion();
        }
        catch (Exception e1) {
            GuiUtil.handleException(e1);
        }
        this.filterComboBox.addItem(ResCenter.getInstance().getString("All_Version"));
        if (null != versions) {
            for (int i = 0; i < versions.length; ++i) {
                this.filterComboBox.addItem(versions[i]);
            }
        }
        this.filterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForSelectTreePanel.this.refreshPageTree();
            }
        });
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridBagLayout());
        leftPanel.add((Component)this.filterLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.filterComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        if (onlyToolBar) {
            this.filterLabel.setVisible(false);
            this.filterComboBox.setVisible(false);
        }
        this.toolbar = new LittleToolbar();
        this.setupToolbar();
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new FlowLayout(0));
        rightPanel.add(this.toolbar);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)leftPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)rightPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public ForSelectTreePanel(Window parentWindow, int width, int height, boolean onlyToolBar, int pageTreeType) {
        this.parentWindow = parentWindow;
        this.panel = new JPanel();
        if (width > 0 && height > 0) {
            this.panel.setPreferredSize(new Dimension(width, height));
            this.panel.setMinimumSize(new Dimension(width, height));
        }
        this.panel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), ResCenter.getInstance().getString(onlyToolBar ? "selectedne" : "selectablene")));
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.getFilterPanel(onlyToolBar), "North");
        try {
            this.m_oNETree = this.createPageTree(pageTreeType, "");
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        this.m_oNETree.setName("nelic_ForSelectTreePanel_PageTree");
        this.panel.add((Component)this.m_oNETree, "Center");
    }

    public void setTreeSelectionListener(TreeSelectionListener l) {
        this.m_oNETree.addTreeSelectionListener(l);
    }

    public ForSelectTreePanel(Window parentWindow, int width, int height, boolean onlyToolBar, int pageTreeType, String[] selectedNeArray) {
        this.parentWindow = parentWindow;
        this.panel = new JPanel();
        if (width > 0 && height > 0) {
            this.panel.setPreferredSize(new Dimension(width, height));
            this.panel.setMinimumSize(new Dimension(width, height));
        }
        this.panel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), ResCenter.getInstance().getString(onlyToolBar ? "selectedne" : "selectablene")));
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.getFilterPanel(onlyToolBar), "North");
        this.m_oNETree = this.createPageTree(pageTreeType, this.getVersion(), selectedNeArray);
        this.m_oNETree.setName("nelic_ForSelectTreePanel_PageTree");
        this.panel.add((Component)this.m_oNETree, "Center");
        if (pageTreeType == 1) {
            this.m_oFdnVector = new Vector();
            for (String strVersion : selectedNeArray) {
                this.m_oFdnVector.add(strVersion);
            }
        }
    }

    public String getVersion() {
        String toString = this.filterComboBox.getSelectedItem().toString();
        if (ResCenter.getInstance().getString("All_Version").equals(toString)) {
            return "allversion";
        }
        return toString;
    }

    public void refreshPageTree(String version, String[] selectedNeArray) {
        NETreeUtil.updateNETree(version, selectedNeArray, true, this.m_oNETree);
    }

    private void refreshPageTree() {
        String[] strFDNs = new String[]{};
        boolean isContain = true;
        if (null != this.m_oFdnVector && this.m_oFdnVector.size() > 0) {
            strFDNs = this.m_oFdnVector.toArray(new String[0]);
            isContain = false;
        }
        NETreeUtil.updateNETree(this.getVersion(), strFDNs, isContain, this.m_oNETree);
    }

    private NETree createPageTree(int type, String version, String[] selectedNeArray) {
        boolean isContain = true;
        if (type == 2) {
            if (null == selectedNeArray || 0 == selectedNeArray.length) {
                isContain = false;
            }
        } else if (null != selectedNeArray && 0 < selectedNeArray.length) {
            isContain = false;
        }
        NETree tree = NETreeUtil.createNETree(version, selectedNeArray, isContain);
        return tree;
    }

    private NETree createPageTree(int type, String version) {
        boolean isContain = true;
        if (type == 2) {
            isContain = false;
        }
        NETree tree = NETreeUtil.createNETree(version, null, isContain);
        return tree;
    }

    private void setupToolbar() {
        this.toolbar.removeAll();
        this.addToolbar(this.toolbar, this.getFindActionToolBar(), true);
        this.toolbar.updateUI();
    }

    private void addToolbar(LittleToolbar _toolbar, ToolBarAction action, boolean isAdd) {
        if (isAdd) {
            _toolbar.addAction(action);
        }
    }

    private ToolBarAction getFindActionToolBar() {
        ToolBarAction findAction = new ToolBarAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog fd = new FindDialog(ForSelectTreePanel.this.parentWindow, ResCenter.getInstance().getString("OBJECT_FIND"), true, null);
                NETreeFindCommand cmd = new NETreeFindCommand(ForSelectTreePanel.this.m_oNETree);
                fd.setFindCommand(cmd);
                fd.setVisible(true);
                fd.dispose();
            }
        };
        findAction.setIcon(ResCenter.getInstance().getIMageIcon("icons/search.gif"));
        findAction.setTooltip(ResCenter.getInstance().getString("Search"));
        return findAction;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setTreeName(String name) {
        this.m_oNETree.setName(name);
        this.m_oNETree.getTree().setName("JTree_" + name);
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setToolTipText(value.toString());
            this.setBackground(isSelected ? Color.blue : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }
}

