/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.panel;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileSelectPanel {
    private JPanel panel = new JPanel();
    private JLabel label = null;
    private JTextField text = null;
    private JButton selectBtn = null;

    public FileSelectPanel(final Component parent) {
        Box box = Box.createHorizontalBox();
        this.label = new JLabel();
        this.label.setName("Export_File_Label");
        this.label.setText(ResCenter.getInstance().getString("label_expertfile"));
        box.add(this.label);
        box.add(Box.createRigidArea(new Dimension(8, 30)));
        this.text = new JTextField();
        this.text.setName("Export_File_Text");
        this.text.setMinimumSize(new Dimension(200, 21));
        this.text.setPreferredSize(new Dimension(350, 21));
        this.text.setMaximumSize(new Dimension(2000, 21));
        this.text.setEditable(false);
        box.add(this.text);
        this.selectBtn = new JButton();
        this.selectBtn.setName("Download_PathSettingPanel_SelectBtn");
        this.selectBtn.setPreferredSize(new Dimension(21, 21));
        this.selectBtn.setMaximumSize(new Dimension(21, 21));
        this.selectBtn.setMinimumSize(new Dimension(21, 21));
        this.selectBtn.setText(ResCenter.getInstance().getString("button_choiceexportfile"));
        this.selectBtn.setToolTipText(ResCenter.getInstance().getString("noselectedfile"));
        this.selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean fileDir;
                String strPath = System.getProperty("user.dir") + System.getProperty("file.separator") + "report/";
                File fileDoc = new File(strPath);
                if (!fileDoc.exists() && !(fileDir = fileDoc.mkdir())) {
                    LicDebugTracer.trace("FileSelectPanel#FileSelectPanel fail to make directory");
                }
                SaveFileChooser chooser = new SaveFileChooser(strPath, true);
                chooser.setAcceptAllFileFilterUsed(false);
                FileChooserFilter xml = new FileChooserFilter("xml", ResCenter.getInstance().getString("filefilter_xml"));
                chooser.addChoosableFileFilter((FileFilter)xml);
                if (chooser.showSaveDialog(parent) != 0) {
                    return;
                }
                String savePath = chooser.getSelectedFile().getPath();
                String newfilterStr = "." + ((FileChooserFilter)chooser.getFileFilter()).getAllFilters().get(0).toString();
                if (savePath.lastIndexOf(".") == -1) {
                    savePath = savePath + newfilterStr;
                } else {
                    String oldFilterStr = savePath.substring(savePath.lastIndexOf("."), savePath.length()).toLowerCase();
                    if (!oldFilterStr.equals(newfilterStr)) {
                        savePath = savePath + newfilterStr;
                    }
                }
                FileSelectPanel.this.text.setText(savePath);
            }
        });
        box.add(this.selectBtn);
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)box, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 3), 0, 0));
    }

    public Component getPanel() {
        return this.panel;
    }

    public static void main(String[] args) {
        Dialog dlg = new Dialog(FrameworkUtilities.getMainFrame(), "FileSelectPanel Test", true);
        ScreenToolKit.centerLocateToScreen((Component)dlg);
        dlg.setSize(400, 55);
        FileSelectPanel panel = new FileSelectPanel(FrameworkUtilities.getMainFrame());
        dlg.add(panel.getPanel());
        dlg.setVisible(true);
    }

    public String getFilePath() {
        return this.text.getText();
    }
}

