/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.dlg.search;

import com.huawei.u2000.nelicense.gui.dlg.search.FindCommand;
import com.huawei.u2000.nelicense.gui.dlg.search.SearchUtil;
import com.huawei.u2000.nelicense.gui.netree.NETree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class NETreeFindCommand
implements FindCommand {
    private NETree m_oTree;

    public NETreeFindCommand(NETree oTree) {
        this.m_oTree = oTree;
    }

    @Override
    public void findNext(String findText, int searchDir, boolean matchWholeWord, boolean matchCase) {
        if (null != this.m_oTree) {
            DefaultMutableTreeNode oCurrentNode = this.getCurrentNode();
            DefaultMutableTreeNode oNode = this.findNextNode(oCurrentNode, findText, searchDir, matchWholeWord, matchCase);
            if (null == oNode) {
                String strNodeName = oCurrentNode.getUserObject().toString();
                if (this.isMatch(findText, strNodeName, matchWholeWord, matchCase)) {
                    SearchUtil.showActionDialog(findText, true);
                } else {
                    SearchUtil.showActionDialog(findText, false);
                }
            } else {
                TreePath oPath = new TreePath(oNode.getPath());
                this.m_oTree.getTree().scrollPathToVisible(oPath);
                this.m_oTree.getTree().setSelectionPath(oPath);
            }
        }
    }

    private DefaultMutableTreeNode findNextNode(DefaultMutableTreeNode oCurrentNode, String findText, int searchDir, boolean matchWholeWord, boolean matchCase) {
        String strName;
        DefaultMutableTreeNode oNode = null;
        oNode = 1 == searchDir ? oCurrentNode.getPreviousNode() : oCurrentNode.getNextNode();
        while (!(null == oNode || oNode.isLeaf() && this.isMatch(findText, strName = oNode.getUserObject().toString(), matchWholeWord, matchCase))) {
            if (1 == searchDir) {
                oNode = oNode.getPreviousNode();
                continue;
            }
            oNode = oNode.getNextNode();
        }
        return oNode;
    }

    private boolean isMatch(String findText, String oNodeName, boolean matchWholeWord, boolean matchCase) {
        int index;
        return matchWholeWord && matchCase ? findText.equals(oNodeName) : (matchWholeWord ? findText.equalsIgnoreCase(oNodeName) : (matchCase ? 0 <= (index = oNodeName.indexOf(findText)) : 0 <= (index = oNodeName.toLowerCase().indexOf(findText.toLowerCase()))));
    }

    private DefaultMutableTreeNode getCurrentNode() {
        TreePath oPath = this.m_oTree.getTree().getSelectionPath();
        if (oPath == null) {
            return this.m_oTree.getRoot();
        }
        return (DefaultMutableTreeNode)oPath.getLastPathComponent();
    }
}

