/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.dlg.search;

import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.gui.dlg.search.FindCommand;
import com.huawei.u2000.nelicense.gui.dlg.search.InitializeSearchCondition;
import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class FindDialog
extends JDialog {
    private static final long serialVersionUID = -1415550688553934784L;
    private IviewLogger log = IviewLogger.getLogger(FindDialog.class);
    private JLabel textFieldLabel = new JLabel();
    private JTextField textField = new JTextField();
    private JButton findNextButton = new JButton();
    private JButton cancelButton = new JButton();
    private JCheckBox matchWholeCheckBox = new JCheckBox();
    private JCheckBox matchCaseCheckBox = new JCheckBox();
    private JRadioButton downRadioButton = new JRadioButton();
    private JRadioButton upRadioButton = new JRadioButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private TitledBorder border = new TitledBorder(BorderFactory.createEtchedBorder(), ResCenter.getInstance().getString("Direction"));
    private JPanel buttonGroupPanel = new JPanel();
    private FindCommand findCommand = null;
    private InitializeSearchCondition initSearchCondition = null;
    private Window parentWindow = null;
    private static final int BUTTON_PREFERRED_WIDTH = 90;
    private static final int BUTTON_PREFERRED_HEIGHT = 21;
    public static final int UP = 1;
    public static final int DOWN = 2;
    private String findLabelStr = null;

    public void clear() {
        this.parentWindow = null;
    }

    public FindDialog(Window parentWindow, String title, boolean modal, String _findLabelStr) {
        super(parentWindow, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setTitle(title);
        this.findLabelStr = _findLabelStr;
        this.parentWindow = parentWindow;
        try {
            this.jbInit();
            this.initTextFieldListener();
            this.initActionListener();
            this.pack();
        }
        catch (Exception e) {
            this.log.trace((Object)"Init FindDialog failed!", (Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        if (this.findLabelStr != null) {
            this.textFieldLabel.setText(this.findLabelStr);
        } else {
            this.textFieldLabel.setText(ResCenter.getInstance().getString("FindLabel"));
        }
        JPanel fieldPanel = this.buildFieldPanel();
        JPanel buttonPanel = this.buildButtonPanel();
        this.setFocusTraversalPolicy(new FindDialogFocusTraversalPolicy());
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)fieldPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)buttonPanel, new GridBagConstraints(1, 0, 1, 0, 0.0, 0.0, 17, 2, new Insets(0, 10, 40, 10), 0, 0));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        ScreenToolKit.setDefaultButtons((AbstractButton)this.findNextButton, (AbstractButton)this.cancelButton);
        ScreenToolKit.setPreferredSizeofButtons((JButton[])new JButton[]{this.findNextButton, this.cancelButton}, (int)21);
        ScreenToolKit.centerLocateToScreen((Component)this);
    }

    private JPanel buildButtonPanel() {
        this.findNextButton.setMaximumSize(new Dimension(90, 21));
        this.findNextButton.setMinimumSize(new Dimension(90, 21));
        this.findNextButton.setPreferredSize(new Dimension(90, 21));
        this.findNextButton.setActionCommand("findNext");
        this.findNextButton.setMargin(new Insets(2, 1, 2, 1));
        this.findNextButton.setText(ResCenter.getInstance().getString("FindNext"));
        this.findNextButton.setBounds(new Rectangle(320, 13, 90, 21));
        this.findNextButton.setEnabled(false);
        this.findNextButton.setMnemonic('f');
        this.findNextButton.setName("FindDialog_findNextButton");
        this.cancelButton.setBounds(new Rectangle(320, 62, 90, 21));
        this.cancelButton.setMaximumSize(new Dimension(90, 21));
        this.cancelButton.setMinimumSize(new Dimension(90, 21));
        this.cancelButton.setPreferredSize(new Dimension(90, 21));
        this.cancelButton.setMnemonic('0');
        this.cancelButton.setText(ResCenter.getInstance().getString("Cancel"));
        this.cancelButton.setName("FindDialog_cancelButton");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)this.findNextButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        return buttonPanel;
    }

    private JPanel buildFieldPanel() {
        this.textFieldLabel.setLabelFor(this.textField);
        this.textField.setMinimumSize(new Dimension(4, 21));
        this.textField.setPreferredSize(new Dimension(70, 21));
        this.textField.setText("");
        this.textField.setDocument((Document)new ValidCharDocument(255, null));
        this.matchWholeCheckBox.setText(ResCenter.getInstance().getString("Match_Whole"));
        this.matchWholeCheckBox.setMnemonic('m');
        this.matchWholeCheckBox.setName("FindDialog_matchWholeCheckBox");
        this.matchCaseCheckBox.setText(ResCenter.getInstance().getString("Match_Case"));
        this.matchCaseCheckBox.setMnemonic('c');
        this.matchCaseCheckBox.setName("FindDialog_matchCaseCheckBox");
        this.upRadioButton.setText(ResCenter.getInstance().getString("Up"));
        this.upRadioButton.setMnemonic('u');
        this.upRadioButton.setName("FindDialog_upRadioButton");
        this.downRadioButton.setText(ResCenter.getInstance().getString("Down"));
        this.downRadioButton.setSelected(true);
        this.downRadioButton.setMnemonic('d');
        this.downRadioButton.setName("FindDialog_downRadioButton");
        this.buttonGroup.add(this.upRadioButton);
        this.buttonGroup.add(this.downRadioButton);
        this.buttonGroupPanel.setLayout(new GridBagLayout());
        this.buttonGroupPanel.setPreferredSize(new Dimension(90, 76));
        this.buttonGroupPanel.setBorder(this.border);
        this.buttonGroupPanel.add((Component)this.upRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonGroupPanel.add((Component)this.downRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this.textFieldLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.textField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        fieldPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        fieldPanel.add((Component)this.matchWholeCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
        fieldPanel.add((Component)this.buttonGroupPanel, new GridBagConstraints(1, 1, 1, 2, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        fieldPanel.add((Component)this.matchCaseCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return fieldPanel;
    }

    private void initTextFieldListener() {
        this.textField.getDocument().addDocumentListener(new TextFieldDocumentListener());
    }

    private void initActionListener() {
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null != FindDialog.this.findCommand) {
                    FindDialog.this.findCommand.findNext(FindDialog.this.textField.getText(), FindDialog.this.getFindDirection(), FindDialog.this.matchWholeCheckBox.isSelected(), FindDialog.this.matchCaseCheckBox.isSelected());
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.dispose();
            }
        });
    }

    public void setInitSearchCondionListener(InitializeSearchCondition initSearchCondition) {
        this.initSearchCondition = initSearchCondition;
        this.addInitSearchCondionListener();
    }

    private void addInitSearchCondionListener() {
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FindDialog.this.initSearchCondition();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FindDialog.this.initSearchCondition();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FindDialog.this.initSearchCondition();
            }
        });
        this.matchCaseCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FindDialog.this.initSearchCondition();
            }
        });
        this.matchWholeCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FindDialog.this.initSearchCondition();
            }
        });
    }

    private void initSearchCondition() {
        if (null != this.initSearchCondition) {
            this.initSearchCondition.initSearchCondition();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setSize(new Dimension(422, 150));
            this.textField.requestFocus();
            this.textField.selectAll();
        }
        super.setVisible(b);
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    private void stateChanged() {
        String input = this.textField.getText();
        if (null == input || "".equals(input)) {
            this.findNextButton.setEnabled(false);
        } else {
            this.findNextButton.setEnabled(true);
        }
    }

    public JTextField getFindTextField() {
        return this.textField;
    }

    public void setTextField(String searchText) {
        this.textField.setText(searchText);
    }

    public boolean isMatchWholeSelected() {
        return this.matchWholeCheckBox.isSelected();
    }

    public boolean isMatchCaseSelected() {
        return this.matchCaseCheckBox.isSelected();
    }

    public int getFindDirection() {
        if (this.upRadioButton.isSelected()) {
            return 1;
        }
        return 2;
    }

    public FindCommand getFindCommand() {
        return this.findCommand;
    }

    public void setFindCommand(FindCommand findCommand) {
        this.findCommand = findCommand;
    }

    @Override
    public void dispose() {
        this.findCommand = null;
        super.dispose();
        this.clear();
    }

    private class FindDialogFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private FindDialogFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(FindDialog.this.textField)) {
                return FindDialog.this.matchWholeCheckBox;
            }
            if (aComponent.equals(FindDialog.this.matchWholeCheckBox)) {
                return FindDialog.this.matchCaseCheckBox;
            }
            if (aComponent.equals(FindDialog.this.matchCaseCheckBox)) {
                return FindDialog.this.upRadioButton;
            }
            if (aComponent.equals(FindDialog.this.upRadioButton)) {
                return FindDialog.this.downRadioButton;
            }
            if (aComponent.equals(FindDialog.this.downRadioButton)) {
                if (FindDialog.this.findNextButton.isEnabled()) {
                    return FindDialog.this.findNextButton;
                }
                return FindDialog.this.cancelButton;
            }
            if (aComponent.equals(FindDialog.this.findNextButton)) {
                return FindDialog.this.cancelButton;
            }
            return FindDialog.this.textField;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(FindDialog.this.textField)) {
                return FindDialog.this.cancelButton;
            }
            if (aComponent.equals(FindDialog.this.matchWholeCheckBox)) {
                return FindDialog.this.textField;
            }
            if (aComponent.equals(FindDialog.this.matchCaseCheckBox)) {
                return FindDialog.this.matchWholeCheckBox;
            }
            if (aComponent.equals(FindDialog.this.upRadioButton)) {
                return FindDialog.this.matchCaseCheckBox;
            }
            if (aComponent.equals(FindDialog.this.downRadioButton)) {
                return FindDialog.this.upRadioButton;
            }
            if (aComponent.equals(FindDialog.this.findNextButton)) {
                return FindDialog.this.downRadioButton;
            }
            if (FindDialog.this.findNextButton.isEnabled()) {
                return FindDialog.this.findNextButton;
            }
            return FindDialog.this.downRadioButton;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return FindDialog.this.textField;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return FindDialog.this.cancelButton;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return FindDialog.this.textField;
        }
    }

    private final class TextFieldDocumentListener
    implements DocumentListener {
        private TextFieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FindDialog.this.stateChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FindDialog.this.stateChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FindDialog.this.stateChanged();
        }
    }
}

