/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.dlg;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.gui.dlg.MultiSelectDomainDlg;
import com.huawei.u2000.nelicense.gui.netree.NETree;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.model.FilterCondition;
import com.huawei.u2000.nelicense.model.NETreeNodeInfo;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.model.SearchLicenseConditionBean;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.huawei.u2000.nelicense.util.NETreeUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SearchLicenseFilterDialog
extends JDialog {
    private static final long serialVersionUID = -3235862377933689160L;
    private IviewLogger log = IviewLogger.getLogger(SearchLicenseFilterDialog.class);
    private JCheckBox businessCheckBox;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JCheckBox debugCheckBox;
    private JPanel devicePanel;
    private NETree deviceTree;
    private long treeId;
    private JCheckBox exigencyCheckBox;
    private JButton okButton;
    private JCheckBox protectedCheckBox;
    private JButton selectButton;
    private JPanel statusPane;
    private JCheckBox validCheckBox;
    private JLabel versionLabel;
    private JComboBox versionComboBox;
    private SearchLicenseConditionBean conditionBean;
    private boolean isOK = false;
    private static final String LICENSE_STATUS_lABEL = ResCenter.getInstance().getString("License_Status_Label");
    private static final String BUSINESS_LABEL = ResCenter.getInstance().getString("commercialuse");
    private static final String DEBUG_LABEL = ResCenter.getInstance().getString("debugging");
    private static final String EXIGENCY_LABEL = ResCenter.getInstance().getString("critical");
    private static final String VALID_LABEL = ResCenter.getInstance().getString("novalidlicense");
    private static final String PROTECTED_LABEL = ResCenter.getInstance().getString("protected");
    private static final String VERSION_LABEL = ResCenter.getInstance().getString("selectversion");
    private static final String DEVICE_LABEL = ResCenter.getInstance().getString("Device_Label");
    private static final String SELECT_LABEL = ResCenter.getInstance().getString("button_select");
    private static final String OK_LABEL = ResCenter.getInstance().getString("dlgbutton_ok");
    private static final String CANCEL_LABEL = ResCenter.getInstance().getString("Cancel");
    private static final String TITLE = ResCenter.getInstance().getString("filter_dig_title");
    private static final String ALL_VERSION = ResCenter.getInstance().getString("All_Version");

    public SearchLicenseFilterDialog(FilterCondition filterCondition, boolean modal) {
        super(FrameworkUtilities.getMainFrame(), TITLE, true);
        if (null != filterCondition) {
            this.conditionBean = new SearchLicenseConditionBean();
            this.conditionBean.revivify(filterCondition);
        }
        this.initComponents();
        GuiUtil.enableHelpKey(this.getRootPane(), "iVIEW.LTELIC.SearchLicenseFilterDialog");
    }

    public boolean isOK() {
        return this.isOK;
    }

    public FilterCondition getCondition() {
        SearchLicenseConditionBean condition = new SearchLicenseConditionBean();
        condition.setNoValidLicenseFile(this.validCheckBox.isSelected());
        condition.setDebuged(this.debugCheckBox.isSelected());
        condition.setBusiness(this.businessCheckBox.isSelected());
        condition.setProtected(this.protectedCheckBox.isSelected());
        condition.setExigency(this.exigencyCheckBox.isSelected());
        String version = this.versionComboBox.getSelectedItem().toString();
        condition.setVersion(version.equals(ALL_VERSION) ? "" : version);
        condition.setTreeId(this.treeId);
        if (null != this.deviceTree) {
            DefaultMutableTreeNode oRoot = this.deviceTree.getRoot();
            Enumeration<TreeNode> enu = oRoot.breadthFirstEnumeration();
            StringBuilder fdnBuilder = new StringBuilder();
            while (enu.hasMoreElements()) {
                DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)enu.nextElement();
                Object oInfo = oNode.getUserObject();
                if (!oNode.isLeaf() || !(oInfo instanceof NETreeNodeInfo)) continue;
                NETreeNodeInfo oNodeInfo = (NETreeNodeInfo)oNode.getUserObject();
                fdnBuilder.append(oNodeInfo.getNeLicInfo().getFdn()).append("><");
            }
            if (fdnBuilder.length() > 0) {
                condition.setNeFdnArray(fdnBuilder.substring(0, fdnBuilder.length() - 2).split("><"));
            } else {
                condition.setNeFdnArray(new String[0]);
            }
        }
        return condition.transfer();
    }

    private void initComponents() {
        this.initNePageTree(this.conditionBean == null ? new String[]{} : this.conditionBean.getNeFdnArray());
        this.statusPane = new JPanel();
        this.businessCheckBox = new JCheckBox();
        this.debugCheckBox = new JCheckBox();
        this.exigencyCheckBox = new JCheckBox();
        this.validCheckBox = new JCheckBox();
        this.protectedCheckBox = new JCheckBox();
        this.versionLabel = new JLabel();
        this.versionComboBox = new JComboBox();
        this.versionComboBox.setRenderer(new MyCellRenderer());
        this.devicePanel = new JPanel();
        this.selectButton = new JButton();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SearchLicenseFilterDialog.this.formKeyPressed(evt);
            }
        });
        this.statusPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(LICENSE_STATUS_lABEL)));
        this.statusPane.setName("statusPane");
        this.statusPane.setLayout(new GridBagLayout());
        this.createCheckBoxOnPage();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.statusPane, gridBagConstraints);
        this.versionLabel.setText(VERSION_LABEL);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.getContentPane().add((Component)this.versionLabel, gridBagConstraints);
        this.versionComboBox.setName("SearchLicenseFilterDialog_versionComboBox");
        this.versionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ALL_VERSION}));
        this.getNELicVersion();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.getContentPane().add((Component)this.versionComboBox, gridBagConstraints);
        this.devicePanel.setBorder(BorderFactory.createTitledBorder(DEVICE_LABEL));
        this.devicePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 30;
        gridBagConstraints.ipady = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.deviceTree.setName("SearchLicenseFilterDialog_deviceTree");
        this.devicePanel.add((Component)this.deviceTree, gridBagConstraints);
        this.selectButton.setName("SearchLicenseFilterDialog_selectBtn");
        this.selectButton.setText(SELECT_LABEL);
        this.selectButton.setMinimumSize(new Dimension(80, 21));
        this.selectButton.setMnemonic('S');
        this.selectButton.setPreferredSize(new Dimension(80, 21));
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchLicenseFilterDialog.this.selectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.devicePanel.add((Component)this.selectButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.devicePanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okButton.setName("SearchLicenseFilterDialog_okBtn");
        this.okButton.setText(OK_LABEL);
        this.okButton.setMinimumSize(new Dimension(80, 21));
        this.okButton.setPreferredSize(new Dimension(80, 21));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchLicenseFilterDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setName("SearchLicenseFilterDialog_cancelBtn");
        this.cancelButton.setText(CANCEL_LABEL);
        this.cancelButton.setMinimumSize(new Dimension(80, 21));
        this.cancelButton.setPreferredSize(new Dimension(80, 21));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchLicenseFilterDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        if (null != this.conditionBean) {
            this.validCheckBox.setSelected(this.conditionBean.isNoValidLicenseFile());
            this.debugCheckBox.setSelected(this.conditionBean.isDebuged());
            this.businessCheckBox.setSelected(this.conditionBean.isBusiness());
            this.protectedCheckBox.setSelected(this.conditionBean.isProtected());
            this.exigencyCheckBox.setSelected(this.conditionBean.isExigency());
            this.versionComboBox.setSelectedItem(this.conditionBean.getVersion());
        }
        this.setPreferredSize(new Dimension(500, 540));
        ScreenToolKit.setDefaultButtons((AbstractButton)this.okButton, (AbstractButton)this.cancelButton);
        this.pack();
    }

    private void createCheckBoxOnPage() {
        this.businessCheckBox.setName("SearchLicenseFilterDialog_businessCBox");
        this.businessCheckBox.setText(BUSINESS_LABEL);
        this.businessCheckBox.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.statusPane.add((Component)this.businessCheckBox, gridBagConstraints);
        this.debugCheckBox.setName("SearchLicenseFilterDialog_debugCBox");
        this.debugCheckBox.setText(DEBUG_LABEL);
        this.debugCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.statusPane.add((Component)this.debugCheckBox, gridBagConstraints);
        this.exigencyCheckBox.setName("SearchLicenseFilterDialog_exigencyCBox");
        this.exigencyCheckBox.setText(EXIGENCY_LABEL);
        this.exigencyCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.statusPane.add((Component)this.exigencyCheckBox, gridBagConstraints);
        this.validCheckBox.setName("SearchLicenseFilterDialog_validCBox");
        this.validCheckBox.setText(VALID_LABEL);
        this.validCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        this.statusPane.add((Component)this.validCheckBox, gridBagConstraints);
        this.protectedCheckBox.setName("SearchLicenseFilterDialog_protectedCBox");
        this.protectedCheckBox.setText(PROTECTED_LABEL);
        this.protectedCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.statusPane.add((Component)this.protectedCheckBox, gridBagConstraints);
    }

    private void getNELicVersion() {
        block4: {
            try {
                String[] versions = NeLicenseInfoManager.getInstance().getAllVersion();
                if (null != versions) {
                    List<String> versionList = Arrays.asList(versions);
                    Collections.sort(versionList);
                    for (int i = 0; i < versionList.size(); ++i) {
                        this.versionComboBox.addItem(versionList.get(i));
                    }
                    String strVersion = QueryLicensePanel.getInstance().getFilterCondition().getVersion();
                    this.versionComboBox.setSelectedItem(strVersion);
                }
            }
            catch (Exception e) {
                if (GuiUtil.handleException(e)) break block4;
                this.log.error((Object)"getAllNeVersionInfo fail.", (Throwable)e);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.isEmptyCondition()) {
            DCOptionPane.showMessageDialog((Component)this, (String)ResCenter.getInstance().getString("errorMessageofFilter"));
            return;
        }
        this.isOK = true;
        QueryLicensePanel.getInstance().setFilterCondition(this.getCondition());
        this.dispose();
    }

    private boolean isEmptyCondition() {
        if (this.validCheckBox.isSelected()) {
            return false;
        }
        if (this.debugCheckBox.isSelected()) {
            return false;
        }
        if (this.businessCheckBox.isSelected()) {
            return false;
        }
        if (this.protectedCheckBox.isSelected()) {
            return false;
        }
        return !this.exigencyCheckBox.isSelected();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        String[] FDNArray = QueryLicensePanel.getInstance().getFilterCondition().getNeFdnArray();
        MultiSelectDomainDlg oDlg = null;
        oDlg = FDNArray.length > 0 ? new MultiSelectDomainDlg((Window)this, FDNArray, -1) : new MultiSelectDomainDlg((Window)this);
        if (null != oDlg && oDlg.getStatus()) {
            try {
                List<NeLicenseBaseInfo> oSelectedNeLicInfos = oDlg.getSelectedNes();
                int iSize = oSelectedNeLicInfos.size();
                String[] strFDNs = new String[iSize];
                for (int i = 0; i < iSize; ++i) {
                    strFDNs[i] = oSelectedNeLicInfos.get(i).getFdn();
                }
                boolean isContain = true;
                if (0 == strFDNs.length) {
                    isContain = false;
                }
                NETreeUtil.updateNETree("allversion", strFDNs, isContain, this.deviceTree);
            }
            catch (Exception e) {
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
        }
    }

    private void formKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.dispose();
        }
    }

    private void initNePageTree(String[] neFdnArray) {
        String[] FDNArray = QueryLicensePanel.getInstance().getFilterCondition().getNeFdnArray();
        boolean isContain = true;
        if (null == FDNArray || 0 == FDNArray.length) {
            isContain = false;
        }
        this.deviceTree = NETreeUtil.createNETree("", FDNArray, isContain);
        this.deviceTree.getAccessibleContext().setAccessibleName("nelic_SearchLicenseFilterDialog_PageTree");
    }

    public boolean confirmShow() {
        this.setModal(true);
        ScreenToolKit.centerLocateToScreen((Component)this);
        this.setVisible(true);
        return this.isOK();
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            this.setToolTipText(value.toString());
            this.setBackground(isSelected ? Color.blue : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }
}

