/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui.dlg;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.gui.netree.NETree;
import com.huawei.u2000.nelicense.gui.panel.DlgButtonPanel;
import com.huawei.u2000.nelicense.gui.panel.ForSelectTreePanel;
import com.huawei.u2000.nelicense.gui.panel.SelectButtonPanel;
import com.huawei.u2000.nelicense.model.NETreeNodeInfo;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.model.StatusTreeNodeInfo;
import com.huawei.u2000.nelicense.model.TreeNodeInfo;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MultiSelectDomainDlg
extends JDialog {
    private static final long serialVersionUID = -4550969884747950756L;
    private long parentTreeId;
    private boolean status = false;
    private String[] selectedNeArray;
    private Window parentWindow;
    private static MultiSelectDomainDlg newInstance;
    private SelectButtonPanel selectButtonPanel = new SelectButtonPanel();
    private ForSelectTreePanel leftTreePanel;
    private ForSelectTreePanel rightTreePanel;

    public MultiSelectDomainDlg(Window parentWindow, String[] selectedNeArray, int dialogType) {
        super(parentWindow, ResCenter.getInstance().getString("selectdomain"), Dialog.ModalityType.APPLICATION_MODAL);
        this.parentWindow = parentWindow;
        this.selectedNeArray = selectedNeArray;
        this.jInit(dialogType);
        ScreenToolKit.centerLocateToScreen((Component)this);
        this.setVisible(true);
    }

    public MultiSelectDomainDlg getInstance(Window parentWindow, long parentTreeId) {
        if (newInstance == null) {
            newInstance = new MultiSelectDomainDlg(parentWindow, parentTreeId);
        }
        return newInstance;
    }

    public MultiSelectDomainDlg(Window parentWindow, String[] selectedNeArray) {
        this(parentWindow, selectedNeArray, -1);
    }

    public MultiSelectDomainDlg(Window parentWindow, long parentTreeId) {
        super(parentWindow, ResCenter.getInstance().getString("selectdomain"), Dialog.ModalityType.APPLICATION_MODAL);
        this.parentWindow = parentWindow;
        this.parentTreeId = parentTreeId;
        this.jInit(-1);
        ScreenToolKit.centerLocateToScreen((Component)this);
        this.setVisible(true);
    }

    public MultiSelectDomainDlg(Window parentWindow) {
        super(parentWindow, ResCenter.getInstance().getString("selectdomain"), Dialog.ModalityType.APPLICATION_MODAL);
        this.parentWindow = parentWindow;
        this.jInit(-1);
        ScreenToolKit.centerLocateToScreen((Component)this);
        this.setVisible(true);
    }

    private void jInit(int panelType) {
        if (this.selectedNeArray == null) {
            this.rightTreePanel = new ForSelectTreePanel(this.parentWindow, 320, 450, true, 2);
            this.leftTreePanel = new ForSelectTreePanel(this.parentWindow, 320, 450, false, 1);
            this.leftTreePanel.setTreeName("nelic_ForSelectTreePanel_PageTree1");
            this.rightTreePanel.setTreeName("nelic_ForSelectTreePanel_PageTree2");
        } else {
            this.rightTreePanel = new ForSelectTreePanel(this.parentWindow, 320, 450, true, 2, this.selectedNeArray);
            this.leftTreePanel = new ForSelectTreePanel(this.parentWindow, 320, 450, false, 1, this.selectedNeArray);
            this.leftTreePanel.setTreeName("nelic_ForSelectTreePanel_PageTree1");
            this.rightTreePanel.setTreeName("nelic_ForSelectTreePanel_PageTree2");
        }
        this.leftTreePanel.setTreeSelectionListener(new MyTreeSelectionListener(true));
        this.rightTreePanel.setTreeSelectionListener(new MyTreeSelectionListener(false));
        Container context = this.getContentPane();
        context.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridBagLayout());
        selectPanel.add((Component)this.leftTreePanel.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        selectPanel.add((Component)this.selectButtonPanel.getButtonPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.addListener();
        selectPanel.add((Component)this.rightTreePanel.getPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)selectPanel, "Center");
        DlgButtonPanel buttonPanel = new DlgButtonPanel(new OKActionListener(), new CancelActionListener());
        panel.add((Component)buttonPanel.getButtonPanel(), "South");
        context.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.setSize(new Dimension(800, 500));
        this.setResizable(false);
        ScreenToolKit.setDefaultButtons((AbstractButton)buttonPanel.getOKButton(), (AbstractButton)buttonPanel.getCancelButton());
        this.firePageTreeSelectedListener();
        this.setDefaultCloseOperation(2);
    }

    private void firePageTreeSelectedListener() {
        this.leftTreePanel.getNETree().setSelectionRow(0);
        this.rightTreePanel.getNETree().setSelectionRow(0);
        this.enableSelectButton(this.rightTreePanel, true);
    }

    private void enableSelectButton(ForSelectTreePanel treePanel, boolean leftOrRight) {
        JTree tree;
        if (null != treePanel && null != treePanel.getNETree() && (tree = treePanel.getNETree().getTree()).getRowCount() > 1 && leftOrRight) {
            this.selectButtonPanel.getDeSelectAllButton().setEnabled(true);
        }
    }

    private void addListener() {
        this.selectButtonPanel.getSelectButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultiSelectDomainDlg.this.moveSelectedNode(MultiSelectDomainDlg.this.leftTreePanel, MultiSelectDomainDlg.this.rightTreePanel);
                    MultiSelectDomainDlg.this.setSelectVector(MultiSelectDomainDlg.this.rightTreePanel, MultiSelectDomainDlg.this.leftTreePanel);
                    MultiSelectDomainDlg.this.firePageTreeSelectedListener();
                }
                catch (Exception ex) {
                    LicDebugTracer.trace("NELicenseInfo:" + ex);
                    LicDebugTracer.trace(ex);
                }
            }
        });
        this.selectButtonPanel.getDeSelectButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultiSelectDomainDlg.this.moveSelectedNode(MultiSelectDomainDlg.this.rightTreePanel, MultiSelectDomainDlg.this.leftTreePanel);
                    MultiSelectDomainDlg.this.setSelectVector(MultiSelectDomainDlg.this.rightTreePanel, MultiSelectDomainDlg.this.leftTreePanel);
                    MultiSelectDomainDlg.this.firePageTreeSelectedListener();
                }
                catch (Exception ex) {
                    LicDebugTracer.trace("NELicenseInfo:" + ex);
                    LicDebugTracer.trace(ex);
                }
            }
        });
        this.selectButtonPanel.getSelectAllButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultiSelectDomainDlg.this.moveAllNode(MultiSelectDomainDlg.this.leftTreePanel, MultiSelectDomainDlg.this.rightTreePanel);
                    MultiSelectDomainDlg.this.setSelectVector(MultiSelectDomainDlg.this.rightTreePanel, MultiSelectDomainDlg.this.leftTreePanel);
                    MultiSelectDomainDlg.this.firePageTreeSelectedListener();
                }
                catch (Exception ex) {
                    LicDebugTracer.trace("NELicenseInfo:" + ex);
                    LicDebugTracer.trace(ex);
                }
            }
        });
        this.selectButtonPanel.getDeSelectAllButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MultiSelectDomainDlg.this.moveAllNode(MultiSelectDomainDlg.this.rightTreePanel, MultiSelectDomainDlg.this.leftTreePanel);
                    MultiSelectDomainDlg.this.setSelectVector(MultiSelectDomainDlg.this.rightTreePanel, MultiSelectDomainDlg.this.leftTreePanel);
                    MultiSelectDomainDlg.this.firePageTreeSelectedListener();
                }
                catch (Exception ex) {
                    LicDebugTracer.trace("NELicenseInfo:" + ex);
                    LicDebugTracer.trace(ex);
                }
            }
        });
    }

    private void moveSelectedNode(ForSelectTreePanel fromPanel, ForSelectTreePanel toPanel) {
        NETree fromNETree = fromPanel.getNETree();
        NETree toNETree = toPanel.getNETree();
        Vector<DefaultMutableTreeNode> oSelectedNodeVec = new Vector<DefaultMutableTreeNode>();
        TreePath[] oTreePath = fromNETree.getTree().getSelectionPaths();
        for (int i = 0; i < oTreePath.length; ++i) {
            this.moveSelectNode(oSelectedNodeVec, oTreePath, i);
        }
        boolean isRight = true;
        if (fromNETree.getName().length() < toNETree.getName().length()) {
            isRight = false;
        }
        String version = toPanel.getVersion();
        DefaultMutableTreeNode oToTreeRoot = toNETree.getRoot();
        for (DefaultMutableTreeNode oNode : oSelectedNodeVec) {
            this.moveChooseNodeToTree(toNETree, isRight, version, oToTreeRoot, oNode);
        }
        fromNETree.getTree().updateUI();
        toNETree.getTree().updateUI();
    }

    private void moveSelectNode(Vector<DefaultMutableTreeNode> oSelectedNodeVec, TreePath[] oTreePath, int i) {
        TreePath oPath = oTreePath[i];
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)oPath.getLastPathComponent();
        if (oNode.isRoot()) {
            this.moveSelectRootNode(oSelectedNodeVec, oNode);
            i = oTreePath.length;
            return;
        }
        if (oNode.isLeaf() && oSelectedNodeVec.contains(oNode.getParent())) {
            return;
        }
        this.moveStatusNode(oSelectedNodeVec, oNode);
    }

    private void moveStatusNode(Vector<DefaultMutableTreeNode> oSelectedNodeVec, DefaultMutableTreeNode oNode) {
        if (!oNode.isLeaf()) {
            oSelectedNodeVec.add(oNode);
            oNode.removeFromParent();
            return;
        }
        oSelectedNodeVec.add(oNode);
        TreeNode oParent = oNode.getParent();
        oNode.removeFromParent();
        if (0 == oParent.getChildCount()) {
            ((DefaultMutableTreeNode)oParent).removeFromParent();
        }
    }

    private void moveSelectRootNode(Vector<DefaultMutableTreeNode> oSelectedNodeVec, DefaultMutableTreeNode oNode) {
        for (int j = 0; j < oNode.getChildCount(); ++j) {
            oSelectedNodeVec.add((DefaultMutableTreeNode)oNode.getChildAt(j));
        }
        oNode.removeAllChildren();
    }

    private void moveChooseNodeToTree(NETree toNETree, boolean isRight, String version, DefaultMutableTreeNode oToTreeRoot, DefaultMutableTreeNode oNode) {
        TreeNodeInfo oNodeInfo = (TreeNodeInfo)oNode.getUserObject();
        if (!isRight && !"allversion".equals(version)) {
            oNode = this.filterVersion(oNode, version);
        }
        if (oNode == null) {
            return;
        }
        if (-2 == oNodeInfo.getType()) {
            StatusTreeNodeInfo oStatusNodeInfo = (StatusTreeNodeInfo)oNodeInfo;
            DefaultMutableTreeNode oStatusNode = this.getStatusNode(oStatusNodeInfo.getStatus(), toNETree);
            this.addStatusNode(oToTreeRoot, oNode, oStatusNode);
            return;
        }
        NETreeNodeInfo oNENodeInfo = (NETreeNodeInfo)oNodeInfo;
        int iStatus = oNENodeInfo.getNeLicInfo().getStatus();
        DefaultMutableTreeNode oStatusNode = this.getStatusNode(iStatus, toNETree);
        if (null == oStatusNode) {
            StatusTreeNodeInfo oStatusNodeInfo = new StatusTreeNodeInfo(iStatus);
            oStatusNode = new DefaultMutableTreeNode(oStatusNodeInfo);
            oToTreeRoot.add(oStatusNode);
        }
        oStatusNode.add(oNode);
    }

    private void addStatusNode(DefaultMutableTreeNode oToTreeRoot, DefaultMutableTreeNode oNode, DefaultMutableTreeNode oStatusNode) {
        if (null == oStatusNode) {
            oToTreeRoot.add(oNode);
            return;
        }
        while (oNode.getChildCount() > 0) {
            oStatusNode.add((DefaultMutableTreeNode)oNode.getChildAt(0));
        }
    }

    private void moveAllNode(ForSelectTreePanel fromPanel, ForSelectTreePanel toPanel) {
        NETree fromNETree = fromPanel.getNETree();
        NETree toNETree = toPanel.getNETree();
        Vector<DefaultMutableTreeNode> oSelectedNodeVec = new Vector<DefaultMutableTreeNode>();
        DefaultMutableTreeNode oFromTreeRoot = fromNETree.getRoot();
        this.moveSelectRootNode(oSelectedNodeVec, oFromTreeRoot);
        boolean isRight = true;
        if (fromNETree.getName().length() < toNETree.getName().length()) {
            isRight = false;
        }
        String version = toPanel.getVersion();
        DefaultMutableTreeNode oToTreeRoot = toNETree.getRoot();
        for (DefaultMutableTreeNode oNode : oSelectedNodeVec) {
            oNode = this.moveNodeToTree(toNETree, isRight, version, oToTreeRoot, oNode);
        }
        fromNETree.getTree().updateUI();
        toNETree.getTree().updateUI();
    }

    private DefaultMutableTreeNode moveNodeToTree(NETree toNETree, boolean isRight, String version, DefaultMutableTreeNode oToTreeRoot, DefaultMutableTreeNode oNode) {
        StatusTreeNodeInfo oStatusNodeInfo = (StatusTreeNodeInfo)oNode.getUserObject();
        DefaultMutableTreeNode oStatusNode = this.getStatusNode(oStatusNodeInfo.getStatus(), toNETree);
        if (!isRight && !"allversion".equals(version)) {
            oNode = this.filterVersion(oNode, version);
        }
        if (oNode == null) {
            return null;
        }
        this.addStatusNode(oToTreeRoot, oNode, oStatusNode);
        return oNode;
    }

    private DefaultMutableTreeNode filterVersion(DefaultMutableTreeNode oNode, String version) {
        DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)oNode.clone();
        NETreeNodeInfo oNodeInfo = (NETreeNodeInfo)oNode.getUserObject();
        String curVersion = oNodeInfo.getNeLicInfo().getVersion();
        if (!version.equals(curVersion)) {
            return null;
        }
        int iChildCount = oNode.getChildCount();
        for (int i = 0; i < iChildCount; ++i) {
            this.filterWrongNode(oNode, version, tempNode, i);
        }
        return tempNode;
    }

    private void filterWrongNode(DefaultMutableTreeNode oNode, String version, DefaultMutableTreeNode tempNode, int i) {
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)oNode.getChildAt(i);
        DefaultMutableTreeNode tempChildNode = (DefaultMutableTreeNode)childNode.clone();
        NETreeNodeInfo oChildInfo = (NETreeNodeInfo)childNode.getUserObject();
        String childVersion = oChildInfo.getNeLicInfo().getVersion();
        if (version.equals(childVersion)) {
            tempNode.add(tempChildNode);
        }
    }

    private DefaultMutableTreeNode getStatusNode(int iStatus, NETree oNETree) {
        DefaultMutableTreeNode oRoot = oNETree.getRoot();
        int iStatusNodeCount = oRoot.getChildCount();
        for (int i = 0; i < iStatusNodeCount; ++i) {
            DefaultMutableTreeNode oStatusNode = (DefaultMutableTreeNode)oRoot.getChildAt(i);
            StatusTreeNodeInfo oNodeInfo = (StatusTreeNodeInfo)oStatusNode.getUserObject();
            if (iStatus != oNodeInfo.getStatus()) continue;
            return oStatusNode;
        }
        return null;
    }

    public List<NeLicenseBaseInfo> getSelectedNes() throws Exception {
        ArrayList<NeLicenseBaseInfo> oNeLicInfoLst = new ArrayList<NeLicenseBaseInfo>();
        DefaultMutableTreeNode oRoot = this.rightTreePanel.getNETree().getRoot();
        Enumeration<TreeNode> enu = oRoot.breadthFirstEnumeration();
        while (enu.hasMoreElements()) {
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)enu.nextElement();
            if (!oNode.isLeaf() || oNode.isRoot()) continue;
            NETreeNodeInfo oNodeInfo = (NETreeNodeInfo)oNode.getUserObject();
            oNeLicInfoLst.add(oNodeInfo.getNeLicInfo());
        }
        return oNeLicInfoLst;
    }

    public void setSelectVector(ForSelectTreePanel rightPanel, ForSelectTreePanel leftPanel) {
        DefaultMutableTreeNode oRoot = rightPanel.getNETree().getRoot();
        Enumeration<TreeNode> enu = oRoot.breadthFirstEnumeration();
        Vector<String> FDNVector = new Vector<String>();
        while (enu.hasMoreElements()) {
            this.addFDNToVector(enu, FDNVector);
        }
        leftPanel.setFDNVector(FDNVector);
    }

    private void addFDNToVector(Enumeration enu, Vector<String> FDNVector) {
        DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)enu.nextElement();
        if (oNode.isLeaf() && !oNode.isRoot()) {
            NETreeNodeInfo oNodeInfo = (NETreeNodeInfo)oNode.getUserObject();
            FDNVector.add(oNodeInfo.getNeLicInfo().getFdn());
        }
    }

    public boolean getStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiSelectDomainDlg.this.dispose();
            MultiSelectDomainDlg.this.status = false;
        }
    }

    private class OKActionListener
    implements ActionListener {
        private OKActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiSelectDomainDlg.this.dispose();
            MultiSelectDomainDlg.this.status = true;
        }
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        private boolean isLeftTree;

        public MyTreeSelectionListener(boolean isLeftTree) {
            this.isLeftTree = isLeftTree;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.isLeftTree) {
                MultiSelectDomainDlg.this.selectButtonPanel.getSelectButton().setEnabled(true);
            } else {
                MultiSelectDomainDlg.this.selectButtonPanel.getDeSelectButton().setEnabled(true);
            }
            if (e.getSource() instanceof JTree) {
                JTree tree = (JTree)e.getSource();
                if (tree.getSelectionCount() > 0) {
                    MultiSelectDomainDlg.this.selectButtonPanel.getDeSelectButton().setEnabled(true);
                } else {
                    MultiSelectDomainDlg.this.selectButtonPanel.getDeSelectButton().setEnabled(false);
                }
                if (tree.getRowCount() > 1 && !this.isLeftTree) {
                    MultiSelectDomainDlg.this.selectButtonPanel.getDeSelectAllButton().setEnabled(true);
                } else {
                    MultiSelectDomainDlg.this.selectButtonPanel.getDeSelectAllButton().setEnabled(false);
                }
            }
        }
    }
}

