/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.gui;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.framework.adaptive.AdaptiveUtil;
import com.huawei.u2000.nelicense.common.Constants;
import com.huawei.u2000.nelicense.common.ContentType;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.NELicenseXMLParser;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicLoadProRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicLoadProSetReq;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicLoadProSetRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicLoadProcotolEnum;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.controller.LicAsynCommController;
import com.huawei.u2000.nelicense.common.controller.LicAsynDetailController;
import com.huawei.u2000.nelicense.common.controller.LicOperationManager;
import com.huawei.u2000.nelicense.common.controller.NeLicenseDetailManager;
import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.event.EventRegisterFactory;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.util.GlobalUtil;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.mdi.ExtendedWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class LicenseMainFrame
extends ExtendedWindow {
    private static final long serialVersionUID = 3294165840506262563L;
    private JTree navigationTree = null;
    private JSplitPane frameSplitPane;
    protected DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode(ResCenter.getInstance().getString("mainFrame_root"));
    private DefaultMutableTreeNode selectedNode;
    private DefaultMutableTreeNode lastSelectedNode;
    private JPanel rightPanel = new JPanel();
    private JButton viewNEButton = new JButton(ResCenter.getInstance().getString("licenseinfoquery"));
    private JButton NELicenseButton = new JButton(ResCenter.getInstance().getString("licensemaintenance"));
    private JCheckBox startupIviewLicense = new JCheckBox(ResCenter.getInstance().getString("directgo"));
    DefaultMutableTreeNode viewLicenseNode = new DefaultMutableTreeNode(ResCenter.getInstance().getString("licenseinfoquery"));
    DefaultMutableTreeNode nelicenseNode = new DefaultMutableTreeNode(ResCenter.getInstance().getString("licensemaintenance"));
    private int m_licenseMainFrameID = -1;
    JPanel rootPanel = null;
    QueryLicensePanel queryLicensePanel = null;
    private boolean isFirstSelected = true;
    private static LicenseMainFrame oLicenseMainFrame;
    private JPanel oLoadProtocolPanel = null;
    private JComboBox loadCombox = null;
    private JButton applyBtn = null;
    private static final String NEMGR_ROUTER = "nemgr_router";

    public LicenseMainFrame() {
        this.initMainFrame();
    }

    public static synchronized LicenseMainFrame getInstance() {
        if (null == oLicenseMainFrame) {
            oLicenseMainFrame = new LicenseMainFrame();
        }
        return oLicenseMainFrame;
    }

    private void initLoadProtocolPanel() {
        this.oLoadProtocolPanel = new JPanel(new GridBagLayout());
        TitledBorder oTitledBorder = BorderFactory.createTitledBorder(ResCenter.getInstance().getString("filetranprotocol"));
        this.oLoadProtocolPanel.setBorder(oTitledBorder);
        JLabel viewNElabel = new JLabel(ResCenter.getInstance().getString("loadprotocoldesc"));
        this.loadCombox = new JComboBox();
        this.loadCombox.addItem(new ContentType(2, ResCenter.getInstance().getString("sftpprotocol")));
        this.loadCombox.addItem(new ContentType(1, ResCenter.getInstance().getString("ftpprotocol")));
        this.updateIPTranProtocol();
        this.oLoadProtocolPanel.add((Component)viewNElabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 12, 10, 0), 0, 0));
        this.oLoadProtocolPanel.add((Component)this.loadCombox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 12, 10, 12), 0, 0));
        this.applyBtn = new JButton(ResCenter.getInstance().getString("applybtn"));
        this.applyBtn.setMnemonic('A');
        Dimension dim = new Dimension(100, 21);
        this.applyBtn.setMaximumSize(dim);
        this.applyBtn.setPreferredSize(dim);
        this.applyBtn.setMinimumSize(dim);
        this.applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseMainFrame.this.setIPTranProtocol();
            }
        });
        this.oLoadProtocolPanel.add((Component)this.applyBtn, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 12, 10, 12), 0, 0));
    }

    private void updateIPTranProtocol() {
        BaseCommManager m_comMgr = BaseCommManager.getInstance();
        AsnNeLicLoadProRsp oAsnNeLicLoadProRsp = new AsnNeLicLoadProRsp();
        LicDebugTracer.trace("updateIPTranProtocol send message ");
        int iErrCode = m_comMgr.sendSyncMsg(m_comMgr.getMSGHead(99820260, 1), null, oAsnNeLicLoadProRsp);
        LicDebugTracer.trace("updateIPTranProtocol get message ");
        if (0 != iErrCode) {
            DCOptionPane.showMessageDialog((Component)((Object)this), (String)ResCenter.getInstance().getString("queryfiletranffailed"), (String)ResCenter.getInstance().getString("connect_error"), (int)0);
            LicDebugTracer.trace("updateIPTranProtocol error code : " + iErrCode);
        }
        int count = this.loadCombox.getItemCount();
        for (int index = 0; index < count; ++index) {
            ContentType oContentType = (ContentType)this.loadCombox.getItemAt(index);
            if (oAsnNeLicLoadProRsp.eProtocol.value != oContentType.getContentTypeCode()) continue;
            this.loadCombox.setSelectedIndex(index);
            break;
        }
    }

    public void setIPTranProtocol() {
        ContentType oContentType = (ContentType)this.loadCombox.getSelectedItem();
        AsnNeLicLoadProSetReq oAsnNeLicLoadProSetReq = new AsnNeLicLoadProSetReq();
        oAsnNeLicLoadProSetReq.eProtocol = new AsnNeLicLoadProcotolEnum(oContentType.getContentTypeCode());
        BaseCommManager m_comMgr = BaseCommManager.getInstance();
        AsnNeLicLoadProSetRsp oAsnNeLicLoadProSetRsp = new AsnNeLicLoadProSetRsp();
        LicDebugTracer.trace("setIPTranProtocol send message ");
        int iErrCode = m_comMgr.sendSyncMsg(m_comMgr.getMSGHead(99820261, 1), oAsnNeLicLoadProSetReq, oAsnNeLicLoadProSetRsp);
        LicDebugTracer.trace("setIPTranProtocol get message ");
        if (0 != iErrCode) {
            DCOptionPane.showMessageDialog((Component)((Object)this), (String)ResCenter.getInstance().getString("setfiletranffailed"), (String)ResCenter.getInstance().getString("connect_error"), (int)0);
            LicDebugTracer.trace("setIPTranProtocol error code : " + iErrCode);
            return;
        }
        if (null != oAsnNeLicLoadProSetRsp.iErrCode) {
            if (0 == oAsnNeLicLoadProSetRsp.iErrCode.intValue()) {
                DCOptionPane.showMessageDialog((Component)((Object)this), (String)ResCenter.getInstance().getString("setfiletranfsuccess"), (String)ResCenter.getInstance().getString("title"), (int)1);
            } else {
                DCOptionPane.showMessageDialog((Component)((Object)this), (String)ResCenter.getInstance().getString("setfiletranffailed"), (String)ResCenter.getInstance().getString("connect_error"), (int)0);
                LicDebugTracer.trace("setIPTranProtocol error code : " + oAsnNeLicLoadProSetRsp.iErrCode);
            }
        }
    }

    private void initMainFrame() {
        super.setTitle(ResCenter.getInstance().getString("mainFrame_root"));
        this.frameSplitPane = new JSplitPane(1, false);
        this.frameSplitPane.setOneTouchExpandable(true);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JScrollPane leftScrollPane = new JScrollPane();
        this.initTreeData();
        this.treeModel = new DefaultTreeModel(this.root);
        this.navigationTree = new JTree(this.treeModel);
        this.navigationTree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 141927189902496234L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                this.setText(value.toString());
                this.setIcon(ResCenter.getInstance().getIMageIcon("icons/license.gif"));
                return this;
            }
        });
        this.navigationTree.addTreeSelectionListener(this.getTreeSelectionListener());
        this.navigationTree.setExpandsSelectedPaths(true);
        this.navigationTree.setName("nelic_LicenseMainFrame_NavigatorTree");
        leftScrollPane.getViewport().add(this.navigationTree);
        leftPanel.add((Component)leftScrollPane, "Center");
        leftScrollPane.setMinimumSize(Constants.Component.ComponentSize.NELICENSE_FRAME_HALF_SIZE);
        this.setLayout(new BorderLayout());
        this.add(this.frameSplitPane, "Center");
        this.initListener();
        this.frameSplitPane.add((Component)leftPanel, "left");
        this.initLoadProtocolPanel();
        this.frameSplitPane.add((Component)this.getRootContentPanel(), "right");
        this.frameSplitPane.setDividerLocation(190);
        this.setIconImage(ResCenter.getInstance().getIMageIcon("icons/license.gif").getImage());
        ScreenToolKit.setPreferredSizeofButtons((JButton[])new JButton[]{this.viewNEButton, this.NELicenseButton}, (int)21);
    }

    public void setStartViewLicense() {
        if (this.isStartViewLicense()) {
            this.startupIviewLicense.setSelected(true);
            this.navigationTree.setSelectionPath(new TreePath(this.viewLicenseNode.getPath()));
        } else {
            this.startupIviewLicense.setSelected(false);
            this.navigationTree.setSelectionPath(new TreePath(this.root.getPath()));
        }
    }

    public boolean isStartViewLicense() {
        String startviewLicenseStr = "";
        try {
            CommStyleInfo info = NELicenseXMLParser.getConfigInfo();
            startviewLicenseStr = info.getParasItemValue("startsIviewLicense", "isStartsIviewLicense");
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        return Boolean.valueOf(startviewLicenseStr);
    }

    private void initListener() {
        this.viewNEButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseMainFrame.this.navigationTree.setSelectionPath(new TreePath(LicenseMainFrame.this.viewLicenseNode.getPath()));
            }
        });
        this.NELicenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseMainFrame.this.navigationTree.setSelectionPath(new TreePath(LicenseMainFrame.this.nelicenseNode.getPath()));
            }
        });
    }

    private JPanel getRootContentPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel(new GridBagLayout());
            JPanel topPanel = new JPanel(new GridBagLayout());
            JLabel viewNElabel = new JLabel(ResCenter.getInstance().getString("licenseinfoquerydetail"));
            JLabel NELicenselabel = new JLabel(ResCenter.getInstance().getString("licensemaintenancedetail"));
            topPanel.add((Component)this.viewNEButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 5, 0, 0), 0, 0));
            topPanel.add((Component)viewNElabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 5, 0, 14), 0, 0));
            topPanel.add((Component)this.NELicenseButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 5, 0, 14), 0, 0));
            topPanel.add((Component)NELicenselabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(12, 5, 0, 14), 0, 0));
            JPanel bootomPanel = new JPanel(new GridBagLayout());
            bootomPanel.add((Component)this.startupIviewLicense, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 5, 0, 0), 0, 0));
            topPanel.add((Component)this.startupIviewLicense, new GridBagConstraints(0, 2, 0, 2, 1.0, 0.0, 17, 0, new Insets(12, 5, 12, 12), 0, 0));
            if (!GlobalUtil.isStandalone()) {
                if (AdaptiveUtil.isSubsystemDeployed((String)NEMGR_ROUTER)) {
                    topPanel.add((Component)this.oLoadProtocolPanel, new GridBagConstraints(0, 4, 0, 2, 2.0, 0.0, 17, 0, new Insets(12, 5, 12, 12), 0, 0));
                }
            } else {
                topPanel.add((Component)this.oLoadProtocolPanel, new GridBagConstraints(0, 4, 0, 2, 2.0, 0.0, 17, 0, new Insets(12, 5, 12, 12), 0, 0));
            }
            JPanel bankPanel = new JPanel();
            this.rootPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(12, 5, 0, 0), 0, 0));
            this.rootPanel.add((Component)bankPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.rootPanel.add((Component)bootomPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 16, 0, new Insets(12, 5, 0, 0), 0, 0));
            this.rootPanel.setMinimumSize(Constants.Component.ComponentSize.NELICENSE_RIGHT_FRAME_MIN_SIZE);
        }
        return this.rootPanel;
    }

    private TreeSelectionListener getTreeSelectionListener() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (null == e.getNewLeadSelectionPath()) {
                    LicenseMainFrame.this.navigationTree.setSelectionPath(new TreePath(LicenseMainFrame.this.root.getPath()));
                } else {
                    LicenseMainFrame.this.handleTreeSelection(e);
                }
            }
        };
    }

    public void showFrame() {
        WindowManager windowManager = ((MDIFrame)FrameworkUtilities.getMainFrame()).getWindowManager();
        if (-1 == this.m_licenseMainFrameID) {
            this.m_licenseMainFrameID = windowManager.registerWindowEX((ExtendedWindow)this);
        }
        windowManager.activateWindow(this.m_licenseMainFrameID);
        this.setStartViewLicense();
    }

    private void initTreeData() {
        this.root.add(this.viewLicenseNode);
        this.root.add(this.nelicenseNode);
    }

    private void handleTreeSelection(TreeSelectionEvent e) {
        TreePath path = this.navigationTree.getSelectionPath();
        if (path != null) {
            this.selectedNode = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            if (null != this.lastSelectedNode && this.lastSelectedNode.equals(this.selectedNode)) {
                return;
            }
            Object obj = this.selectedNode.getUserObject();
            if (obj instanceof String) {
                String treeNodeName = (String)obj;
                if (treeNodeName.equalsIgnoreCase(ResCenter.getInstance().getString("mainFrame_root"))) {
                    this.frameSplitPane.remove(this.rightPanel);
                    this.rightPanel = this.getRootContentPanel();
                    this.frameSplitPane.add((Component)this.rightPanel, "right");
                    this.frameSplitPane.updateUI();
                    GuiUtil.enableHelpKey(this.getRootPane(), "iVIEW.LTELIC.LicenseMainFrame");
                } else if (treeNodeName.equalsIgnoreCase(ResCenter.getInstance().getString("licenseinfoquery"))) {
                    this.frameSplitPane.remove(this.rightPanel);
                    this.rightPanel = this.getQueryLicensePanel();
                    this.frameSplitPane.add((Component)this.rightPanel, "right");
                    this.frameSplitPane.updateUI();
                    this.queryLicensePanel = this.getQueryLicensePanel();
                    if (!this.isFirstSelected && this.queryLicensePanel.getTableModel().getRowCount() == 0) {
                        this.queryLicensePanel.refresh();
                    }
                    if (this.isFirstSelected) {
                        this.isFirstSelected = false;
                        this.queryLicensePanel.filter();
                    }
                    GuiUtil.enableHelpKey(this.getRootPane(), "iVIEW.LTELIC.LicenseInfoQuery");
                } else if (treeNodeName.equalsIgnoreCase(ResCenter.getInstance().getString("licensemaintenance"))) {
                    JPanel oTmpPanel = this.rightPanel;
                    this.rightPanel = LicenseTaskPanel.getInstance();
                    this.frameSplitPane.add((Component)this.rightPanel, "right");
                    this.frameSplitPane.remove(oTmpPanel);
                    this.frameSplitPane.updateUI();
                    GuiUtil.enableHelpKey(this.getRootPane(), "iVIEW.LTELIC.LicenseMaintenance");
                }
            }
        }
    }

    private QueryLicensePanel getQueryLicensePanel() {
        if (this.queryLicensePanel == null) {
            this.queryLicensePanel = QueryLicensePanel.getInstance();
        }
        return this.queryLicensePanel;
    }

    public void windowClosed() {
        LicDebugTracer.trace("[NELIC] LicenseMainFrame#windowClosed Start ");
        NELicenseXMLParser.writeBackStartViewLicenseItemToXML(this.startupIviewLicense.isSelected());
        EventRegisterFactory.getInstance().unRegisterAll();
        BaseCommManager oBaseManager = BaseCommManager.getInstance();
        oBaseManager.stopShakeHand();
        this.m_licenseMainFrameID = -1;
        this.disposeLicense();
        LicDebugTracer.trace("[NELIC] LicenseMainFrame#windowClosed End ");
    }

    private void disposeLicense() {
        QueryLicensePanel.clear();
        LicenseTaskPanel.clear();
        NeLicenseDetailManager.getInstance().setToNull();
        LicOperationManager.getInstance().setToNull();
        if (null != LicAsynCommController.getInstance()) {
            LicAsynCommController.getInstance().setToNull();
            LicAsynCommController.getInstance().release();
        }
        if (null != LicAsynDetailController.getInstance()) {
            LicAsynDetailController.getInstance().release();
            LicAsynDetailController.getInstance().setToNull();
        }
        NeLicenseInfoManager.getInstance().setToNull();
    }

    public static LicenseMainFrame getLicenseMainFrame() {
        return oLicenseMainFrame;
    }
}

