/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.event.handlers;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.event.IEventHandler;
import com.huawei.u2000.nelicense.event.handlers.ExportInfoEventHandler;
import com.huawei.u2000.nelicense.event.handlers.QueryNeLicenseDetailInfoHandler;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.gui.treetable.TaskProcess;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import java.util.Set;
import javax.swing.SwingUtilities;

public class StatusUpdatedEventHandler
implements IEventHandler {
    private static StatusUpdatedEventHandler instance = new StatusUpdatedEventHandler();

    public static StatusUpdatedEventHandler getInstance() {
        return instance;
    }

    private StatusUpdatedEventHandler() {
    }

    @Override
    public boolean handle(RpcEvent event) {
        try {
            LicDebugTracer.trace("NELicenseInfo:StatusUpdatedEventHandler handle");
            DataTable table = event.getMessage().getTable("Additional");
            final NeLicenseTask task = new NeLicenseTask();
            String errDesc = null;
            if (table != null && table.size() > 0) {
                DataRecord record = table.get(0);
                task.setTaskId(record.getInt("taskId"));
                task.setSubTaskId(record.getInt("subTaskId"));
                task.setOperator(record.get("operator"));
                task.setType(Integer.valueOf(record.get("type")));
                task.setState(record.getInt("state"));
                task.setFdn(record.get("fdn"));
                task.setNeType(record.get("neType"));
                task.setNeName(record.get("neName"));
                task.setBeginDateTime(TimeDateFormatUtil.convertFromUTC((long)(Long.valueOf(record.get("beginDateTime")) * 1000L)));
                task.setDetail(record.get("detail"));
                errDesc = table.get(0).get("errDesc");
            }
            LicDebugTracer.trace("NELicenseInfo:zsq " + task.getFdn() + ":" + task.getNeName() + ":" + task.getType() + ":" + task.getTaskId() + ":" + task.getSubTaskId() + ":" + task.getState());
            if (ExportInfoEventHandler.getInstance().hasSubTask(task, task.getFdn())) {
                return false;
            }
            if (task.getType() == 5) {
                if (QueryLicensePanel.getInstance().isExport()) {
                    String details = task.getDetail() == null ? errDesc : task.getDetail();
                    LicDebugTracer.trace("NELicenseInfo:export details task:" + task.getTaskId() + " fialure, fdn:" + task.getFdn());
                    QueryNeLicenseDetailInfoHandler.getInstance().exportFailData(task.getTaskId(), task.getFdn(), details);
                } else {
                    QueryLicensePanel.getInstance().clearDetailTable();
                }
                return true;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LicenseTaskPanel.getInstance().refreshData(task.getTaskId());
                    }
                });
            }
            catch (Exception e) {
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
            if (!ExportInfoEventHandler.getInstance().isFinish(task.getTaskId())) {
                return false;
            }
            if (task.getType() == 4 || task.getType() == 2) {
                Set<String> fdnlist = ExportInfoEventHandler.getInstance().getTaskAndNeMap().get(task.getTaskId());
                if (null == fdnlist || fdnlist.size() == 0) {
                    GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exetaskfailured", new String[]{String.valueOf(task.getTaskId()), this.getType(task.getType())}));
                } else if (TaskProcess.getInstance().get((int)task.getTaskId()).total == fdnlist.size()) {
                    GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exetasksucceeded", new String[]{String.valueOf(task.getTaskId()), this.getType(task.getType())}));
                } else {
                    GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exeexporttaskpartsuccess", new String[]{String.valueOf(task.getTaskId()), this.getType(task.getType())}));
                }
            } else {
                LicDebugTracer.trace("NELicenseInfo:ExportInfoEventHandler.getInstance().export taskId:" + task.getTaskId());
                ExportInfoEventHandler.getInstance().export(task.getTaskId());
            }
            return true;
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:StatusUpdatedEventHandler | handle failed " + e);
            LicDebugTracer.trace(e);
            return false;
        }
    }

    private String getType(int type) {
        switch (type) {
            case 0: {
                return ResCenter.getInstance().getString("exportneapplyinfo");
            }
            case 1: {
                return ResCenter.getInstance().getString("adjustlicense");
            }
            case 2: {
                return ResCenter.getInstance().getString("synch_esn");
            }
            case 3: {
                return ResCenter.getInstance().getString("invalidationlicnese");
            }
            case 4: {
                return ResCenter.getInstance().getString("loadlicense");
            }
        }
        return "";
    }
}

