/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.event.handlers;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.event.IEventHandler;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.model.NeLicenseDetailInfo;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryNeLicenseDetailInfoHandler
implements IEventHandler {
    private static QueryNeLicenseDetailInfoHandler instance = new QueryNeLicenseDetailInfoHandler();
    private Map<Integer, QueryLicDetailInfoEventListener> mapListener = new HashMap<Integer, QueryLicDetailInfoEventListener>();

    private QueryNeLicenseDetailInfoHandler() {
    }

    public static QueryNeLicenseDetailInfoHandler getInstance() {
        return instance;
    }

    public void addQueryLicDetailInfoEventListener(int taskId, QueryLicDetailInfoEventListener l) {
        this.mapListener.put(taskId, l);
    }

    public void removeQueryLicDetailInfoEventListener(int taskId) {
        this.mapListener.remove(taskId);
    }

    @Override
    public boolean handle(RpcEvent event) {
        try {
            LicDebugTracer.trace("NELicenseInfo:QueryNeLicenseDetailInfoHandler handle");
            DataTable table = event.getMessage().getTable("Additional");
            if (table != null) {
                List columns = table.getColumns();
                ArrayList<String[]> datas = new ArrayList<String[]>();
                int rowSize = table.size();
                for (int row = 0; row < rowSize; ++row) {
                    String[] rowData = new String[columns.size()];
                    int colSize = columns.size();
                    for (int col = 0; col < colSize; ++col) {
                        rowData[col] = table.get(row).get((String)columns.get(col));
                    }
                    datas.add(rowData);
                }
                LicDebugTracer.trace("NELicenseInfo:" + table.getString("fdn") + ":" + table.getInt("taskId"));
                if (this.mapListener.size() == 0) {
                    QueryLicensePanel.getInstance().addDetailTable(new NeLicenseDetailInfo(columns, datas, table.getString("fdn")), table.getInt("taskId"));
                } else {
                    QueryLicDetailInfoEventListener l = this.mapListener.get(table.getInt("taskId"));
                    if (null != l) {
                        l.fireLicDetailInfoReceived(new NeLicenseDetailInfo(columns, datas, table.getString("fdn")));
                    } else {
                        LicDebugTracer.trace("NELicenseInfo:not register QueryLicDetailInfoEventListener for the task:" + table.getInt("taskId"));
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            return false;
        }
    }

    public void exportFailData(int taskId, String fdn, String details) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("details");
        ArrayList<String[]> datas = new ArrayList<String[]>();
        datas.add(new String[]{details == null ? "" : details});
        QueryLicDetailInfoEventListener l = this.mapListener.get(taskId);
        if (null != l) {
            l.fireLicDetailInfoReceived(new NeLicenseDetailInfo(columns, datas, fdn));
        } else {
            LicDebugTracer.trace("NELicenseInfo:not register QueryLicDetailInfoEventListener for the task:" + taskId);
        }
    }

    public static interface QueryLicDetailInfoEventListener {
        public void fireLicDetailInfoReceived(NeLicenseDetailInfo var1);
    }
}

