/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.event.handlers;

import com.huawei.u2000.nelicense.common.ExportNeLicInfoMgr;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.LicFunctionItem;
import com.huawei.u2000.nelicense.common.LicNeLicenseInfo;
import com.huawei.u2000.nelicense.common.LicResourceItem;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.event.IEventHandler;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.gui.treetable.TaskProcess;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class ExportInfoEventHandler
implements IEventHandler {
    private static ExportInfoEventHandler instance = new ExportInfoEventHandler();
    private Map<Integer, Set<String>> taskAndNeMap = new HashMap<Integer, Set<String>>();
    private Map<Integer, Set<String>> taskAndNeOfFailMap = new HashMap<Integer, Set<String>>();
    private Map<String, LicNeLicenseInfo> exportInfoMap = new HashMap<String, LicNeLicenseInfo>();
    private Map<Integer, List<Integer>> taskAndSubTaskIdMap = new HashMap<Integer, List<Integer>>();

    public static ExportInfoEventHandler getInstance() {
        return instance;
    }

    private ExportInfoEventHandler() {
    }

    @Override
    public boolean handle(RpcEvent event) {
        try {
            Set<String> list;
            int i;
            DataTable table = event.getMessage().getTable("Additional");
            if (null == table) {
                return false;
            }
            final int taskId = table.getInt("taskId");
            LicDebugTracer.trace("NELicenseInfo:receive event from ds " + taskId);
            LicNeLicenseInfo licInfo = new LicNeLicenseInfo();
            licInfo.esn = table.getString("esn");
            licInfo.lsn = table.getString("lsn");
            licInfo.nename = table.getString("nename");
            licInfo.attrInfo = table.getString("attrInfo");
            licInfo.description = table.getString("description");
            licInfo.productName = table.getString("productName");
            licInfo.rvkCode = table.getString("rvkCode");
            licInfo.siteModel = table.getString("siteModel");
            licInfo.versionNo = table.getString("versionNo");
            String[] licItemArray = null;
            int[] value = null;
            String[] evaluateValue = null;
            String[] endDate = null;
            if (null != table.getStringArray("licItemForFun")) {
                licItemArray = table.getStringArray("licItemForFun");
                value = table.getIntArray("valueForFun");
                evaluateValue = table.getStringArray("evaluateValueForFun");
                endDate = table.getStringArray("endDateForFun");
                List<LicFunctionItem> listFunc = licInfo.funItemList;
                LicFunctionItem itemFunc = null;
                for (i = 0; i < licItemArray.length; ++i) {
                    itemFunc = new LicFunctionItem();
                    itemFunc.licItem = licItemArray[i];
                    itemFunc.value = value[i];
                    if (null != evaluateValue[i] && !evaluateValue[i].equals("")) {
                        try {
                            itemFunc.evaluateValue = Integer.valueOf(evaluateValue[i]);
                        }
                        catch (NumberFormatException e) {
                            LicDebugTracer.trace("NELicenseInfo:itemFunc.evaluateValue:" + itemFunc.evaluateValue);
                        }
                    }
                    if (null != endDate[i] && !endDate[i].equals("")) {
                        itemFunc.endDate = endDate[i];
                    }
                    listFunc.add(itemFunc);
                }
            }
            if (null != table.getStringArray("licItemForRes")) {
                licItemArray = table.getStringArray("licItemForRes");
                value = table.getIntArray("valueForRes");
                evaluateValue = table.getStringArray("evaluateValueForRes");
                endDate = table.getStringArray("endDateForRes");
                List<LicResourceItem> listRes = licInfo.resItemList;
                LicResourceItem itemRes = null;
                for (i = 0; i < licItemArray.length; ++i) {
                    itemRes = new LicResourceItem();
                    itemRes.licItem = licItemArray[i];
                    itemRes.value = BigInteger.valueOf(value[i]);
                    if (null != evaluateValue[i] && !evaluateValue[i].equals("")) {
                        try {
                            itemRes.evaluateValue = BigInteger.valueOf(Integer.valueOf(evaluateValue[i]).intValue());
                        }
                        catch (NumberFormatException e) {
                            LicDebugTracer.trace("NELicenseInfo:itemFunc.evaluateValue:" + itemRes.evaluateValue);
                        }
                    }
                    if (null != endDate[i] && !endDate[i].equals("")) {
                        itemRes.endDate = endDate[i];
                    }
                    listRes.add(itemRes);
                }
            }
            if (null == (list = this.taskAndNeMap.get(taskId))) {
                list = new HashSet<String>();
                this.taskAndNeMap.put(taskId, list);
            }
            if (list.contains(table.getString("fdn"))) {
                return false;
            }
            list.add(table.getString("fdn"));
            this.exportInfoMap.put(table.getString("fdn"), licInfo);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LicenseTaskPanel.getInstance().refreshData(taskId);
                    }
                });
            }
            catch (Exception e) {
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
            if (this.isFinish(taskId)) {
                NeLicenseTask task = LicenseTaskPanel.getInstance().getTaskInfo(taskId);
                if (task.getType() == 2) {
                    this.dealSynchTypeTask(taskId, task);
                } else {
                    LicDebugTracer.trace("NELicenseInfo:export taskId:" + taskId);
                    this.export(taskId);
                }
            }
            return true;
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
            return false;
        }
    }

    private void dealSynchTypeTask(int taskId, NeLicenseTask task) {
        Set<String> fdnlist = this.taskAndNeMap.get(taskId);
        if (null == fdnlist || fdnlist.size() == 0) {
            GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exetaskfailured", new String[]{String.valueOf(task.getTaskId()), this.getType(task.getType())}));
        } else if (TaskProcess.getInstance().get((int)task.getTaskId()).total == fdnlist.size()) {
            GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exetasksucceeded", new String[]{String.valueOf(task.getTaskId()), this.getType(task.getType())}));
        } else {
            GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exeexporttaskpartsuccess", new String[]{String.valueOf(task.getTaskId()), this.getType(task.getType())}));
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    QueryLicensePanel.getInstance().refresh();
                }
            });
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
    }

    public boolean isFinish(int taskId) {
        Set<String> list = this.taskAndNeMap.get(taskId);
        Set<String> listOfFail = this.taskAndNeOfFailMap.get(taskId);
        if (null == list && null == listOfFail) {
            return false;
        }
        if (null != list && null == listOfFail) {
            return list.size() == TaskProcess.getInstance().get((int)taskId).total;
        }
        if (null == list && null != listOfFail) {
            return listOfFail.size() == TaskProcess.getInstance().get((int)taskId).total;
        }
        return listOfFail.size() + list.size() == TaskProcess.getInstance().get((int)taskId).total;
    }

    public boolean hasSubTask(int taskId, String fdn) {
        Set<String> list = this.taskAndNeOfFailMap.get(taskId);
        if (null == list) {
            list = new HashSet<String>();
            this.taskAndNeOfFailMap.put(taskId, list);
        }
        if (list.contains(fdn)) {
            return true;
        }
        list.add(fdn);
        return false;
    }

    public boolean hasSubTask(NeLicenseTask task, String fdn) {
        int taskId = task.getTaskId();
        Set<String> failedList = this.taskAndNeOfFailMap.get(taskId);
        Set<String> successList = this.taskAndNeMap.get(taskId);
        if (task.getState() != 0) {
            if (null == failedList) {
                failedList = new HashSet<String>();
                this.taskAndNeOfFailMap.put(taskId, failedList);
            }
            if (this.isContained(successList, failedList, fdn, task)) {
                return true;
            }
            failedList.add(fdn);
        } else {
            if (null == successList) {
                successList = new HashSet<String>();
                this.taskAndNeMap.put(taskId, successList);
            }
            if (this.isContained(successList, failedList, fdn, task)) {
                return true;
            }
            successList.add(fdn);
        }
        this.addSubTaskToMap(task);
        return false;
    }

    private void addSubTaskToMap(NeLicenseTask task) {
        List<Integer> subTaskList = this.taskAndSubTaskIdMap.get(task.getTaskId());
        if (null == subTaskList) {
            subTaskList = new ArrayList<Integer>();
            this.taskAndSubTaskIdMap.put(task.getTaskId(), subTaskList);
        }
        subTaskList.add(task.getSubTaskId());
    }

    private boolean isContained(Set<String> successList, Set<String> failedList, String fdn, NeLicenseTask task) {
        HashSet<String> list = new HashSet<String>();
        if (successList != null) {
            list.addAll(successList);
        }
        if (failedList != null) {
            list.addAll(failedList);
        }
        return list.contains(fdn) && this.isInSubTaskMap(task);
    }

    private boolean isInSubTaskMap(NeLicenseTask task) {
        List<Integer> list = this.taskAndSubTaskIdMap.get(task.getTaskId());
        if (null == list || list.size() == 0) {
            return false;
        }
        return list.contains(task.getSubTaskId());
    }

    public void export(int taskId) {
        Set<String> fdnlist = this.taskAndNeMap.get(taskId);
        int taskType = LicenseTaskPanel.getInstance().getTaskType(taskId);
        if ((null == fdnlist || fdnlist.size() == 0) && this.taskAndNeOfFailMap.get(taskId).size() == TaskProcess.getInstance().get((int)taskId).total) {
            GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exetaskfailured", new String[]{String.valueOf(taskId), this.getType(taskType), ExportNeLicInfoMgr.getInstance().getExprotFile(taskId)}));
            return;
        }
        if (fdnlist == null || fdnlist.size() == 0) {
            LicDebugTracer.trace("NELicenseInfo:fdnlist should not be null or length of 0.");
            return;
        }
        LicNeLicenseInfo[] licInfoArray = new LicNeLicenseInfo[fdnlist.size()];
        int i = 0;
        for (String fdn : fdnlist) {
            LicDebugTracer.trace("NELicenseInfo:export fdn:" + fdn);
            licInfoArray[i++] = this.exportInfoMap.get(fdn);
        }
        String filePath = ExportNeLicInfoMgr.getInstance().getExprotFile(taskId);
        if (TaskProcess.getInstance().get((int)taskId).total == fdnlist.size()) {
            if (null == filePath || filePath.trim().isEmpty()) {
                GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exetasksucceeded", new String[]{String.valueOf(taskId), this.getType(taskType)}));
            } else {
                boolean exportSuccess = ExportNeLicInfoMgr.getInstance().exportToFile(taskId, licInfoArray);
                GuiUtil.showBubble(ResCenter.getInstance().getMergeString(exportSuccess ? "exeexporttasksucceeded" : "exeexporttasksucceededwritefilefail", new String[]{String.valueOf(taskId), this.getType(taskType), filePath}));
            }
        } else if (null == filePath || filePath.trim().isEmpty()) {
            GuiUtil.showBubble(ResCenter.getInstance().getMergeString("exeexporttaskpartsuccess", new String[]{String.valueOf(taskId), this.getType(taskType)}));
        } else {
            boolean exportSuccess = ExportNeLicInfoMgr.getInstance().exportToFile(taskId, licInfoArray);
            GuiUtil.showBubble(ResCenter.getInstance().getMergeString(exportSuccess ? "exeexporttaskpartsucceeded" : "exeexporttaskpartsucceededwritefilefail", new String[]{String.valueOf(taskId), this.getType(taskType), ExportNeLicInfoMgr.getInstance().getExprotFile(taskId)}));
        }
    }

    private String getType(int type) {
        switch (type) {
            case 0: {
                return ResCenter.getInstance().getString("exportneapplyinfo");
            }
            case 1: {
                return ResCenter.getInstance().getString("adjustlicense");
            }
            case 2: {
                return ResCenter.getInstance().getString("synch_esn");
            }
            case 3: {
                return ResCenter.getInstance().getString("invalidationlicnese");
            }
            case 4: {
                return ResCenter.getInstance().getString("loadlicense");
            }
        }
        return "";
    }

    public void delTaskData(int[] taskIds) {
        for (int i = 0; i < taskIds.length; ++i) {
            if (!this.taskAndNeMap.containsKey(taskIds[i])) continue;
            Set<String> fdnlist = this.taskAndNeMap.get(taskIds[i]);
            this.taskAndNeMap.remove(taskIds[i]);
            this.taskAndNeOfFailMap.remove(taskIds[i]);
            if (null == fdnlist) continue;
            for (String fdn : fdnlist) {
                this.exportInfoMap.remove(fdn);
            }
        }
    }

    public Map<Integer, Set<String>> getTaskAndNeMap() {
        return this.taskAndNeMap;
    }

    public Map<Integer, List<Integer>> getTaskAndSubTaskIdMap() {
        return this.taskAndSubTaskIdMap;
    }
}

