/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.event;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.event.EventRegisterFactory;
import com.huawei.u2000.nelicense.event.IEventHandler;
import com.huawei.u2000.nelicense.event.IEventRegister;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import java.util.List;

public class EventDispatch
implements RpcServerPushHandler {
    private static final EventDispatch instance = new EventDispatch();
    private IEventRegister register = EventRegisterFactory.getInstance();

    public static EventDispatch getInstance() {
        return instance;
    }

    private void dispatch(String key, RpcEvent event) {
        List<IEventHandler> handlerList = this.register.getHandlers().get(key);
        if (handlerList != null) {
            for (IEventHandler handler : handlerList) {
                handler.handle(event);
            }
        }
    }

    public void handleServerPush(RpcEvent event) {
        int mainType = event.getMessage().getInt("Type");
        int subType = event.getMessage().getInt("SubType");
        String sourceClass = event.getMessage().getString("SourceClass");
        LicDebugTracer.trace("NELicenseInfo:SecurityEventProcessor | processEvent | get security event, SOURCECLASS:" + sourceClass + " maintype is:<" + mainType + '>' + " sub type is:<" + subType + '>');
        this.dispatch(this.getEventKey(mainType, subType), event);
    }

    public void start() {
        RpcServerPush.addHandler((String)"CommonLicService.NELicEventInternal", (RpcServerPushHandler)this);
    }

    private String getEventKey(int mainType, int subType) {
        return "" + mainType + ':' + subType;
    }

    public void stop() {
        RpcServerPush.removeHandler((RpcServerPushHandler)this);
    }
}

