/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.licdetailsinfo;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.common.LicenseTaskInfoXMLWriter;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.controller.LicOperationManager;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.model.NeLicenseTaskDetail;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class NeRequestExport
implements Runnable {
    private String m_fileName;
    private int m_exportCount = 0;
    private int m_current = 0;
    private Map<String, String> m_neKeys = new HashMap<String, String>();
    private Map<String, String> m_count = new HashMap<String, String>();
    private Map<String, NeLicenseTaskDetail> m_exportDatas = new HashMap<String, NeLicenseTaskDetail>();
    private static IviewLogger logger = IviewLogger.getLogger(NeRequestExport.class);
    private boolean m_isRun = true;
    private int m_taskID = 0;
    private int m_failure = 0;
    private long waitTime = Long.MAX_VALUE;

    public NeRequestExport(String fileName, int taskID) {
        this.m_fileName = fileName;
        this.m_taskID = taskID;
    }

    private void getNeRequestExportInfo() {
        this.m_exportDatas = new HashMap<String, NeLicenseTaskDetail>();
        this.m_count = new HashMap<String, String>();
        this.m_current = 0;
        Set<NeLicenseTask> oNeLicTaskSet = LicOperationManager.getInstance().getNeLicenseTask();
        for (NeLicenseTask oTask : oNeLicTaskSet) {
            int iTaskID = oTask.getTaskId();
            String strFDN = oTask.getFdn();
            String strNeName = oTask.getNeName();
            if (iTaskID != this.m_taskID) continue;
            if (this.m_neKeys.get(strFDN) == null || !strNeName.equals(this.m_neKeys.get(strFDN))) {
                this.m_neKeys.put(strFDN, strNeName);
            }
            ++this.m_exportCount;
        }
    }

    public void startTask() {
        this.getNeRequestExportInfo();
        Thread thread = new Thread(this);
        thread.start();
    }

    public boolean isRun() {
        return this.m_isRun;
    }

    public int getTaskId() {
        return this.m_taskID;
    }

    public void cancelTask() {
        this.m_isRun = false;
        this.m_neKeys.clear();
        this.m_neKeys = null;
        this.m_exportDatas.clear();
        this.m_exportDatas = null;
        this.m_count.clear();
        this.m_count = null;
        StringBuffer message = new StringBuffer();
        if (this.m_taskID != 0) {
            message.append("The task: ").append(this.m_taskID).append(" be terminate!");
            logger.debug((Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_current < this.m_exportCount) {
            NeRequestExport neRequestExport = this;
            synchronized (neRequestExport) {
                try {
                    this.wait(this.waitTime);
                }
                catch (InterruptedException e) {
                    StringBuffer message = new StringBuffer();
                    message.append("Fail to Receive the data at ").append(this.m_current).append(" of ").append(this.m_exportCount).append("!");
                    logger.error((Object)message, (Throwable)e);
                    DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (Object)message);
                }
            }
        }
        logger.debug((Object)("Have Exported " + this.m_current + " of " + this.m_exportCount));
        if (this.m_current >= this.m_exportCount) {
            if (this.m_failure < this.m_exportCount) {
                LicenseTaskInfoXMLWriter.getInstance().save(this.m_exportDatas, this.m_fileName);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NeRequestExport.this.cancelTask();
                    String message = "string";
                    String reason = ResCenter.getInstance().getString("exportlicensetaskrequest_failure_all");
                    message = NeRequestExport.this.m_failure < NeRequestExport.this.m_exportCount ? ResCenter.getInstance().getString("exportlicensetaskrequest_success") : ResCenter.getInstance().getMergeString("exportlicensetaskrequest_failure", new String[]{reason});
                    GuiUtil.showBubble(message);
                }
            });
        }
    }

    public synchronized void addExportData(NeLicenseTaskDetail taskDetail) {
        if (this.m_neKeys.containsKey(taskDetail.getFdn())) {
            taskDetail.setNeName(this.m_neKeys.get(taskDetail.getFdn()));
            if (taskDetail.getColumn() != null && 0 != taskDetail.getColumn().size()) {
                this.m_exportDatas.put(taskDetail.getFdn(), taskDetail);
            }
            this.m_count.put(taskDetail.getFdn(), "");
            this.m_current = this.m_count.size();
            this.m_failure = this.m_count.size() - this.m_exportDatas.size();
            logger.debug((Object)("Have fetched " + this.m_current + " of " + this.m_exportCount));
            this.notifyAll();
        }
    }
}

