/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.licdetailsinfo;

import com.huawei.u2000.nelicense.common.ASNInvoker;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.LicenseDetailInfoXMLWriter;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.event.handlers.QueryNeLicenseDetailInfoHandler;
import com.huawei.u2000.nelicense.model.NeLicenseDetailInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.util.ProgressHandler;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class LicSaveTask
implements Runnable,
QueryNeLicenseDetailInfoHandler.QueryLicDetailInfoEventListener {
    private ProgressHandler handler;
    private JProgressBar progressBar;
    private Map<String, NeLicenseDetailInfo> data;
    private int total;
    private int current;
    private String fileName;
    private Map<String, String> keys;
    private int taskId = 0;
    private boolean isCanel = false;
    private long waitTime = Long.MAX_VALUE;

    public LicSaveTask(int total, Map<String, String> fdns, String file, String[] arrayFDN) {
        this.total = total;
        this.fileName = file;
        this.keys = fdns;
    }

    public boolean startTask() {
        this.handler = ProgressHandler.getInstance();
        this.data = new HashMap<String, NeLicenseDetailInfo>();
        if (this.total == 0) {
            return false;
        }
        this.createProgressDialog(FrameworkUtilities.getMainFrame());
        Thread thread = new Thread(this);
        thread.setName("LicSaveTaskTrhead");
        thread.start();
        return true;
    }

    public synchronized void addData(NeLicenseDetailInfo info) {
        if (this.keys.containsKey(info.getFdn())) {
            info.setNeName(this.keys.get(info.getFdn()));
            this.data.put(info.getFdn(), info);
            this.current = this.data.size();
            LicDebugTracer.trace("NELicenseInfo:current:" + this.current + " total:" + this.total + " add fdn:" + info.getFdn());
            this.notifyAll();
        }
    }

    public int getTaskId() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int[] result = ASNInvoker.getInstance().queryNeLicenseDetailInfo(this.keys.keySet().toArray(new String[0]));
            if (result == null || result[0] != 0) {
                this.cancelTask();
                return;
            }
            this.taskId = result[1];
            QueryNeLicenseDetailInfoHandler.getInstance().addQueryLicDetailInfoEventListener(this.taskId, this);
            this.progressBar.setStringPainted(true);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(this.total);
            this.progressBar.setValue(0);
            this.handler.showProgress();
        }
        catch (Exception e1) {
            if (!GuiUtil.handleException(e1)) {
                LicDebugTracer.trace("NELicenseInfo:" + e1);
                LicDebugTracer.trace(e1);
            }
            QueryNeLicenseDetailInfoHandler.getInstance().removeQueryLicDetailInfoEventListener(this.taskId);
            return;
        }
        while (this.current < this.total) {
            LicSaveTask licSaveTask = this;
            synchronized (licSaveTask) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LicSaveTask.this.progressBar.setValue(LicSaveTask.this.current);
                    }
                });
                try {
                    this.wait(this.waitTime);
                }
                catch (InterruptedException e) {
                    LicDebugTracer.trace("NELicenseInfo:" + e);
                    LicDebugTracer.trace(e);
                }
            }
        }
        LicDebugTracer.trace("NELicensInfo:current:" + this.current + " total:" + this.total);
        if (this.current >= this.total) {
            QueryNeLicenseDetailInfoHandler.getInstance().removeQueryLicDetailInfoEventListener(this.taskId);
            LicenseDetailInfoXMLWriter.getInstance().save(this.data, this.fileName);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LicSaveTask.this.progressBar.setValue(LicSaveTask.this.total);
                    LicSaveTask.this.cancelTask();
                    GuiUtil.showBubble(ResCenter.getInstance().getString("exportlicensedetailinfo_success"));
                }
            });
        }
    }

    public boolean isRun() {
        return !this.isCanel;
    }

    public void cancelTask() {
        this.handler.removeProgress(this.progressBar);
        QueryNeLicenseDetailInfoHandler.getInstance().removeQueryLicDetailInfoEventListener(this.taskId);
        this.isCanel = true;
        LicDebugTracer.trace("NELicenseInfo:the task:" + this.taskId + " be terminate, the progress:" + this.progressBar.getValue());
    }

    private void createProgressDialog(Component component) {
        Window window = null;
        if (null != component && (window = SwingUtilities.windowForComponent(component)) == null && component instanceof Window) {
            window = (Window)component;
        }
        IStop istop = new IStop(){

            public void stop() {
                LicSaveTask.this.cancelTask();
            }
        };
        this.handler.setProcess(window);
        this.progressBar = new JProgressBar();
        this.handler.addProgress(this.progressBar, istop);
    }

    @Override
    public void fireLicDetailInfoReceived(NeLicenseDetailInfo info) {
        this.addData(info);
    }
}

