/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.licdetailsinfo;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.LicenseDetailInfoXMLWriter;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.controller.NeLicenseDetailManager;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.model.NeLicenseDetailInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.util.ProgressHandler;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class LicExportTask
implements Runnable {
    private String m_fileName;
    private int m_exportCount;
    private int m_current;
    private Map<String, String> m_neKeys;
    private int m_taskId = 0;
    private ProgressHandler m_handler;
    private JProgressBar m_progressBar;
    private Map<String, NeLicenseDetailInfo> m_exportData;
    private boolean m_isRun = true;
    private String[] m_arrayFDN;
    private long waitTime = Long.MAX_VALUE;

    public LicExportTask(int exportCount, Map<String, String> neFDNs, String fileName, String[] arrayFDN) {
        this.m_exportCount = exportCount;
        this.m_neKeys = neFDNs;
        this.m_fileName = fileName;
        this.m_arrayFDN = arrayFDN;
    }

    private void setInitVariable() {
        this.m_handler = ProgressHandler.getInstance();
        this.m_exportData = new HashMap<String, NeLicenseDetailInfo>();
        this.m_current = 0;
    }

    public boolean startTask() {
        this.setInitVariable();
        if (this.m_exportCount <= 0) {
            DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)"Haven't selected any data to export!");
            return false;
        }
        if (!this.createProgressDialog()) {
            this.cancelTask();
            return false;
        }
        Thread thread = new Thread(this);
        thread.setName("LicExportTaskTrhead");
        thread.start();
        return true;
    }

    private boolean createProgressDialog() {
        Window window = null;
        JFrame component = FrameworkUtilities.getMainFrame();
        if (null != component && (window = SwingUtilities.windowForComponent(component)) == null && component instanceof Window) {
            window = component;
        }
        IStop iStop = new IStop(){

            public void stop() {
                LicExportTask.this.cancelTask();
            }
        };
        try {
            this.m_handler.setProcess(window);
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
            DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)"Fail to create the export task!");
            return false;
        }
        this.m_progressBar = new JProgressBar();
        this.m_handler.addProgress(this.m_progressBar, iStop);
        return true;
    }

    public boolean isRun() {
        return this.m_isRun;
    }

    public int getTaskId() {
        return this.m_taskId;
    }

    public void cancelTask() {
        this.m_handler.removeProgress(this.m_progressBar);
        this.m_isRun = false;
        this.m_neKeys.clear();
        this.m_neKeys = null;
        this.m_exportData.clear();
        this.m_exportData = null;
        QueryLicensePanel.getInstance().cancelSaveTask(this.m_taskId);
        if (this.m_taskId != 0) {
            String message = "The task: " + this.m_taskId + " be terminate, the progress: " + this.m_progressBar.getValue();
            LicDebugTracer.trace(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.m_arrayFDN.length < 1) {
            DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)"Can't get any FDN to export!");
            return;
        }
        int[] exportResult = NeLicenseDetailManager.getInstance().getNeLicenseDetailInfo(this.m_arrayFDN);
        int iErrCode = exportResult[0];
        if (0 != iErrCode) {
            this.cancelTask();
            DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)"Send request fail!");
            return;
        }
        this.m_taskId = exportResult[1];
        this.m_progressBar.setStringPainted(true);
        this.m_progressBar.setMinimum(0);
        this.m_progressBar.setMaximum(this.m_exportCount);
        this.m_progressBar.setValue(0);
        this.m_handler.showProgress();
        while (this.m_current < this.m_exportCount) {
            LicExportTask licExportTask = this;
            synchronized (licExportTask) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LicExportTask.this.m_progressBar.setValue(LicExportTask.this.m_current);
                    }
                });
                try {
                    this.wait(this.waitTime);
                }
                catch (InterruptedException e) {
                    String message = "Fail to Receive the data at " + this.m_current + " of " + this.m_exportCount + "!";
                    LicDebugTracer.trace(message);
                    DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)message);
                }
            }
        }
        LicDebugTracer.trace("Have Exported " + this.m_current + " of " + this.m_exportCount);
        if (this.m_current >= this.m_exportCount) {
            LicenseDetailInfoXMLWriter.getInstance().save(this.m_exportData, this.m_fileName);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LicExportTask.this.m_progressBar.setValue(LicExportTask.this.m_exportCount);
                    LicExportTask.this.cancelTask();
                    String message = ResCenter.getInstance().getString("exportlicensedetailinfo_success");
                    GuiUtil.showBubble(message);
                }
            });
        }
    }

    public synchronized void addExportData(NeLicenseDetailInfo detailInfo) {
        if (this.m_neKeys.containsKey(detailInfo.getFdn())) {
            detailInfo.setNeName(this.m_neKeys.get(detailInfo.getFdn()));
            if (detailInfo.getColumns() == null || detailInfo.getColumns().size() == 0) {
                ArrayList<String> oDetailHead = new ArrayList<String>();
                oDetailHead.add("details");
                ArrayList<String[]> oDetailDatas = new ArrayList<String[]>();
                String[] data = new String[]{this.m_neKeys.get(detailInfo.getFdn())};
                oDetailDatas.add(data);
                detailInfo.setColumns(oDetailHead);
                detailInfo.setDatas(oDetailDatas);
            }
            this.m_exportData.put(detailInfo.getFdn(), detailInfo);
            this.m_current = this.m_exportData.size();
            LicDebugTracer.trace("Have fetched " + this.m_current + " of " + this.m_exportCount);
            this.notifyAll();
        }
    }
}

