/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.controller;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.NELicenseModuleManager;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicBaseInfo;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicBaseInfoLst;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryBaseInfoLstReq;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryBaseInfoLstRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryVerNameLstRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicVersionLst;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.controller.LicAsynCommController;
import com.huawei.u2000.nelicense.common.interfaces.IASNMessageListener;
import com.huawei.u2000.nelicense.common.interfaces.IObjectDeallocator;
import com.huawei.u2000.nelicense.common.interfaces.MessageEvent;
import com.huawei.u2000.nelicense.model.FilterCondition;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class NeLicenseInfoManager
implements IObjectDeallocator,
IASNMessageListener {
    private static NeLicenseInfoManager m_instance;
    private LicAsynCommController m_oAsynCommCtr = LicAsynCommController.getInstance();
    private Vector<String> m_oVersionVec;
    private Map<String, NeLicenseBaseInfo> m_oLicBaseInfoMap;
    private boolean m_isFinishGettingVersion = false;
    private boolean m_isFinishGettingLicInfo = false;
    private Object m_oSynObj;
    private BaseCommManager m_commMgr = BaseCommManager.getInstance();
    private static final int DEFAULT_TIME_OUT = 10000;
    public static final FilterCondition DEFAULT_FILTER_CONDITION;

    private NeLicenseInfoManager() {
        this.m_oVersionVec = new Vector();
        this.m_oLicBaseInfoMap = new HashMap<String, NeLicenseBaseInfo>();
        this.m_oSynObj = new Object();
    }

    public static synchronized NeLicenseInfoManager getInstance() {
        if (null == m_instance) {
            m_instance = new NeLicenseInfoManager();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToNull() {
        if (null != this.m_oAsynCommCtr) {
            this.m_oAsynCommCtr.setToNull();
        }
        if (this.m_oVersionVec.size() >= 0) {
            this.m_oVersionVec.clear();
            this.m_oVersionVec = null;
        }
        if (this.m_oLicBaseInfoMap.size() >= 0) {
            this.m_oLicBaseInfoMap.clear();
            this.m_oLicBaseInfoMap = null;
        }
        if (null != this.m_oSynObj) {
            Object object = this.m_oSynObj;
            synchronized (object) {
                this.m_oSynObj.notifyAll();
            }
            this.m_oSynObj = null;
        }
        if (this.m_commMgr != null) {
            this.m_commMgr = null;
        }
        m_instance = null;
    }

    public String[] getAllVersion() {
        if (!this.m_isFinishGettingVersion) {
            this.synVersionInfo();
        }
        return this.m_oVersionVec.toArray(new String[0]);
    }

    public NeLicenseBaseInfo[] getAllNeLicenseInfo() {
        return this.getNeLicenseInfo(DEFAULT_FILTER_CONDITION);
    }

    private boolean isAllCondition(FilterCondition oCondition) {
        return oCondition.getStatusArray().length == DEFAULT_FILTER_CONDITION.getStatusArray().length && DEFAULT_FILTER_CONDITION.getVersion().equals(oCondition.getVersion()) && (null == oCondition.getNeFdnArray() || DEFAULT_FILTER_CONDITION.getNeFdnArray().length == oCondition.getNeFdnArray().length);
    }

    public NeLicenseBaseInfo[] getNeLicenseInfo(FilterCondition oCondition) {
        if (this.m_isFinishGettingLicInfo) {
            return this.filterNeLicenseInfo(oCondition);
        }
        this.synNeLicenseInfo(oCondition);
        if (!this.isAllCondition(oCondition)) {
            this.m_isFinishGettingLicInfo = false;
        }
        return this.m_oLicBaseInfoMap.values().toArray(new NeLicenseBaseInfo[0]);
    }

    public void refresh() {
        this.m_isFinishGettingVersion = false;
        this.m_isFinishGettingLicInfo = false;
    }

    private NeLicenseBaseInfo[] filterNeLicenseInfo(FilterCondition oCondition) {
        Vector<NeLicenseBaseInfo> oNeLicInfoVec = new Vector<NeLicenseBaseInfo>();
        String[] strFdns = oCondition.getNeFdnArray();
        int[] iStatusArray = oCondition.getStatusArray();
        String strVersion = oCondition.getVersion();
        boolean isAllVersion = false;
        if ("".equals(strVersion)) {
            isAllVersion = true;
        }
        if (null == strFdns || 0 == strFdns.length) {
            for (NeLicenseBaseInfo oLicInfo : this.m_oLicBaseInfoMap.values()) {
                this.addNELicInfo(oNeLicInfoVec, iStatusArray, strVersion, isAllVersion, oLicInfo);
            }
        } else {
            for (String strFdn : strFdns) {
                NeLicenseBaseInfo oLicInfo = this.m_oLicBaseInfoMap.get(strFdn);
                this.addNELicInfo(oNeLicInfoVec, iStatusArray, strVersion, isAllVersion, oLicInfo);
            }
        }
        return oNeLicInfoVec.toArray(new NeLicenseBaseInfo[0]);
    }

    private void addNELicInfo(Vector<NeLicenseBaseInfo> oNeLicInfoVec, int[] iStatusArray, String strVersion, boolean isAllVersion, NeLicenseBaseInfo oLicInfo) {
        int iStatus;
        if (isAllVersion) {
            int iStatus2 = oLicInfo.getStatus();
            if (this.isContainStatus(iStatus2, iStatusArray)) {
                oNeLicInfoVec.add(oLicInfo);
            }
        } else if (strVersion.equals(oLicInfo.getVersion()) && this.isContainStatus(iStatus = oLicInfo.getStatus(), iStatusArray)) {
            oNeLicInfoVec.add(oLicInfo);
        }
    }

    private boolean isContainStatus(int iStatus, int[] iStatusArray) {
        for (int value : iStatusArray) {
            if (value != iStatus) continue;
            return true;
        }
        return false;
    }

    private void synVersionInfo() {
        int iErrCode = 0;
        final AsnNeLicQueryVerNameLstRsp oVersionRsp = new AsnNeLicQueryVerNameLstRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = BaseCommManager.getInstance().sendSyncMsg(NeLicenseInfoManager.this.m_commMgr.getMSGHead(99820101, 1), null, oVersionRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        if (0 == iErrCode) {
            iErrCode = oVersionRsp.iErrCode.intValue();
            this.m_oVersionVec.clear();
            if (0 == iErrCode) {
                AsnNeLicVersionLst oVersionLst = oVersionRsp.oAsnNeLicVersionLst;
                for (int i = 0; i < oVersionLst.size(); ++i) {
                    this.m_oVersionVec.add(new String((byte[])oVersionLst.get(i)));
                }
                this.m_isFinishGettingVersion = true;
            } else {
                String message = ResCenter.getInstance().getString("getVersionError");
                DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)message);
            }
        }
    }

    private void synNeLicenseInfo(FilterCondition filterCondition) {
        int i;
        int iErrCode = 0;
        final AsnNeLicQueryBaseInfoLstRsp oNeLicInfoRsp = new AsnNeLicQueryBaseInfoLstRsp();
        final AsnNeLicQueryBaseInfoLstReq oNeInfoListReq = new AsnNeLicQueryBaseInfoLstReq();
        int[] statusArray = filterCondition.getStatusArray();
        String[] fdnArray = filterCondition.getNeFdnArray();
        String version = filterCondition.getVersion();
        int fdnArrayCount = 0;
        int statusArrayCount = 0;
        if (null != fdnArray) {
            fdnArrayCount = fdnArray.length;
        }
        if (null != statusArray) {
            statusArrayCount = statusArray.length;
        }
        oNeInfoListReq.oAsnNeLicLicenseStateLst.clear();
        oNeInfoListReq.oAsnNeLicFdnLst.clear();
        oNeInfoListReq.oAsnNeLicVersionLst.clear();
        for (i = 0; i < statusArrayCount; ++i) {
            if (null == statusArray) continue;
            oNeInfoListReq.oAsnNeLicLicenseStateLst.addElement(BigInteger.valueOf(statusArray[i]));
        }
        for (i = 0; i < fdnArrayCount; ++i) {
            if (null == fdnArray) continue;
            oNeInfoListReq.oAsnNeLicFdnLst.addElement(fdnArray[i].getBytes());
        }
        if (!"".equals(version)) {
            oNeInfoListReq.oAsnNeLicVersionLst.addElement(version.getBytes());
        }
        if (!BaseCommManager.getIsStandAlone()) {
            oNeInfoListReq.iUserID = BigInteger.valueOf(NELicenseModuleManager.getUserID());
        } else {
            int tmpUserID = 0;
            oNeInfoListReq.iUserID = BigInteger.valueOf(tmpUserID);
        }
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = BaseCommManager.getInstance().sendSyncMsg(NeLicenseInfoManager.this.m_commMgr.getMSGHead(99820102, 1), oNeInfoListReq, oNeLicInfoRsp);
                LicDebugTracer.trace("NELicenseInfo:oNeInfoListReq.oAsnNeLicLicenseStateLst::" + oNeInfoListReq.oAsnNeLicLicenseStateLst);
                LicDebugTracer.trace("NELicenseInfo:oNeInfoListReq.oAsnNeLicFdnLst::" + oNeInfoListReq.oAsnNeLicFdnLst);
                LicDebugTracer.trace("NELicenseInfo:oNeInfoListReq.oAsnNeLicVersionLst::" + oNeInfoListReq.oAsnNeLicVersionLst);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        if (0 == iErrCode) {
            iErrCode = oNeLicInfoRsp.iErrCode.intValue();
            if (0 != iErrCode) {
                String message = ResCenter.getInstance().getString("getNEBaseInfoError");
                DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)message);
                return;
            }
            if (!this.m_isFinishGettingLicInfo) {
                this.m_oLicBaseInfoMap.clear();
                AsnNeLicBaseInfoLst oNEInfoList = oNeLicInfoRsp.oAsnNeLicBaseInfoLst;
                for (Object oLicInfo : oNEInfoList) {
                    AsnNeLicBaseInfo oBaseInfo = (AsnNeLicBaseInfo)oLicInfo;
                    String strFdn = new String(oBaseInfo.strFdn);
                    String strName = new String(oBaseInfo.strLabel);
                    String strDesc = new String(oBaseInfo.strDesc);
                    String strType = new String(oBaseInfo.strNeType);
                    String strVer = new String(oBaseInfo.strVersion);
                    String strEsn = new String(oBaseInfo.strEsn);
                    if ("".equals(strEsn.trim())) {
                        strEsn = ResCenter.getInstance().getString("unknown_esn");
                    }
                    int iState = oBaseInfo.iLicState.intValue();
                    NeLicenseBaseInfo oNeLicBaseInfo = new NeLicenseBaseInfo();
                    oNeLicBaseInfo.setLabel(strName);
                    oNeLicBaseInfo.setDesc(strDesc);
                    oNeLicBaseInfo.setNeType(strType);
                    oNeLicBaseInfo.setVersion(strVer);
                    oNeLicBaseInfo.setEsn(strEsn);
                    oNeLicBaseInfo.setStatus(iState);
                    oNeLicBaseInfo.setFdn(strFdn);
                    this.m_oLicBaseInfoMap.put(strFdn, oNeLicBaseInfo);
                }
                this.m_isFinishGettingLicInfo = true;
            }
        }
    }

    @Override
    public void release() {
        this.m_oAsynCommCtr.removeAsnMessageListener(this);
        this.m_oVersionVec.clear();
        this.m_oVersionVec = null;
        this.m_oLicBaseInfoMap.clear();
        this.m_oLicBaseInfoMap = null;
        m_instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessage(MessageEvent event) {
        int iErrCode = 0;
        if (event != null) {
            FStruct oAsn = event.getData();
            switch (event.getCmdCode()) {
                case 99820101: {
                    if (!(oAsn instanceof AsnNeLicQueryVerNameLstRsp)) break;
                    this.dealVersionInfo(oAsn);
                    break;
                }
                case 99820102: {
                    if (!(oAsn instanceof AsnNeLicQueryBaseInfoLstRsp)) break;
                    AsnNeLicQueryBaseInfoLstRsp oNEInfoListRsp = (AsnNeLicQueryBaseInfoLstRsp)oAsn;
                    iErrCode = oNEInfoListRsp.iErrCode.intValue();
                    this.dealBaseInfoList(iErrCode, oNEInfoListRsp);
                    break;
                }
            }
            Object object = this.m_oSynObj;
            synchronized (object) {
                this.m_oSynObj.notifyAll();
            }
        }
    }

    private void dealVersionInfo(FStruct oAsn) {
        AsnNeLicQueryVerNameLstRsp oVersionRsp = (AsnNeLicQueryVerNameLstRsp)oAsn;
        int iErrCode = oVersionRsp.iErrCode.intValue();
        if (0 == iErrCode) {
            AsnNeLicVersionLst oVersionLst = oVersionRsp.oAsnNeLicVersionLst;
            for (int i = 0; i < oVersionLst.size(); ++i) {
                this.m_oVersionVec.add(new String((byte[])oVersionLst.get(i)));
            }
            this.m_isFinishGettingVersion = true;
        } else {
            String message = ResCenter.getInstance().getString("getVersionError");
            DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)message);
        }
    }

    private void dealBaseInfoList(int iErrCode, AsnNeLicQueryBaseInfoLstRsp oNEInfoListRsp) {
        if (0 == iErrCode) {
            AsnNeLicBaseInfoLst oNEInfoList = oNEInfoListRsp.oAsnNeLicBaseInfoLst;
            for (Object oLicInfo : oNEInfoList) {
                AsnNeLicBaseInfo oBaseInfo = (AsnNeLicBaseInfo)oLicInfo;
                String strFdn = new String(oBaseInfo.strFdn);
                String strName = new String(oBaseInfo.strLabel);
                String strDesc = new String(oBaseInfo.strDesc);
                String strType = new String(oBaseInfo.strNeType);
                String strVer = new String(oBaseInfo.strVersion);
                String strEsn = new String(oBaseInfo.strEsn);
                if ("".equals(strEsn.trim())) {
                    strEsn = ResCenter.getInstance().getString("unknown_esn");
                }
                int iState = oBaseInfo.iLicState.intValue();
                NeLicenseBaseInfo oNeLicBaseInfo = new NeLicenseBaseInfo();
                oNeLicBaseInfo.setLabel(strName);
                oNeLicBaseInfo.setDesc(strDesc);
                oNeLicBaseInfo.setNeType(strType);
                oNeLicBaseInfo.setVersion(strVer);
                oNeLicBaseInfo.setEsn(strEsn);
                oNeLicBaseInfo.setStatus(iState);
                oNeLicBaseInfo.setFdn(strFdn);
                this.m_oLicBaseInfoMap.put(strFdn, oNeLicBaseInfo);
            }
            this.m_isFinishGettingLicInfo = true;
        } else {
            String message = ResCenter.getInstance().getString("getNEBaseInfoError");
            DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)message);
        }
    }

    static {
        DEFAULT_FILTER_CONDITION = new FilterCondition(new int[]{0, 1, 2, 3, 4}, "", new String[0]);
    }
}

