/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.controller;

import com.huawei.u2000.nelicense.NELicenseModuleManager;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicPairData;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTableDataValue;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskEventDataRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskEventDataTableRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskReq;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskRsp;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.controller.LicAsynDetailController;
import com.huawei.u2000.nelicense.common.controller.LicOperationManager;
import com.huawei.u2000.nelicense.common.interfaces.IASNMessageListener;
import com.huawei.u2000.nelicense.common.interfaces.IObjectDeallocator;
import com.huawei.u2000.nelicense.common.interfaces.MessageEvent;
import com.huawei.u2000.nelicense.common.licdetailsinfo.LicExportTask;
import com.huawei.u2000.nelicense.common.licdetailsinfo.NeRequestExport;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.model.NeLicenseDetailInfo;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.model.NeLicenseTaskDetail;
import com.huawei.u2000.nelicense.model.NeLicenseTaskItemInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.util.DebugTracer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class NeLicenseDetailManager
implements IObjectDeallocator,
IASNMessageListener {
    private static NeLicenseDetailManager m_instance;
    private LicAsynDetailController m_oAsyDetailCtr = LicAsynDetailController.getInstance();
    private BaseCommManager m_comMgr;
    private Object m_oSynObj;

    private NeLicenseDetailManager() {
        this.m_oAsyDetailCtr.addAsynMessageListener(this);
        this.m_comMgr = BaseCommManager.getInstance();
        this.m_oSynObj = new Object();
    }

    public static synchronized NeLicenseDetailManager getInstance() {
        if (null == m_instance) {
            m_instance = new NeLicenseDetailManager();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToNull() {
        if (null != this.m_oAsyDetailCtr) {
            this.m_oAsyDetailCtr.setToNull();
        }
        if (null != this.m_oSynObj) {
            Object object = this.m_oSynObj;
            synchronized (object) {
                this.m_oSynObj.notifyAll();
            }
            this.m_oSynObj = null;
        }
        if (this.m_comMgr != null) {
            this.m_comMgr = null;
        }
        m_instance = null;
    }

    public int[] getNeLicenseDetailInfo(String[] neFDN) {
        int iErrCode;
        int[] detailResult = new int[]{0, 0};
        AsnNeLicTaskReq oNeTaskReq = new AsnNeLicTaskReq();
        AsnNeLicTaskRsp oNeTaskRsp = new AsnNeLicTaskRsp();
        for (String curFDN : neFDN) {
            oNeTaskReq.oAsnNeLicFdnLst.addElement(curFDN.getBytes());
        }
        int userID = NELicenseModuleManager.getUserID();
        oNeTaskReq.iUserID = BigInteger.valueOf(userID);
        DebugTracer.trace((String)("NELicenseInfo:Ready to post the current userID <" + userID + "> to backgroud!"));
        detailResult[0] = iErrCode = this.m_comMgr.sendSyncMsg(this.m_comMgr.getMSGHead(99820151, 1), oNeTaskReq, oNeTaskRsp);
        if (0 != iErrCode) {
            detailResult[1] = 0;
            return detailResult;
        }
        if (0 != oNeTaskRsp.iErrCode.intValue()) {
            detailResult[0] = oNeTaskRsp.iErrCode.intValue();
            detailResult[1] = 0;
            return detailResult;
        }
        detailResult[1] = oNeTaskRsp.iTaskID.intValue();
        return detailResult;
    }

    @Override
    public void release() {
        this.m_oAsyDetailCtr.removeAsynMessageListener(this);
        m_instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessage(MessageEvent event) {
        if (event != null) {
            FStruct oAsn = event.getData();
            this.analysisMessage(event, oAsn);
            Object object = this.m_oSynObj;
            synchronized (object) {
                this.m_oSynObj.notifyAll();
            }
        }
    }

    private void analysisMessage(MessageEvent event, FStruct oAsn) {
        switch (event.getCmdCode()) {
            case 99820258: {
                if (!(oAsn instanceof AsnNeLicTaskEventDataTableRsp)) break;
                AsnNeLicTaskEventDataTableRsp oNeTaskDataTableRsp = (AsnNeLicTaskEventDataTableRsp)oAsn;
                this.analysisTaskEventDataTable(oNeTaskDataTableRsp);
                break;
            }
            case 99820256: {
                if (!(oAsn instanceof AsnNeLicTaskEventDataRsp)) break;
                AsnNeLicTaskEventDataRsp oNeDataRsp = (AsnNeLicTaskEventDataRsp)oAsn;
                this.analysisTaskEventData(oNeDataRsp);
                break;
            }
        }
    }

    private void analysisTaskEventDataTable(AsnNeLicTaskEventDataTableRsp oNeTaskDataTableRsp) {
        int iErrCode = oNeTaskDataTableRsp.iErrCode.intValue();
        String curFDN = new String(oNeTaskDataTableRsp.strFdn);
        int iTaskID = oNeTaskDataTableRsp.iTaskID.intValue();
        if (0 == iErrCode) {
            List<String> oDetailColumn = this.getNEDetailHeader(oNeTaskDataTableRsp);
            ArrayList<String[]> oDetailDatas = new ArrayList<String[]>();
            this.getNEDetailDatas(oNeTaskDataTableRsp, oDetailDatas);
            NeLicenseDetailInfo curNeDetailInfo = new NeLicenseDetailInfo(oDetailColumn, oDetailDatas, curFDN);
            QueryLicensePanel.getInstance().addDetailTable(curNeDetailInfo, iTaskID);
            for (LicExportTask task : QueryLicensePanel.getInstance().getListTask()) {
                if (task.getTaskId() != iTaskID) continue;
                task.addExportData(curNeDetailInfo);
                break;
            }
        } else {
            DebugTracer.trace((String)("NELicenseInfo:Export NE task information failure, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:Error_Code_" + iErrCode));
        }
    }

    private void analysisTaskEventData(AsnNeLicTaskEventDataRsp oNeDataRsp) {
        int iErrCode = oNeDataRsp.iErrCode.intValue();
        int iTaskID = oNeDataRsp.iTaskID.intValue();
        String curFDN = new String(oNeDataRsp.strFdn);
        int taskType = oNeDataRsp.iTaskType.intValue();
        if (0 == iErrCode) {
            if (4 == taskType) {
                DebugTracer.trace((String)("NELicenseInfo:Upload NE license file success, task ID:" + iTaskID + ", FDN:" + curFDN));
                String message = ResCenter.getInstance().getMergeString("uploadlicensefileinfo_success", new String[]{String.valueOf(iTaskID)});
                GuiUtil.showBubble(message);
            }
            return;
        }
        this.dealErrorMessage(oNeDataRsp);
    }

    private void getNEDetailDatas(AsnNeLicTaskEventDataTableRsp oNeTaskDataTableRsp, List<String[]> oDetailDatas) {
        for (Object dataObj : oNeTaskDataTableRsp.oAsnNeLicTableDataValueLst) {
            if (!(dataObj instanceof AsnNeLicTableDataValue)) continue;
            AsnNeLicTableDataValue oNeDataValue = (AsnNeLicTableDataValue)dataObj;
            String[] arrayData = new String[oNeDataValue.size()];
            for (int i = 0; i < oNeDataValue.size(); ++i) {
                arrayData[i] = new String((byte[])oNeDataValue.elementAt(i));
            }
            oDetailDatas.add(arrayData);
        }
    }

    private List<String> getNEDetailHeader(AsnNeLicTaskEventDataTableRsp oNeTaskDataTableRsp) {
        ArrayList<String> oDetailColumn = new ArrayList<String>();
        for (Object circleObj : oNeTaskDataTableRsp.oAsnNeLicPairDataLst) {
            if (!(circleObj instanceof AsnNeLicPairData)) continue;
            AsnNeLicPairData oPairData = (AsnNeLicPairData)circleObj;
            oDetailColumn.add(new String(oPairData.strValue));
        }
        return oDetailColumn;
    }

    private void dealErrorMessage(AsnNeLicTaskEventDataRsp oNeDataRsp) {
        if (null == oNeDataRsp) {
            return;
        }
        int iTaskID = oNeDataRsp.iTaskID.intValue();
        int taskType = oNeDataRsp.iTaskType.intValue();
        String curFDN = new String(oNeDataRsp.strFdn);
        String strErr = new String(oNeDataRsp.strErr);
        int detailID = QueryLicensePanel.getInstance().getTaskID();
        switch (taskType) {
            case 0: 
            case 1: 
            case 3: {
                this.addExportData(iTaskID, curFDN, strErr);
                break;
            }
            case 5: {
                ArrayList<String> oDetailHead = new ArrayList<String>();
                ArrayList<String[]> oDetailDatas = new ArrayList<String[]>();
                NeLicenseDetailInfo curNeDetailInfo = new NeLicenseDetailInfo(oDetailHead, oDetailDatas, curFDN);
                if (0 != detailID && iTaskID == detailID) {
                    QueryLicensePanel.getInstance().addDetailTable(curNeDetailInfo, iTaskID);
                    DebugTracer.trace((String)("NELicenseInfo:Query NE license Details failure, task ID:" + iTaskID + ", cause:" + strErr));
                    break;
                }
                this.addNEDetailToExportDatas(iTaskID, curFDN, strErr, curNeDetailInfo);
                break;
            }
            case 4: {
                String curNename = this.getNeName(iTaskID, curFDN);
                DebugTracer.trace((String)"NELicenseInfo:Upload NE license file failure********************NeLicenseDetailManager****************************");
                DebugTracer.trace((String)("NELicenseInfo:Upload NE license file failure, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:" + strErr));
                String message = ResCenter.getInstance().getMergeString("uploadlicensefileinfo_failure", new String[]{String.valueOf(iTaskID), curNename, strErr});
                GuiUtil.showBubble(message);
                break;
            }
        }
    }

    private void addNEDetailToExportDatas(int iTaskID, String curFDN, String strErr, NeLicenseDetailInfo curNeDetailInfo) {
        for (LicExportTask task : QueryLicensePanel.getInstance().getListTask()) {
            if (task.getTaskId() != iTaskID) continue;
            task.addExportData(curNeDetailInfo);
            DebugTracer.trace((String)("NELicenseInfo:Export NE license detail failure, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:" + strErr));
            break;
        }
    }

    private void addExportData(int iTaskID, String curFDN, String strErr) {
        HashMap<String, String> detailMap = new HashMap<String, String>();
        ArrayList<NeLicenseTaskItemInfo> resItemList = new ArrayList<NeLicenseTaskItemInfo>();
        ArrayList<NeLicenseTaskItemInfo> funItemList = new ArrayList<NeLicenseTaskItemInfo>();
        NeLicenseTaskDetail neTaskDetail = new NeLicenseTaskDetail(curFDN, iTaskID, detailMap);
        neTaskDetail.setResItemInfo(resItemList);
        neTaskDetail.setFunItemInfo(funItemList);
        for (NeRequestExport task : LicenseTaskPanel.getInstance().getExportList()) {
            if (task.getTaskId() != iTaskID) continue;
            task.addExportData(neTaskDetail);
            DebugTracer.trace((String)("NELicenseInfo:Export NE task information failure, task ID:" + iTaskID + ", FDN:" + curFDN + ", cause:" + strErr));
            break;
        }
    }

    private String getNeName(int iTaskID, String curFDN) {
        String curNename = "";
        Set<NeLicenseTask> oNeLicTaskSet = LicOperationManager.getInstance().getNeLicenseTask();
        for (NeLicenseTask oTask : oNeLicTaskSet) {
            int taskID = oTask.getTaskId();
            String taskFDN = oTask.getFdn();
            if (taskID != iTaskID || !taskFDN.equals(curFDN)) continue;
            curNename = oTask.getNeName();
            break;
        }
        return curNename;
    }
}

