/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.controller;

import com.huawei.u2000.nelicense.NELicenseModuleManager;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicExeTaskReq;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicExeTaskRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicLicenseFileInfo;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryTaskInfoLstReq;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryTaskInfoLstRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicStartTaskReq;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskEventDataMapRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskEventDataRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskInfo;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskReq;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicUpdateLicTaskReq;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicUpdateLicTaskRsp;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.controller.LicAsynCommController;
import com.huawei.u2000.nelicense.common.interfaces.IASNMessageListener;
import com.huawei.u2000.nelicense.common.interfaces.IObjectDeallocator;
import com.huawei.u2000.nelicense.common.interfaces.MessageEvent;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.model.NELicenseFileInfo;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.model.TaskIdInfo;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import java.awt.Component;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class LicOperationManager
implements IObjectDeallocator,
IASNMessageListener {
    private static LicOperationManager m_instance;
    private BaseCommManager m_commMgr;
    private Set<NeLicenseTask> m_oNeLicTaskSet;
    private Object obj = new Object();

    private LicOperationManager() {
        this.m_commMgr = BaseCommManager.getInstance();
        this.m_oNeLicTaskSet = new HashSet<NeLicenseTask>();
    }

    public static synchronized LicOperationManager getInstance() {
        if (null == m_instance) {
            m_instance = new LicOperationManager();
        }
        return m_instance;
    }

    public void setToNull() {
        if (this.m_oNeLicTaskSet.size() >= 0) {
            this.m_oNeLicTaskSet.clear();
            this.m_oNeLicTaskSet = null;
        }
        if (this.m_commMgr != null) {
            this.m_commMgr = null;
        }
        m_instance = null;
    }

    public int loadLicenseFile(NELicenseFileInfo[] oLicFileInfos) {
        int iErrCode = 0;
        final AsnNeLicUpdateLicTaskReq oReq = new AsnNeLicUpdateLicTaskReq();
        for (NELicenseFileInfo oLicFileInfo : oLicFileInfos) {
            AsnNeLicLicenseFileInfo oAsnFileInfo = new AsnNeLicLicenseFileInfo();
            oAsnFileInfo.strFdn = oLicFileInfo.getFdn().getBytes();
            oAsnFileInfo.strFileName = oLicFileInfo.getFileName().getBytes();
            oAsnFileInfo.strLicContent = oLicFileInfo.getLicenseContent().getBytes();
            oReq.oAsnNeLicLicenseFileInfoLst.add(oAsnFileInfo);
        }
        int userID = NELicenseModuleManager.getUserID();
        oReq.iUserID = BigInteger.valueOf(userID);
        LicDebugTracer.trace("NELicenseInfo:Ready to post the current userID <" + userID + "> to backgroud!");
        final AsnNeLicUpdateLicTaskRsp oRsp = new AsnNeLicUpdateLicTaskRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = LicOperationManager.this.m_commMgr.sendSyncMsg(LicOperationManager.this.m_commMgr.getMSGHead(99820159, 1), oReq, oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        if (0 == iErrCode) {
            iErrCode = oRsp.iErrCode.intValue();
        }
        return iErrCode;
    }

    private Set<NeLicenseTask> getNeLicenseTaskFromServer(int iTaskId) {
        int iErrCode = 0;
        final AsnNeLicQueryTaskInfoLstReq oReq = new AsnNeLicQueryTaskInfoLstReq();
        oReq.iTaskID = BigInteger.valueOf(iTaskId);
        HashSet<NeLicenseTask> oNeLicTaskSet = new HashSet<NeLicenseTask>();
        final AsnNeLicQueryTaskInfoLstRsp oRsp = new AsnNeLicQueryTaskInfoLstRsp();
        LicAsynCommController oLicAsynControl = LicAsynCommController.getInstance();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = LicOperationManager.this.m_commMgr.sendSyncMsg(LicOperationManager.this.m_commMgr.getMSGHead(99820103, 1), oReq, oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        if (0 == iErrCode && 0 == (iErrCode = oRsp.iErrCode.intValue())) {
            oLicAsynControl.addAsnMessageListener(this);
            LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer Task size:" + oRsp.oAsnNeLicTaskInfoLst.size());
            for (Object task : oRsp.oAsnNeLicTaskInfoLst) {
                NeLicenseTask neTaskInfo = new NeLicenseTask();
                AsnNeLicTaskInfo oTaskInfo = (AsnNeLicTaskInfo)task;
                neTaskInfo.setTaskId(oTaskInfo.iTaskID.intValue());
                neTaskInfo.setSubTaskId(oTaskInfo.iSubTaskID.intValue());
                neTaskInfo.setOperator(new String(oTaskInfo.strOpera));
                neTaskInfo.setFdn(new String(oTaskInfo.strFdn));
                neTaskInfo.setNeName(new String(oTaskInfo.strNeName));
                neTaskInfo.setNeType(new String(oTaskInfo.strNeType));
                neTaskInfo.setBeginDateTime(TimeDateFormatUtil.convertFromUTC((long)(oTaskInfo.iBeginDateTime.longValue() * 1000L)));
                neTaskInfo.setState(oTaskInfo.iTaskState.intValue());
                neTaskInfo.setType(oTaskInfo.iTaskType.intValue());
                neTaskInfo.setDetail(new String(oTaskInfo.strErrDesc));
                LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer iTaskID:" + oTaskInfo.iTaskID.intValue());
                LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer iSubTaskID:" + oTaskInfo.iSubTaskID.intValue());
                LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer DevName:" + new String(oTaskInfo.strNeName));
                oNeLicTaskSet.add(neTaskInfo);
            }
        }
        return oNeLicTaskSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLicenseTask(AsnNeLicTaskEventDataRsp oNeDataRsp) {
        Object object = this.obj;
        synchronized (object) {
            if (null == this.m_oNeLicTaskSet || this.m_oNeLicTaskSet.isEmpty()) {
                LicDebugTracer.trace("[NELIC] updateLicenseTask() m_oNeLicTaskSet is null");
                return;
            }
        }
        String sCurFDN = new String(oNeDataRsp.strFdn);
        int iTaskID = oNeDataRsp.iTaskID.intValue();
        int iErrCode = oNeDataRsp.iErrCode.intValue();
        String sErrInfo = new String(oNeDataRsp.strErr);
        for (NeLicenseTask oTask : this.m_oNeLicTaskSet) {
            if (null == oTask || iTaskID != oTask.getTaskId() || !oTask.getFdn().equals(sCurFDN)) continue;
            oTask.setDetail(sErrInfo);
            oTask.setState(iErrCode);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLicenseTask(AsnNeLicTaskEventDataMapRsp oAsnDataMapRsp) {
        Object object = this.obj;
        synchronized (object) {
            if (null == this.m_oNeLicTaskSet || this.m_oNeLicTaskSet.isEmpty()) {
                LicDebugTracer.trace("[NELIC] updateLicenseTask() m_oNeLicTaskSet is null");
                return;
            }
        }
        String sCurFDN = new String(oAsnDataMapRsp.strFdn);
        int iTaskID = oAsnDataMapRsp.iTaskID.intValue();
        int iNeState = oAsnDataMapRsp.iErrCode.intValue();
        for (NeLicenseTask oTask : this.m_oNeLicTaskSet) {
            if (null == oTask || iTaskID != oTask.getTaskId() || !oTask.getFdn().equals(sCurFDN)) continue;
            if (0 == iNeState) {
                oTask.setDetail("");
            }
            oTask.setState(iNeState);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NeLicenseTask> getAllNeLicenseTaskFromServer() {
        Object object = this.obj;
        synchronized (object) {
            this.getNeLicenseTaskFromServer(-1);
        }
        return this.m_oNeLicTaskSet;
    }

    public Set<NeLicenseTask> getAppointedNeLicenseTaskFromServer(int iTaskId) {
        return this.getNeLicenseTaskFromServer(iTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NeLicenseTask> getNeLicenseTask() {
        Object object = this.obj;
        synchronized (object) {
            return this.m_oNeLicTaskSet;
        }
    }

    public int invalidateLicense(String[] strFDNs, TaskIdInfo oTaskIdInfo) {
        return this.doLicenseOpration(strFDNs, 99820155, oTaskIdInfo);
    }

    public int synNeLicenseInfo(String[] strFDNs, TaskIdInfo oTaskIdInfo) {
        return this.doLicenseOpration(strFDNs, 99820158, oTaskIdInfo);
    }

    public int adjustNeLicense(String[] strFDNs, TaskIdInfo oTaskIdInfo) {
        return this.doLicenseOpration(strFDNs, 99820157, oTaskIdInfo);
    }

    public int exportLicenseInfo(String[] strFDNs, TaskIdInfo oTaskIdInfo) {
        return this.doLicenseOpration(strFDNs, 99820156, oTaskIdInfo);
    }

    public int forceExeTask(int[] iTaskIdArray) {
        return this.doExeOpreration(iTaskIdArray, 99820153);
    }

    public int retryTask(int[] iTaskIdArray) {
        return this.doExeOpreration(iTaskIdArray, 99820154);
    }

    public int deleteTask(int[] iTaskIdArray) {
        return this.doExeOpreration(iTaskIdArray, 99820152);
    }

    private int doLicenseOpration(String[] strFDNArray, final int iCmdCode, TaskIdInfo oTaskIdInfo) {
        int iErrCode = 0;
        final AsnNeLicTaskReq oReq = new AsnNeLicTaskReq();
        final AsnNeLicTaskRsp oRsp = new AsnNeLicTaskRsp();
        for (String strFDN : strFDNArray) {
            oReq.oAsnNeLicFdnLst.add(strFDN.getBytes());
        }
        int userID = NELicenseModuleManager.getUserID();
        oReq.iUserID = BigInteger.valueOf(userID);
        LicDebugTracer.trace("NELicenseInfo:Ready to post the current userID <" + userID + "> to backgroud!");
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = LicOperationManager.this.m_commMgr.sendSyncMsg(LicOperationManager.this.m_commMgr.getMSGHead(iCmdCode, 1), oReq, oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        LicDebugTracer.trace("NELicenseInfo:doLicenseOpration ErrorCode: " + iErrCode);
        if (0 == iErrCode) {
            iErrCode = oRsp.iErrCode.intValue();
            oTaskIdInfo.setTaskId(oRsp.iTaskID.intValue());
        }
        return iErrCode;
    }

    private int doExeOpreration(int[] iTaskIdArray, final int iCmdCode) {
        int iErrCode = 0;
        final AsnNeLicExeTaskReq oReq = new AsnNeLicExeTaskReq();
        final AsnNeLicExeTaskRsp oRsp = new AsnNeLicExeTaskRsp();
        for (int iTaskId : iTaskIdArray) {
            boolean add = oReq.oAsnNeLicTaskIDLst.add(BigInteger.valueOf(iTaskId));
        }
        int userID = NELicenseModuleManager.getUserID();
        oReq.iUserID = BigInteger.valueOf(userID);
        LicDebugTracer.trace("NELicenseInfo:Ready to post the current userID <" + userID + "> to backgroud!");
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = LicOperationManager.this.m_commMgr.sendSyncMsg(LicOperationManager.this.m_commMgr.getMSGHead(iCmdCode, 1), oReq, oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        if (0 == iErrCode) {
            iErrCode = oRsp.iErrCode.intValue();
        }
        return iErrCode;
    }

    @Override
    public void release() {
        m_instance = null;
    }

    @Override
    public void notifyMessage(MessageEvent event) {
        if (event != null) {
            this.dealNETaskMessage(event);
        }
    }

    private void dealNETaskMessage(MessageEvent event) {
        LicDebugTracer.trace("LicOperationManager#dealNETaskMessage: " + event.getCmdCode());
        switch (event.getCmdCode()) {
            case 99820103: {
                Set<NeLicenseTask> neLicenseTaskList = null;
                try {
                    neLicenseTaskList = event.getNeLicenseTaskLst();
                    this.m_oNeLicTaskSet = neLicenseTaskList;
                }
                catch (Exception e) {
                    GuiUtil.handleException(e);
                }
                LicenseTaskPanel.getInstance().initData(neLicenseTaskList);
                break;
            }
        }
    }

    public int notifyServerToExportNelic(int taskId) {
        int iErrCode = 0;
        final AsnNeLicStartTaskReq oReq = new AsnNeLicStartTaskReq();
        final AsnNeLicTaskRsp oRsp = new AsnNeLicTaskRsp();
        int userID = NELicenseModuleManager.getUserID();
        oReq.iUserID = BigInteger.valueOf(userID);
        oReq.iTaskID = BigInteger.valueOf(taskId);
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = LicOperationManager.this.m_commMgr.sendSyncMsg(LicOperationManager.this.m_commMgr.getMSGHead(54079, 1), oReq, oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        LicDebugTracer.trace("NELicenseInfo:notifyServerToExportNelic ErrorCode: " + iErrCode);
        if (0 == iErrCode) {
            iErrCode = oRsp.iErrCode.intValue();
        }
        return iErrCode;
    }
}

