/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.controller;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryBaseInfoLstRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryTaskInfoLstRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryVerNameLstRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskInfo;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.interfaces.IASNMessageListener;
import com.huawei.u2000.nelicense.common.interfaces.IObjectDeallocator;
import com.huawei.u2000.nelicense.common.interfaces.MessageEvent;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class LicAsynCommController
extends MSGReceiver
implements IObjectDeallocator {
    private static LicAsynCommController m_instance = null;
    private Vector<IASNMessageListener> m_oListenerVec;
    private static Set<NeLicenseTask> neLicenseTaskList = new HashSet<NeLicenseTask>();
    private BaseCommManager m_comMgr = BaseCommManager.getInstance();

    private LicAsynCommController() {
        this.m_comMgr.addMessageListener(99820014, (MSGListener)this);
        this.m_comMgr.addMessageListener(99820103, (MSGListener)this);
        this.m_oListenerVec = new Vector();
    }

    public static synchronized LicAsynCommController getInstance() {
        if (null == m_instance) {
            m_instance = new LicAsynCommController();
        }
        return m_instance;
    }

    public void setToNull() {
        this.close();
        if (this.m_oListenerVec.size() >= 0) {
            this.m_oListenerVec.clear();
            this.m_oListenerVec = null;
        }
        if (this.m_comMgr != null) {
            this.m_comMgr = null;
        }
        m_instance = null;
    }

    protected void processMessage(MSGPacketExt oReceivePacket) {
        MessageEvent oEvent = null;
        int iCmdCode = oReceivePacket.getCmdCode();
        LicDebugTracer.trace("[NELIC] LicAsynCommController#processMessage:" + iCmdCode);
        switch (iCmdCode) {
            case 99820014: {
                AsnNeLicQueryBaseInfoLstRsp oRsp = new AsnNeLicQueryBaseInfoLstRsp();
                this.m_comMgr.decodeAsn1Data(oRsp, oReceivePacket.getData());
                oEvent = new MessageEvent(iCmdCode, oRsp);
                break;
            }
            case 99820101: {
                AsnNeLicQueryVerNameLstRsp oVersionRsp = new AsnNeLicQueryVerNameLstRsp();
                this.m_comMgr.decodeAsn1Data(oVersionRsp, oReceivePacket.getData());
                oEvent = new MessageEvent(iCmdCode, oVersionRsp);
                break;
            }
            case 99820102: {
                AsnNeLicQueryBaseInfoLstRsp oNeLicInfoRsp = new AsnNeLicQueryBaseInfoLstRsp();
                this.m_comMgr.decodeAsn1Data(oNeLicInfoRsp, oReceivePacket.getData());
                oEvent = new MessageEvent(iCmdCode, oNeLicInfoRsp);
                break;
            }
            case 99820103: {
                AsnNeLicQueryTaskInfoLstRsp oRsp = new AsnNeLicQueryTaskInfoLstRsp();
                this.m_comMgr.decodeAsn1Data(oRsp, oReceivePacket.getData());
                this.setNeLicenseTaskList(oRsp);
                if (!oRsp.bIsFinal) break;
                oEvent = new MessageEvent(iCmdCode, neLicenseTaskList);
                break;
            }
        }
        this.notifyMessage(oEvent);
        LicDebugTracer.trace("LicAsynCommController#processMessage End");
    }

    private void setNeLicenseTaskList(AsnNeLicQueryTaskInfoLstRsp oRsp) {
        int iErrCode = oRsp.iErrCode.intValue();
        LicDebugTracer.trace("[NELIC] LicAsynCommController#setNeLicenseTaskList iErrCode:" + iErrCode);
        if (0 == iErrCode) {
            if (oRsp.iSequence.intValue() <= 1) {
                neLicenseTaskList.clear();
            }
            LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer Task size:" + oRsp.oAsnNeLicTaskInfoLst.size());
            LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer Task final:" + oRsp.bIsFinal);
            for (Object task : oRsp.oAsnNeLicTaskInfoLst) {
                NeLicenseTask neTaskInfo = new NeLicenseTask();
                AsnNeLicTaskInfo oTaskInfo = (AsnNeLicTaskInfo)task;
                neTaskInfo.setTaskId(oTaskInfo.iTaskID.intValue());
                neTaskInfo.setSubTaskId(oTaskInfo.iSubTaskID.intValue());
                neTaskInfo.setOperator(new String(oTaskInfo.strOpera));
                neTaskInfo.setFdn(new String(oTaskInfo.strFdn));
                neTaskInfo.setNeName(new String(oTaskInfo.strNeName));
                neTaskInfo.setNeType(new String(oTaskInfo.strNeType));
                neTaskInfo.setBeginDateTime(TimeDateFormatUtil.convertFromUTC((long)(oTaskInfo.iBeginDateTime.longValue() * 1000L)));
                neTaskInfo.setState(oTaskInfo.iTaskState.intValue());
                neTaskInfo.setType(oTaskInfo.iTaskType.intValue());
                neTaskInfo.setDetail(new String(oTaskInfo.strErrDesc));
                LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer iTaskID:" + oTaskInfo.iTaskID.intValue());
                LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer iSubTaskID:" + oTaskInfo.iSubTaskID.intValue());
                LicDebugTracer.trace("[NELIC] getNeLicenseTaskFromServer DevName:" + new String(oTaskInfo.strNeName));
                neLicenseTaskList.add(neTaskInfo);
            }
        }
    }

    public void timeout(int arg0, Character arg1) {
    }

    public void addAsnMessageListener(IASNMessageListener oListener) {
        if (!this.m_oListenerVec.contains(oListener)) {
            this.m_oListenerVec.add(oListener);
        }
    }

    public void removeAsnMessageListener(IASNMessageListener oListener) {
        this.m_oListenerVec.remove(oListener);
    }

    private void notifyMessage(MessageEvent oEvent) {
        if (null == oEvent) {
            return;
        }
        for (IASNMessageListener oListener : this.m_oListenerVec) {
            oListener.notifyMessage(oEvent);
        }
    }

    private void removeMessageListener() {
        this.m_comMgr.removeMessageListener(99820014, (MSGListener)this);
        this.m_comMgr.removeMessageListener(99820103, (MSGListener)this);
    }

    @Override
    public void release() {
        this.removeMessageListener();
        if (null != m_instance) {
            m_instance.close();
            m_instance = null;
        }
    }

    public void clearNeLicTaskListData() {
        neLicenseTaskList.clear();
    }
}

