/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.commmanager;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.NELicenseXMLParser;
import com.huawei.u2000.nelicense.common.asnnelic.FStruDecoderFixUTC;
import com.huawei.u2000.nelicense.common.commmanager.StandAloneCommManager;
import com.huawei.u2000.nelicense.common.commmanager.U2000CommManager;
import com.huawei.u2000.nelicense.util.GlobalUtil;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.huawei.u2000.nelicense.util.NELicShakeHandThread;
import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.CommManageService;
import com.swimap.iview.communicate.MSGHead;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import com.swimap.iview.communicate.MSGSyncReceiver;
import java.io.Serializable;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public abstract class BaseCommManager
implements Serializable {
    private static final long serialVersionUID = 4882959712567311804L;
    protected CommHandle m_oCommHandle = null;
    private int m_iTimes;
    private NELicShakeHandThread m_oLicShakehandThread;
    private static BaseCommManager m_instance = null;

    protected BaseCommManager() {
        try {
            String TIMEOUTPERIOD = NELicenseXMLParser.getTimeOut();
            this.m_iTimes = Integer.parseInt(TIMEOUTPERIOD);
        }
        catch (NumberFormatException nfe) {
            this.m_iTimes = 300000;
            LicDebugTracer.trace("NELicenseInfo:BaseCommManager/BaseCommManager<NumberFormatException>:" + nfe);
            LicDebugTracer.trace(nfe);
        }
        catch (Exception e) {
            this.m_iTimes = 300000;
            LicDebugTracer.trace("NELicenseInfo:BaseCommManager/BaseCommManager<Exception>:" + e);
            LicDebugTracer.trace(e);
        }
    }

    public static synchronized BaseCommManager getInstance() {
        if (null == m_instance || null == m_instance.getCommHandle()) {
            m_instance = GlobalUtil.isStandalone() ? new StandAloneCommManager() : new U2000CommManager();
        }
        return m_instance;
    }

    public static boolean getIsStandAlone() {
        return GlobalUtil.isStandalone();
    }

    public final MSGHead getMSGHead(int iCmdCode) {
        MSGHead head = new MSGHead();
        head.cmdCode = iCmdCode;
        head.receiverProcID = (char)138;
        head.receiverModule = 0;
        head.msgType = (byte)6;
        head.cmdHandle = '\u0000';
        head.senderCmdHandle = '\u0000';
        return head;
    }

    public final MSGHead getMSGHead(int iCmdCode, int iServerModuleId) {
        MSGHead head = new MSGHead();
        head.cmdCode = iCmdCode;
        head.receiverProcID = (char)138;
        head.receiverModule = (byte)iServerModuleId;
        head.msgType = (byte)6;
        head.cmdHandle = '\u0000';
        head.senderCmdHandle = '\u0000';
        return head;
    }

    public final MSGHead getMSGHead(int iCmdCode, int oRecvCmdHandle, int iServerModuleId) {
        MSGHead head = new MSGHead();
        head.cmdCode = iCmdCode;
        head.receiverProcID = (char)138;
        head.receiverModule = (byte)iServerModuleId;
        head.msgType = (byte)6;
        head.cmdHandle = (char)oRecvCmdHandle;
        head.senderCmdHandle = '\u0000';
        return head;
    }

    public final int sendAsyncMsg(MSGHead oMsgHead, FStruct oData, MSGReceiver listener) {
        if (null == this.m_oCommHandle) {
            return 100002;
        }
        try {
            this.m_oCommHandle.sendAsyncMessage(oMsgHead, oData, (MSGListener)listener, this.m_iTimes);
        }
        catch (FStruException asnEx) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)asnEx));
            LicDebugTracer.trace((Exception)((Object)asnEx));
            return 100003;
        }
        catch (Exception ioEx) {
            LicDebugTracer.trace("NELicenseInfo:" + ioEx);
            LicDebugTracer.trace(ioEx);
            return 100005;
        }
        return 0;
    }

    public int sendSyncMsg(MSGHead oMsgHead, FStruct oSendData, FStruct oRecvData) {
        int error = this.sendSyncMsg(oMsgHead, oSendData, oRecvData, this.m_iTimes);
        return error;
    }

    public final int sendSyncMsg(MSGHead oMsgHead, FStruct oSendData, FStruct oRecvData, int iTimes) {
        if (null == this.m_oCommHandle) {
            return 100002;
        }
        GuiUtil.setWaitingCursor();
        MSGSyncReceiver reply = new MSGSyncReceiver();
        int errorcode = -1;
        try {
            errorcode = this.m_oCommHandle.sendMessage(oMsgHead, oSendData, reply, iTimes);
        }
        catch (Exception e) {
            LicDebugTracer.trace(e);
        }
        if (0 != errorcode) {
            GuiUtil.setDefaultCursor();
            return errorcode;
        }
        MSGPacketExt[] result = reply.getResults();
        if (null == result || 0 == result.length) {
            GuiUtil.setDefaultCursor();
            return 100001;
        }
        if (1 == result.length) {
            byte[] bytes = result[0].getData();
            if (null == bytes) {
                GuiUtil.setDefaultCursor();
                return 100000;
            }
            int error = this.decodeAsn1Data(oRecvData, bytes);
            if (0 != error) {
                GuiUtil.setDefaultCursor();
                return error;
            }
        }
        GuiUtil.setDefaultCursor();
        return 0;
    }

    public void addMessageListener(int iCmdID, MSGListener listener) {
        this.m_oCommHandle.addMessageListener(iCmdID, listener);
    }

    public final void removeMessageListener(int iCmdID, MSGListener listener) {
        if (null != this.m_oCommHandle) {
            this.m_oCommHandle.removeMessageListener(iCmdID, listener);
        }
    }

    public final int decodeAsn1Data(FStruct oDestData, byte[] arrSrcData) {
        try {
            if (arrSrcData == null || 0 == arrSrcData.length) {
                return 100004;
            }
            FStruDecoderFixUTC dec = new FStruDecoderFixUTC(arrSrcData);
            oDestData.deserialize((Decoder)dec);
        }
        catch (Exception ex) {
            LicDebugTracer.trace(ex);
            return 100003;
        }
        return 0;
    }

    public CommHandle getCommHandle() {
        return this.m_oCommHandle;
    }

    public void startShakeHand() {
        if (null == this.m_oLicShakehandThread) {
            this.m_oLicShakehandThread = new NELicShakeHandThread();
            this.m_oLicShakehandThread.startShakeHand();
            this.m_oLicShakehandThread.start();
        } else {
            this.m_oLicShakehandThread.startShakeHand();
        }
    }

    public void stopShakeHand() {
        if (null != this.m_oLicShakehandThread) {
            this.m_oLicShakehandThread.stopShakeHand();
            this.m_oLicShakehandThread = null;
        }
    }

    public void setNull() {
        m_instance = null;
    }

    public static BaseCommManager getBaseCommManager() {
        return m_instance;
    }

    public abstract int initializeComm(CommManageService var1);
}

