/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common.checknodesinfoxml;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.checknodesinfoxml.generated.TIndex;
import com.huawei.u2000.nelicense.common.checknodesinfoxml.generated.TLic;
import com.huawei.u2000.nelicense.model.NELicenseFileInfo;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ReadZIPLicenseFile {
    private static List<NELicenseFileInfo> dataSet = new ArrayList<NELicenseFileInfo>();
    private static String indexFileName = "Index.xml";

    public static List<NELicenseFileInfo> readXMLFile(String zipFilepath) {
        dataSet.clear();
        try {
            ZipFile zipFile = new ZipFile(new File(zipFilepath));
            InputStream input = ReadZIPLicenseFile.unzipIndexfile(zipFile);
            if (input != null) {
                ReadZIPLicenseFile.readZipFile(zipFilepath, input);
                input.close();
                zipFile.close();
            }
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void readZipFile(String zipFilepath, InputStream input) {
        dataSet = new ArrayList<NELicenseFileInfo>();
        ValidationEventCollector veCollector = null;
        try {
            String schemaFile;
            Plugin plugin = PluginManager.getInstance().getPlugin("u2000nelicense");
            if (plugin != null) {
                schemaFile = plugin.getURL().getPath() + System.getProperty("file.separator") + "style/conf/IndexSchema.xsd";
                LicDebugTracer.trace("NELicenseInfo:Get XSD File in U2000");
            } else {
                schemaFile = System.getProperty("user.dir") + System.getProperty("file.separator") + "style/productstyle/conf/u2000nelicense/IndexSchema.xsd";
                LicDebugTracer.trace("NELicenseInfo:Get XSD File in STANDALONE");
            }
            LicDebugTracer.trace("NELicenseInfo:Get XSD File at path:" + schemaFile);
            String[] temp = schemaFile.split("%20");
            StringBuffer filePath = new StringBuffer(temp[0]);
            for (int i = 1; i < temp.length; ++i) {
                filePath.append(" ").append(temp[i]);
            }
            schemaFile = filePath.toString();
            LicDebugTracer.trace("NELicenseInfo:schemaFile:" + schemaFile);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema mySchema = sf.newSchema(new File(schemaFile));
            veCollector = new ValidationEventCollector();
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.huawei.u2000.nelicense.common.checknodesinfoxml.generated");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(mySchema);
            unmarshaller.setEventHandler((ValidationEventHandler)veCollector);
            JAXBElement elements = (JAXBElement)unmarshaller.unmarshal(input);
            TIndex index = (TIndex)elements.getValue();
            List<TLic> licList = index.getLic();
            String licenseFileName = "";
            String esn = "";
            String fileContent = "";
            for (TLic l : licList) {
                licenseFileName = l.getName();
                esn = l.getEsn();
                fileContent = ReadZIPLicenseFile.getSingleFileContents(zipFilepath, licenseFileName);
                dataSet.add(new NELicenseFileInfo(licenseFileName, esn, fileContent));
            }
        }
        catch (SAXException saxe) {
            LicDebugTracer.trace("NELicenseInfo:" + saxe);
            if (veCollector != null && veCollector.hasEvents()) {
                ValidationEvent[] events2;
                for (ValidationEvent ve : events2 = veCollector.getEvents()) {
                    String msg = ve.getMessage();
                    ValidationEventLocator vel = ve.getLocator();
                    int line = vel.getLineNumber();
                    int column = vel.getColumnNumber();
                    LicDebugTracer.trace("NELicenseInfo:" + ResCenter.getInstance().getMergeString("xmlCheckErrorMeg", new String[]{zipFilepath, String.valueOf(line), String.valueOf(column), msg}));
                }
            }
        }
        catch (Exception e) {
            String message = ResCenter.getInstance().getString("INDEXFILE_FORMAT_INVALID");
            DCOptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (String)message);
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
            if (veCollector != null && veCollector.hasEvents()) {
                ValidationEvent[] events3;
                for (ValidationEvent ve : events3 = veCollector.getEvents()) {
                    String msg = ve.getMessage();
                    ValidationEventLocator vel = ve.getLocator();
                    int line = vel.getLineNumber();
                    int column = vel.getColumnNumber();
                    LicDebugTracer.trace("NELicenseInfo:" + ResCenter.getInstance().getMergeString("xmlCheckErrorMeg", new String[]{zipFilepath, String.valueOf(line), String.valueOf(column), msg}));
                }
            }
            {
                catch (Throwable throwable) {
                    if (veCollector != null && veCollector.hasEvents()) {
                        ValidationEvent[] events4;
                        for (ValidationEvent ve : events4 = veCollector.getEvents()) {
                            String msg = ve.getMessage();
                            ValidationEventLocator vel = ve.getLocator();
                            int line = vel.getLineNumber();
                            int column = vel.getColumnNumber();
                            LicDebugTracer.trace("NELicenseInfo:" + ResCenter.getInstance().getMergeString("xmlCheckErrorMeg", new String[]{zipFilepath, String.valueOf(line), String.valueOf(column), msg}));
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (veCollector != null && veCollector.hasEvents()) {
            ValidationEvent[] events;
            for (ValidationEvent ve : events = veCollector.getEvents()) {
                String msg = ve.getMessage();
                ValidationEventLocator vel = ve.getLocator();
                int line = vel.getLineNumber();
                int column = vel.getColumnNumber();
                LicDebugTracer.trace("NELicenseInfo:" + ResCenter.getInstance().getMergeString("xmlCheckErrorMeg", new String[]{zipFilepath, String.valueOf(line), String.valueOf(column), msg}));
            }
        }
    }

    public static String getDATorTXTFileContents(String filePath) {
        StringBuffer content = new StringBuffer("");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
            String line = reader.readLine();
            while (null != line) {
                content.append(line);
                content.append("\r\n");
                line = reader.readLine();
            }
            if (content.length() > 1) {
                content.replace(content.length() - 2, content.length(), "");
            }
        }
        catch (FileNotFoundException e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        catch (IOException e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSingleFileContents(String zipFilePath, String licFilename) {
        StringBuffer content = new StringBuffer("");
        ZipFile zipFile = null;
        BufferedReader reader = null;
        InputStreamReader inputStreamReader = null;
        try {
            zipFile = new ZipFile(new File(zipFilePath));
            ZipEntry entry = zipFile.getEntry(licFilename);
            if (entry != null) {
                InputStream input = zipFile.getInputStream(entry);
                inputStreamReader = new InputStreamReader(input);
                reader = new BufferedReader(inputStreamReader);
                String lineStr = reader.readLine();
                while (null != lineStr) {
                    content.append(lineStr);
                    content.append("\r\n");
                    lineStr = reader.readLine();
                }
                if (content.length() > 1) {
                    content.replace(content.length() - 2, content.length(), "");
                }
            }
        }
        catch (ZipException e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
            if (null != inputStreamReader) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    LicDebugTracer.trace("NELicenseInfo:" + e);
                    LicDebugTracer.trace(e);
                }
            }
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LicDebugTracer.trace("NELicenseInfo:" + e);
                    LicDebugTracer.trace(e);
                }
            }
        }
        return content.toString();
    }

    private static InputStream unzipIndexfile(ZipFile zipFile) {
        InputStream in = null;
        try {
            ZipEntry entry = zipFile.getEntry(indexFileName);
            if (entry != null) {
                in = zipFile.getInputStream(entry);
            } else {
                zipFile.close();
            }
        }
        catch (ZipException e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        catch (IOException e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        if (null == in) {
            String message = ResCenter.getInstance().getString("INDEXFILE_INEXISTENCE");
            DCOptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (String)message);
        }
        return in;
    }
}

