/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common;

import com.huawei.u2000.nelicense.common.DCXMLOutputter;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.model.NeLicenseTaskDetail;
import com.huawei.u2000.nelicense.model.NeLicenseTaskItemInfo;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class LicenseTaskInfoXMLWriter {
    private static final LicenseTaskInfoXMLWriter instance = new LicenseTaskInfoXMLWriter();
    private boolean isRootNode = true;

    private LicenseTaskInfoXMLWriter() {
    }

    public static LicenseTaskInfoXMLWriter getInstance() {
        return instance;
    }

    private Element getRoot() {
        return new Element("NodesInfo");
    }

    public void save(Map<String, NeLicenseTaskDetail> data, String file) {
        Element root = this.getRoot();
        root.setAttribute("formatVersion", "1.0");
        Document Doc = new Document(root);
        DCXMLOutputter XMLOut = new DCXMLOutputter();
        ArrayList<String> keyElement = new ArrayList<String>();
        keyElement.add("createTime");
        keyElement.add("version");
        keyElement.add("productName");
        keyElement.add("nodeName");
        keyElement.add("SiteModel");
        keyElement.add("Description");
        keyElement.add("Esn");
        keyElement.add("LSN");
        keyElement.add("RvkCode");
        Element info = new Element("Info");
        String time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        String operator = "admin";
        info.setAttribute("operator", operator);
        info.setAttribute("createTime", time);
        root.addContent((Content)info);
        Iterator<Map.Entry<String, NeLicenseTaskDetail>> ite = data.entrySet().iterator();
        while (ite.hasNext()) {
            String fdn = ite.next().getKey();
            Element node = new Element("Node");
            NeLicenseTaskDetail taskDetail = data.get(fdn);
            Map<Object, Object> column = new HashMap();
            column = taskDetail.getColumn();
            for (Map.Entry<Object, Object> entry : column.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    Element childNode;
                    if ("Esn".equals(key)) {
                        childNode = new Element(key);
                        childNode.addContent(value);
                        node.addContent((Content)childNode);
                        continue;
                    }
                    if ("productName".equals(key) || "version".equals(key)) {
                        node.setAttribute(key, value);
                        continue;
                    }
                    if ("SiteModel".equals(key) || "Description".equals(key) || "LSN".equals(key) || "RvkCode".equals(key)) {
                        if (value == null || value.trim().length() <= 0) continue;
                        childNode = new Element(key);
                        childNode.addContent(value);
                        node.addContent((Content)childNode);
                        continue;
                    }
                    LicDebugTracer.trace("NELicenseInfo:LicenseTaskInfoXML occur other node(s).");
                }
                catch (Exception e) {
                    LicDebugTracer.trace(e);
                }
            }
            this.createChildElement(taskDetail, node);
            root.addContent((Content)node);
            this.output(Doc, XMLOut, file);
        }
    }

    private void createChildElement(NeLicenseTaskDetail taskInfo, Element parent) {
        List<NeLicenseTaskItemInfo> funDatas;
        List<NeLicenseTaskItemInfo> resDatas = taskInfo.getResItemInfo();
        if (resDatas.size() > 0) {
            Element resNode = new Element("Resources");
            for (NeLicenseTaskItemInfo taskItem : resDatas) {
                String key = taskItem.getKey();
                int value = taskItem.getValue();
                Element itemNode = new Element("Res");
                Map<String, String> itemMap = taskItem.getAttribute();
                for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                    String attribKey = entry.getKey();
                    String attribValue = entry.getValue();
                    if (attribValue == null || attribValue.trim().length() <= 0) continue;
                    itemNode.setAttribute(attribKey, attribValue);
                }
                itemNode.setAttribute("name", key);
                itemNode.addContent(String.valueOf(value));
                resNode.addContent((Content)itemNode);
            }
            parent.addContent((Content)resNode);
        }
        if ((funDatas = taskInfo.getFunItemInfo()).size() > 0) {
            Element funNode = new Element("Functions");
            for (NeLicenseTaskItemInfo taskItem : funDatas) {
                String key = taskItem.getKey();
                int value = taskItem.getValue();
                Element itemNode = new Element("Func");
                Map<String, String> itemMap = taskItem.getAttribute();
                for (Map.Entry<String, String> entry : itemMap.entrySet()) {
                    String attribKey = entry.getKey();
                    String attribValue = entry.getValue();
                    if (attribValue == null || attribValue.trim().length() <= 0) continue;
                    itemNode.setAttribute(attribKey, attribValue);
                }
                itemNode.setAttribute("name", key);
                itemNode.addContent(String.valueOf(value));
                funNode.addContent((Content)itemNode);
            }
            parent.addContent((Content)funNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(Document Doc, XMLOutputter XMLOut, String file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            XMLOut.output(Doc, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
        }
        catch (IOException e) {
            LicDebugTracer.trace("NELicenseInfo" + e);
            LicDebugTracer.trace(e);
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LicDebugTracer.trace("NELicenseInfo:" + e);
                    LicDebugTracer.trace(e);
                }
            }
        }
    }
}

