/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common;

import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.model.NeLicenseDetailInfo;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class LicenseDetailInfoXMLWriter {
    private static final LicenseDetailInfoXMLWriter instance = new LicenseDetailInfoXMLWriter();

    private LicenseDetailInfoXMLWriter() {
    }

    public static LicenseDetailInfoXMLWriter getInstance() {
        return instance;
    }

    private Element getRoot() {
        return new Element("LicenseInfo");
    }

    public void save(Map<String, NeLicenseDetailInfo> data, String file) {
        Element root = this.getRoot();
        Document Doc = new Document(root);
        XMLOutputter XMLOut = new XMLOutputter();
        Iterator<Map.Entry<String, NeLicenseDetailInfo>> ite = data.entrySet().iterator();
        while (ite.hasNext()) {
            String fdn = ite.next().getKey();
            Element node = new Element("Node");
            NeLicenseDetailInfo info = data.get(fdn);
            node.setAttribute("nodeName", info.getNeName());
            this.createChildElement(info, node);
            root.addContent((Content)node);
            this.output(Doc, XMLOut, file);
        }
    }

    private void createChildElement(NeLicenseDetailInfo info, Element parent) {
        List<String> columns = info.getColumns();
        List<String[]> datas = info.getDatas();
        int rowSize = datas.size();
        for (int row = 0; row < rowSize; ++row) {
            Element node = new Element("LicenseItem");
            int colSize = columns.size();
            for (int col = 0; col < colSize; ++col) {
                node.setAttribute(columns.get(col), datas.get(row)[col]);
            }
            parent.addContent((Content)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(Document Doc, XMLOutputter XMLOut, String file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            XMLOut.output(Doc, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            LicDebugTracer.trace("NELicenseInfo:Export NE detail fail for not finding file!");
        }
        catch (IOException e) {
            LicDebugTracer.trace("NELicenseInfo:Export NE detail fail for IO error!");
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LicDebugTracer.trace("NELicenseInfo:Export NE detail fail for IO error!");
                }
            }
        }
    }
}

