/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common;

import com.huawei.u2000.nelicense.common.ASNInvoker;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.LicFunctionItem;
import com.huawei.u2000.nelicense.common.LicNeLicenseInfo;
import com.huawei.u2000.nelicense.common.LicResourceItem;
import com.huawei.u2000.nelicense.common.licexportnodeinfo.generated.ObjectFactory;
import com.huawei.u2000.nelicense.common.licexportnodeinfo.generated.TFunc;
import com.huawei.u2000.nelicense.common.licexportnodeinfo.generated.TFunctions;
import com.huawei.u2000.nelicense.common.licexportnodeinfo.generated.TInfo;
import com.huawei.u2000.nelicense.common.licexportnodeinfo.generated.TNode;
import com.huawei.u2000.nelicense.common.licexportnodeinfo.generated.TNodesInfo;
import com.huawei.u2000.nelicense.common.licexportnodeinfo.generated.TRes;
import com.huawei.u2000.nelicense.common.licexportnodeinfo.generated.TResources;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import com.swimap.external.sm.client.base.SessionService;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.datatype.XMLGregorianCalendar;

public class ExportNeLicInfoMgr {
    private static final String FormatVersion = "1.0";
    private static ExportNeLicInfoMgr instance = null;
    private Map<Integer, String> exportFileMap = new HashMap<Integer, String>();

    public static ExportNeLicInfoMgr getInstance() {
        if (null == instance) {
            instance = new ExportNeLicInfoMgr();
        }
        return instance;
    }

    public void addExprotFile(int taskid, String exportfilepath) {
        this.exportFileMap.put(taskid, exportfilepath);
    }

    public String getExprotFile(int taskid) {
        return this.exportFileMap.get(taskid);
    }

    public void removeTask(int taskid) {
        this.exportFileMap.remove(taskid);
    }

    public boolean exportToFile(int taskId, Map<Integer, NeLicenseTask> subTaskMap) {
        String fileName = this.exportFileMap.get(taskId);
        if (fileName == null) {
            LicDebugTracer.trace("NELicenseInfo:Export file is not found for task:" + taskId);
            return false;
        }
        FileOutputStream fileToWrite = null;
        try {
            LicNeLicenseInfo[] licInfos = ASNInvoker.getInstance().getLicNeLicenseInfo(subTaskMap);
            if (licInfos == null || licInfos.length <= 0) {
                LicDebugTracer.trace("NELicenseInfo:license info is empty.");
                return false;
            }
            Marshaller marshaller = this.getMarshaller();
            ObjectFactory fac = new ObjectFactory();
            TNodesInfo nodesInfo = this.makeFileContent(licInfos, fac);
            fileToWrite = new FileOutputStream(fileName);
            marshaller.marshal(fac.createNodesInfo(nodesInfo), (OutputStream)fileToWrite);
        }
        catch (PropertyException e) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
            LicDebugTracer.trace((Exception)((Object)e));
            return false;
        }
        catch (JAXBException e) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
            LicDebugTracer.trace((Exception)((Object)e));
            return false;
        }
        catch (Exception e) {
            if (!GuiUtil.handleException(e)) {
                LicDebugTracer.trace("NELicenseInfo:" + e);
                LicDebugTracer.trace(e);
            }
            return false;
        }
        try {
            if (null != fileToWrite) {
                fileToWrite.close();
            }
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
            return false;
        }
        return true;
    }

    public boolean exportToFile(int taskId, LicNeLicenseInfo[] licInfos) {
        String fileName = this.exportFileMap.get(taskId);
        if (fileName == null) {
            LicDebugTracer.trace("NELicenseInfo:Export file is not found for task:" + taskId);
            return false;
        }
        FileOutputStream fileToWrite = null;
        try {
            if (licInfos == null || licInfos.length <= 0) {
                LicDebugTracer.trace("NELicenseInfo:license info is empty.");
                return false;
            }
            Marshaller marshaller = this.getMarshaller();
            ObjectFactory fac = new ObjectFactory();
            TNodesInfo nodesInfo = this.makeFileContent(licInfos, fac);
            fileToWrite = new FileOutputStream(fileName);
            marshaller.marshal(fac.createNodesInfo(nodesInfo), (OutputStream)fileToWrite);
        }
        catch (PropertyException e) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
            LicDebugTracer.trace((Exception)((Object)e));
            return false;
        }
        catch (JAXBException e) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
            LicDebugTracer.trace((Exception)((Object)e));
            return false;
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
            return false;
        }
        try {
            if (null != fileToWrite) {
                fileToWrite.close();
            }
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace(e);
            return false;
        }
        return true;
    }

    private TNodesInfo makeFileContent(LicNeLicenseInfo[] licInfos, ObjectFactory fac) {
        TNodesInfo nodesInfo = fac.createTNodesInfo();
        nodesInfo.setFormatVersion(FormatVersion);
        TInfo tInfo = this.buildInfo(fac);
        nodesInfo.setInfo(tInfo);
        List<TNode> nodesList = nodesInfo.getNode();
        for (LicNeLicenseInfo info : licInfos) {
            TNode aNode = this.buildNode(fac, info);
            nodesList.add(aNode);
        }
        return nodesInfo;
    }

    private Marshaller getMarshaller() throws JAXBException, PropertyException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.huawei.u2000.nelicense.common.licexportnodeinfo.generated");
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        return marshaller;
    }

    private TInfo buildInfo(ObjectFactory fac) {
        TInfo tInfo = fac.createTInfo();
        tInfo.setOperator(SessionService.getInstance().getCurUserName());
        GregorianCalendar greCal = new GregorianCalendar();
        XMLGregorianCalendar cal = XMLGregorianCalendarImpl.createDateTime(greCal.get(1), greCal.get(2) + 1, greCal.get(5), greCal.get(11), greCal.get(12), greCal.get(13));
        tInfo.setCreateTime(cal);
        return tInfo;
    }

    private TNode buildNode(ObjectFactory fac, LicNeLicenseInfo info) {
        TFunctions functions;
        TNode aNode = fac.createTNode();
        TResources resources = this.buildResource(fac, info);
        if (null != resources) {
            aNode.setResources(resources);
        }
        if (null != (functions = this.buildFunctions(fac, info))) {
            aNode.setFunctions(functions);
        }
        this.buildNodeAttr(info, aNode);
        return aNode;
    }

    private void buildNodeAttr(LicNeLicenseInfo info, TNode aNode) {
        if (this.isValid(info.nename)) {
            aNode.setNodeName(info.nename);
        }
        if (this.isValid(info.productName)) {
            aNode.setProductName(info.productName);
        }
        if (this.isValid(info.versionNo)) {
            aNode.setVersion(info.versionNo);
        }
        if (this.isValid(info.siteModel)) {
            aNode.setSiteModel(info.siteModel);
        }
        if (this.isValid(info.description)) {
            aNode.setDescription(info.description);
        }
        if (this.isValid(info.esn)) {
            aNode.setEsn(info.esn);
        }
        if (this.isValid(info.lsn)) {
            aNode.setLSN(info.lsn);
        }
        if (this.isValid(info.rvkCode)) {
            aNode.setRvkCode(info.rvkCode);
        }
    }

    private boolean isValid(String value) {
        return value != null && !value.trim().isEmpty() && !"NULL".equalsIgnoreCase(value);
    }

    private TFunctions buildFunctions(ObjectFactory fac, LicNeLicenseInfo info) {
        List<LicFunctionItem> funItemList = info.funItemList;
        if (null == funItemList || 0 == funItemList.size()) {
            return null;
        }
        TFunctions functions = fac.createTFunctions();
        List<TFunc> funcList = functions.getFunc();
        for (LicFunctionItem item : funItemList) {
            TFunc func = fac.createTFunc();
            func.setName(item.licItem);
            if (item.evaluateValue != null && item.evaluateValue > 0) {
                func.setEvaluateValue(item.evaluateValue);
            }
            if (item.endDate != null && !item.endDate.isEmpty()) {
                func.setEndDate(item.endDate);
            }
            if (item.value != null && item.value > 0) {
                func.setValue(item.value);
            }
            funcList.add(func);
        }
        return functions;
    }

    private TResources buildResource(ObjectFactory fac, LicNeLicenseInfo info) {
        List<LicResourceItem> resItemList = info.resItemList;
        if (null == resItemList || 0 == resItemList.size()) {
            return null;
        }
        TResources resources = fac.createTResources();
        List<TRes> resList = resources.getRes();
        for (LicResourceItem item : resItemList) {
            TRes res = fac.createTRes();
            res.setName(item.licItem);
            if (item.evaluateValue != null && item.evaluateValue.intValue() > 0) {
                res.setEvaluateValue(item.evaluateValue);
            }
            if (item.endDate != null && !item.endDate.equals("")) {
                res.setEndDate(item.endDate);
            }
            if (item.value != null && item.value.intValue() >= 0) {
                res.setValue(item.value);
            }
            resList.add(res);
        }
        return resources;
    }
}

