/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense.common;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.LicNeLicenseInfo;
import com.huawei.u2000.nelicense.common.NELicenseXMLParser;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryTaskInfoLstRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicQueryVerNameLstRsp;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskInfo;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicTaskInfoLst;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.controller.LicAsynCommController;
import com.huawei.u2000.nelicense.common.controller.NeLicenseInfoManager;
import com.huawei.u2000.nelicense.common.interfaces.IASNMessageListener;
import com.huawei.u2000.nelicense.common.interfaces.MessageEvent;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.model.FilterCondition;
import com.huawei.u2000.nelicense.model.NELicenseFileInfo;
import com.huawei.u2000.nelicense.model.NeLicenseBaseInfo;
import com.huawei.u2000.nelicense.model.NeLicenseTask;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class ASNInvoker
implements IASNMessageListener {
    private String[] m_version;
    private Vector<Vector<String>> m_oLicVec;
    private Set<NeLicenseTask> m_neLicTaskListSet;
    private BaseCommManager m_commMgr = BaseCommManager.getInstance();
    private static ASNInvoker instance = null;
    private int m = 0;

    private ASNInvoker() {
    }

    public static ASNInvoker getInstance() {
        if (null == instance) {
            instance = new ASNInvoker();
        }
        return instance;
    }

    private int[] handleNeLicenseInfo(String[] neFdnArray, String requsetName) throws Exception {
        int[] result = null;
        RpcRequest req = RpcNaming.createRequest((String)requsetName);
        req.addArgument("neFdnArray", (Object)neFdnArray);
        result = req.invoke().getMessage().getIntArray("result");
        return result;
    }

    public long getRecordsIndex(FilterCondition filterCondition) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"nelicense.ds.querylicenseservice.getRecordsIndex");
        req.addArgument("statusArray", (Object)filterCondition.getStatusArray());
        req.addArgument("version", (Object)filterCondition.getVersion());
        req.addArgument("neFdnArray", (Object)filterCondition.getNeFdnArray());
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        return msg.getLong("index");
    }

    public ArrayList<String[]> nextRecordByIndex(long index, int startRow, int pageSize, String sortKey, boolean sortAscend) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"nelicense.ds.querylicenseservice.nextRecordByIndex");
        req.addArgument("index", (Object)index);
        req.addArgument("startRow", (Object)startRow);
        req.addArgument("pageSize", (Object)pageSize);
        req.addArgument("sortKey", (Object)sortKey);
        req.addArgument("sortAscend", (Object)sortAscend);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        int recordCount = msg.getInt("recordCount");
        ArrayList<String[]> records = new ArrayList<String[]>(0);
        for (int i = 0; i < recordCount; ++i) {
            records.add(msg.getStringArray(String.valueOf(i)));
        }
        return records;
    }

    public int getRecordCount(long index) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"nelicense.ds.querylicenseservice.getRecordCount");
        req.addArgument("index", (Object)index);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        return msg.getInt("count");
    }

    public int queryNELicenseInfo(FilterCondition condition, Vector<Vector<String>> rows) {
        Vector<String> row1 = new Vector<String>(7);
        row1.add("NE40E-4");
        row1.add("NE40E-4");
        row1.add("NE40E");
        row1.add("VRP5.50 V600R002C05");
        row1.add("\u00ce\u00bb\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdesn");
        row1.add("\u00c8\u00b1\u00ca\u00a1\u00d7\u00b4\u00cc\u00ac");
        row1.add("NE=10101");
        rows.add(row1);
        Vector<String> row2 = new Vector<String>(7);
        row2.add("NE(9-461)");
        row2.add("NE(9-461)");
        row2.add("OptiX OSN 6800");
        row2.add("5.51.07.11");
        row2.add("\u00ce\u00bb\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdesn");
        row2.add("\u00c8\u00b1\u00ca\u00a1\u00d7\u00b4\u00cc\u00ac");
        row2.add("NE=10102");
        rows.add(row2);
        if (this.m != 0 && this.m != 2) {
            Vector<String> row3 = new Vector<String>(7);
            row3.add("NE(9-461)");
            row3.add("NE(9-461)");
            row3.add("OptiX OSN 6800");
            row3.add("5.51.07.11");
            row3.add("\u00ce\u00bb\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdesn");
            row3.add("\u00c8\u00b1\u00ca\u00a1\u00d7\u00b4\u00cc\u00ac");
            row3.add("NE=10102");
            rows.add(row3);
        }
        ++this.m;
        return 0;
    }

    public int[] queryNeLicenseDetailInfo(String[] neFdnArray) throws Exception {
        return this.handleNeLicenseInfo(neFdnArray, "nelicense.ds.nelicensemgr.queryNeLicenseDetailInfo");
    }

    public int[] cancelLicense(String[] neFdnArray) throws Exception {
        return this.handleNeLicenseInfo(neFdnArray, "nelicense.ds.nelicensemgr.cancelLicense");
    }

    public int[] outputNeInfo(String[] neFdnArray) throws Exception {
        return this.handleNeLicenseInfo(neFdnArray, "nelicense.ds.nelicensemgr.outputNeInfo");
    }

    public int[] adjustNeLicense(String[] neFdnArray) throws Exception {
        return this.handleNeLicenseInfo(neFdnArray, "nelicense.ds.nelicensemgr.adjustNeLicense");
    }

    public int[] synNeInfo(String[] neFdnArray) throws Exception {
        return this.handleNeLicenseInfo(neFdnArray, "nelicense.ds.nelicensemgr.synNeInfo");
    }

    public int handleTask(int[] taskIds, String requsetName) throws Exception {
        int result = -1;
        RpcRequest req = RpcNaming.createRequest((String)requsetName);
        req.addArgument("taskIds", (Object)taskIds);
        result = req.invoke().getMessage().getInt("result");
        return result;
    }

    public int deleteNeLicenseTask(int[] taskIds) throws Exception {
        return this.handleTask(taskIds, "nelicense.ds.nelicensemgr.deleteNeLicenseTask");
    }

    public int forceExeTask(int[] taskIds) throws Exception {
        return this.handleTask(taskIds, "nelicense.ds.nelicensemgr.forceExeTask");
    }

    public int redoTask(int[] taskIds) throws Exception {
        return this.handleTask(taskIds, "nelicense.ds.nelicensemgr.redoTask");
    }

    public int[] updateNeLicense(NELicenseFileInfo[] licFiles) throws Exception {
        LicDebugTracer.trace("NELicenseInfo:invoke updateNeLicense");
        RpcRequest req = RpcNaming.createRequest((String)"nelicense.ds.nelicensemgr.updateNeLicense");
        DataTable licFileTable = new DataTable("licFileTable");
        licFileTable.setColumns(new String[]{"fdn", "fileName", "licenseContent"});
        for (int i = 0; i < licFiles.length; ++i) {
            LicDebugTracer.trace("NELicenseInfo:fdn:" + licFiles[i].getFdn() + " fileName:" + licFiles[i].getFileName() + " LicenseContent:" + licFiles[i].getLicenseContent());
            licFileTable.add(new Object[]{licFiles[i].getFdn(), licFiles[i].getFileName(), licFiles[i].getLicenseContent()});
        }
        req.addTable(licFileTable);
        RpcResponse rsp = req.invoke();
        return rsp.getMessage().getIntArray("result");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllNeVersionInfo() throws Exception {
        int iErrCode = 0;
        LicAsynCommController oLicAsynControl = LicAsynCommController.getInstance();
        final AsnNeLicQueryVerNameLstRsp oVersionRsp = new AsnNeLicQueryVerNameLstRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = BaseCommManager.getInstance().sendSyncMsg(ASNInvoker.this.m_commMgr.getMSGHead(99820101, 1), null, oVersionRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        if (0 == iErrCode) {
            iErrCode = oVersionRsp.iErrCode.intValue();
            if (0 != iErrCode) {
                return null;
            }
            oLicAsynControl.addAsnMessageListener(this);
            ASNInvoker aSNInvoker = this;
            synchronized (aSNInvoker) {
                this.wait(2000L);
            }
            if (this.m_version == null || this.m_version.length == 0) {
                return null;
            }
            return this.m_version;
        }
        return null;
    }

    public Vector<Vector<String>> getAllNEInfoList() throws Exception {
        return this.m_oLicVec;
    }

    public Vector<Vector<String>> sortLicVector(Vector<Vector<String>> neLicVector) {
        int i;
        String strStateCount = NELicenseXMLParser.getNeStateCount();
        int neStateCount = Integer.parseInt(strStateCount);
        Vector<String> stateVector = new Vector<String>();
        for (i = -1; i < neStateCount - 1; ++i) {
            stateVector.addElement(ResCenter.getInstance().getString("neLicenseState_" + i));
        }
        for (i = 0; i < neLicVector.size(); ++i) {
            int k = i;
            for (int j = i + 1; j < neLicVector.size(); ++j) {
                Vector<String> oVector = neLicVector.elementAt(k);
                Vector<String> fVector = neLicVector.elementAt(j);
                String oriName = oVector.elementAt(0);
                String oriState = oVector.elementAt(5);
                String falName = fVector.elementAt(0);
                String falState = fVector.elementAt(5);
                int iOriState = stateVector.indexOf(oriState);
                int iFalState = stateVector.indexOf(falState);
                if (iFalState < iOriState) {
                    k = j;
                    continue;
                }
                if (iFalState != iOriState || falName.compareTo(oriName) >= 0) continue;
                k = j;
            }
            if (k == i) continue;
            Vector<String> tempVector = neLicVector.elementAt(i);
            neLicVector.setElementAt(neLicVector.elementAt(k), i);
            neLicVector.setElementAt(tempVector, k);
        }
        return neLicVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NeLicenseTask> getNeLicenseTask() throws Exception {
        int iErrCode = 0;
        final AsnNeLicQueryTaskInfoLstRsp oNETaskInfoListRsp = new AsnNeLicQueryTaskInfoLstRsp();
        oNETaskInfoListRsp.iErrCode = BigInteger.valueOf(0L);
        LicAsynCommController oLicAsynControl = LicAsynCommController.getInstance();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = BaseCommManager.getInstance().sendSyncMsg(ASNInvoker.this.m_commMgr.getMSGHead(99820103, 1), null, oNETaskInfoListRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)GuiUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrCode = (Integer)syncCommand.getResult();
        }
        if (0 == iErrCode) {
            iErrCode = oNETaskInfoListRsp.iErrCode.intValue();
            if (0 != iErrCode) {
                return null;
            }
            oLicAsynControl.addAsnMessageListener(this);
            ASNInvoker aSNInvoker = this;
            synchronized (aSNInvoker) {
                this.wait(5000L);
            }
            return this.m_neLicTaskListSet;
        }
        return null;
    }

    public Map<String, NeLicenseBaseInfo> getNeLicenseBaseInfos(String[] fdns) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"nelicense.ds.nelicensemgr.getNeLicenseBaseInfos");
        req.addArgument("fdns", (Object)fdns);
        HashMap<String, NeLicenseBaseInfo> neMap = new HashMap<String, NeLicenseBaseInfo>();
        return neMap;
    }

    public void getRecordsIndex(ArrayList<NELicenseFileInfo> dataList) throws Exception {
        String[] neIDArray = new String[dataList.size()];
        int j = 0;
        for (NELicenseFileInfo info : dataList) {
            neIDArray[j] = info.getEsn();
            ++j;
        }
        NeLicenseInfoManager.getInstance().refresh();
        NeLicenseBaseInfo[] neLicInfoList = NeLicenseInfoManager.getInstance().getAllNeLicenseInfo();
        for (int i = 0; i < dataList.size(); ++i) {
            NELicenseFileInfo info = dataList.get(i);
            for (NeLicenseBaseInfo neLicInfo : neLicInfoList) {
                if (!info.getEsn().equals("") && neLicInfo.getEsn().equals(info.getEsn())) {
                    info.setEsnName(neLicInfo.getLabel());
                    info.setFdn(neLicInfo.getFdn());
                    continue;
                }
                info.setEsnName("--");
                info.setFdn("--");
            }
        }
    }

    public LicNeLicenseInfo[] getLicNeLicenseInfo(Map<Integer, NeLicenseTask> subTaskMap) throws Exception {
        int[] subTaskIds = new int[subTaskMap.keySet().size()];
        Iterator<Integer> keyIter = subTaskMap.keySet().iterator();
        int i = 0;
        while (keyIter.hasNext()) {
            subTaskIds[i++] = keyIter.next();
        }
        RpcRequest req = RpcNaming.createRequest((String)"nelicense.ds.nelicensemgr.getNeLicenseInfo");
        req.addArgument("subtaskids", (Object)subTaskIds);
        DataTable table = req.invoke().getMessage().getTable("licTaskData");
        LicNeLicenseInfo[] result = new LicNeLicenseInfo[table.size()];
        for (i = 0; i < result.length; ++i) {
            result[i] = LicNeLicenseInfo.decode(table.get(i).get("taskdata"));
            result[i].description = result[i].nename = subTaskMap.get(Integer.valueOf(table.get(i).get("subtaskid"))).getNeName();
        }
        return result;
    }

    public DataTable[] getNeLicenseTaskCount() throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"nelicense.ds.nelicensemgr.getNeLicenseTaskCount");
        RpcResponse rsp = req.invoke();
        DataTable tolCountTable = rsp.getMessage().getTable("tolCount");
        DataTable completeCountTable = rsp.getMessage().getTable("completeCount");
        DataTable[] tables = new DataTable[]{tolCountTable, completeCountTable};
        return tables;
    }

    public String[] isNEExists(String[] fdn) throws Exception {
        String[] result = null;
        RpcRequest req = RpcNaming.createRequest((String)"nelicense.ds.querylicenseservice.isNEExists");
        req.addArgument("neFdnArray", (Object)fdn);
        RpcResponse rsp = req.invoke();
        result = rsp.getMessage().getStringArray("neList");
        return result;
    }

    public boolean checkNEExists(String[] fdn, List<NeLicenseBaseInfo> selectedNEList) {
        if (LicenseTaskPanel.getInstance().getActionType().equals(ResCenter.getInstance().getString("loadButton"))) {
            for (int i = 0; i < fdn.length; ++i) {
                for (NeLicenseBaseInfo neLicBaseInfo : selectedNEList) {
                    boolean isExist = this.findConfigNE(fdn, i, neLicBaseInfo);
                    if (isExist) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean findConfigNE(String[] fdn, int i, NeLicenseBaseInfo neLicBaseInfo) {
        if (fdn[i].equals(neLicBaseInfo.getFdn()) && ResCenter.getInstance().getString("unknown_esn").equals(neLicBaseInfo.getEsn())) {
            String message = ResCenter.getInstance().getMergeString("loadfile_error", new String[]{neLicBaseInfo.getLabel()});
            DCOptionPane.showMessageDialog((Component)GuiUtil.getMainFrame(), (String)message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessage(MessageEvent event) {
        if (event != null) {
            FStruct oAsn = event.getData();
            switch (event.getCmdCode()) {
                case 99820103: {
                    this.dealTaskInfoListInfo(oAsn);
                    break;
                }
            }
            ASNInvoker aSNInvoker = this;
            synchronized (aSNInvoker) {
                this.notifyAll();
            }
        }
    }

    private void dealTaskInfoListInfo(FStruct oAsn) {
        if (oAsn instanceof AsnNeLicQueryTaskInfoLstRsp) {
            AsnNeLicQueryTaskInfoLstRsp oNELicTaskInfoLstRsp = (AsnNeLicQueryTaskInfoLstRsp)oAsn;
            int iErrCode = oNELicTaskInfoLstRsp.iErrCode.intValue();
            if (0 == iErrCode) {
                AsnNeLicTaskInfoLst oNeTaskLst = oNELicTaskInfoLstRsp.oAsnNeLicTaskInfoLst;
                this.m_neLicTaskListSet = new HashSet<NeLicenseTask>();
                for (Object task : oNeTaskLst) {
                    NeLicenseTask neTaskInfo = new NeLicenseTask();
                    AsnNeLicTaskInfo oTaskInfo = (AsnNeLicTaskInfo)task;
                    neTaskInfo.setTaskId(oTaskInfo.iTaskID.intValue());
                    neTaskInfo.setSubTaskId(oTaskInfo.iSubTaskID.intValue());
                    neTaskInfo.setOperator(new String(oTaskInfo.strOpera));
                    neTaskInfo.setFdn(new String(oTaskInfo.strFdn));
                    neTaskInfo.setNeType(new String(oTaskInfo.strNeType));
                    neTaskInfo.setBeginDateTime(oTaskInfo.iBeginDateTime.toString());
                    neTaskInfo.setState(oTaskInfo.iTaskState.intValue());
                    neTaskInfo.setType(oTaskInfo.iTaskType.intValue());
                    neTaskInfo.setDetail(new String(oTaskInfo.strErrDesc));
                    this.m_neLicTaskListSet.add(neTaskInfo);
                }
            }
        }
    }
}

