/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.NELicenseModuleManager;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.RightManager;
import com.huawei.u2000.nelicense.common.asnnelic.AsnNeLicHandShakeRsp;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.commmanager.StandAloneCommManager;
import com.huawei.u2000.nelicense.common.controller.LicAsynCommController;
import com.huawei.u2000.nelicense.common.controller.LicAsynDetailController;
import com.huawei.u2000.nelicense.common.controller.LicOperationManager;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.util.GlobalUtil;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.communicate.CommManageService;
import com.swimap.iview.communicate.MSGHead;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import javax.swing.SwingUtilities;

public class NWLicenseModuleForU2000
extends BaseModule {
    private NELicenseModuleManager m_oModuleManager;
    private boolean m_bIsInitializeComm = false;

    public NWLicenseModuleForU2000(ModuleManager moduleManager) {
        super(moduleManager);
        GlobalUtil.setIsStandalone(false);
        this.m_oModuleManager = new NELicenseModuleManager(this);
    }

    public void setInitializaComm(boolean IsInitializeComm) {
        this.m_bIsInitializeComm = IsInitializeComm;
    }

    public String getModuleName() {
        return "u2000nelicense";
    }

    public void initialize() {
        this.m_oModuleManager.initializeNELicense(true);
        this.initCommServer();
    }

    public void initCommServer() {
        if (!this.m_bIsInitializeComm) {
            try {
                CommManageService oCommMgrService = (CommManageService)this.getLocalReference("communicateservice");
                int iErrCode = BaseCommManager.getInstance().initializeComm(oCommMgrService);
                if (0 != iErrCode) {
                    LicDebugTracer.trace("fail to initialize nelicense communication, the error code is " + iErrCode);
                    return;
                }
                this.m_bIsInitializeComm = true;
            }
            catch (ModuleManagementException e) {
                LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
                LicDebugTracer.trace((Exception)((Object)e));
            }
        }
    }

    public void showNELicenseFrame() {
        try {
            WindowManager oWindowManager = (WindowManager)this.getLocalReference("mainwindowmanager");
            GuiUtil.setMainFrame(oWindowManager.getJFrame());
        }
        catch (ModuleManagementException e) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
            LicDebugTracer.trace((Exception)((Object)e));
        }
        this.m_bIsInitializeComm = false;
        this.initCommServer();
        if (!this.isHandShakeOK()) {
            return;
        }
        this.m_oModuleManager.showNELicenseFrame();
        StandAloneCommManager.getInstance().startShakeHand();
        LicenseTaskPanel.getInstance();
        LicenseTaskPanel.getInstance().refreshPanel();
    }

    protected void postSystemLoadingFinished() {
        NWLicenseModuleForU2000 nWLicenseModuleForU2000 = this;
        RightManager.getNelicenseRight(nWLicenseModuleForU2000.m_oModuleManager.getUserName());
        try {
            MenuManager oMenuManager = (MenuManager)this.getLocalReference("mainmenumanager");
            Menu oSystemMenu = oMenuManager.getMenu("mainMenu", "SystemMenu");
            oSystemMenu.getMenuItem("U2000_NE_License_Manage").setEnabled(RightManager.hasManageRight());
        }
        catch (ModuleManagementException e) {
            LicDebugTracer.trace("NWLicenseModuleForU2000#postSystemLoadingFinished throw ModuleManagementException" + e.getMessage());
        }
    }

    private boolean isHandShakeOK() {
        BaseCommManager m_comMgr = BaseCommManager.getInstance();
        AsnNeLicHandShakeRsp oAsnHandShake = new AsnNeLicHandShakeRsp();
        int m_iHandShakeTimeOut = Integer.parseInt(ResCenter.getInstance().getString("LicHand_Shake_Time_Out"));
        MSGHead msgHead = null;
        try {
            LicDebugTracer.trace("NELicenseInfo:NELicShakeHandThread is clientId: " + NELicenseModuleManager.getUserID());
            msgHead = m_comMgr.getMSGHead(99820100, 4);
        }
        catch (Exception e) {
            LicDebugTracer.trace("NELicenseInfo:" + e);
            LicDebugTracer.trace("NELicenseInfo:handleTimeout NELicShakeHandThread end.. ");
            return false;
        }
        int iErrorCode = 0;
        try {
            iErrorCode = m_comMgr.sendSyncMsg(msgHead, null, oAsnHandShake, m_iHandShakeTimeOut);
        }
        catch (Exception ex) {
            LicDebugTracer.trace("NELicenseInfo:" + ex);
            LicDebugTracer.trace("NELicenseInfo:handleTimeout NELicShakeHandThread end.. ");
            return false;
        }
        if (null == oAsnHandShake.iErrCode) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog(null, (String)ResCenter.getInstance().getString("LicHAND_SHAKE_CONNECT_FAIL"), (String)ResCenter.getInstance().getString("LicHAND_SHAKE_ERROR"), (int)0);
                }
            });
            LicDebugTracer.trace("NELicenseInfo:RECEIVECODE is null");
            return false;
        }
        LicDebugTracer.trace("NELicenseInfo:RECEIVECODE is " + oAsnHandShake.iErrCode.intValue());
        LicDebugTracer.trace("iErrorCode:" + iErrorCode);
        return true;
    }

    public void stop() {
        LicDebugTracer.trace("NWLicenseModuleForU2000#stop start");
        QueryLicensePanel.clear();
        LicenseTaskPanel.clear();
        LicOperationManager.getInstance().setToNull();
        if (null != LicAsynCommController.getInstance()) {
            LicAsynCommController.getInstance().setToNull();
            LicAsynCommController.getInstance().release();
        }
        if (null != LicAsynDetailController.getInstance()) {
            LicAsynDetailController.getInstance().release();
            LicAsynDetailController.getInstance().setToNull();
        }
    }

    public void clear() {
        this.stop();
    }
}

