/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.commmanager.StandAloneCommManager;
import com.huawei.u2000.nelicense.gui.LicenseMainFrame;
import com.huawei.u2000.nelicense.portal.NELicenseAppModule;
import com.swimap.external.sm.adapter.message.EmfSecurityInterface;
import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.util.DebugTracer;

public class NELicenseModuleManager {
    private static final String STYLE_CONF_NELICENSE_DIR = "conf/u2000nelicense/";
    private BaseModule m_oBaseModule;
    private EmfSecurityInterface m_oSequrityInterface;
    private static int m_userID;
    private static String m_userName;
    private Menu m_oneLicenseMenu;
    private LicenseMainFrame m_frame = null;

    public NELicenseModuleManager(BaseModule oBaseModule) {
        this.m_oBaseModule = oBaseModule;
        this.setSequrityInterFace();
    }

    public static int getUserID() {
        return m_userID;
    }

    public static String getUserName() {
        return m_userName;
    }

    public void initializeNELicense(boolean isStandAlone) {
        try {
            Integer oBmsValue;
            Object obj;
            boolean isInitializeMenu = true;
            if (isStandAlone && null != (obj = System.getProperties().get("SelectedDomain")) && (oBmsValue = Integer.valueOf(3)).equals(obj)) {
                isInitializeMenu = false;
            }
            if (isInitializeMenu) {
                this.initializeMenu();
            }
        }
        catch (ModuleManagementException e) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
            LicDebugTracer.trace((Exception)((Object)e));
        }
    }

    private void initializeMenu() throws ModuleManagementException {
        for (int i = 0; i < 3 && !DCFrameWorkUtil.getIsSingleClientFinal(); ++i) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                LicDebugTracer.trace(e);
            }
        }
        MenuManager oMenuManager = (MenuManager)this.m_oBaseModule.getLocalReference("mainmenumanager");
        if (DCFrameWorkUtil.getIsSingleClient()) {
            oMenuManager.loadDynamicMenus("conf/u2000nelicense/NELicenseMenu", "mainMenu");
            CommandManager.getInstance().loadSecurityCommands("conf/u2000nelicense/commands", "system");
            oMenuManager.addMenu("mainMenu", "neLicense");
            this.m_oneLicenseMenu = oMenuManager.getMenu("mainMenu", "neLicense");
            this.m_oneLicenseMenu.getMenuItem("neLicenseManage").setEnabled(true);
            this.m_oneLicenseMenu.getMenuItem("neLicenseManage").setVisible(false);
        } else if (!NELicenseAppModule.getInstance().isAppStyle()) {
            Menu oSystemMenu = oMenuManager.getMenu("mainMenu", "SystemMenu");
            oSystemMenu.getMenuItem("U2000_NE_License_Manage").setEnabled(true);
        } else {
            oMenuManager = NELicenseAppModule.getInstance().getAppMenuManager("FixNetDC");
            Menu oSystemMenu = oMenuManager.getMenu("mainMenu", "datacenter");
            oSystemMenu.getMenuItem("U2000_NE_License_Manage").setEnabled(true);
        }
    }

    public void showNELicenseFrame() {
        if (this.m_frame == null) {
            this.m_frame = LicenseMainFrame.getInstance();
        }
        this.m_frame.showFrame();
    }

    protected void stop() {
        BaseCommManager oBaseCommManager;
        if (null != this.m_frame) {
            this.m_frame.dispose();
            this.m_frame = null;
        }
        if (null != (oBaseCommManager = StandAloneCommManager.getInstance())) {
            oBaseCommManager.stopShakeHand();
        }
    }

    private void setSequrityInterFace() {
        boolean isStandAlone = StandAloneCommManager.getIsStandAlone();
        if (isStandAlone) {
            return;
        }
        try {
            this.m_oSequrityInterface = (EmfSecurityInterface)this.m_oBaseModule.getLocalReference("com.swimap.adapter.message.sm");
            m_userID = this.m_oSequrityInterface.getUserID();
            m_userName = this.m_oSequrityInterface.getUsername();
            if (null == m_userName) {
                m_userName = "null";
            }
            DebugTracer.trace((String)("NELicenseInfo:Have get current userID <" + m_userID + "> and userName <" + m_userName + "> from NETWORK SOFTWARE or 0 and null in STANDALONE ENV!"));
        }
        catch (ModuleManagementException e) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
            LicDebugTracer.trace((Exception)((Object)e));
        }
    }
}

