/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.nelicense;

import com.huawei.dc.adapter.swimap.iview.util.DCDebugTracer;
import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.u2000.nelicense.NELicenseModuleManager;
import com.huawei.u2000.nelicense.common.LicDebugTracer;
import com.huawei.u2000.nelicense.common.ResCenter;
import com.huawei.u2000.nelicense.common.commmanager.BaseCommManager;
import com.huawei.u2000.nelicense.common.commmanager.StandAloneCommManager;
import com.huawei.u2000.nelicense.gui.LicenseMainFrame;
import com.huawei.u2000.nelicense.gui.panel.LicenseTaskPanel;
import com.huawei.u2000.nelicense.gui.panel.QueryLicensePanel;
import com.huawei.u2000.nelicense.util.GlobalUtil;
import com.huawei.u2000.nelicense.util.GuiUtil;
import com.huawei.u2000.nelicense.util.StreamReaderThread;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;

public class NELicenseModule
extends BaseModule {
    public static final String MODULE_NAME = "u2000nelicense";
    private NELicenseModuleManager m_oModuleManager;
    private static boolean m_bIsStartupServer = false;
    private long waitTime = Long.MAX_VALUE;
    private Process m_serverPro;

    public NELicenseModule(ModuleManager moduleManager) {
        super(moduleManager);
        GlobalUtil.setIsStandalone(true);
        this.m_oModuleManager = new NELicenseModuleManager(this);
    }

    public static void setIsStartupServer(boolean isStartupServer) {
        m_bIsStartupServer = isStartupServer;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public void initialize() {
        this.m_oModuleManager.initializeNELicense(true);
    }

    public void showNELicenseFrame() {
        try {
            WindowManager oWindowManager = (WindowManager)this.getLocalReference("mainwindowmanager");
            GuiUtil.setMainFrame(oWindowManager.getJFrame());
        }
        catch (ModuleManagementException e) {
            LicDebugTracer.trace("NELicenseInfo:" + (Object)((Object)e));
            LicDebugTracer.trace((Exception)((Object)e));
        }
        Thread oThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!m_bIsStartupServer) {
                    boolean isSuccess = NELicenseModule.this.startupServer();
                    if (!isSuccess) {
                        String message = ResCenter.getInstance().getString("corbaerror");
                        DCOptionPane.showMessageDialog((Component)((Object)LicenseMainFrame.getInstance()), (String)message);
                        return;
                    }
                    BaseCommManager.getInstance().initializeComm(null);
                    m_bIsStartupServer = true;
                }
                NELicenseModule.this.m_oModuleManager.showNELicenseFrame();
                StandAloneCommManager.getInstance().startShakeHand();
            }
        });
        oThread.start();
    }

    protected void postSystemLoadingFinished() {
    }

    public void stop() {
        QueryLicensePanel.clear();
        LicenseTaskPanel.clear();
        if (null != this.m_serverPro) {
            this.m_serverPro.destroy();
            this.m_serverPro = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startupServer() {
        Object obj = System.getProperties().get("DCStandaloneDebugMode");
        if (null == obj || Boolean.FALSE.equals(obj)) {
            try {
                String strWorkPath = this.getWorkPath();
                String strNotifyFilePath = strWorkPath + File.separator + "server/common/nelic/conf/Notify.cfg";
                BufferedWriter oWriter = new BufferedWriter(new FileWriter(strNotifyFilePath));
                ((Writer)oWriter).write(48);
                ((Writer)oWriter).close();
                String strServerPath = strWorkPath + File.separator + "server/common/nelic/bin/neLicServer.exe";
                this.m_serverPro = Runtime.getRuntime().exec(strServerPath);
                StreamReaderThread oThread = new StreamReaderThread(this.m_serverPro.getInputStream());
                oThread.start();
            }
            catch (IOException e1) {
                DCDebugTracer.trace((IOException)e1);
            }
            GuiUtil.setWaitingCursor();
            Object oSynObj = new Object();
            CheckThread oCheckThread = new CheckThread(oSynObj);
            oCheckThread.start();
            Object object = oSynObj;
            synchronized (object) {
                try {
                    oSynObj.wait(this.waitTime);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace((InterruptedException)e);
                }
            }
            GuiUtil.setDefaultCursor();
            return oCheckThread.isSuccess();
        }
        return true;
    }

    private String getWorkPath() {
        File oCurrDir = new File(System.getProperty("user.dir"));
        oCurrDir = new File(oCurrDir.getAbsolutePath());
        String strPath = oCurrDir.getParentFile().getAbsolutePath();
        return strPath;
    }

    class CheckThread
    extends Thread {
        private long m_waitTime = 500L;
        private static final int iTimes = 20;
        private boolean m_isSuccess = false;
        private Object m_oSynObj;

        public CheckThread(Object oSynObj) {
            this.m_oSynObj = oSynObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block23: {
                String strWorkPath = NELicenseModule.this.getWorkPath();
                String strNotifyFilePath = strWorkPath + File.separator + "server/common/nelic/conf/Notify.cfg";
                int iCurrentTimes = 0;
                BufferedReader oReader = null;
                InputStreamReader oFileReader = null;
                try {
                    int iContent;
                    do {
                        this.pauseThread(this.m_waitTime);
                        if (20 >= ++iCurrentTimes) continue;
                        break block23;
                    } while (49 != (iContent = (oReader = new BufferedReader(oFileReader = new FileReader(strNotifyFilePath))).read()));
                    this.m_isSuccess = true;
                }
                catch (IOException ioe) {
                    DCDebugTracer.trace((IOException)ioe);
                }
                finally {
                    if (null != oFileReader) {
                        try {
                            oFileReader.close();
                        }
                        catch (IOException e) {
                            LicDebugTracer.trace(e);
                        }
                    }
                    if (null != oReader) {
                        try {
                            oReader.close();
                        }
                        catch (IOException e) {
                            LicDebugTracer.trace(e);
                        }
                    }
                }
            }
            Object object = this.m_oSynObj;
            synchronized (object) {
                this.m_oSynObj.notifyAll();
            }
        }

        public boolean isSuccess() {
            return this.m_isSuccess;
        }

        private void pauseThread(long lMillis) {
            try {
                Thread.sleep(lMillis);
            }
            catch (InterruptedException e1) {
                return;
            }
        }
    }
}

